# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UrlObservationArgs', 'UrlObservation']

@pulumi.input_type
class UrlObservationArgs:
    def __init__(__self__, *,
                 sdk_type: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 url: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a UrlObservation resource.
        :param pulumi.Input[_builtins.str] sdk_type: SDK integration mode. Value:
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] url: The URL of the page to monitor.
        """
        pulumi.set(__self__, "sdk_type", sdk_type)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="sdkType")
    def sdk_type(self) -> pulumi.Input[_builtins.str]:
        """
        SDK integration mode. Value:
        """
        return pulumi.get(self, "sdk_type")

    @sdk_type.setter
    def sdk_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sdk_type", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the page to monitor.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _UrlObservationState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sdk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UrlObservation resources.
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] sdk_type: SDK integration mode. Value:
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] url: The URL of the page to monitor.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if sdk_type is not None:
            pulumi.set(__self__, "sdk_type", sdk_type)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="sdkType")
    def sdk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SDK integration mode. Value:
        """
        return pulumi.get(self, "sdk_type")

    @sdk_type.setter
    def sdk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sdk_type", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the page to monitor.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("alicloud:esa/urlObservation:UrlObservation")
class UrlObservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sdk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Url Observation resource.

        Web page monitoring.

        For information about ESA Url Observation and how to use it, see [What is Url Observation](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateUrlObservation).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_url_observation = alicloud.esa.UrlObservation("default",
            sdk_type="automatic",
            site_id=default_site.id,
            url="terraform.cn/a.html")
        ```

        ## Import

        ESA Url Observation can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/urlObservation:UrlObservation example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] sdk_type: SDK integration mode. Value:
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] url: The URL of the page to monitor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UrlObservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Url Observation resource.

        Web page monitoring.

        For information about ESA Url Observation and how to use it, see [What is Url Observation](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateUrlObservation).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_url_observation = alicloud.esa.UrlObservation("default",
            sdk_type="automatic",
            site_id=default_site.id,
            url="terraform.cn/a.html")
        ```

        ## Import

        ESA Url Observation can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/urlObservation:UrlObservation example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param UrlObservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UrlObservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sdk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UrlObservationArgs.__new__(UrlObservationArgs)

            if sdk_type is None and not opts.urn:
                raise TypeError("Missing required property 'sdk_type'")
            __props__.__dict__["sdk_type"] = sdk_type
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["config_id"] = None
        super(UrlObservation, __self__).__init__(
            'alicloud:esa/urlObservation:UrlObservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            sdk_type: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'UrlObservation':
        """
        Get an existing UrlObservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] sdk_type: SDK integration mode. Value:
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] url: The URL of the page to monitor.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UrlObservationState.__new__(_UrlObservationState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["sdk_type"] = sdk_type
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["url"] = url
        return UrlObservation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="sdkType")
    def sdk_type(self) -> pulumi.Output[_builtins.str]:
        """
        SDK integration mode. Value:
        """
        return pulumi.get(self, "sdk_type")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the page to monitor.
        """
        return pulumi.get(self, "url")

