# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WafRulesetArgs', 'WafRuleset']

@pulumi.input_type
class WafRulesetArgs:
    def __init__(__self__, *,
                 phase: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WafRuleset resource.
        :param pulumi.Input[_builtins.str] phase: The WAF phase
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.str] name: The ruleset name.
        :param pulumi.Input[_builtins.int] site_version: The site version.
        :param pulumi.Input[_builtins.str] status: Rule Set Status
        """
        pulumi.set(__self__, "phase", phase)
        pulumi.set(__self__, "site_id", site_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def phase(self) -> pulumi.Input[_builtins.str]:
        """
        The WAF phase
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phase", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ruleset name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site version.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule Set Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _WafRulesetState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 phase: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WafRuleset resources.
        :param pulumi.Input[_builtins.str] name: The ruleset name.
        :param pulumi.Input[_builtins.str] phase: The WAF phase
        :param pulumi.Input[_builtins.int] ruleset_id: waf rule set id
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The site version.
        :param pulumi.Input[_builtins.str] status: Rule Set Status
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if ruleset_id is not None:
            pulumi.set(__self__, "ruleset_id", ruleset_id)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ruleset name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WAF phase
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase", value)

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        waf rule set id
        """
        return pulumi.get(self, "ruleset_id")

    @ruleset_id.setter
    def ruleset_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ruleset_id", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site version.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule Set Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/wafRuleset:WafRuleset")
class WafRuleset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 phase: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Waf Ruleset resource.

        waf rule set.

        For information about ESA Waf Ruleset and how to use it, see [What is Waf Ruleset](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateWafRuleset).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_waf_ruleset = alicloud.esa.WafRuleset("default",
            site_id=default.sites[0].site_id,
            phase="http_custom",
            site_version=0,
            name=name)
        ```

        ## Import

        ESA Waf Ruleset can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/wafRuleset:WafRuleset example <ruleset_id>:<site_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The ruleset name.
        :param pulumi.Input[_builtins.str] phase: The WAF phase
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The site version.
        :param pulumi.Input[_builtins.str] status: Rule Set Status
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WafRulesetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Waf Ruleset resource.

        waf rule set.

        For information about ESA Waf Ruleset and how to use it, see [What is Waf Ruleset](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateWafRuleset).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_waf_ruleset = alicloud.esa.WafRuleset("default",
            site_id=default.sites[0].site_id,
            phase="http_custom",
            site_version=0,
            name=name)
        ```

        ## Import

        ESA Waf Ruleset can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/wafRuleset:WafRuleset example <ruleset_id>:<site_id>
        ```

        :param str resource_name: The name of the resource.
        :param WafRulesetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WafRulesetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 phase: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WafRulesetArgs.__new__(WafRulesetArgs)

            __props__.__dict__["name"] = name
            if phase is None and not opts.urn:
                raise TypeError("Missing required property 'phase'")
            __props__.__dict__["phase"] = phase
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["status"] = status
            __props__.__dict__["ruleset_id"] = None
        super(WafRuleset, __self__).__init__(
            'alicloud:esa/wafRuleset:WafRuleset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            phase: Optional[pulumi.Input[_builtins.str]] = None,
            ruleset_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'WafRuleset':
        """
        Get an existing WafRuleset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The ruleset name.
        :param pulumi.Input[_builtins.str] phase: The WAF phase
        :param pulumi.Input[_builtins.int] ruleset_id: waf rule set id
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The site version.
        :param pulumi.Input[_builtins.str] status: Rule Set Status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WafRulesetState.__new__(_WafRulesetState)

        __props__.__dict__["name"] = name
        __props__.__dict__["phase"] = phase
        __props__.__dict__["ruleset_id"] = ruleset_id
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["status"] = status
        return WafRuleset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The ruleset name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> pulumi.Output[_builtins.str]:
        """
        The WAF phase
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> pulumi.Output[_builtins.int]:
        """
        waf rule set id
        """
        return pulumi.get(self, "ruleset_id")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The site version.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Rule Set Status
        """
        return pulumi.get(self, "status")

