# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WaitingRoomEventArgs', 'WaitingRoomEvent']

@pulumi.input_type
class WaitingRoomEventArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[_builtins.str],
                 new_users_per_minute: pulumi.Input[_builtins.str],
                 queuing_method: pulumi.Input[_builtins.str],
                 queuing_status_code: pulumi.Input[_builtins.str],
                 session_duration: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 start_time: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str],
                 total_active_users: pulumi.Input[_builtins.str],
                 waiting_room_event_name: pulumi.Input[_builtins.str],
                 waiting_room_type: pulumi.Input[_builtins.str],
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 json_response_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 random_pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WaitingRoomEvent resource.
        :param pulumi.Input[_builtins.str] end_time: The timestamp of the end time of the event.
        :param pulumi.Input[_builtins.str] new_users_per_minute: Number of new users per minute.
        :param pulumi.Input[_builtins.str] queuing_method: Way of queuing. Value:
               -'random': random.
               -'fifo': first in, first out.
               -'passthrough ': through.
               -'reject-all': reject all.
        :param pulumi.Input[_builtins.str] queuing_status_code: Waiting room status code. Value:
               -'200'
               -'202'
               -'429'
        :param pulumi.Input[_builtins.str] session_duration: User session duration in minutes.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] start_time: The timestamp of the event start time.
        :param pulumi.Input[_builtins.str] status: Enabled status. Value:
               -'on': Enable waiting room events
               -'off': Disable waiting room events
        :param pulumi.Input[_builtins.str] total_active_users: Total number of active users.
        :param pulumi.Input[_builtins.str] waiting_room_event_name: Event name, custom event description.
        :param pulumi.Input[_builtins.str] waiting_room_type: Waiting room type. The following types are supported:
               -'default': the default type.
               -'custom': custom type.
        :param pulumi.Input[_builtins.str] custom_page_html: User-defined waiting room page content, when the waiting room type is custom type, you need to enter. The incoming content needs to be base64 encoded.
        :param pulumi.Input[_builtins.str] description: Waiting room description.
        :param pulumi.Input[_builtins.str] disable_session_renewal_enable: Disable session renewal. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] json_response_enable: JSON response switch. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] language: Default language setting. Values include:
               -'enus': English.
               -'zhcn': Simplified Chinese.
               -'zhhk': Traditional Chinese.
        :param pulumi.Input[_builtins.str] pre_queue_enable: Pre-queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] pre_queue_start_time: Pre-queue start time.
        :param pulumi.Input[_builtins.str] random_pre_queue_enable: Random queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        pulumi.set(__self__, "queuing_method", queuing_method)
        pulumi.set(__self__, "queuing_status_code", queuing_status_code)
        pulumi.set(__self__, "session_duration", session_duration)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_active_users", total_active_users)
        pulumi.set(__self__, "waiting_room_event_name", waiting_room_event_name)
        pulumi.set(__self__, "waiting_room_type", waiting_room_type)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal_enable is not None:
            pulumi.set(__self__, "disable_session_renewal_enable", disable_session_renewal_enable)
        if json_response_enable is not None:
            pulumi.set(__self__, "json_response_enable", json_response_enable)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if pre_queue_enable is not None:
            pulumi.set(__self__, "pre_queue_enable", pre_queue_enable)
        if pre_queue_start_time is not None:
            pulumi.set(__self__, "pre_queue_start_time", pre_queue_start_time)
        if random_pre_queue_enable is not None:
            pulumi.set(__self__, "random_pre_queue_enable", random_pre_queue_enable)
        if waiting_room_id is not None:
            pulumi.set(__self__, "waiting_room_id", waiting_room_id)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[_builtins.str]:
        """
        The timestamp of the end time of the event.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Input[_builtins.str]:
        """
        Number of new users per minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "new_users_per_minute", value)

    @_builtins.property
    @pulumi.getter(name="queuingMethod")
    def queuing_method(self) -> pulumi.Input[_builtins.str]:
        """
        Way of queuing. Value:
        -'random': random.
        -'fifo': first in, first out.
        -'passthrough ': through.
        -'reject-all': reject all.
        """
        return pulumi.get(self, "queuing_method")

    @queuing_method.setter
    def queuing_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queuing_method", value)

    @_builtins.property
    @pulumi.getter(name="queuingStatusCode")
    def queuing_status_code(self) -> pulumi.Input[_builtins.str]:
        """
        Waiting room status code. Value:
        -'200'
        -'202'
        -'429'
        """
        return pulumi.get(self, "queuing_status_code")

    @queuing_status_code.setter
    def queuing_status_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queuing_status_code", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Input[_builtins.str]:
        """
        User session duration in minutes.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "session_duration", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        The timestamp of the event start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        Enabled status. Value:
        -'on': Enable waiting room events
        -'off': Disable waiting room events
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Input[_builtins.str]:
        """
        Total number of active users.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "total_active_users", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomEventName")
    def waiting_room_event_name(self) -> pulumi.Input[_builtins.str]:
        """
        Event name, custom event description.
        """
        return pulumi.get(self, "waiting_room_event_name")

    @waiting_room_event_name.setter
    def waiting_room_event_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "waiting_room_event_name", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomType")
    def waiting_room_type(self) -> pulumi.Input[_builtins.str]:
        """
        Waiting room type. The following types are supported:
        -'default': the default type.
        -'custom': custom type.
        """
        return pulumi.get(self, "waiting_room_type")

    @waiting_room_type.setter
    def waiting_room_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "waiting_room_type", value)

    @_builtins.property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined waiting room page content, when the waiting room type is custom type, you need to enter. The incoming content needs to be base64 encoded.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_page_html", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Waiting room description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSessionRenewalEnable")
    def disable_session_renewal_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Disable session renewal. Value:
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "disable_session_renewal_enable")

    @disable_session_renewal_enable.setter
    def disable_session_renewal_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disable_session_renewal_enable", value)

    @_builtins.property
    @pulumi.getter(name="jsonResponseEnable")
    def json_response_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON response switch. Value:
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "json_response_enable")

    @json_response_enable.setter
    def json_response_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "json_response_enable", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default language setting. Values include:
        -'enus': English.
        -'zhcn': Simplified Chinese.
        -'zhhk': Traditional Chinese.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="preQueueEnable")
    def pre_queue_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pre-queue switch.
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "pre_queue_enable")

    @pre_queue_enable.setter
    def pre_queue_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_queue_enable", value)

    @_builtins.property
    @pulumi.getter(name="preQueueStartTime")
    def pre_queue_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pre-queue start time.
        """
        return pulumi.get(self, "pre_queue_start_time")

    @pre_queue_start_time.setter
    def pre_queue_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_queue_start_time", value)

    @_builtins.property
    @pulumi.getter(name="randomPreQueueEnable")
    def random_pre_queue_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Random queue switch.
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "random_pre_queue_enable")

    @random_pre_queue_enable.setter
    def random_pre_queue_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "random_pre_queue_enable", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waiting_room_id", value)


@pulumi.input_type
class _WaitingRoomEventState:
    def __init__(__self__, *,
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 json_response_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 queuing_method: Optional[pulumi.Input[_builtins.str]] = None,
                 queuing_status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 random_pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 total_active_users: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_event_id: Optional[pulumi.Input[_builtins.int]] = None,
                 waiting_room_event_name: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WaitingRoomEvent resources.
        :param pulumi.Input[_builtins.str] custom_page_html: User-defined waiting room page content, when the waiting room type is custom type, you need to enter. The incoming content needs to be base64 encoded.
        :param pulumi.Input[_builtins.str] description: Waiting room description.
        :param pulumi.Input[_builtins.str] disable_session_renewal_enable: Disable session renewal. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] end_time: The timestamp of the end time of the event.
        :param pulumi.Input[_builtins.str] json_response_enable: JSON response switch. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] language: Default language setting. Values include:
               -'enus': English.
               -'zhcn': Simplified Chinese.
               -'zhhk': Traditional Chinese.
        :param pulumi.Input[_builtins.str] new_users_per_minute: Number of new users per minute.
        :param pulumi.Input[_builtins.str] pre_queue_enable: Pre-queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] pre_queue_start_time: Pre-queue start time.
        :param pulumi.Input[_builtins.str] queuing_method: Way of queuing. Value:
               -'random': random.
               -'fifo': first in, first out.
               -'passthrough ': through.
               -'reject-all': reject all.
        :param pulumi.Input[_builtins.str] queuing_status_code: Waiting room status code. Value:
               -'200'
               -'202'
               -'429'
        :param pulumi.Input[_builtins.str] random_pre_queue_enable: Random queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] session_duration: User session duration in minutes.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] start_time: The timestamp of the event start time.
        :param pulumi.Input[_builtins.str] status: Enabled status. Value:
               -'on': Enable waiting room events
               -'off': Disable waiting room events
        :param pulumi.Input[_builtins.str] total_active_users: Total number of active users.
        :param pulumi.Input[_builtins.int] waiting_room_event_id: The waiting room event ID, which can be obtained by calling the [ListWaitingRoomEvents](https://help.aliyun.com/document_detail/2850279.html) operation.
        :param pulumi.Input[_builtins.str] waiting_room_event_name: Event name, custom event description.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        :param pulumi.Input[_builtins.str] waiting_room_type: Waiting room type. The following types are supported:
               -'default': the default type.
               -'custom': custom type.
        """
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal_enable is not None:
            pulumi.set(__self__, "disable_session_renewal_enable", disable_session_renewal_enable)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if json_response_enable is not None:
            pulumi.set(__self__, "json_response_enable", json_response_enable)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if new_users_per_minute is not None:
            pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if pre_queue_enable is not None:
            pulumi.set(__self__, "pre_queue_enable", pre_queue_enable)
        if pre_queue_start_time is not None:
            pulumi.set(__self__, "pre_queue_start_time", pre_queue_start_time)
        if queuing_method is not None:
            pulumi.set(__self__, "queuing_method", queuing_method)
        if queuing_status_code is not None:
            pulumi.set(__self__, "queuing_status_code", queuing_status_code)
        if random_pre_queue_enable is not None:
            pulumi.set(__self__, "random_pre_queue_enable", random_pre_queue_enable)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if total_active_users is not None:
            pulumi.set(__self__, "total_active_users", total_active_users)
        if waiting_room_event_id is not None:
            pulumi.set(__self__, "waiting_room_event_id", waiting_room_event_id)
        if waiting_room_event_name is not None:
            pulumi.set(__self__, "waiting_room_event_name", waiting_room_event_name)
        if waiting_room_id is not None:
            pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        if waiting_room_type is not None:
            pulumi.set(__self__, "waiting_room_type", waiting_room_type)

    @_builtins.property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined waiting room page content, when the waiting room type is custom type, you need to enter. The incoming content needs to be base64 encoded.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_page_html", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Waiting room description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSessionRenewalEnable")
    def disable_session_renewal_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Disable session renewal. Value:
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "disable_session_renewal_enable")

    @disable_session_renewal_enable.setter
    def disable_session_renewal_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disable_session_renewal_enable", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of the end time of the event.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="jsonResponseEnable")
    def json_response_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON response switch. Value:
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "json_response_enable")

    @json_response_enable.setter
    def json_response_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "json_response_enable", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default language setting. Values include:
        -'enus': English.
        -'zhcn': Simplified Chinese.
        -'zhhk': Traditional Chinese.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of new users per minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "new_users_per_minute", value)

    @_builtins.property
    @pulumi.getter(name="preQueueEnable")
    def pre_queue_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pre-queue switch.
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "pre_queue_enable")

    @pre_queue_enable.setter
    def pre_queue_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_queue_enable", value)

    @_builtins.property
    @pulumi.getter(name="preQueueStartTime")
    def pre_queue_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pre-queue start time.
        """
        return pulumi.get(self, "pre_queue_start_time")

    @pre_queue_start_time.setter
    def pre_queue_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_queue_start_time", value)

    @_builtins.property
    @pulumi.getter(name="queuingMethod")
    def queuing_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Way of queuing. Value:
        -'random': random.
        -'fifo': first in, first out.
        -'passthrough ': through.
        -'reject-all': reject all.
        """
        return pulumi.get(self, "queuing_method")

    @queuing_method.setter
    def queuing_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queuing_method", value)

    @_builtins.property
    @pulumi.getter(name="queuingStatusCode")
    def queuing_status_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Waiting room status code. Value:
        -'200'
        -'202'
        -'429'
        """
        return pulumi.get(self, "queuing_status_code")

    @queuing_status_code.setter
    def queuing_status_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queuing_status_code", value)

    @_builtins.property
    @pulumi.getter(name="randomPreQueueEnable")
    def random_pre_queue_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Random queue switch.
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "random_pre_queue_enable")

    @random_pre_queue_enable.setter
    def random_pre_queue_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "random_pre_queue_enable", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User session duration in minutes.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_duration", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of the event start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enabled status. Value:
        -'on': Enable waiting room events
        -'off': Disable waiting room events
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Total number of active users.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "total_active_users", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomEventId")
    def waiting_room_event_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The waiting room event ID, which can be obtained by calling the [ListWaitingRoomEvents](https://help.aliyun.com/document_detail/2850279.html) operation.
        """
        return pulumi.get(self, "waiting_room_event_id")

    @waiting_room_event_id.setter
    def waiting_room_event_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "waiting_room_event_id", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomEventName")
    def waiting_room_event_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Event name, custom event description.
        """
        return pulumi.get(self, "waiting_room_event_name")

    @waiting_room_event_name.setter
    def waiting_room_event_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waiting_room_event_name", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waiting_room_id", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomType")
    def waiting_room_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Waiting room type. The following types are supported:
        -'default': the default type.
        -'custom': custom type.
        """
        return pulumi.get(self, "waiting_room_type")

    @waiting_room_type.setter
    def waiting_room_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waiting_room_type", value)


@pulumi.type_token("alicloud:esa/waitingRoomEvent:WaitingRoomEvent")
class WaitingRoomEvent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 json_response_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 queuing_method: Optional[pulumi.Input[_builtins.str]] = None,
                 queuing_status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 random_pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 total_active_users: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_event_name: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Waiting Room Event resource.

        For information about ESA Waiting Room Event and how to use it, see [What is Waiting Room Event](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateWaitingRoomEvent).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_waiting_room = alicloud.esa.WaitingRoom("default",
            status="off",
            site_id=default_site.id,
            json_response_enable="off",
            description="example",
            waiting_room_type="default",
            disable_session_renewal_enable="off",
            cookie_name="__aliwaitingroom_example",
            waiting_room_name="waitingroom_example",
            queue_all_enable="off",
            queuing_status_code="200",
            custom_page_html="",
            new_users_per_minute="200",
            session_duration="5",
            language="zhcn",
            total_active_users="300",
            queuing_method="fifo",
            host_name_and_paths=[{
                "domain": "sub_domain.com",
                "path": "/example",
                "subdomain": "example_sub_domain.com.",
            }])
        default_waiting_room_event = alicloud.esa.WaitingRoomEvent("default",
            waiting_room_id=default_waiting_room.waiting_room_id,
            end_time="1719863200",
            waiting_room_event_name="WaitingRoomEvent_example",
            pre_queue_start_time="",
            random_pre_queue_enable="off",
            json_response_enable="off",
            site_id=default_site.id,
            pre_queue_enable="off",
            description="example",
            new_users_per_minute="200",
            queuing_status_code="200",
            custom_page_html="",
            language="zhcn",
            total_active_users="300",
            waiting_room_type="default",
            start_time="1719763200",
            status="off",
            disable_session_renewal_enable="off",
            queuing_method="fifo",
            session_duration="5")
        ```

        ## Import

        ESA Waiting Room Event can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/waitingRoomEvent:WaitingRoomEvent example <site_id>:<waiting_room_id>:<waiting_room_event_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_page_html: User-defined waiting room page content, when the waiting room type is custom type, you need to enter. The incoming content needs to be base64 encoded.
        :param pulumi.Input[_builtins.str] description: Waiting room description.
        :param pulumi.Input[_builtins.str] disable_session_renewal_enable: Disable session renewal. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] end_time: The timestamp of the end time of the event.
        :param pulumi.Input[_builtins.str] json_response_enable: JSON response switch. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] language: Default language setting. Values include:
               -'enus': English.
               -'zhcn': Simplified Chinese.
               -'zhhk': Traditional Chinese.
        :param pulumi.Input[_builtins.str] new_users_per_minute: Number of new users per minute.
        :param pulumi.Input[_builtins.str] pre_queue_enable: Pre-queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] pre_queue_start_time: Pre-queue start time.
        :param pulumi.Input[_builtins.str] queuing_method: Way of queuing. Value:
               -'random': random.
               -'fifo': first in, first out.
               -'passthrough ': through.
               -'reject-all': reject all.
        :param pulumi.Input[_builtins.str] queuing_status_code: Waiting room status code. Value:
               -'200'
               -'202'
               -'429'
        :param pulumi.Input[_builtins.str] random_pre_queue_enable: Random queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] session_duration: User session duration in minutes.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] start_time: The timestamp of the event start time.
        :param pulumi.Input[_builtins.str] status: Enabled status. Value:
               -'on': Enable waiting room events
               -'off': Disable waiting room events
        :param pulumi.Input[_builtins.str] total_active_users: Total number of active users.
        :param pulumi.Input[_builtins.str] waiting_room_event_name: Event name, custom event description.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        :param pulumi.Input[_builtins.str] waiting_room_type: Waiting room type. The following types are supported:
               -'default': the default type.
               -'custom': custom type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WaitingRoomEventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Waiting Room Event resource.

        For information about ESA Waiting Room Event and how to use it, see [What is Waiting Room Event](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateWaitingRoomEvent).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_waiting_room = alicloud.esa.WaitingRoom("default",
            status="off",
            site_id=default_site.id,
            json_response_enable="off",
            description="example",
            waiting_room_type="default",
            disable_session_renewal_enable="off",
            cookie_name="__aliwaitingroom_example",
            waiting_room_name="waitingroom_example",
            queue_all_enable="off",
            queuing_status_code="200",
            custom_page_html="",
            new_users_per_minute="200",
            session_duration="5",
            language="zhcn",
            total_active_users="300",
            queuing_method="fifo",
            host_name_and_paths=[{
                "domain": "sub_domain.com",
                "path": "/example",
                "subdomain": "example_sub_domain.com.",
            }])
        default_waiting_room_event = alicloud.esa.WaitingRoomEvent("default",
            waiting_room_id=default_waiting_room.waiting_room_id,
            end_time="1719863200",
            waiting_room_event_name="WaitingRoomEvent_example",
            pre_queue_start_time="",
            random_pre_queue_enable="off",
            json_response_enable="off",
            site_id=default_site.id,
            pre_queue_enable="off",
            description="example",
            new_users_per_minute="200",
            queuing_status_code="200",
            custom_page_html="",
            language="zhcn",
            total_active_users="300",
            waiting_room_type="default",
            start_time="1719763200",
            status="off",
            disable_session_renewal_enable="off",
            queuing_method="fifo",
            session_duration="5")
        ```

        ## Import

        ESA Waiting Room Event can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/waitingRoomEvent:WaitingRoomEvent example <site_id>:<waiting_room_id>:<waiting_room_event_id>
        ```

        :param str resource_name: The name of the resource.
        :param WaitingRoomEventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WaitingRoomEventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 json_response_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_queue_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 queuing_method: Optional[pulumi.Input[_builtins.str]] = None,
                 queuing_status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 random_pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 total_active_users: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_event_name: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WaitingRoomEventArgs.__new__(WaitingRoomEventArgs)

            __props__.__dict__["custom_page_html"] = custom_page_html
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_session_renewal_enable"] = disable_session_renewal_enable
            if end_time is None and not opts.urn:
                raise TypeError("Missing required property 'end_time'")
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["json_response_enable"] = json_response_enable
            __props__.__dict__["language"] = language
            if new_users_per_minute is None and not opts.urn:
                raise TypeError("Missing required property 'new_users_per_minute'")
            __props__.__dict__["new_users_per_minute"] = new_users_per_minute
            __props__.__dict__["pre_queue_enable"] = pre_queue_enable
            __props__.__dict__["pre_queue_start_time"] = pre_queue_start_time
            if queuing_method is None and not opts.urn:
                raise TypeError("Missing required property 'queuing_method'")
            __props__.__dict__["queuing_method"] = queuing_method
            if queuing_status_code is None and not opts.urn:
                raise TypeError("Missing required property 'queuing_status_code'")
            __props__.__dict__["queuing_status_code"] = queuing_status_code
            __props__.__dict__["random_pre_queue_enable"] = random_pre_queue_enable
            if session_duration is None and not opts.urn:
                raise TypeError("Missing required property 'session_duration'")
            __props__.__dict__["session_duration"] = session_duration
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            if total_active_users is None and not opts.urn:
                raise TypeError("Missing required property 'total_active_users'")
            __props__.__dict__["total_active_users"] = total_active_users
            if waiting_room_event_name is None and not opts.urn:
                raise TypeError("Missing required property 'waiting_room_event_name'")
            __props__.__dict__["waiting_room_event_name"] = waiting_room_event_name
            __props__.__dict__["waiting_room_id"] = waiting_room_id
            if waiting_room_type is None and not opts.urn:
                raise TypeError("Missing required property 'waiting_room_type'")
            __props__.__dict__["waiting_room_type"] = waiting_room_type
            __props__.__dict__["waiting_room_event_id"] = None
        super(WaitingRoomEvent, __self__).__init__(
            'alicloud:esa/waitingRoomEvent:WaitingRoomEvent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_session_renewal_enable: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            json_response_enable: Optional[pulumi.Input[_builtins.str]] = None,
            language: Optional[pulumi.Input[_builtins.str]] = None,
            new_users_per_minute: Optional[pulumi.Input[_builtins.str]] = None,
            pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
            pre_queue_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            queuing_method: Optional[pulumi.Input[_builtins.str]] = None,
            queuing_status_code: Optional[pulumi.Input[_builtins.str]] = None,
            random_pre_queue_enable: Optional[pulumi.Input[_builtins.str]] = None,
            session_duration: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            total_active_users: Optional[pulumi.Input[_builtins.str]] = None,
            waiting_room_event_id: Optional[pulumi.Input[_builtins.int]] = None,
            waiting_room_event_name: Optional[pulumi.Input[_builtins.str]] = None,
            waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
            waiting_room_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'WaitingRoomEvent':
        """
        Get an existing WaitingRoomEvent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_page_html: User-defined waiting room page content, when the waiting room type is custom type, you need to enter. The incoming content needs to be base64 encoded.
        :param pulumi.Input[_builtins.str] description: Waiting room description.
        :param pulumi.Input[_builtins.str] disable_session_renewal_enable: Disable session renewal. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] end_time: The timestamp of the end time of the event.
        :param pulumi.Input[_builtins.str] json_response_enable: JSON response switch. Value:
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] language: Default language setting. Values include:
               -'enus': English.
               -'zhcn': Simplified Chinese.
               -'zhhk': Traditional Chinese.
        :param pulumi.Input[_builtins.str] new_users_per_minute: Number of new users per minute.
        :param pulumi.Input[_builtins.str] pre_queue_enable: Pre-queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] pre_queue_start_time: Pre-queue start time.
        :param pulumi.Input[_builtins.str] queuing_method: Way of queuing. Value:
               -'random': random.
               -'fifo': first in, first out.
               -'passthrough ': through.
               -'reject-all': reject all.
        :param pulumi.Input[_builtins.str] queuing_status_code: Waiting room status code. Value:
               -'200'
               -'202'
               -'429'
        :param pulumi.Input[_builtins.str] random_pre_queue_enable: Random queue switch.
               -'on': open.
               -'off': closed.
        :param pulumi.Input[_builtins.str] session_duration: User session duration in minutes.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] start_time: The timestamp of the event start time.
        :param pulumi.Input[_builtins.str] status: Enabled status. Value:
               -'on': Enable waiting room events
               -'off': Disable waiting room events
        :param pulumi.Input[_builtins.str] total_active_users: Total number of active users.
        :param pulumi.Input[_builtins.int] waiting_room_event_id: The waiting room event ID, which can be obtained by calling the [ListWaitingRoomEvents](https://help.aliyun.com/document_detail/2850279.html) operation.
        :param pulumi.Input[_builtins.str] waiting_room_event_name: Event name, custom event description.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        :param pulumi.Input[_builtins.str] waiting_room_type: Waiting room type. The following types are supported:
               -'default': the default type.
               -'custom': custom type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WaitingRoomEventState.__new__(_WaitingRoomEventState)

        __props__.__dict__["custom_page_html"] = custom_page_html
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_session_renewal_enable"] = disable_session_renewal_enable
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["json_response_enable"] = json_response_enable
        __props__.__dict__["language"] = language
        __props__.__dict__["new_users_per_minute"] = new_users_per_minute
        __props__.__dict__["pre_queue_enable"] = pre_queue_enable
        __props__.__dict__["pre_queue_start_time"] = pre_queue_start_time
        __props__.__dict__["queuing_method"] = queuing_method
        __props__.__dict__["queuing_status_code"] = queuing_status_code
        __props__.__dict__["random_pre_queue_enable"] = random_pre_queue_enable
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["total_active_users"] = total_active_users
        __props__.__dict__["waiting_room_event_id"] = waiting_room_event_id
        __props__.__dict__["waiting_room_event_name"] = waiting_room_event_name
        __props__.__dict__["waiting_room_id"] = waiting_room_id
        __props__.__dict__["waiting_room_type"] = waiting_room_type
        return WaitingRoomEvent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-defined waiting room page content, when the waiting room type is custom type, you need to enter. The incoming content needs to be base64 encoded.
        """
        return pulumi.get(self, "custom_page_html")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Waiting room description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableSessionRenewalEnable")
    def disable_session_renewal_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Disable session renewal. Value:
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "disable_session_renewal_enable")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of the end time of the event.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="jsonResponseEnable")
    def json_response_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON response switch. Value:
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "json_response_enable")

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default language setting. Values include:
        -'enus': English.
        -'zhcn': Simplified Chinese.
        -'zhhk': Traditional Chinese.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Output[_builtins.str]:
        """
        Number of new users per minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @_builtins.property
    @pulumi.getter(name="preQueueEnable")
    def pre_queue_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Pre-queue switch.
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "pre_queue_enable")

    @_builtins.property
    @pulumi.getter(name="preQueueStartTime")
    def pre_queue_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Pre-queue start time.
        """
        return pulumi.get(self, "pre_queue_start_time")

    @_builtins.property
    @pulumi.getter(name="queuingMethod")
    def queuing_method(self) -> pulumi.Output[_builtins.str]:
        """
        Way of queuing. Value:
        -'random': random.
        -'fifo': first in, first out.
        -'passthrough ': through.
        -'reject-all': reject all.
        """
        return pulumi.get(self, "queuing_method")

    @_builtins.property
    @pulumi.getter(name="queuingStatusCode")
    def queuing_status_code(self) -> pulumi.Output[_builtins.str]:
        """
        Waiting room status code. Value:
        -'200'
        -'202'
        -'429'
        """
        return pulumi.get(self, "queuing_status_code")

    @_builtins.property
    @pulumi.getter(name="randomPreQueueEnable")
    def random_pre_queue_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Random queue switch.
        -'on': open.
        -'off': closed.
        """
        return pulumi.get(self, "random_pre_queue_enable")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[_builtins.str]:
        """
        User session duration in minutes.
        """
        return pulumi.get(self, "session_duration")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of the event start time.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Enabled status. Value:
        -'on': Enable waiting room events
        -'off': Disable waiting room events
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Output[_builtins.str]:
        """
        Total number of active users.
        """
        return pulumi.get(self, "total_active_users")

    @_builtins.property
    @pulumi.getter(name="waitingRoomEventId")
    def waiting_room_event_id(self) -> pulumi.Output[_builtins.int]:
        """
        The waiting room event ID, which can be obtained by calling the [ListWaitingRoomEvents](https://help.aliyun.com/document_detail/2850279.html) operation.
        """
        return pulumi.get(self, "waiting_room_event_id")

    @_builtins.property
    @pulumi.getter(name="waitingRoomEventName")
    def waiting_room_event_name(self) -> pulumi.Output[_builtins.str]:
        """
        Event name, custom event description.
        """
        return pulumi.get(self, "waiting_room_event_name")

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> pulumi.Output[_builtins.str]:
        """
        Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        return pulumi.get(self, "waiting_room_id")

    @_builtins.property
    @pulumi.getter(name="waitingRoomType")
    def waiting_room_type(self) -> pulumi.Output[_builtins.str]:
        """
        Waiting room type. The following types are supported:
        -'default': the default type.
        -'custom': custom type.
        """
        return pulumi.get(self, "waiting_room_type")

