# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualPhysicalConnectionsResult',
    'AwaitableGetVirtualPhysicalConnectionsResult',
    'get_virtual_physical_connections',
    'get_virtual_physical_connections_output',
]

@pulumi.output_type
class GetVirtualPhysicalConnectionsResult:
    """
    A collection of values returned by getVirtualPhysicalConnections.
    """
    def __init__(__self__, business_status=None, connections=None, id=None, ids=None, is_confirmed=None, name_regex=None, names=None, output_file=None, parent_physical_connection_id=None, virtual_physical_connection_ids=None, virtual_physical_connection_status=None, vlan_ids=None, vpconn_ali_uid=None):
        if business_status and not isinstance(business_status, str):
            raise TypeError("Expected argument 'business_status' to be a str")
        pulumi.set(__self__, "business_status", business_status)
        if connections and not isinstance(connections, list):
            raise TypeError("Expected argument 'connections' to be a list")
        pulumi.set(__self__, "connections", connections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if is_confirmed and not isinstance(is_confirmed, bool):
            raise TypeError("Expected argument 'is_confirmed' to be a bool")
        pulumi.set(__self__, "is_confirmed", is_confirmed)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if parent_physical_connection_id and not isinstance(parent_physical_connection_id, str):
            raise TypeError("Expected argument 'parent_physical_connection_id' to be a str")
        pulumi.set(__self__, "parent_physical_connection_id", parent_physical_connection_id)
        if virtual_physical_connection_ids and not isinstance(virtual_physical_connection_ids, list):
            raise TypeError("Expected argument 'virtual_physical_connection_ids' to be a list")
        pulumi.set(__self__, "virtual_physical_connection_ids", virtual_physical_connection_ids)
        if virtual_physical_connection_status and not isinstance(virtual_physical_connection_status, str):
            raise TypeError("Expected argument 'virtual_physical_connection_status' to be a str")
        pulumi.set(__self__, "virtual_physical_connection_status", virtual_physical_connection_status)
        if vlan_ids and not isinstance(vlan_ids, list):
            raise TypeError("Expected argument 'vlan_ids' to be a list")
        pulumi.set(__self__, "vlan_ids", vlan_ids)
        if vpconn_ali_uid and not isinstance(vpconn_ali_uid, str):
            raise TypeError("Expected argument 'vpconn_ali_uid' to be a str")
        pulumi.set(__self__, "vpconn_ali_uid", vpconn_ali_uid)

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[_builtins.str]:
        """
        The commercial status of the physical line. Value:-**Normal**: activated.-**Financialized**: Arrears locked.-**SecurityLocked**: locked for security reasons.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetVirtualPhysicalConnectionsConnectionResult']:
        """
        A list of Virtual Physical Connection Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Virtual Physical Connection IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="isConfirmed")
    def is_confirmed(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_confirmed")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Virtual Physical Connections.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="parentPhysicalConnectionId")
    def parent_physical_connection_id(self) -> Optional[_builtins.str]:
        """
        The ID of the instance of the physical connection.
        """
        return pulumi.get(self, "parent_physical_connection_id")

    @_builtins.property
    @pulumi.getter(name="virtualPhysicalConnectionIds")
    def virtual_physical_connection_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "virtual_physical_connection_ids")

    @_builtins.property
    @pulumi.getter(name="virtualPhysicalConnectionStatus")
    def virtual_physical_connection_status(self) -> Optional[_builtins.str]:
        """
        The business status of the shared line. Value:-**Confirmed**: The shared line has been Confirmed to receive.-**UnConfirmed**: The shared line has not been confirmed to be received.-**Deleted**: The shared line has been Deleted.
        """
        return pulumi.get(self, "virtual_physical_connection_status")

    @_builtins.property
    @pulumi.getter(name="vlanIds")
    def vlan_ids(self) -> Optional[Sequence[_builtins.int]]:
        return pulumi.get(self, "vlan_ids")

    @_builtins.property
    @pulumi.getter(name="vpconnAliUid")
    def vpconn_ali_uid(self) -> Optional[_builtins.str]:
        """
        The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        return pulumi.get(self, "vpconn_ali_uid")


class AwaitableGetVirtualPhysicalConnectionsResult(GetVirtualPhysicalConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualPhysicalConnectionsResult(
            business_status=self.business_status,
            connections=self.connections,
            id=self.id,
            ids=self.ids,
            is_confirmed=self.is_confirmed,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            parent_physical_connection_id=self.parent_physical_connection_id,
            virtual_physical_connection_ids=self.virtual_physical_connection_ids,
            virtual_physical_connection_status=self.virtual_physical_connection_status,
            vlan_ids=self.vlan_ids,
            vpconn_ali_uid=self.vpconn_ali_uid)


def get_virtual_physical_connections(business_status: Optional[_builtins.str] = None,
                                     ids: Optional[Sequence[_builtins.str]] = None,
                                     is_confirmed: Optional[_builtins.bool] = None,
                                     name_regex: Optional[_builtins.str] = None,
                                     output_file: Optional[_builtins.str] = None,
                                     parent_physical_connection_id: Optional[_builtins.str] = None,
                                     virtual_physical_connection_ids: Optional[Sequence[_builtins.str]] = None,
                                     virtual_physical_connection_status: Optional[_builtins.str] = None,
                                     vlan_ids: Optional[Sequence[_builtins.int]] = None,
                                     vpconn_ali_uid: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualPhysicalConnectionsResult:
    """
    This data source provides Express Connect Virtual Physical Connection available to the user.

    > **NOTE:** Available in 1.196.0+


    :param _builtins.str business_status: The commercial status of the physical line. Value:
           - **Normal**: activated.
           - **Financialized**: Arrears locked.
           - **SecurityLocked**: locked for security reasons.
    :param Sequence[_builtins.str] ids: A list of Virtual Physical Connection IDs.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str parent_physical_connection_id: The ID of the instance of the physical connection.
    :param Sequence[_builtins.str] virtual_physical_connection_ids: The ID of the hosted connection. You can specify multiple hosted connection IDs.
    :param _builtins.str virtual_physical_connection_status: The business status of the shared line. Value:
           - **Confirmed**: The shared line has been Confirmed to receive.
           - **UnConfirmed**: The shared line has not been confirmed to be received.
           - **Deleted**: The shared line has been Deleted.
    :param Sequence[_builtins.int] vlan_ids: The VLAN ID of the hosted connection. You can specify multiple VLAN IDs.
    :param _builtins.str vpconn_ali_uid: The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
    """
    __args__ = dict()
    __args__['businessStatus'] = business_status
    __args__['ids'] = ids
    __args__['isConfirmed'] = is_confirmed
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['parentPhysicalConnectionId'] = parent_physical_connection_id
    __args__['virtualPhysicalConnectionIds'] = virtual_physical_connection_ids
    __args__['virtualPhysicalConnectionStatus'] = virtual_physical_connection_status
    __args__['vlanIds'] = vlan_ids
    __args__['vpconnAliUid'] = vpconn_ali_uid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:expressconnect/getVirtualPhysicalConnections:getVirtualPhysicalConnections', __args__, opts=opts, typ=GetVirtualPhysicalConnectionsResult).value

    return AwaitableGetVirtualPhysicalConnectionsResult(
        business_status=pulumi.get(__ret__, 'business_status'),
        connections=pulumi.get(__ret__, 'connections'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        is_confirmed=pulumi.get(__ret__, 'is_confirmed'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        parent_physical_connection_id=pulumi.get(__ret__, 'parent_physical_connection_id'),
        virtual_physical_connection_ids=pulumi.get(__ret__, 'virtual_physical_connection_ids'),
        virtual_physical_connection_status=pulumi.get(__ret__, 'virtual_physical_connection_status'),
        vlan_ids=pulumi.get(__ret__, 'vlan_ids'),
        vpconn_ali_uid=pulumi.get(__ret__, 'vpconn_ali_uid'))
def get_virtual_physical_connections_output(business_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                            is_confirmed: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                            name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            parent_physical_connection_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            virtual_physical_connection_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                            virtual_physical_connection_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            vlan_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.int]]]] = None,
                                            vpconn_ali_uid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualPhysicalConnectionsResult]:
    """
    This data source provides Express Connect Virtual Physical Connection available to the user.

    > **NOTE:** Available in 1.196.0+


    :param _builtins.str business_status: The commercial status of the physical line. Value:
           - **Normal**: activated.
           - **Financialized**: Arrears locked.
           - **SecurityLocked**: locked for security reasons.
    :param Sequence[_builtins.str] ids: A list of Virtual Physical Connection IDs.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str parent_physical_connection_id: The ID of the instance of the physical connection.
    :param Sequence[_builtins.str] virtual_physical_connection_ids: The ID of the hosted connection. You can specify multiple hosted connection IDs.
    :param _builtins.str virtual_physical_connection_status: The business status of the shared line. Value:
           - **Confirmed**: The shared line has been Confirmed to receive.
           - **UnConfirmed**: The shared line has not been confirmed to be received.
           - **Deleted**: The shared line has been Deleted.
    :param Sequence[_builtins.int] vlan_ids: The VLAN ID of the hosted connection. You can specify multiple VLAN IDs.
    :param _builtins.str vpconn_ali_uid: The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
    """
    __args__ = dict()
    __args__['businessStatus'] = business_status
    __args__['ids'] = ids
    __args__['isConfirmed'] = is_confirmed
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['parentPhysicalConnectionId'] = parent_physical_connection_id
    __args__['virtualPhysicalConnectionIds'] = virtual_physical_connection_ids
    __args__['virtualPhysicalConnectionStatus'] = virtual_physical_connection_status
    __args__['vlanIds'] = vlan_ids
    __args__['vpconnAliUid'] = vpconn_ali_uid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:expressconnect/getVirtualPhysicalConnections:getVirtualPhysicalConnections', __args__, opts=opts, typ=GetVirtualPhysicalConnectionsResult)
    return __ret__.apply(lambda __response__: GetVirtualPhysicalConnectionsResult(
        business_status=pulumi.get(__response__, 'business_status'),
        connections=pulumi.get(__response__, 'connections'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        is_confirmed=pulumi.get(__response__, 'is_confirmed'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        parent_physical_connection_id=pulumi.get(__response__, 'parent_physical_connection_id'),
        virtual_physical_connection_ids=pulumi.get(__response__, 'virtual_physical_connection_ids'),
        virtual_physical_connection_status=pulumi.get(__response__, 'virtual_physical_connection_status'),
        vlan_ids=pulumi.get(__response__, 'vlan_ids'),
        vpconn_ali_uid=pulumi.get(__response__, 'vpconn_ali_uid')))
