# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PhysicalConnectionArgs', 'PhysicalConnection']

@pulumi.input_type
class PhysicalConnectionArgs:
    def __init__(__self__, *,
                 access_point_id: pulumi.Input[_builtins.str],
                 line_operator: pulumi.Input[_builtins.str],
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_location: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 physical_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PhysicalConnection resource.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] line_operator: The connectivity provider of the Express Connect circuit. Valid values:
               - `CT`: China Telecom.
               - `CU`: China Unicom.
               - `CM`: China Mobile.
               - `CO`: Other connectivity providers in the Chinese mainland.
               - `Equinix`: Equinix.
               - `Other`: Other connectivity providers outside the Chinese mainland.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the hosted connection.
        :param pulumi.Input[_builtins.str] circuit_code: The circuit code of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] description: The description of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] peer_location: The geographical location of the data center.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Valid values:
               - If `pricing_cycle` is set to `Month`. Valid values: `1` to `9`.
               - If `pricing_cycle` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] physical_connection_name: The name of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] port_type: The port type of the Express Connect circuit. Valid values:
               - `100Base-T`: 100 Mbit/s copper Ethernet port.
               - `1000Base-T`: 1000 Mbit/s copper Ethernet port.
               - `1000Base-LX`: 1000 Mbit/s single-mode optical port (10 km).
               - `10GBase-T`: 10000 Mbit/s copper Ethernet port.
               - `10GBase-LR`: 10000 Mbit/s single-mode optical port (10 km).
               - `40GBase-LR`: 40000 Mbit/s single-mode optical port.
               - `100GBase-LR`: 100000 Mbit/s single-mode optical port.
               > **NOTE:** From version 1.185.0, `port_type` can be set to `40GBase-LR`, `100GBase-LR`. From version 1.230.1, `port_type` cannot be modified.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription. Default value: `Month`. Valid values: `Month`, `Year`.
               > **NOTE:** `period` and `pricing_cycle` are valid only when `status` is set to `Enabled`.
        :param pulumi.Input[_builtins.str] redundant_physical_connection_id: The ID of the redundant Express Connect circuit. **NOTE:** From version 1.230.1, `redundant_physical_connection_id` cannot be modified.
        :param pulumi.Input[_builtins.str] status: The status of the Express Connect circuit. Valid values: `Confirmed`, `Enabled`, `Canceled`, `Terminated`. **NOTE:** From version 1.230.1, `status` can be set to `Confirmed`. If you want to set `status` to `Enabled`, `period` must be set.
        :param pulumi.Input[_builtins.str] type: The type of Express Connect circuit. Default value: `VPC`. Valid values: `VPC`.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "line_operator", line_operator)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if peer_location is not None:
            pulumi.set(__self__, "peer_location", peer_location)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if physical_connection_name is not None:
            pulumi.set(__self__, "physical_connection_name", physical_connection_name)
        if port_type is not None:
            pulumi.set(__self__, "port_type", port_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if redundant_physical_connection_id is not None:
            pulumi.set(__self__, "redundant_physical_connection_id", redundant_physical_connection_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> pulumi.Input[_builtins.str]:
        """
        The access point ID of the Express Connect circuit.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_point_id", value)

    @_builtins.property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> pulumi.Input[_builtins.str]:
        """
        The connectivity provider of the Express Connect circuit. Valid values:
        - `CT`: China Telecom.
        - `CU`: China Unicom.
        - `CM`: China Mobile.
        - `CO`: Other connectivity providers in the Chinese mainland.
        - `Equinix`: Equinix.
        - `Other`: Other connectivity providers outside the Chinese mainland.
        """
        return pulumi.get(self, "line_operator")

    @line_operator.setter
    def line_operator(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "line_operator", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum bandwidth of the hosted connection.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The circuit code of the Express Connect circuit.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "circuit_code", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Express Connect circuit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographical location of the data center.
        """
        return pulumi.get(self, "peer_location")

    @peer_location.setter
    def peer_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_location", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription duration. Valid values:
        - If `pricing_cycle` is set to `Month`. Valid values: `1` to `9`.
        - If `pricing_cycle` is set to `Year`. Valid values: `1` to `5`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="physicalConnectionName")
    def physical_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Express Connect circuit.
        """
        return pulumi.get(self, "physical_connection_name")

    @physical_connection_name.setter
    def physical_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "physical_connection_name", value)

    @_builtins.property
    @pulumi.getter(name="portType")
    def port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port type of the Express Connect circuit. Valid values:
        - `100Base-T`: 100 Mbit/s copper Ethernet port.
        - `1000Base-T`: 1000 Mbit/s copper Ethernet port.
        - `1000Base-LX`: 1000 Mbit/s single-mode optical port (10 km).
        - `10GBase-T`: 10000 Mbit/s copper Ethernet port.
        - `10GBase-LR`: 10000 Mbit/s single-mode optical port (10 km).
        - `40GBase-LR`: 40000 Mbit/s single-mode optical port.
        - `100GBase-LR`: 100000 Mbit/s single-mode optical port.
        > **NOTE:** From version 1.185.0, `port_type` can be set to `40GBase-LR`, `100GBase-LR`. From version 1.230.1, `port_type` cannot be modified.
        """
        return pulumi.get(self, "port_type")

    @port_type.setter
    def port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the subscription. Default value: `Month`. Valid values: `Month`, `Year`.
        > **NOTE:** `period` and `pricing_cycle` are valid only when `status` is set to `Enabled`.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the redundant Express Connect circuit. **NOTE:** From version 1.230.1, `redundant_physical_connection_id` cannot be modified.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @redundant_physical_connection_id.setter
    def redundant_physical_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundant_physical_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Express Connect circuit. Valid values: `Confirmed`, `Enabled`, `Canceled`, `Terminated`. **NOTE:** From version 1.230.1, `status` can be set to `Confirmed`. If you want to set `status` to `Enabled`, `period` must be set.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Express Connect circuit. Default value: `VPC`. Valid values: `VPC`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _PhysicalConnectionState:
    def __init__(__self__, *,
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 line_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 order_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_location: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 physical_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PhysicalConnection resources.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the hosted connection.
        :param pulumi.Input[_builtins.str] circuit_code: The circuit code of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] description: The description of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] line_operator: The connectivity provider of the Express Connect circuit. Valid values:
               - `CT`: China Telecom.
               - `CU`: China Unicom.
               - `CM`: China Mobile.
               - `CO`: Other connectivity providers in the Chinese mainland.
               - `Equinix`: Equinix.
               - `Other`: Other connectivity providers outside the Chinese mainland.
        :param pulumi.Input[_builtins.str] order_id: The ID of the order that is placed. **Note:** `order_id` takes effect only if `status` is set to `Enabled`.
        :param pulumi.Input[_builtins.str] peer_location: The geographical location of the data center.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Valid values:
               - If `pricing_cycle` is set to `Month`. Valid values: `1` to `9`.
               - If `pricing_cycle` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] physical_connection_name: The name of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] port_type: The port type of the Express Connect circuit. Valid values:
               - `100Base-T`: 100 Mbit/s copper Ethernet port.
               - `1000Base-T`: 1000 Mbit/s copper Ethernet port.
               - `1000Base-LX`: 1000 Mbit/s single-mode optical port (10 km).
               - `10GBase-T`: 10000 Mbit/s copper Ethernet port.
               - `10GBase-LR`: 10000 Mbit/s single-mode optical port (10 km).
               - `40GBase-LR`: 40000 Mbit/s single-mode optical port.
               - `100GBase-LR`: 100000 Mbit/s single-mode optical port.
               > **NOTE:** From version 1.185.0, `port_type` can be set to `40GBase-LR`, `100GBase-LR`. From version 1.230.1, `port_type` cannot be modified.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription. Default value: `Month`. Valid values: `Month`, `Year`.
               > **NOTE:** `period` and `pricing_cycle` are valid only when `status` is set to `Enabled`.
        :param pulumi.Input[_builtins.str] redundant_physical_connection_id: The ID of the redundant Express Connect circuit. **NOTE:** From version 1.230.1, `redundant_physical_connection_id` cannot be modified.
        :param pulumi.Input[_builtins.str] status: The status of the Express Connect circuit. Valid values: `Confirmed`, `Enabled`, `Canceled`, `Terminated`. **NOTE:** From version 1.230.1, `status` can be set to `Confirmed`. If you want to set `status` to `Enabled`, `period` must be set.
        :param pulumi.Input[_builtins.str] type: The type of Express Connect circuit. Default value: `VPC`. Valid values: `VPC`.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if line_operator is not None:
            pulumi.set(__self__, "line_operator", line_operator)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)
        if peer_location is not None:
            pulumi.set(__self__, "peer_location", peer_location)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if physical_connection_name is not None:
            pulumi.set(__self__, "physical_connection_name", physical_connection_name)
        if port_type is not None:
            pulumi.set(__self__, "port_type", port_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if redundant_physical_connection_id is not None:
            pulumi.set(__self__, "redundant_physical_connection_id", redundant_physical_connection_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access point ID of the Express Connect circuit.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_id", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum bandwidth of the hosted connection.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The circuit code of the Express Connect circuit.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "circuit_code", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Express Connect circuit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connectivity provider of the Express Connect circuit. Valid values:
        - `CT`: China Telecom.
        - `CU`: China Unicom.
        - `CM`: China Mobile.
        - `CO`: Other connectivity providers in the Chinese mainland.
        - `Equinix`: Equinix.
        - `Other`: Other connectivity providers outside the Chinese mainland.
        """
        return pulumi.get(self, "line_operator")

    @line_operator.setter
    def line_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "line_operator", value)

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the order that is placed. **Note:** `order_id` takes effect only if `status` is set to `Enabled`.
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "order_id", value)

    @_builtins.property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographical location of the data center.
        """
        return pulumi.get(self, "peer_location")

    @peer_location.setter
    def peer_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_location", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription duration. Valid values:
        - If `pricing_cycle` is set to `Month`. Valid values: `1` to `9`.
        - If `pricing_cycle` is set to `Year`. Valid values: `1` to `5`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="physicalConnectionName")
    def physical_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Express Connect circuit.
        """
        return pulumi.get(self, "physical_connection_name")

    @physical_connection_name.setter
    def physical_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "physical_connection_name", value)

    @_builtins.property
    @pulumi.getter(name="portType")
    def port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port type of the Express Connect circuit. Valid values:
        - `100Base-T`: 100 Mbit/s copper Ethernet port.
        - `1000Base-T`: 1000 Mbit/s copper Ethernet port.
        - `1000Base-LX`: 1000 Mbit/s single-mode optical port (10 km).
        - `10GBase-T`: 10000 Mbit/s copper Ethernet port.
        - `10GBase-LR`: 10000 Mbit/s single-mode optical port (10 km).
        - `40GBase-LR`: 40000 Mbit/s single-mode optical port.
        - `100GBase-LR`: 100000 Mbit/s single-mode optical port.
        > **NOTE:** From version 1.185.0, `port_type` can be set to `40GBase-LR`, `100GBase-LR`. From version 1.230.1, `port_type` cannot be modified.
        """
        return pulumi.get(self, "port_type")

    @port_type.setter
    def port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the subscription. Default value: `Month`. Valid values: `Month`, `Year`.
        > **NOTE:** `period` and `pricing_cycle` are valid only when `status` is set to `Enabled`.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the redundant Express Connect circuit. **NOTE:** From version 1.230.1, `redundant_physical_connection_id` cannot be modified.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @redundant_physical_connection_id.setter
    def redundant_physical_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundant_physical_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Express Connect circuit. Valid values: `Confirmed`, `Enabled`, `Canceled`, `Terminated`. **NOTE:** From version 1.230.1, `status` can be set to `Confirmed`. If you want to set `status` to `Enabled`, `period` must be set.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Express Connect circuit. Default value: `VPC`. Valid values: `VPC`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:expressconnect/physicalConnection:PhysicalConnection")
class PhysicalConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 line_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_location: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 physical_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Physical Connection resource.

        For information about Express Connect Physical Connection and how to use it, see [What is Physical Connection](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-vpc-2016-04-28-createphysicalconnection-efficiency-channels).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        domestic = alicloud.expressconnect.PhysicalConnection("domestic",
            access_point_id="ap-cn-hangzhou-yh-B",
            line_operator="CT",
            peer_location="example_value",
            physical_connection_name="example_value",
            type="VPC",
            description="my domestic connection",
            port_type="1000Base-LX",
            bandwidth="100")
        international = alicloud.expressconnect.PhysicalConnection("international",
            access_point_id="ap-sg-singpore-A",
            line_operator="Other",
            peer_location="example_value",
            physical_connection_name="example_value",
            type="VPC",
            description="my domestic connection",
            port_type="1000Base-LX",
            bandwidth="100")
        ```

        ## Import

        Express Connect Physical Connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/physicalConnection:PhysicalConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the hosted connection.
        :param pulumi.Input[_builtins.str] circuit_code: The circuit code of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] description: The description of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] line_operator: The connectivity provider of the Express Connect circuit. Valid values:
               - `CT`: China Telecom.
               - `CU`: China Unicom.
               - `CM`: China Mobile.
               - `CO`: Other connectivity providers in the Chinese mainland.
               - `Equinix`: Equinix.
               - `Other`: Other connectivity providers outside the Chinese mainland.
        :param pulumi.Input[_builtins.str] peer_location: The geographical location of the data center.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Valid values:
               - If `pricing_cycle` is set to `Month`. Valid values: `1` to `9`.
               - If `pricing_cycle` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] physical_connection_name: The name of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] port_type: The port type of the Express Connect circuit. Valid values:
               - `100Base-T`: 100 Mbit/s copper Ethernet port.
               - `1000Base-T`: 1000 Mbit/s copper Ethernet port.
               - `1000Base-LX`: 1000 Mbit/s single-mode optical port (10 km).
               - `10GBase-T`: 10000 Mbit/s copper Ethernet port.
               - `10GBase-LR`: 10000 Mbit/s single-mode optical port (10 km).
               - `40GBase-LR`: 40000 Mbit/s single-mode optical port.
               - `100GBase-LR`: 100000 Mbit/s single-mode optical port.
               > **NOTE:** From version 1.185.0, `port_type` can be set to `40GBase-LR`, `100GBase-LR`. From version 1.230.1, `port_type` cannot be modified.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription. Default value: `Month`. Valid values: `Month`, `Year`.
               > **NOTE:** `period` and `pricing_cycle` are valid only when `status` is set to `Enabled`.
        :param pulumi.Input[_builtins.str] redundant_physical_connection_id: The ID of the redundant Express Connect circuit. **NOTE:** From version 1.230.1, `redundant_physical_connection_id` cannot be modified.
        :param pulumi.Input[_builtins.str] status: The status of the Express Connect circuit. Valid values: `Confirmed`, `Enabled`, `Canceled`, `Terminated`. **NOTE:** From version 1.230.1, `status` can be set to `Confirmed`. If you want to set `status` to `Enabled`, `period` must be set.
        :param pulumi.Input[_builtins.str] type: The type of Express Connect circuit. Default value: `VPC`. Valid values: `VPC`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PhysicalConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Physical Connection resource.

        For information about Express Connect Physical Connection and how to use it, see [What is Physical Connection](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-vpc-2016-04-28-createphysicalconnection-efficiency-channels).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        domestic = alicloud.expressconnect.PhysicalConnection("domestic",
            access_point_id="ap-cn-hangzhou-yh-B",
            line_operator="CT",
            peer_location="example_value",
            physical_connection_name="example_value",
            type="VPC",
            description="my domestic connection",
            port_type="1000Base-LX",
            bandwidth="100")
        international = alicloud.expressconnect.PhysicalConnection("international",
            access_point_id="ap-sg-singpore-A",
            line_operator="Other",
            peer_location="example_value",
            physical_connection_name="example_value",
            type="VPC",
            description="my domestic connection",
            port_type="1000Base-LX",
            bandwidth="100")
        ```

        ## Import

        Express Connect Physical Connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/physicalConnection:PhysicalConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PhysicalConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PhysicalConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 line_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_location: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 physical_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PhysicalConnectionArgs.__new__(PhysicalConnectionArgs)

            if access_point_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_point_id'")
            __props__.__dict__["access_point_id"] = access_point_id
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["circuit_code"] = circuit_code
            __props__.__dict__["description"] = description
            if line_operator is None and not opts.urn:
                raise TypeError("Missing required property 'line_operator'")
            __props__.__dict__["line_operator"] = line_operator
            __props__.__dict__["peer_location"] = peer_location
            __props__.__dict__["period"] = period
            __props__.__dict__["physical_connection_name"] = physical_connection_name
            __props__.__dict__["port_type"] = port_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["redundant_physical_connection_id"] = redundant_physical_connection_id
            __props__.__dict__["status"] = status
            __props__.__dict__["type"] = type
            __props__.__dict__["order_id"] = None
        super(PhysicalConnection, __self__).__init__(
            'alicloud:expressconnect/physicalConnection:PhysicalConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            circuit_code: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            line_operator: Optional[pulumi.Input[_builtins.str]] = None,
            order_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_location: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            physical_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
            port_type: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            redundant_physical_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'PhysicalConnection':
        """
        Get an existing PhysicalConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_id: The access point ID of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the hosted connection.
        :param pulumi.Input[_builtins.str] circuit_code: The circuit code of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] description: The description of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] line_operator: The connectivity provider of the Express Connect circuit. Valid values:
               - `CT`: China Telecom.
               - `CU`: China Unicom.
               - `CM`: China Mobile.
               - `CO`: Other connectivity providers in the Chinese mainland.
               - `Equinix`: Equinix.
               - `Other`: Other connectivity providers outside the Chinese mainland.
        :param pulumi.Input[_builtins.str] order_id: The ID of the order that is placed. **Note:** `order_id` takes effect only if `status` is set to `Enabled`.
        :param pulumi.Input[_builtins.str] peer_location: The geographical location of the data center.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Valid values:
               - If `pricing_cycle` is set to `Month`. Valid values: `1` to `9`.
               - If `pricing_cycle` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] physical_connection_name: The name of the Express Connect circuit.
        :param pulumi.Input[_builtins.str] port_type: The port type of the Express Connect circuit. Valid values:
               - `100Base-T`: 100 Mbit/s copper Ethernet port.
               - `1000Base-T`: 1000 Mbit/s copper Ethernet port.
               - `1000Base-LX`: 1000 Mbit/s single-mode optical port (10 km).
               - `10GBase-T`: 10000 Mbit/s copper Ethernet port.
               - `10GBase-LR`: 10000 Mbit/s single-mode optical port (10 km).
               - `40GBase-LR`: 40000 Mbit/s single-mode optical port.
               - `100GBase-LR`: 100000 Mbit/s single-mode optical port.
               > **NOTE:** From version 1.185.0, `port_type` can be set to `40GBase-LR`, `100GBase-LR`. From version 1.230.1, `port_type` cannot be modified.
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the subscription. Default value: `Month`. Valid values: `Month`, `Year`.
               > **NOTE:** `period` and `pricing_cycle` are valid only when `status` is set to `Enabled`.
        :param pulumi.Input[_builtins.str] redundant_physical_connection_id: The ID of the redundant Express Connect circuit. **NOTE:** From version 1.230.1, `redundant_physical_connection_id` cannot be modified.
        :param pulumi.Input[_builtins.str] status: The status of the Express Connect circuit. Valid values: `Confirmed`, `Enabled`, `Canceled`, `Terminated`. **NOTE:** From version 1.230.1, `status` can be set to `Confirmed`. If you want to set `status` to `Enabled`, `period` must be set.
        :param pulumi.Input[_builtins.str] type: The type of Express Connect circuit. Default value: `VPC`. Valid values: `VPC`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PhysicalConnectionState.__new__(_PhysicalConnectionState)

        __props__.__dict__["access_point_id"] = access_point_id
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["circuit_code"] = circuit_code
        __props__.__dict__["description"] = description
        __props__.__dict__["line_operator"] = line_operator
        __props__.__dict__["order_id"] = order_id
        __props__.__dict__["peer_location"] = peer_location
        __props__.__dict__["period"] = period
        __props__.__dict__["physical_connection_name"] = physical_connection_name
        __props__.__dict__["port_type"] = port_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["redundant_physical_connection_id"] = redundant_physical_connection_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return PhysicalConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> pulumi.Output[_builtins.str]:
        """
        The access point ID of the Express Connect circuit.
        """
        return pulumi.get(self, "access_point_id")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum bandwidth of the hosted connection.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The circuit code of the Express Connect circuit.
        """
        return pulumi.get(self, "circuit_code")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Express Connect circuit.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> pulumi.Output[_builtins.str]:
        """
        The connectivity provider of the Express Connect circuit. Valid values:
        - `CT`: China Telecom.
        - `CU`: China Unicom.
        - `CM`: China Mobile.
        - `CO`: Other connectivity providers in the Chinese mainland.
        - `Equinix`: Equinix.
        - `Other`: Other connectivity providers outside the Chinese mainland.
        """
        return pulumi.get(self, "line_operator")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the order that is placed. **Note:** `order_id` takes effect only if `status` is set to `Enabled`.
        """
        return pulumi.get(self, "order_id")

    @_builtins.property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographical location of the data center.
        """
        return pulumi.get(self, "peer_location")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The subscription duration. Valid values:
        - If `pricing_cycle` is set to `Month`. Valid values: `1` to `9`.
        - If `pricing_cycle` is set to `Year`. Valid values: `1` to `5`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="physicalConnectionName")
    def physical_connection_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Express Connect circuit.
        """
        return pulumi.get(self, "physical_connection_name")

    @_builtins.property
    @pulumi.getter(name="portType")
    def port_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port type of the Express Connect circuit. Valid values:
        - `100Base-T`: 100 Mbit/s copper Ethernet port.
        - `1000Base-T`: 1000 Mbit/s copper Ethernet port.
        - `1000Base-LX`: 1000 Mbit/s single-mode optical port (10 km).
        - `10GBase-T`: 10000 Mbit/s copper Ethernet port.
        - `10GBase-LR`: 10000 Mbit/s single-mode optical port (10 km).
        - `40GBase-LR`: 40000 Mbit/s single-mode optical port.
        - `100GBase-LR`: 100000 Mbit/s single-mode optical port.
        > **NOTE:** From version 1.185.0, `port_type` can be set to `40GBase-LR`, `100GBase-LR`. From version 1.230.1, `port_type` cannot be modified.
        """
        return pulumi.get(self, "port_type")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing cycle of the subscription. Default value: `Month`. Valid values: `Month`, `Year`.
        > **NOTE:** `period` and `pricing_cycle` are valid only when `status` is set to `Enabled`.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the redundant Express Connect circuit. **NOTE:** From version 1.230.1, `redundant_physical_connection_id` cannot be modified.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Express Connect circuit. Valid values: `Confirmed`, `Enabled`, `Canceled`, `Terminated`. **NOTE:** From version 1.230.1, `status` can be set to `Confirmed`. If you want to set `status` to `Enabled`, `period` must be set.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of Express Connect circuit. Default value: `VPC`. Valid values: `VPC`.
        """
        return pulumi.get(self, "type")

