# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrafficQosArgs', 'TrafficQos']

@pulumi.input_type
class TrafficQosArgs:
    def __init__(__self__, *,
                 qos_description: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TrafficQos resource.
        :param pulumi.Input[_builtins.str] qos_description: The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] qos_name: The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
        """
        if qos_description is not None:
            pulumi.set(__self__, "qos_description", qos_description)
        if qos_name is not None:
            pulumi.set(__self__, "qos_name", qos_name)

    @_builtins.property
    @pulumi.getter(name="qosDescription")
    def qos_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "qos_description")

    @qos_description.setter
    def qos_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_description", value)

    @_builtins.property
    @pulumi.getter(name="qosName")
    def qos_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "qos_name")

    @qos_name.setter
    def qos_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_name", value)


@pulumi.input_type
class _TrafficQosState:
    def __init__(__self__, *,
                 qos_description: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrafficQos resources.
        :param pulumi.Input[_builtins.str] qos_description: The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] qos_name: The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] status: The status of the QoS policy. Value:
               > **NOTE:**  QoS in the configuration state will restrict the creation, update, and deletion of most QoS policies, QoS queues, and QoS rules.
        """
        if qos_description is not None:
            pulumi.set(__self__, "qos_description", qos_description)
        if qos_name is not None:
            pulumi.set(__self__, "qos_name", qos_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="qosDescription")
    def qos_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "qos_description")

    @qos_description.setter
    def qos_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_description", value)

    @_builtins.property
    @pulumi.getter(name="qosName")
    def qos_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "qos_name")

    @qos_name.setter
    def qos_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the QoS policy. Value:
        > **NOTE:**  QoS in the configuration state will restrict the creation, update, and deletion of most QoS policies, QoS queues, and QoS rules.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:expressconnect/trafficQos:TrafficQos")
class TrafficQos(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 qos_description: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Traffic Qos resource. Express Connect Traffic QoS Policy.

        For information about Express Connect Traffic Qos and how to use it, see [What is Traffic Qos](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/CreateExpressConnectTrafficQos).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        create_qos = alicloud.expressconnect.TrafficQos("createQos",
            qos_name=name,
            qos_description="terraform-example")
        ```

        ## Import

        Express Connect Traffic Qos can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/trafficQos:TrafficQos example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] qos_description: The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] qos_name: The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TrafficQosArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Traffic Qos resource. Express Connect Traffic QoS Policy.

        For information about Express Connect Traffic Qos and how to use it, see [What is Traffic Qos](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/CreateExpressConnectTrafficQos).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        create_qos = alicloud.expressconnect.TrafficQos("createQos",
            qos_name=name,
            qos_description="terraform-example")
        ```

        ## Import

        Express Connect Traffic Qos can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/trafficQos:TrafficQos example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TrafficQosArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficQosArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 qos_description: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficQosArgs.__new__(TrafficQosArgs)

            __props__.__dict__["qos_description"] = qos_description
            __props__.__dict__["qos_name"] = qos_name
            __props__.__dict__["status"] = None
        super(TrafficQos, __self__).__init__(
            'alicloud:expressconnect/trafficQos:TrafficQos',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            qos_description: Optional[pulumi.Input[_builtins.str]] = None,
            qos_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrafficQos':
        """
        Get an existing TrafficQos resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] qos_description: The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] qos_name: The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] status: The status of the QoS policy. Value:
               > **NOTE:**  QoS in the configuration state will restrict the creation, update, and deletion of most QoS policies, QoS queues, and QoS rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficQosState.__new__(_TrafficQosState)

        __props__.__dict__["qos_description"] = qos_description
        __props__.__dict__["qos_name"] = qos_name
        __props__.__dict__["status"] = status
        return TrafficQos(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="qosDescription")
    def qos_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the QoS policy.  The length is **0** to **256** characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "qos_description")

    @_builtins.property
    @pulumi.getter(name="qosName")
    def qos_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the QoS policy.  The length is **0** to **128** characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "qos_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the QoS policy. Value:
        > **NOTE:**  QoS in the configuration state will restrict the creation, update, and deletion of most QoS policies, QoS queues, and QoS rules.
        """
        return pulumi.get(self, "status")

