# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrafficQosRuleArgs', 'TrafficQosRule']

@pulumi.input_type
class TrafficQosRuleArgs:
    def __init__(__self__, *,
                 priority: pulumi.Input[_builtins.int],
                 protocol: pulumi.Input[_builtins.str],
                 qos_id: pulumi.Input[_builtins.str],
                 queue_id: pulumi.Input[_builtins.str],
                 dst_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 match_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 remarking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_description: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 src_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_port_range: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TrafficQosRule resource.
        :param pulumi.Input[_builtins.int] priority: QoS rule priority. Value range: **1** to **9000**. The larger the number, the higher the priority. The priority of a QoS rule cannot be repeated in the same QoS policy.
        :param pulumi.Input[_builtins.str] protocol: QoS rule protocol type, value:
               - **ALL**
               - **ICMP(IPv4)**
               - **ICMPv6(IPv6)* *
               - **TCP**
               - **UDP**
               - **GRE**
               - **SSH**
               - **Telnet**
               - **HTTP**
               - **HTTPS**
               - **MS SQL**
               - **Oracle**
               - **MySql**
               - **RDP**
               - **PostgreSQL**
               - **Redis**.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        :param pulumi.Input[_builtins.str] queue_id: The QoS queue ID.
        :param pulumi.Input[_builtins.str] dst_cidr: The traffic of the QoS rule matches the Destination IPv4 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] dst_ipv6_cidr: The QoS rule traffic matches the Destination IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] dst_port_range: QoS rule traffic matches the destination port number range. Value range: **0** to **65535**. If not, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same. The corresponding destination port number range is fixed for different protocol types. The values are as follows:
               - **ALL**:-1/-1, not editable.
               - **ICMP(IPv4)**:-1/-1, non-editable.
               - **ICMPv6(IPv6)**:-1/-1, non-editable.
               - **TCP**:-1/-1, editable.
               - **UDP**:-1/-1, editable.
               - **GRE**:-1/-1, not editable.
               - **SSH**:22/22, not editable.
               - **Telnet**:23/23, not editable.
               - **HTTP**:80/80, non-editable.
               - **HTTPS**:443/443, which cannot be edited.
               - **MS SQL**:1443/1443, which cannot be edited.
               - **Oracle**:1521/1521, non-editable.
               - **MySql**:3306/3306, non-editable.
               - **RDP**:3389/3389, non-editable.
               - **PostgreSQL**:5432/5432, non-editable.
               - **Redis**:6379/6379, non-editable.
        :param pulumi.Input[_builtins.int] match_dscp: The DSCP value of the traffic matched by the QoS rule. Value range: **0** to **63**. If not, the value is - 1.
        :param pulumi.Input[_builtins.int] remarking_dscp: Modify The DSCP value in the flow. Value range: **0** to **63**. If the value is not modified, the value is - 1.
        :param pulumi.Input[_builtins.str] rule_description: The description of the QoS rule.  The length is 0 to 256 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] rule_name: The name of the QoS rule.  The length is 0 to 128 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] src_cidr: The QoS rule traffic matches the source IPv4 CIDR block.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] src_ipv6_cidr: The QoS rule traffic matches the source IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] src_port_range: The source port number of the QoS rule traffic matching. The value range is **0** to **65535**. If the traffic does not match, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "qos_id", qos_id)
        pulumi.set(__self__, "queue_id", queue_id)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_ipv6_cidr is not None:
            pulumi.set(__self__, "dst_ipv6_cidr", dst_ipv6_cidr)
        if dst_port_range is not None:
            pulumi.set(__self__, "dst_port_range", dst_port_range)
        if match_dscp is not None:
            pulumi.set(__self__, "match_dscp", match_dscp)
        if remarking_dscp is not None:
            pulumi.set(__self__, "remarking_dscp", remarking_dscp)
        if rule_description is not None:
            pulumi.set(__self__, "rule_description", rule_description)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_ipv6_cidr is not None:
            pulumi.set(__self__, "src_ipv6_cidr", src_ipv6_cidr)
        if src_port_range is not None:
            pulumi.set(__self__, "src_port_range", src_port_range)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        QoS rule priority. Value range: **1** to **9000**. The larger the number, the higher the priority. The priority of a QoS rule cannot be repeated in the same QoS policy.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        QoS rule protocol type, value:
        - **ALL**
        - **ICMP(IPv4)**
        - **ICMPv6(IPv6)* *
        - **TCP**
        - **UDP**
        - **GRE**
        - **SSH**
        - **Telnet**
        - **HTTP**
        - **HTTPS**
        - **MS SQL**
        - **Oracle**
        - **MySql**
        - **RDP**
        - **PostgreSQL**
        - **Redis**.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> pulumi.Input[_builtins.str]:
        """
        The QoS policy ID.
        """
        return pulumi.get(self, "qos_id")

    @qos_id.setter
    def qos_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "qos_id", value)

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> pulumi.Input[_builtins.str]:
        """
        The QoS queue ID.
        """
        return pulumi.get(self, "queue_id")

    @queue_id.setter
    def queue_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_id", value)

    @_builtins.property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The traffic of the QoS rule matches the Destination IPv4 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_cidr", value)

    @_builtins.property
    @pulumi.getter(name="dstIpv6Cidr")
    def dst_ipv6_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS rule traffic matches the Destination IPv6 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        """
        return pulumi.get(self, "dst_ipv6_cidr")

    @dst_ipv6_cidr.setter
    def dst_ipv6_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_ipv6_cidr", value)

    @_builtins.property
    @pulumi.getter(name="dstPortRange")
    def dst_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        QoS rule traffic matches the destination port number range. Value range: **0** to **65535**. If not, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same. The corresponding destination port number range is fixed for different protocol types. The values are as follows:
        - **ALL**:-1/-1, not editable.
        - **ICMP(IPv4)**:-1/-1, non-editable.
        - **ICMPv6(IPv6)**:-1/-1, non-editable.
        - **TCP**:-1/-1, editable.
        - **UDP**:-1/-1, editable.
        - **GRE**:-1/-1, not editable.
        - **SSH**:22/22, not editable.
        - **Telnet**:23/23, not editable.
        - **HTTP**:80/80, non-editable.
        - **HTTPS**:443/443, which cannot be edited.
        - **MS SQL**:1443/1443, which cannot be edited.
        - **Oracle**:1521/1521, non-editable.
        - **MySql**:3306/3306, non-editable.
        - **RDP**:3389/3389, non-editable.
        - **PostgreSQL**:5432/5432, non-editable.
        - **Redis**:6379/6379, non-editable.
        """
        return pulumi.get(self, "dst_port_range")

    @dst_port_range.setter
    def dst_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_port_range", value)

    @_builtins.property
    @pulumi.getter(name="matchDscp")
    def match_dscp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The DSCP value of the traffic matched by the QoS rule. Value range: **0** to **63**. If not, the value is - 1.
        """
        return pulumi.get(self, "match_dscp")

    @match_dscp.setter
    def match_dscp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "match_dscp", value)

    @_builtins.property
    @pulumi.getter(name="remarkingDscp")
    def remarking_dscp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Modify The DSCP value in the flow. Value range: **0** to **63**. If the value is not modified, the value is - 1.
        """
        return pulumi.get(self, "remarking_dscp")

    @remarking_dscp.setter
    def remarking_dscp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "remarking_dscp", value)

    @_builtins.property
    @pulumi.getter(name="ruleDescription")
    def rule_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the QoS rule.  The length is 0 to 256 characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "rule_description")

    @rule_description.setter
    def rule_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_description", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the QoS rule.  The length is 0 to 128 characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS rule traffic matches the source IPv4 CIDR block.
        > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_cidr", value)

    @_builtins.property
    @pulumi.getter(name="srcIpv6Cidr")
    def src_ipv6_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS rule traffic matches the source IPv6 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        """
        return pulumi.get(self, "src_ipv6_cidr")

    @src_ipv6_cidr.setter
    def src_ipv6_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_ipv6_cidr", value)

    @_builtins.property
    @pulumi.getter(name="srcPortRange")
    def src_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source port number of the QoS rule traffic matching. The value range is **0** to **65535**. If the traffic does not match, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same.
        """
        return pulumi.get(self, "src_port_range")

    @src_port_range.setter
    def src_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_port_range", value)


@pulumi.input_type
class _TrafficQosRuleState:
    def __init__(__self__, *,
                 dst_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 match_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remarking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_description: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 src_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrafficQosRule resources.
        :param pulumi.Input[_builtins.str] dst_cidr: The traffic of the QoS rule matches the Destination IPv4 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] dst_ipv6_cidr: The QoS rule traffic matches the Destination IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] dst_port_range: QoS rule traffic matches the destination port number range. Value range: **0** to **65535**. If not, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same. The corresponding destination port number range is fixed for different protocol types. The values are as follows:
               - **ALL**:-1/-1, not editable.
               - **ICMP(IPv4)**:-1/-1, non-editable.
               - **ICMPv6(IPv6)**:-1/-1, non-editable.
               - **TCP**:-1/-1, editable.
               - **UDP**:-1/-1, editable.
               - **GRE**:-1/-1, not editable.
               - **SSH**:22/22, not editable.
               - **Telnet**:23/23, not editable.
               - **HTTP**:80/80, non-editable.
               - **HTTPS**:443/443, which cannot be edited.
               - **MS SQL**:1443/1443, which cannot be edited.
               - **Oracle**:1521/1521, non-editable.
               - **MySql**:3306/3306, non-editable.
               - **RDP**:3389/3389, non-editable.
               - **PostgreSQL**:5432/5432, non-editable.
               - **Redis**:6379/6379, non-editable.
        :param pulumi.Input[_builtins.int] match_dscp: The DSCP value of the traffic matched by the QoS rule. Value range: **0** to **63**. If not, the value is - 1.
        :param pulumi.Input[_builtins.int] priority: QoS rule priority. Value range: **1** to **9000**. The larger the number, the higher the priority. The priority of a QoS rule cannot be repeated in the same QoS policy.
        :param pulumi.Input[_builtins.str] protocol: QoS rule protocol type, value:
               - **ALL**
               - **ICMP(IPv4)**
               - **ICMPv6(IPv6)* *
               - **TCP**
               - **UDP**
               - **GRE**
               - **SSH**
               - **Telnet**
               - **HTTP**
               - **HTTPS**
               - **MS SQL**
               - **Oracle**
               - **MySql**
               - **RDP**
               - **PostgreSQL**
               - **Redis**.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        :param pulumi.Input[_builtins.str] queue_id: The QoS queue ID.
        :param pulumi.Input[_builtins.int] remarking_dscp: Modify The DSCP value in the flow. Value range: **0** to **63**. If the value is not modified, the value is - 1.
        :param pulumi.Input[_builtins.str] rule_description: The description of the QoS rule.  The length is 0 to 256 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the QoS rule.
        :param pulumi.Input[_builtins.str] rule_name: The name of the QoS rule.  The length is 0 to 128 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] src_cidr: The QoS rule traffic matches the source IPv4 CIDR block.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] src_ipv6_cidr: The QoS rule traffic matches the source IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] src_port_range: The source port number of the QoS rule traffic matching. The value range is **0** to **65535**. If the traffic does not match, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same.
        :param pulumi.Input[_builtins.str] status: The status of the QoS rule. Value:
        """
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_ipv6_cidr is not None:
            pulumi.set(__self__, "dst_ipv6_cidr", dst_ipv6_cidr)
        if dst_port_range is not None:
            pulumi.set(__self__, "dst_port_range", dst_port_range)
        if match_dscp is not None:
            pulumi.set(__self__, "match_dscp", match_dscp)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if qos_id is not None:
            pulumi.set(__self__, "qos_id", qos_id)
        if queue_id is not None:
            pulumi.set(__self__, "queue_id", queue_id)
        if remarking_dscp is not None:
            pulumi.set(__self__, "remarking_dscp", remarking_dscp)
        if rule_description is not None:
            pulumi.set(__self__, "rule_description", rule_description)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_ipv6_cidr is not None:
            pulumi.set(__self__, "src_ipv6_cidr", src_ipv6_cidr)
        if src_port_range is not None:
            pulumi.set(__self__, "src_port_range", src_port_range)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The traffic of the QoS rule matches the Destination IPv4 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_cidr", value)

    @_builtins.property
    @pulumi.getter(name="dstIpv6Cidr")
    def dst_ipv6_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS rule traffic matches the Destination IPv6 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        """
        return pulumi.get(self, "dst_ipv6_cidr")

    @dst_ipv6_cidr.setter
    def dst_ipv6_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_ipv6_cidr", value)

    @_builtins.property
    @pulumi.getter(name="dstPortRange")
    def dst_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        QoS rule traffic matches the destination port number range. Value range: **0** to **65535**. If not, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same. The corresponding destination port number range is fixed for different protocol types. The values are as follows:
        - **ALL**:-1/-1, not editable.
        - **ICMP(IPv4)**:-1/-1, non-editable.
        - **ICMPv6(IPv6)**:-1/-1, non-editable.
        - **TCP**:-1/-1, editable.
        - **UDP**:-1/-1, editable.
        - **GRE**:-1/-1, not editable.
        - **SSH**:22/22, not editable.
        - **Telnet**:23/23, not editable.
        - **HTTP**:80/80, non-editable.
        - **HTTPS**:443/443, which cannot be edited.
        - **MS SQL**:1443/1443, which cannot be edited.
        - **Oracle**:1521/1521, non-editable.
        - **MySql**:3306/3306, non-editable.
        - **RDP**:3389/3389, non-editable.
        - **PostgreSQL**:5432/5432, non-editable.
        - **Redis**:6379/6379, non-editable.
        """
        return pulumi.get(self, "dst_port_range")

    @dst_port_range.setter
    def dst_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_port_range", value)

    @_builtins.property
    @pulumi.getter(name="matchDscp")
    def match_dscp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The DSCP value of the traffic matched by the QoS rule. Value range: **0** to **63**. If not, the value is - 1.
        """
        return pulumi.get(self, "match_dscp")

    @match_dscp.setter
    def match_dscp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "match_dscp", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        QoS rule priority. Value range: **1** to **9000**. The larger the number, the higher the priority. The priority of a QoS rule cannot be repeated in the same QoS policy.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        QoS rule protocol type, value:
        - **ALL**
        - **ICMP(IPv4)**
        - **ICMPv6(IPv6)* *
        - **TCP**
        - **UDP**
        - **GRE**
        - **SSH**
        - **Telnet**
        - **HTTP**
        - **HTTPS**
        - **MS SQL**
        - **Oracle**
        - **MySql**
        - **RDP**
        - **PostgreSQL**
        - **Redis**.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS policy ID.
        """
        return pulumi.get(self, "qos_id")

    @qos_id.setter
    def qos_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_id", value)

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS queue ID.
        """
        return pulumi.get(self, "queue_id")

    @queue_id.setter
    def queue_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_id", value)

    @_builtins.property
    @pulumi.getter(name="remarkingDscp")
    def remarking_dscp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Modify The DSCP value in the flow. Value range: **0** to **63**. If the value is not modified, the value is - 1.
        """
        return pulumi.get(self, "remarking_dscp")

    @remarking_dscp.setter
    def remarking_dscp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "remarking_dscp", value)

    @_builtins.property
    @pulumi.getter(name="ruleDescription")
    def rule_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the QoS rule.  The length is 0 to 256 characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "rule_description")

    @rule_description.setter
    def rule_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_description", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the QoS rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the QoS rule.  The length is 0 to 128 characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS rule traffic matches the source IPv4 CIDR block.
        > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_cidr", value)

    @_builtins.property
    @pulumi.getter(name="srcIpv6Cidr")
    def src_ipv6_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS rule traffic matches the source IPv6 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        """
        return pulumi.get(self, "src_ipv6_cidr")

    @src_ipv6_cidr.setter
    def src_ipv6_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_ipv6_cidr", value)

    @_builtins.property
    @pulumi.getter(name="srcPortRange")
    def src_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source port number of the QoS rule traffic matching. The value range is **0** to **65535**. If the traffic does not match, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same.
        """
        return pulumi.get(self, "src_port_range")

    @src_port_range.setter
    def src_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_port_range", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the QoS rule. Value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:expressconnect/trafficQosRule:TrafficQosRule")
class TrafficQosRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dst_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 match_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remarking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_description: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 src_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Traffic Qos Rule resource. Express Connect Traffic QoS Rule.

        For information about Express Connect Traffic Qos Rule and how to use it, see [What is Traffic Qos Rule](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/CreateExpressConnectTrafficQosRule).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        create_qos = alicloud.expressconnect.TrafficQos("createQos",
            qos_name=name,
            qos_description="terraform-example")
        associate_qos = alicloud.expressconnect.TrafficQosAssociation("associateQos",
            instance_id=default.ids[1],
            qos_id=create_qos.id,
            instance_type="PHYSICALCONNECTION")
        create_qos_queue = alicloud.expressconnect.TrafficQosQueue("createQosQueue",
            qos_id=create_qos.id,
            bandwidth_percent="60",
            queue_description="terraform-example",
            queue_name=name,
            queue_type="Medium")
        default_traffic_qos_rule = alicloud.expressconnect.TrafficQosRule("default",
            rule_description="terraform-example",
            priority=1,
            protocol="ALL",
            src_port_range="-1/-1",
            dst_ipv6_cidr="2001:db8:1234:5678::/64",
            src_ipv6_cidr="2001:db8:1234:5678::/64",
            dst_port_range="-1/-1",
            remarking_dscp=-1,
            queue_id=create_qos_queue.queue_id,
            qos_id=create_qos.id,
            match_dscp=-1,
            rule_name=name)
        ```

        ## Import

        Express Connect Traffic Qos Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/trafficQosRule:TrafficQosRule example <qos_id>:<queue_id>:<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dst_cidr: The traffic of the QoS rule matches the Destination IPv4 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] dst_ipv6_cidr: The QoS rule traffic matches the Destination IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] dst_port_range: QoS rule traffic matches the destination port number range. Value range: **0** to **65535**. If not, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same. The corresponding destination port number range is fixed for different protocol types. The values are as follows:
               - **ALL**:-1/-1, not editable.
               - **ICMP(IPv4)**:-1/-1, non-editable.
               - **ICMPv6(IPv6)**:-1/-1, non-editable.
               - **TCP**:-1/-1, editable.
               - **UDP**:-1/-1, editable.
               - **GRE**:-1/-1, not editable.
               - **SSH**:22/22, not editable.
               - **Telnet**:23/23, not editable.
               - **HTTP**:80/80, non-editable.
               - **HTTPS**:443/443, which cannot be edited.
               - **MS SQL**:1443/1443, which cannot be edited.
               - **Oracle**:1521/1521, non-editable.
               - **MySql**:3306/3306, non-editable.
               - **RDP**:3389/3389, non-editable.
               - **PostgreSQL**:5432/5432, non-editable.
               - **Redis**:6379/6379, non-editable.
        :param pulumi.Input[_builtins.int] match_dscp: The DSCP value of the traffic matched by the QoS rule. Value range: **0** to **63**. If not, the value is - 1.
        :param pulumi.Input[_builtins.int] priority: QoS rule priority. Value range: **1** to **9000**. The larger the number, the higher the priority. The priority of a QoS rule cannot be repeated in the same QoS policy.
        :param pulumi.Input[_builtins.str] protocol: QoS rule protocol type, value:
               - **ALL**
               - **ICMP(IPv4)**
               - **ICMPv6(IPv6)* *
               - **TCP**
               - **UDP**
               - **GRE**
               - **SSH**
               - **Telnet**
               - **HTTP**
               - **HTTPS**
               - **MS SQL**
               - **Oracle**
               - **MySql**
               - **RDP**
               - **PostgreSQL**
               - **Redis**.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        :param pulumi.Input[_builtins.str] queue_id: The QoS queue ID.
        :param pulumi.Input[_builtins.int] remarking_dscp: Modify The DSCP value in the flow. Value range: **0** to **63**. If the value is not modified, the value is - 1.
        :param pulumi.Input[_builtins.str] rule_description: The description of the QoS rule.  The length is 0 to 256 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] rule_name: The name of the QoS rule.  The length is 0 to 128 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] src_cidr: The QoS rule traffic matches the source IPv4 CIDR block.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] src_ipv6_cidr: The QoS rule traffic matches the source IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] src_port_range: The source port number of the QoS rule traffic matching. The value range is **0** to **65535**. If the traffic does not match, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficQosRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Traffic Qos Rule resource. Express Connect Traffic QoS Rule.

        For information about Express Connect Traffic Qos Rule and how to use it, see [What is Traffic Qos Rule](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/CreateExpressConnectTrafficQosRule).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        create_qos = alicloud.expressconnect.TrafficQos("createQos",
            qos_name=name,
            qos_description="terraform-example")
        associate_qos = alicloud.expressconnect.TrafficQosAssociation("associateQos",
            instance_id=default.ids[1],
            qos_id=create_qos.id,
            instance_type="PHYSICALCONNECTION")
        create_qos_queue = alicloud.expressconnect.TrafficQosQueue("createQosQueue",
            qos_id=create_qos.id,
            bandwidth_percent="60",
            queue_description="terraform-example",
            queue_name=name,
            queue_type="Medium")
        default_traffic_qos_rule = alicloud.expressconnect.TrafficQosRule("default",
            rule_description="terraform-example",
            priority=1,
            protocol="ALL",
            src_port_range="-1/-1",
            dst_ipv6_cidr="2001:db8:1234:5678::/64",
            src_ipv6_cidr="2001:db8:1234:5678::/64",
            dst_port_range="-1/-1",
            remarking_dscp=-1,
            queue_id=create_qos_queue.queue_id,
            qos_id=create_qos.id,
            match_dscp=-1,
            rule_name=name)
        ```

        ## Import

        Express Connect Traffic Qos Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/trafficQosRule:TrafficQosRule example <qos_id>:<queue_id>:<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param TrafficQosRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficQosRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dst_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 dst_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 match_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remarking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_description: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 src_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 src_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficQosRuleArgs.__new__(TrafficQosRuleArgs)

            __props__.__dict__["dst_cidr"] = dst_cidr
            __props__.__dict__["dst_ipv6_cidr"] = dst_ipv6_cidr
            __props__.__dict__["dst_port_range"] = dst_port_range
            __props__.__dict__["match_dscp"] = match_dscp
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if qos_id is None and not opts.urn:
                raise TypeError("Missing required property 'qos_id'")
            __props__.__dict__["qos_id"] = qos_id
            if queue_id is None and not opts.urn:
                raise TypeError("Missing required property 'queue_id'")
            __props__.__dict__["queue_id"] = queue_id
            __props__.__dict__["remarking_dscp"] = remarking_dscp
            __props__.__dict__["rule_description"] = rule_description
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["src_cidr"] = src_cidr
            __props__.__dict__["src_ipv6_cidr"] = src_ipv6_cidr
            __props__.__dict__["src_port_range"] = src_port_range
            __props__.__dict__["rule_id"] = None
            __props__.__dict__["status"] = None
        super(TrafficQosRule, __self__).__init__(
            'alicloud:expressconnect/trafficQosRule:TrafficQosRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dst_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            dst_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            dst_port_range: Optional[pulumi.Input[_builtins.str]] = None,
            match_dscp: Optional[pulumi.Input[_builtins.int]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            qos_id: Optional[pulumi.Input[_builtins.str]] = None,
            queue_id: Optional[pulumi.Input[_builtins.str]] = None,
            remarking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
            rule_description: Optional[pulumi.Input[_builtins.str]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            src_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            src_ipv6_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            src_port_range: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrafficQosRule':
        """
        Get an existing TrafficQosRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dst_cidr: The traffic of the QoS rule matches the Destination IPv4 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] dst_ipv6_cidr: The QoS rule traffic matches the Destination IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] dst_port_range: QoS rule traffic matches the destination port number range. Value range: **0** to **65535**. If not, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same. The corresponding destination port number range is fixed for different protocol types. The values are as follows:
               - **ALL**:-1/-1, not editable.
               - **ICMP(IPv4)**:-1/-1, non-editable.
               - **ICMPv6(IPv6)**:-1/-1, non-editable.
               - **TCP**:-1/-1, editable.
               - **UDP**:-1/-1, editable.
               - **GRE**:-1/-1, not editable.
               - **SSH**:22/22, not editable.
               - **Telnet**:23/23, not editable.
               - **HTTP**:80/80, non-editable.
               - **HTTPS**:443/443, which cannot be edited.
               - **MS SQL**:1443/1443, which cannot be edited.
               - **Oracle**:1521/1521, non-editable.
               - **MySql**:3306/3306, non-editable.
               - **RDP**:3389/3389, non-editable.
               - **PostgreSQL**:5432/5432, non-editable.
               - **Redis**:6379/6379, non-editable.
        :param pulumi.Input[_builtins.int] match_dscp: The DSCP value of the traffic matched by the QoS rule. Value range: **0** to **63**. If not, the value is - 1.
        :param pulumi.Input[_builtins.int] priority: QoS rule priority. Value range: **1** to **9000**. The larger the number, the higher the priority. The priority of a QoS rule cannot be repeated in the same QoS policy.
        :param pulumi.Input[_builtins.str] protocol: QoS rule protocol type, value:
               - **ALL**
               - **ICMP(IPv4)**
               - **ICMPv6(IPv6)* *
               - **TCP**
               - **UDP**
               - **GRE**
               - **SSH**
               - **Telnet**
               - **HTTP**
               - **HTTPS**
               - **MS SQL**
               - **Oracle**
               - **MySql**
               - **RDP**
               - **PostgreSQL**
               - **Redis**.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        :param pulumi.Input[_builtins.str] queue_id: The QoS queue ID.
        :param pulumi.Input[_builtins.int] remarking_dscp: Modify The DSCP value in the flow. Value range: **0** to **63**. If the value is not modified, the value is - 1.
        :param pulumi.Input[_builtins.str] rule_description: The description of the QoS rule.  The length is 0 to 256 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the QoS rule.
        :param pulumi.Input[_builtins.str] rule_name: The name of the QoS rule.  The length is 0 to 128 characters and cannot start with 'http:// 'or 'https.
        :param pulumi.Input[_builtins.str] src_cidr: The QoS rule traffic matches the source IPv4 CIDR block.
               > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        :param pulumi.Input[_builtins.str] src_ipv6_cidr: The QoS rule traffic matches the source IPv6 network segment.
               > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        :param pulumi.Input[_builtins.str] src_port_range: The source port number of the QoS rule traffic matching. The value range is **0** to **65535**. If the traffic does not match, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same.
        :param pulumi.Input[_builtins.str] status: The status of the QoS rule. Value:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficQosRuleState.__new__(_TrafficQosRuleState)

        __props__.__dict__["dst_cidr"] = dst_cidr
        __props__.__dict__["dst_ipv6_cidr"] = dst_ipv6_cidr
        __props__.__dict__["dst_port_range"] = dst_port_range
        __props__.__dict__["match_dscp"] = match_dscp
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["qos_id"] = qos_id
        __props__.__dict__["queue_id"] = queue_id
        __props__.__dict__["remarking_dscp"] = remarking_dscp
        __props__.__dict__["rule_description"] = rule_description
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["src_cidr"] = src_cidr
        __props__.__dict__["src_ipv6_cidr"] = src_ipv6_cidr
        __props__.__dict__["src_port_range"] = src_port_range
        __props__.__dict__["status"] = status
        return TrafficQosRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The traffic of the QoS rule matches the Destination IPv4 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        """
        return pulumi.get(self, "dst_cidr")

    @_builtins.property
    @pulumi.getter(name="dstIpv6Cidr")
    def dst_ipv6_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The QoS rule traffic matches the Destination IPv6 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        """
        return pulumi.get(self, "dst_ipv6_cidr")

    @_builtins.property
    @pulumi.getter(name="dstPortRange")
    def dst_port_range(self) -> pulumi.Output[_builtins.str]:
        """
        QoS rule traffic matches the destination port number range. Value range: **0** to **65535**. If not, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same. The corresponding destination port number range is fixed for different protocol types. The values are as follows:
        - **ALL**:-1/-1, not editable.
        - **ICMP(IPv4)**:-1/-1, non-editable.
        - **ICMPv6(IPv6)**:-1/-1, non-editable.
        - **TCP**:-1/-1, editable.
        - **UDP**:-1/-1, editable.
        - **GRE**:-1/-1, not editable.
        - **SSH**:22/22, not editable.
        - **Telnet**:23/23, not editable.
        - **HTTP**:80/80, non-editable.
        - **HTTPS**:443/443, which cannot be edited.
        - **MS SQL**:1443/1443, which cannot be edited.
        - **Oracle**:1521/1521, non-editable.
        - **MySql**:3306/3306, non-editable.
        - **RDP**:3389/3389, non-editable.
        - **PostgreSQL**:5432/5432, non-editable.
        - **Redis**:6379/6379, non-editable.
        """
        return pulumi.get(self, "dst_port_range")

    @_builtins.property
    @pulumi.getter(name="matchDscp")
    def match_dscp(self) -> pulumi.Output[_builtins.int]:
        """
        The DSCP value of the traffic matched by the QoS rule. Value range: **0** to **63**. If not, the value is - 1.
        """
        return pulumi.get(self, "match_dscp")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        QoS rule priority. Value range: **1** to **9000**. The larger the number, the higher the priority. The priority of a QoS rule cannot be repeated in the same QoS policy.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        QoS rule protocol type, value:
        - **ALL**
        - **ICMP(IPv4)**
        - **ICMPv6(IPv6)* *
        - **TCP**
        - **UDP**
        - **GRE**
        - **SSH**
        - **Telnet**
        - **HTTP**
        - **HTTPS**
        - **MS SQL**
        - **Oracle**
        - **MySql**
        - **RDP**
        - **PostgreSQL**
        - **Redis**.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> pulumi.Output[_builtins.str]:
        """
        The QoS policy ID.
        """
        return pulumi.get(self, "qos_id")

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> pulumi.Output[_builtins.str]:
        """
        The QoS queue ID.
        """
        return pulumi.get(self, "queue_id")

    @_builtins.property
    @pulumi.getter(name="remarkingDscp")
    def remarking_dscp(self) -> pulumi.Output[_builtins.int]:
        """
        Modify The DSCP value in the flow. Value range: **0** to **63**. If the value is not modified, the value is - 1.
        """
        return pulumi.get(self, "remarking_dscp")

    @_builtins.property
    @pulumi.getter(name="ruleDescription")
    def rule_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the QoS rule.  The length is 0 to 256 characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "rule_description")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the QoS rule.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the QoS rule.  The length is 0 to 128 characters and cannot start with 'http:// 'or 'https.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The QoS rule traffic matches the source IPv4 CIDR block.
        > **NOTE:**  If this parameter is not supported, enter **SrcIPv6Cidr** or **DstIPv6Cidr * *.
        """
        return pulumi.get(self, "src_cidr")

    @_builtins.property
    @pulumi.getter(name="srcIpv6Cidr")
    def src_ipv6_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The QoS rule traffic matches the source IPv6 network segment.
        > **NOTE:**  If this parameter is not supported, enter **SrcCidr** or **DstCidr * *.
        """
        return pulumi.get(self, "src_ipv6_cidr")

    @_builtins.property
    @pulumi.getter(name="srcPortRange")
    def src_port_range(self) -> pulumi.Output[_builtins.str]:
        """
        The source port number of the QoS rule traffic matching. The value range is **0** to **65535**. If the traffic does not match, the value is - 1. Currently, only a single port number is supported, and the start and end of the port number must be the same.
        """
        return pulumi.get(self, "src_port_range")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the QoS rule. Value:
        """
        return pulumi.get(self, "status")

