# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BandwidthPackageAttachmentArgs', 'BandwidthPackageAttachment']

@pulumi.input_type
class BandwidthPackageAttachmentArgs:
    def __init__(__self__, *,
                 accelerator_id: pulumi.Input[_builtins.str],
                 bandwidth_package_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a BandwidthPackageAttachment resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the Bandwidth Package. **NOTE:** From version 1.192.0, `bandwidth_package_id` can be modified.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Global Accelerator instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Bandwidth Package. **NOTE:** From version 1.192.0, `bandwidth_package_id` can be modified.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bandwidth_package_id", value)


@pulumi.input_type
class _BandwidthPackageAttachmentState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BandwidthPackageAttachment resources.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accelerators: Accelerators bound with current Bandwidth Package.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the Bandwidth Package. **NOTE:** From version 1.192.0, `bandwidth_package_id` can be modified.
        :param pulumi.Input[_builtins.str] status: State of Bandwidth Package.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if bandwidth_package_id is not None:
            pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Global Accelerator instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Accelerators bound with current Bandwidth Package.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "accelerators", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Bandwidth Package. **NOTE:** From version 1.192.0, `bandwidth_package_id` can be modified.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of Bandwidth Package.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:ga/bandwidthPackageAttachment:BandwidthPackageAttachment")
class BandwidthPackageAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Bandwidth Package Attachment resource.

        For information about Global Accelerator (GA) Bandwidth Package Attachment and how to use it, see [What is Bandwidth Package Attachment](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-bandwidthpackageaddaccelerator).

        > **NOTE:** Available since v1.113.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ga.Accelerator("default",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default.id,
            bandwidth_package_id=default_bandwidth_package.id)
        ```

        ## Import

        Ga Bandwidth Package Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/bandwidthPackageAttachment:BandwidthPackageAttachment example <accelerator_id>:<bandwidth_package_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the Bandwidth Package. **NOTE:** From version 1.192.0, `bandwidth_package_id` can be modified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BandwidthPackageAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Bandwidth Package Attachment resource.

        For information about Global Accelerator (GA) Bandwidth Package Attachment and how to use it, see [What is Bandwidth Package Attachment](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-bandwidthpackageaddaccelerator).

        > **NOTE:** Available since v1.113.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ga.Accelerator("default",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default.id,
            bandwidth_package_id=default_bandwidth_package.id)
        ```

        ## Import

        Ga Bandwidth Package Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/bandwidthPackageAttachment:BandwidthPackageAttachment example <accelerator_id>:<bandwidth_package_id>
        ```

        :param str resource_name: The name of the resource.
        :param BandwidthPackageAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BandwidthPackageAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BandwidthPackageAttachmentArgs.__new__(BandwidthPackageAttachmentArgs)

            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            if bandwidth_package_id is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth_package_id'")
            __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
            __props__.__dict__["accelerators"] = None
            __props__.__dict__["status"] = None
        super(BandwidthPackageAttachment, __self__).__init__(
            'alicloud:ga/bandwidthPackageAttachment:BandwidthPackageAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
            accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'BandwidthPackageAttachment':
        """
        Get an existing BandwidthPackageAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the Global Accelerator instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accelerators: Accelerators bound with current Bandwidth Package.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the Bandwidth Package. **NOTE:** From version 1.192.0, `bandwidth_package_id` can be modified.
        :param pulumi.Input[_builtins.str] status: State of Bandwidth Package.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BandwidthPackageAttachmentState.__new__(_BandwidthPackageAttachmentState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["accelerators"] = accelerators
        __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
        __props__.__dict__["status"] = status
        return BandwidthPackageAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Global Accelerator instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Accelerators bound with current Bandwidth Package.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Bandwidth Package. **NOTE:** From version 1.192.0, `bandwidth_package_id` can be modified.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        State of Bandwidth Package.
        """
        return pulumi.get(self, "status")

