# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AclAclEntry',
    'CustomRoutingEndpointTrafficPolicyPortRange',
    'EndpointGroupEndpointConfiguration',
    'EndpointGroupPortOverrides',
    'ForwardingRuleRuleAction',
    'ForwardingRuleRuleActionForwardGroupConfig',
    'ForwardingRuleRuleActionForwardGroupConfigServerGroupTuple',
    'ForwardingRuleRuleCondition',
    'ForwardingRuleRuleConditionHostConfig',
    'ForwardingRuleRuleConditionPathConfig',
    'ListenerCertificate',
    'ListenerForwardedForConfig',
    'ListenerPortRange',
    'GetAcceleratorSpareIpAttachmentsAttachmentResult',
    'GetAcceleratorsAcceleratorResult',
    'GetAcceleratorsAcceleratorBasicBandwidthPackageResult',
    'GetAcceleratorsAcceleratorCrossDomainBandwidthPackageResult',
    'GetAclsAclResult',
    'GetAclsAclAclEntryResult',
    'GetAdditionalCertificatesCertificateResult',
    'GetBandwidthPackagesPackageResult',
    'GetBasicAccelerateIpEndpointRelationsRelationResult',
    'GetBasicAccelerateIpsIpResult',
    'GetBasicAcceleratorsAcceleratorResult',
    'GetBasicAcceleratorsAcceleratorBasicBandwidthPackageResult',
    'GetBasicAcceleratorsAcceleratorCrossDomainBandwidthPackageResult',
    'GetBasicEndpointsEndpointResult',
    'GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestinationResult',
    'GetCustomRoutingEndpointGroupsGroupResult',
    'GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyResult',
    'GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyPortRangeResult',
    'GetCustomRoutingEndpointsCustomRoutingEndpointResult',
    'GetCustomRoutingPortMappingsCustomRoutingPortMappingResult',
    'GetCustomRoutingPortMappingsCustomRoutingPortMappingDestinationSocketAddressResult',
    'GetDomainsDomainResult',
    'GetEndpointGroupIpAddressCidrBlocksEndpointGroupIpAddressCidrBlockResult',
    'GetEndpointGroupsGroupResult',
    'GetEndpointGroupsGroupEndpointConfigurationResult',
    'GetEndpointGroupsGroupPortOverrideResult',
    'GetForwardingRulesForwardingRuleResult',
    'GetForwardingRulesForwardingRuleRuleActionResult',
    'GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigResult',
    'GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigServerGroupTupleResult',
    'GetForwardingRulesForwardingRuleRuleConditionResult',
    'GetForwardingRulesForwardingRuleRuleConditionHostConfigResult',
    'GetForwardingRulesForwardingRuleRuleConditionPathConfigResult',
    'GetIpSetsSetResult',
    'GetListenersListenerResult',
    'GetListenersListenerCertificateResult',
    'GetListenersListenerPortRangeResult',
]

@pulumi.output_type
class AclAclEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryDescription":
            suggest = "entry_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclAclEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclAclEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclAclEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entry: Optional[_builtins.str] = None,
                 entry_description: Optional[_builtins.str] = None):
        """
        :param _builtins.str entry: The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
        :param _builtins.str entry_description: The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
        """
        if entry is not None:
            pulumi.set(__self__, "entry", entry)
        if entry_description is not None:
            pulumi.set(__self__, "entry_description", entry_description)

    @_builtins.property
    @pulumi.getter
    def entry(self) -> Optional[_builtins.str]:
        """
        The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
        """
        return pulumi.get(self, "entry")

    @_builtins.property
    @pulumi.getter(name="entryDescription")
    def entry_description(self) -> Optional[_builtins.str]:
        """
        The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
        """
        return pulumi.get(self, "entry_description")


@pulumi.output_type
class CustomRoutingEndpointTrafficPolicyPortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomRoutingEndpointTrafficPolicyPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomRoutingEndpointTrafficPolicyPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomRoutingEndpointTrafficPolicyPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: Optional[_builtins.int] = None,
                 to_port: Optional[_builtins.int] = None):
        """
        :param _builtins.int from_port: The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        :param _builtins.int to_port: The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[_builtins.int]:
        """
        The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        return pulumi.get(self, "from_port")

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[_builtins.int]:
        """
        The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class EndpointGroupEndpointConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableClientipPreservation":
            suggest = "enable_clientip_preservation"
        elif key == "enableProxyProtocol":
            suggest = "enable_proxy_protocol"
        elif key == "subAddress":
            suggest = "sub_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointGroupEndpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointGroupEndpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointGroupEndpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 type: _builtins.str,
                 weight: _builtins.int,
                 enable_clientip_preservation: Optional[_builtins.bool] = None,
                 enable_proxy_protocol: Optional[_builtins.bool] = None,
                 sub_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: The IP address or domain name of Endpoint N in the endpoint group.
        :param _builtins.str type: The type of Endpoint N in the endpoint group. Valid values:
               - `Domain`: A custom domain name.
               - `Ip`: A custom IP address.
               - `PublicIp`: An Alibaba Cloud public IP address.
               - `ECS`: An Elastic Compute Service (ECS) instance.
               - `SLB`: A Classic Load Balancer (CLB) instance.
               - `ALB`: An Application Load Balancer (ALB) instance.
               - `NLB`: A Network Load Balancer (NLB) instance.
               - `ENI`: An Elastic Network Interface (ENI).
               - `OSS`: An Object Storage Service (OSS) bucket.
               > **NOTE:** From version 1.232.0, `type` can be set to `ALB`, `NLB`, `ENI`, `OSS`.
        :param _builtins.int weight: The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
               > **NOTE:** If the weight of a terminal node is set to `0`, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
        :param _builtins.bool enable_clientip_preservation: Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
        :param _builtins.bool enable_proxy_protocol: Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
        :param _builtins.str sub_address: The private IP address of the ENI.
               > **NOTE:** `sub_address` is valid only when `type` is set to `ENI`.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)
        if enable_clientip_preservation is not None:
            pulumi.set(__self__, "enable_clientip_preservation", enable_clientip_preservation)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if sub_address is not None:
            pulumi.set(__self__, "sub_address", sub_address)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The IP address or domain name of Endpoint N in the endpoint group.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Endpoint N in the endpoint group. Valid values:
        - `Domain`: A custom domain name.
        - `Ip`: A custom IP address.
        - `PublicIp`: An Alibaba Cloud public IP address.
        - `ECS`: An Elastic Compute Service (ECS) instance.
        - `SLB`: A Classic Load Balancer (CLB) instance.
        - `ALB`: An Application Load Balancer (ALB) instance.
        - `NLB`: A Network Load Balancer (NLB) instance.
        - `ENI`: An Elastic Network Interface (ENI).
        - `OSS`: An Object Storage Service (OSS) bucket.
        > **NOTE:** From version 1.232.0, `type` can be set to `ALB`, `NLB`, `ENI`, `OSS`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
        > **NOTE:** If the weight of a terminal node is set to `0`, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
        """
        return pulumi.get(self, "weight")

    @_builtins.property
    @pulumi.getter(name="enableClientipPreservation")
    def enable_clientip_preservation(self) -> Optional[_builtins.bool]:
        """
        Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_clientip_preservation")

    @_builtins.property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @_builtins.property
    @pulumi.getter(name="subAddress")
    def sub_address(self) -> Optional[_builtins.str]:
        """
        The private IP address of the ENI.
        > **NOTE:** `sub_address` is valid only when `type` is set to `ENI`.
        """
        return pulumi.get(self, "sub_address")


@pulumi.output_type
class EndpointGroupPortOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointPort":
            suggest = "endpoint_port"
        elif key == "listenerPort":
            suggest = "listener_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointGroupPortOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointGroupPortOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointGroupPortOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_port: Optional[_builtins.int] = None,
                 listener_port: Optional[_builtins.int] = None):
        """
        :param _builtins.int endpoint_port: Forwarding port.
        :param _builtins.int listener_port: Listener port.
        """
        if endpoint_port is not None:
            pulumi.set(__self__, "endpoint_port", endpoint_port)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)

    @_builtins.property
    @pulumi.getter(name="endpointPort")
    def endpoint_port(self) -> Optional[_builtins.int]:
        """
        Forwarding port.
        """
        return pulumi.get(self, "endpoint_port")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[_builtins.int]:
        """
        Listener port.
        """
        return pulumi.get(self, "listener_port")


@pulumi.output_type
class ForwardingRuleRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleActionType":
            suggest = "rule_action_type"
        elif key == "forwardGroupConfig":
            suggest = "forward_group_config"
        elif key == "ruleActionValue":
            suggest = "rule_action_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingRuleRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingRuleRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingRuleRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 order: _builtins.int,
                 rule_action_type: _builtins.str,
                 forward_group_config: Optional['outputs.ForwardingRuleRuleActionForwardGroupConfig'] = None,
                 rule_action_value: Optional[_builtins.str] = None):
        """
        :param _builtins.int order: Forwarding priority.
        :param _builtins.str rule_action_type: The type of the forwarding action. Valid values: `ForwardGroup`, `Redirect`, `FixResponse`, `Rewrite`, `AddHeader`, `RemoveHeader`, `Drop`.
        :param 'ForwardingRuleRuleActionForwardGroupConfigArgs' forward_group_config: Forwarding configuration. See `forward_group_config` below.
               > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
        :param _builtins.str rule_action_value: The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "rule_action_type", rule_action_type)
        if forward_group_config is not None:
            pulumi.set(__self__, "forward_group_config", forward_group_config)
        if rule_action_value is not None:
            pulumi.set(__self__, "rule_action_value", rule_action_value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.int:
        """
        Forwarding priority.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="ruleActionType")
    def rule_action_type(self) -> _builtins.str:
        """
        The type of the forwarding action. Valid values: `ForwardGroup`, `Redirect`, `FixResponse`, `Rewrite`, `AddHeader`, `RemoveHeader`, `Drop`.
        """
        return pulumi.get(self, "rule_action_type")

    @_builtins.property
    @pulumi.getter(name="forwardGroupConfig")
    def forward_group_config(self) -> Optional['outputs.ForwardingRuleRuleActionForwardGroupConfig']:
        """
        Forwarding configuration. See `forward_group_config` below.
        > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
        """
        return pulumi.get(self, "forward_group_config")

    @_builtins.property
    @pulumi.getter(name="ruleActionValue")
    def rule_action_value(self) -> Optional[_builtins.str]:
        """
        The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        return pulumi.get(self, "rule_action_value")


@pulumi.output_type
class ForwardingRuleRuleActionForwardGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverGroupTuples":
            suggest = "server_group_tuples"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingRuleRuleActionForwardGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingRuleRuleActionForwardGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingRuleRuleActionForwardGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_group_tuples: Sequence['outputs.ForwardingRuleRuleActionForwardGroupConfigServerGroupTuple']):
        """
        :param Sequence['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs'] server_group_tuples: The information about the endpoint group. See `server_group_tuples` below.
        """
        pulumi.set(__self__, "server_group_tuples", server_group_tuples)

    @_builtins.property
    @pulumi.getter(name="serverGroupTuples")
    def server_group_tuples(self) -> Sequence['outputs.ForwardingRuleRuleActionForwardGroupConfigServerGroupTuple']:
        """
        The information about the endpoint group. See `server_group_tuples` below.
        """
        return pulumi.get(self, "server_group_tuples")


@pulumi.output_type
class ForwardingRuleRuleActionForwardGroupConfigServerGroupTuple(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointGroupId":
            suggest = "endpoint_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingRuleRuleActionForwardGroupConfigServerGroupTuple. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingRuleRuleActionForwardGroupConfigServerGroupTuple.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingRuleRuleActionForwardGroupConfigServerGroupTuple.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_group_id: _builtins.str):
        """
        :param _builtins.str endpoint_group_id: The ID of the endpoint group.
        """
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_id")


@pulumi.output_type
class ForwardingRuleRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleConditionType":
            suggest = "rule_condition_type"
        elif key == "hostConfigs":
            suggest = "host_configs"
        elif key == "pathConfig":
            suggest = "path_config"
        elif key == "ruleConditionValue":
            suggest = "rule_condition_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingRuleRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingRuleRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingRuleRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_condition_type: _builtins.str,
                 host_configs: Optional[Sequence['outputs.ForwardingRuleRuleConditionHostConfig']] = None,
                 path_config: Optional['outputs.ForwardingRuleRuleConditionPathConfig'] = None,
                 rule_condition_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str rule_condition_type: The type of the forwarding conditions. Valid values: `Host`, `Path`, `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`. **NOTE:** From version 1.231.0, `rule_condition_type` can be set to `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`.
        :param Sequence['ForwardingRuleRuleConditionHostConfigArgs'] host_configs: The configuration of the domain name. See `host_config` below.
               > **NOTE:** From version 1.231.0, We recommend that you do not use `path_config` or `host_config`, and we recommend that you use the `rule_condition_type` and `rule_condition_value` to configure forwarding conditions.
        :param 'ForwardingRuleRuleConditionPathConfigArgs' path_config: The configuration of the path. See `path_config` below.
        :param _builtins.str rule_condition_value: The value of the forwarding condition type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        pulumi.set(__self__, "rule_condition_type", rule_condition_type)
        if host_configs is not None:
            pulumi.set(__self__, "host_configs", host_configs)
        if path_config is not None:
            pulumi.set(__self__, "path_config", path_config)
        if rule_condition_value is not None:
            pulumi.set(__self__, "rule_condition_value", rule_condition_value)

    @_builtins.property
    @pulumi.getter(name="ruleConditionType")
    def rule_condition_type(self) -> _builtins.str:
        """
        The type of the forwarding conditions. Valid values: `Host`, `Path`, `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`. **NOTE:** From version 1.231.0, `rule_condition_type` can be set to `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`.
        """
        return pulumi.get(self, "rule_condition_type")

    @_builtins.property
    @pulumi.getter(name="hostConfigs")
    def host_configs(self) -> Optional[Sequence['outputs.ForwardingRuleRuleConditionHostConfig']]:
        """
        The configuration of the domain name. See `host_config` below.
        > **NOTE:** From version 1.231.0, We recommend that you do not use `path_config` or `host_config`, and we recommend that you use the `rule_condition_type` and `rule_condition_value` to configure forwarding conditions.
        """
        return pulumi.get(self, "host_configs")

    @_builtins.property
    @pulumi.getter(name="pathConfig")
    def path_config(self) -> Optional['outputs.ForwardingRuleRuleConditionPathConfig']:
        """
        The configuration of the path. See `path_config` below.
        """
        return pulumi.get(self, "path_config")

    @_builtins.property
    @pulumi.getter(name="ruleConditionValue")
    def rule_condition_value(self) -> Optional[_builtins.str]:
        """
        The value of the forwarding condition type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        return pulumi.get(self, "rule_condition_value")


@pulumi.output_type
class ForwardingRuleRuleConditionHostConfig(dict):
    def __init__(__self__, *,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] values: The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ForwardingRuleRuleConditionPathConfig(dict):
    def __init__(__self__, *,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] values: The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerCertificate(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The id of the certificate.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The id of the certificate.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ListenerForwardedForConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardedForGaApEnabled":
            suggest = "forwarded_for_ga_ap_enabled"
        elif key == "forwardedForGaIdEnabled":
            suggest = "forwarded_for_ga_id_enabled"
        elif key == "forwardedForPortEnabled":
            suggest = "forwarded_for_port_enabled"
        elif key == "forwardedForProtoEnabled":
            suggest = "forwarded_for_proto_enabled"
        elif key == "realIpEnabled":
            suggest = "real_ip_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerForwardedForConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerForwardedForConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerForwardedForConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarded_for_ga_ap_enabled: Optional[_builtins.bool] = None,
                 forwarded_for_ga_id_enabled: Optional[_builtins.bool] = None,
                 forwarded_for_port_enabled: Optional[_builtins.bool] = None,
                 forwarded_for_proto_enabled: Optional[_builtins.bool] = None,
                 real_ip_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool forwarded_for_ga_ap_enabled: Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
        :param _builtins.bool forwarded_for_ga_id_enabled: Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
        :param _builtins.bool forwarded_for_port_enabled: Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
        :param _builtins.bool forwarded_for_proto_enabled: Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
        :param _builtins.bool real_ip_enabled: Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
        """
        if forwarded_for_ga_ap_enabled is not None:
            pulumi.set(__self__, "forwarded_for_ga_ap_enabled", forwarded_for_ga_ap_enabled)
        if forwarded_for_ga_id_enabled is not None:
            pulumi.set(__self__, "forwarded_for_ga_id_enabled", forwarded_for_ga_id_enabled)
        if forwarded_for_port_enabled is not None:
            pulumi.set(__self__, "forwarded_for_port_enabled", forwarded_for_port_enabled)
        if forwarded_for_proto_enabled is not None:
            pulumi.set(__self__, "forwarded_for_proto_enabled", forwarded_for_proto_enabled)
        if real_ip_enabled is not None:
            pulumi.set(__self__, "real_ip_enabled", real_ip_enabled)

    @_builtins.property
    @pulumi.getter(name="forwardedForGaApEnabled")
    def forwarded_for_ga_ap_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_ga_ap_enabled")

    @_builtins.property
    @pulumi.getter(name="forwardedForGaIdEnabled")
    def forwarded_for_ga_id_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_ga_id_enabled")

    @_builtins.property
    @pulumi.getter(name="forwardedForPortEnabled")
    def forwarded_for_port_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_port_enabled")

    @_builtins.property
    @pulumi.getter(name="forwardedForProtoEnabled")
    def forwarded_for_proto_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_proto_enabled")

    @_builtins.property
    @pulumi.getter(name="realIpEnabled")
    def real_ip_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "real_ip_enabled")


@pulumi.output_type
class ListenerPortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: _builtins.int,
                 to_port: _builtins.int):
        """
        :param _builtins.int from_port: The initial listening port used to receive requests and forward them to terminal nodes.
        :param _builtins.int to_port: The end listening port used to receive requests and forward them to terminal nodes.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> _builtins.int:
        """
        The initial listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "from_port")

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> _builtins.int:
        """
        The end listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class GetAcceleratorSpareIpAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 id: _builtins.str,
                 spare_ip: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the global acceleration instance.
        :param _builtins.str id: The ID of the Accelerator Spare Ip Attachment.
        :param _builtins.str spare_ip: The standby IP address of CNAME. When the acceleration area is abnormal, the traffic is switched to the standby IP address.
        :param _builtins.str status: The status of the standby CNAME IP address. Valid values: `active`, `inuse`.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "spare_ip", spare_ip)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the global acceleration instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Accelerator Spare Ip Attachment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="spareIp")
    def spare_ip(self) -> _builtins.str:
        """
        The standby IP address of CNAME. When the acceleration area is abnormal, the traffic is switched to the standby IP address.
        """
        return pulumi.get(self, "spare_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the standby CNAME IP address. Valid values: `active`, `inuse`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAcceleratorsAcceleratorResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 accelerator_name: _builtins.str,
                 basic_bandwidth_packages: Sequence['outputs.GetAcceleratorsAcceleratorBasicBandwidthPackageResult'],
                 cen_id: _builtins.str,
                 cross_domain_bandwidth_packages: Sequence['outputs.GetAcceleratorsAcceleratorCrossDomainBandwidthPackageResult'],
                 ddos_id: _builtins.str,
                 description: _builtins.str,
                 dns_name: _builtins.str,
                 expired_time: _builtins.int,
                 id: _builtins.str,
                 payment_type: _builtins.str,
                 second_dns_name: _builtins.str,
                 spec: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the GA instance to query.
        :param _builtins.str accelerator_name: The Name of the GA instance.
        :param Sequence['GetAcceleratorsAcceleratorBasicBandwidthPackageArgs'] basic_bandwidth_packages: Details of the basic bandwidth package bound to the global acceleration instance.
        :param _builtins.str cen_id: The cloud enterprise network instance ID bound to the global acceleration instance.
        :param Sequence['GetAcceleratorsAcceleratorCrossDomainBandwidthPackageArgs'] cross_domain_bandwidth_packages: Details of the cross-domain acceleration package bound to the global acceleration instance.
        :param _builtins.str ddos_id: DDoS high-defense instance ID that is unbound from the global acceleration instance.
        :param _builtins.str description: Descriptive information of the global acceleration instance.
        :param _builtins.str dns_name: CNAME address assigned by Global Acceleration instance.
        :param _builtins.int expired_time: Time when the global acceleration instance expires.
        :param _builtins.str id: The ID of the Accelerator.
        :param _builtins.str payment_type: The billing method of the GA instance. Valid values: `POSTPAY`, `PREPAY`.
        :param _builtins.str second_dns_name: CNAME of the Global Acceleration Linkage DDoS High Defense Instance.
        :param _builtins.str spec: The instance type of the GA instance.
        :param _builtins.str status: The status of the GA instance. Valid values: `active`, `binding`, `configuring`, `deleting`, `finacialLocked`, `init`, `unbinding`.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "accelerator_name", accelerator_name)
        pulumi.set(__self__, "basic_bandwidth_packages", basic_bandwidth_packages)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cross_domain_bandwidth_packages", cross_domain_bandwidth_packages)
        pulumi.set(__self__, "ddos_id", ddos_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "second_dns_name", second_dns_name)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance to query.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="acceleratorName")
    def accelerator_name(self) -> _builtins.str:
        """
        The Name of the GA instance.
        """
        return pulumi.get(self, "accelerator_name")

    @_builtins.property
    @pulumi.getter(name="basicBandwidthPackages")
    def basic_bandwidth_packages(self) -> Sequence['outputs.GetAcceleratorsAcceleratorBasicBandwidthPackageResult']:
        """
        Details of the basic bandwidth package bound to the global acceleration instance.
        """
        return pulumi.get(self, "basic_bandwidth_packages")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The cloud enterprise network instance ID bound to the global acceleration instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="crossDomainBandwidthPackages")
    def cross_domain_bandwidth_packages(self) -> Sequence['outputs.GetAcceleratorsAcceleratorCrossDomainBandwidthPackageResult']:
        """
        Details of the cross-domain acceleration package bound to the global acceleration instance.
        """
        return pulumi.get(self, "cross_domain_bandwidth_packages")

    @_builtins.property
    @pulumi.getter(name="ddosId")
    def ddos_id(self) -> _builtins.str:
        """
        DDoS high-defense instance ID that is unbound from the global acceleration instance.
        """
        return pulumi.get(self, "ddos_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Descriptive information of the global acceleration instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> _builtins.str:
        """
        CNAME address assigned by Global Acceleration instance.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.int:
        """
        Time when the global acceleration instance expires.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Accelerator.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The billing method of the GA instance. Valid values: `POSTPAY`, `PREPAY`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="secondDnsName")
    def second_dns_name(self) -> _builtins.str:
        """
        CNAME of the Global Acceleration Linkage DDoS High Defense Instance.
        """
        return pulumi.get(self, "second_dns_name")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        The instance type of the GA instance.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the GA instance. Valid values: `active`, `binding`, `configuring`, `deleting`, `finacialLocked`, `init`, `unbinding`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAcceleratorsAcceleratorBasicBandwidthPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 bandwidth_type: _builtins.str,
                 instance_id: _builtins.str):
        """
        :param _builtins.int bandwidth: Bandwidth value of cross-domain acceleration package.
        :param _builtins.str bandwidth_type: The bandwidth type of the basic bandwidth package.
        :param _builtins.str instance_id: Instance ID of the cross-domain acceleration package.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        Bandwidth value of cross-domain acceleration package.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> _builtins.str:
        """
        The bandwidth type of the basic bandwidth package.
        """
        return pulumi.get(self, "bandwidth_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Instance ID of the cross-domain acceleration package.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetAcceleratorsAcceleratorCrossDomainBandwidthPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 instance_id: _builtins.str):
        """
        :param _builtins.int bandwidth: Bandwidth value of cross-domain acceleration package.
        :param _builtins.str instance_id: Instance ID of the cross-domain acceleration package.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        Bandwidth value of cross-domain acceleration package.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Instance ID of the cross-domain acceleration package.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetAclsAclResult(dict):
    def __init__(__self__, *,
                 acl_entries: Sequence['outputs.GetAclsAclAclEntryResult'],
                 acl_id: _builtins.str,
                 acl_name: _builtins.str,
                 address_ip_version: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str):
        """
        :param Sequence['GetAclsAclAclEntryArgs'] acl_entries: The entries of the Acl.
        :param _builtins.str acl_id: The  ID of the Acl.
        :param _builtins.str acl_name: The name of the acl.
        :param _builtins.str address_ip_version: The address ip version.
        :param _builtins.str id: The ID of the Acl. Its value is same as `acl_id`.
        :param _builtins.str status: The status of the resource. Valid values: `active`, `configuring`, `deleting`, `init`.
        """
        pulumi.set(__self__, "acl_entries", acl_entries)
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "acl_name", acl_name)
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aclEntries")
    def acl_entries(self) -> Sequence['outputs.GetAclsAclAclEntryResult']:
        """
        The entries of the Acl.
        """
        return pulumi.get(self, "acl_entries")

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> _builtins.str:
        """
        The  ID of the Acl.
        """
        return pulumi.get(self, "acl_id")

    @_builtins.property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> _builtins.str:
        """
        The name of the acl.
        """
        return pulumi.get(self, "acl_name")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> _builtins.str:
        """
        The address ip version.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Acl. Its value is same as `acl_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `active`, `configuring`, `deleting`, `init`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAclsAclAclEntryResult(dict):
    def __init__(__self__, *,
                 entry: _builtins.str,
                 entry_description: _builtins.str):
        """
        :param _builtins.str entry: The IP entry that you want to add to the ACL.
        :param _builtins.str entry_description: The description of the IP entry.
        """
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "entry_description", entry_description)

    @_builtins.property
    @pulumi.getter
    def entry(self) -> _builtins.str:
        """
        The IP entry that you want to add to the ACL.
        """
        return pulumi.get(self, "entry")

    @_builtins.property
    @pulumi.getter(name="entryDescription")
    def entry_description(self) -> _builtins.str:
        """
        The description of the IP entry.
        """
        return pulumi.get(self, "entry_description")


@pulumi.output_type
class GetAdditionalCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 certificate_id: _builtins.str,
                 domain: _builtins.str,
                 id: _builtins.str,
                 listener_id: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the GA instance.
        :param _builtins.str certificate_id: The Certificate ID.
        :param _builtins.str domain: The domain name specified by the certificate.
        :param _builtins.str id: The ID of the Additional Certificate. The value formats as `<accelerator_id>:<listener_id>:<domain>`.
        :param _builtins.str listener_id: The ID of the listener. Only HTTPS listeners support this parameter.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The Certificate ID.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain name specified by the certificate.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Additional Certificate. The value formats as `<accelerator_id>:<listener_id>:<domain>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener. Only HTTPS listeners support this parameter.
        """
        return pulumi.get(self, "listener_id")


@pulumi.output_type
class GetBandwidthPackagesPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 bandwidth_package_id: _builtins.str,
                 bandwidth_package_name: _builtins.str,
                 bandwidth_type: _builtins.str,
                 cbn_geographic_region_ida: _builtins.str,
                 cbn_geographic_region_idb: _builtins.str,
                 description: _builtins.str,
                 expired_time: _builtins.str,
                 id: _builtins.str,
                 payment_type: _builtins.str,
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int bandwidth: The bandwidth value of bandwidth packet.
        :param _builtins.str bandwidth_package_id: The Resource ID of the bandwidth.
        :param _builtins.str bandwidth_package_name: The name of the bandwidth packet.
        :param _builtins.str bandwidth_type: The bandwidth type of the bandwidth.
        :param _builtins.str cbn_geographic_region_ida: Interworking area A of cross domain acceleration package. Only international stations support returning this parameter.
        :param _builtins.str cbn_geographic_region_idb: Interworking area B of cross domain acceleration package. Only international stations support returning this parameter.
        :param _builtins.str description: The description of bandwidth package.
        :param _builtins.str expired_time: Bandwidth package expiration time.
        :param _builtins.str id: The ID of the Bandwidth Package.
        :param _builtins.str payment_type: The payment type of the bandwidth.
        :param _builtins.str status: The status of the bandwidth plan. Valid values: `active`, `binded`, `binding`, `finacialLocked`, `init`, `unbinding`, `updating`.
        :param _builtins.str type: The type of the bandwidth plan. Valid values: `Basic`, `CrossDomain`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        pulumi.set(__self__, "cbn_geographic_region_ida", cbn_geographic_region_ida)
        pulumi.set(__self__, "cbn_geographic_region_idb", cbn_geographic_region_idb)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth value of bandwidth packet.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> _builtins.str:
        """
        The Resource ID of the bandwidth.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> _builtins.str:
        """
        The name of the bandwidth packet.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> _builtins.str:
        """
        The bandwidth type of the bandwidth.
        """
        return pulumi.get(self, "bandwidth_type")

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIda")
    def cbn_geographic_region_ida(self) -> _builtins.str:
        """
        Interworking area A of cross domain acceleration package. Only international stations support returning this parameter.
        """
        return pulumi.get(self, "cbn_geographic_region_ida")

    @_builtins.property
    @pulumi.getter(name="cbnGeographicRegionIdb")
    def cbn_geographic_region_idb(self) -> _builtins.str:
        """
        Interworking area B of cross domain acceleration package. Only international stations support returning this parameter.
        """
        return pulumi.get(self, "cbn_geographic_region_idb")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of bandwidth package.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        Bandwidth package expiration time.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Bandwidth Package.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the bandwidth.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the bandwidth plan. Valid values: `active`, `binded`, `binding`, `finacialLocked`, `init`, `unbinding`, `updating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the bandwidth plan. Valid values: `Basic`, `CrossDomain`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBasicAccelerateIpEndpointRelationsRelationResult(dict):
    def __init__(__self__, *,
                 accelerate_ip_id: _builtins.str,
                 accelerator_id: _builtins.str,
                 basic_endpoint_name: _builtins.str,
                 endpoint_address: _builtins.str,
                 endpoint_id: _builtins.str,
                 endpoint_sub_address: _builtins.str,
                 endpoint_sub_address_type: _builtins.str,
                 endpoint_type: _builtins.str,
                 endpoint_zone_id: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerate_ip_id: The ID of the Basic Accelerate IP.
        :param _builtins.str accelerator_id: The ID of the Global Accelerator Basic Accelerator instance.
        :param _builtins.str basic_endpoint_name: The name of the Basic Endpoint.
        :param _builtins.str endpoint_address: The address of the Basic Endpoint.
        :param _builtins.str endpoint_id: The ID of the Basic Endpoint.
        :param _builtins.str endpoint_sub_address: The sub address of the Basic Endpoint.
        :param _builtins.str endpoint_sub_address_type: The sub address type of the Basic Endpoint.
        :param _builtins.str endpoint_type: The type of the Basic Endpoint.
        :param _builtins.str endpoint_zone_id: The zone id of the Basic Endpoint.
        :param _builtins.str id: The id of the Global Accelerator Basic Accelerate Ip Endpoint Relation. It formats as `<accelerator_id>:<accelerate_ip_id>:<endpoint_id>`.
        :param _builtins.str ip_address: The address of the Basic Accelerate IP.
        :param _builtins.str status: The status of the Global Accelerator Basic Accelerate Ip Endpoint Relation. Valid Value: `active`.
        """
        pulumi.set(__self__, "accelerate_ip_id", accelerate_ip_id)
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "basic_endpoint_name", basic_endpoint_name)
        pulumi.set(__self__, "endpoint_address", endpoint_address)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_sub_address", endpoint_sub_address)
        pulumi.set(__self__, "endpoint_sub_address_type", endpoint_sub_address_type)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "endpoint_zone_id", endpoint_zone_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accelerateIpId")
    def accelerate_ip_id(self) -> _builtins.str:
        """
        The ID of the Basic Accelerate IP.
        """
        return pulumi.get(self, "accelerate_ip_id")

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="basicEndpointName")
    def basic_endpoint_name(self) -> _builtins.str:
        """
        The name of the Basic Endpoint.
        """
        return pulumi.get(self, "basic_endpoint_name")

    @_builtins.property
    @pulumi.getter(name="endpointAddress")
    def endpoint_address(self) -> _builtins.str:
        """
        The address of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_address")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The ID of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="endpointSubAddress")
    def endpoint_sub_address(self) -> _builtins.str:
        """
        The sub address of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_sub_address")

    @_builtins.property
    @pulumi.getter(name="endpointSubAddressType")
    def endpoint_sub_address_type(self) -> _builtins.str:
        """
        The sub address type of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_sub_address_type")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> _builtins.str:
        """
        The type of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter(name="endpointZoneId")
    def endpoint_zone_id(self) -> _builtins.str:
        """
        The zone id of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_zone_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Basic Accelerate Ip Endpoint Relation. It formats as `<accelerator_id>:<accelerate_ip_id>:<endpoint_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The address of the Basic Accelerate IP.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Global Accelerator Basic Accelerate Ip Endpoint Relation. Valid Value: `active`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBasicAccelerateIpsIpResult(dict):
    def __init__(__self__, *,
                 accelerate_ip_address: _builtins.str,
                 accelerate_ip_id: _builtins.str,
                 accelerator_id: _builtins.str,
                 id: _builtins.str,
                 ip_set_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerate_ip_address: The address of the Basic Accelerate IP.
        :param _builtins.str accelerate_ip_id: The id of the Basic Accelerate IP.
        :param _builtins.str accelerator_id: The id of the Global Accelerator Basic Accelerator instance.
        :param _builtins.str id: The id of the Basic Accelerate IP.
        :param _builtins.str ip_set_id: The ID of the Basic Ip Set.
        :param _builtins.str status: The status of the Global Accelerator Basic Accelerate IP instance. Valid Value: `active`, `binding`, `bound`, `unbinding`, `deleting`.
        """
        pulumi.set(__self__, "accelerate_ip_address", accelerate_ip_address)
        pulumi.set(__self__, "accelerate_ip_id", accelerate_ip_id)
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_set_id", ip_set_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accelerateIpAddress")
    def accelerate_ip_address(self) -> _builtins.str:
        """
        The address of the Basic Accelerate IP.
        """
        return pulumi.get(self, "accelerate_ip_address")

    @_builtins.property
    @pulumi.getter(name="accelerateIpId")
    def accelerate_ip_id(self) -> _builtins.str:
        """
        The id of the Basic Accelerate IP.
        """
        return pulumi.get(self, "accelerate_ip_id")

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Basic Accelerate IP.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipSetId")
    def ip_set_id(self) -> _builtins.str:
        """
        The ID of the Basic Ip Set.
        """
        return pulumi.get(self, "ip_set_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Global Accelerator Basic Accelerate IP instance. Valid Value: `active`, `binding`, `bound`, `unbinding`, `deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBasicAcceleratorsAcceleratorResult(dict):
    def __init__(__self__, *,
                 bandwidth_billing_type: _builtins.str,
                 basic_accelerator_id: _builtins.str,
                 basic_accelerator_name: _builtins.str,
                 basic_bandwidth_packages: Sequence['outputs.GetBasicAcceleratorsAcceleratorBasicBandwidthPackageResult'],
                 basic_endpoint_group_id: _builtins.str,
                 basic_ip_set_id: _builtins.str,
                 create_time: _builtins.int,
                 cross_domain_bandwidth_packages: Sequence['outputs.GetBasicAcceleratorsAcceleratorCrossDomainBandwidthPackageResult'],
                 description: _builtins.str,
                 expired_time: _builtins.int,
                 id: _builtins.str,
                 instance_charge_type: _builtins.str,
                 region_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str bandwidth_billing_type: The bandwidth billing method. Valid values:
               - `BandwidthPackage`: billed based on bandwidth plans.
               - `CDT`: billed through Cloud Data Transfer (CDT) and based on data transfer.
               - `CDT95`: billed through CDT and based on the 95th percentile bandwidth. This bandwidth billing method is available only for users that are included in the whitelist.
        :param _builtins.str basic_accelerator_id: The id of the Global Accelerator Basic Accelerator instance.
        :param _builtins.str basic_accelerator_name: The name of the Global Accelerator Basic Accelerator instance.
        :param Sequence['GetBasicAcceleratorsAcceleratorBasicBandwidthPackageArgs'] basic_bandwidth_packages: The details about the basic bandwidth plan that is associated with the Global Accelerator Basic Accelerator instance.
        :param _builtins.str basic_endpoint_group_id: The ID of the endpoint group that is associated with the Global Accelerator Basic Accelerator instance.
        :param _builtins.str basic_ip_set_id: The ID of the acceleration region.
        :param _builtins.int create_time: The timestamp that indicates when the Global Accelerator Basic Accelerator instance was created.
        :param Sequence['GetBasicAcceleratorsAcceleratorCrossDomainBandwidthPackageArgs'] cross_domain_bandwidth_packages: The details about the cross-region acceleration bandwidth plan that is associated with the Global Accelerator Basic Accelerator instance. **NOTE:** This array is returned only for Global Accelerator Basic Accelerator instances that are created on the International site.
        :param _builtins.str description: The description of the Global Accelerator Basic Accelerator instance.
        :param _builtins.int expired_time: The timestamp that indicates when the Global Accelerator Basic Accelerator instance was expired.
        :param _builtins.str id: The id of the Global Accelerator Basic Accelerator.
        :param _builtins.str instance_charge_type: The billing method of the Global Accelerator Basic Accelerator instance.
        :param _builtins.str region_id: The ID of the region where the Global Accelerator Basic Accelerator instance is deployed.
        :param _builtins.str status: The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
        """
        pulumi.set(__self__, "bandwidth_billing_type", bandwidth_billing_type)
        pulumi.set(__self__, "basic_accelerator_id", basic_accelerator_id)
        pulumi.set(__self__, "basic_accelerator_name", basic_accelerator_name)
        pulumi.set(__self__, "basic_bandwidth_packages", basic_bandwidth_packages)
        pulumi.set(__self__, "basic_endpoint_group_id", basic_endpoint_group_id)
        pulumi.set(__self__, "basic_ip_set_id", basic_ip_set_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "cross_domain_bandwidth_packages", cross_domain_bandwidth_packages)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="bandwidthBillingType")
    def bandwidth_billing_type(self) -> _builtins.str:
        """
        The bandwidth billing method. Valid values:
        - `BandwidthPackage`: billed based on bandwidth plans.
        - `CDT`: billed through Cloud Data Transfer (CDT) and based on data transfer.
        - `CDT95`: billed through CDT and based on the 95th percentile bandwidth. This bandwidth billing method is available only for users that are included in the whitelist.
        """
        return pulumi.get(self, "bandwidth_billing_type")

    @_builtins.property
    @pulumi.getter(name="basicAcceleratorId")
    def basic_accelerator_id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "basic_accelerator_id")

    @_builtins.property
    @pulumi.getter(name="basicAcceleratorName")
    def basic_accelerator_name(self) -> _builtins.str:
        """
        The name of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "basic_accelerator_name")

    @_builtins.property
    @pulumi.getter(name="basicBandwidthPackages")
    def basic_bandwidth_packages(self) -> Sequence['outputs.GetBasicAcceleratorsAcceleratorBasicBandwidthPackageResult']:
        """
        The details about the basic bandwidth plan that is associated with the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "basic_bandwidth_packages")

    @_builtins.property
    @pulumi.getter(name="basicEndpointGroupId")
    def basic_endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the endpoint group that is associated with the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "basic_endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="basicIpSetId")
    def basic_ip_set_id(self) -> _builtins.str:
        """
        The ID of the acceleration region.
        """
        return pulumi.get(self, "basic_ip_set_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        The timestamp that indicates when the Global Accelerator Basic Accelerator instance was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossDomainBandwidthPackages")
    def cross_domain_bandwidth_packages(self) -> Sequence['outputs.GetBasicAcceleratorsAcceleratorCrossDomainBandwidthPackageResult']:
        """
        The details about the cross-region acceleration bandwidth plan that is associated with the Global Accelerator Basic Accelerator instance. **NOTE:** This array is returned only for Global Accelerator Basic Accelerator instances that are created on the International site.
        """
        return pulumi.get(self, "cross_domain_bandwidth_packages")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.int:
        """
        The timestamp that indicates when the Global Accelerator Basic Accelerator instance was expired.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Basic Accelerator.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> _builtins.str:
        """
        The billing method of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of the region where the Global Accelerator Basic Accelerator instance is deployed.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBasicAcceleratorsAcceleratorBasicBandwidthPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 bandwidth_type: _builtins.str,
                 instance_id: _builtins.str):
        """
        :param _builtins.int bandwidth: The bandwidth value of the cross-region acceleration bandwidth plan. Unit: Mbit/s.
        :param _builtins.str bandwidth_type: The type of the bandwidth that is provided by the basic bandwidth plan.
        :param _builtins.str instance_id: The ID of the cross-region acceleration bandwidth plan.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth value of the cross-region acceleration bandwidth plan. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> _builtins.str:
        """
        The type of the bandwidth that is provided by the basic bandwidth plan.
        """
        return pulumi.get(self, "bandwidth_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the cross-region acceleration bandwidth plan.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetBasicAcceleratorsAcceleratorCrossDomainBandwidthPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 instance_id: _builtins.str):
        """
        :param _builtins.int bandwidth: The bandwidth value of the cross-region acceleration bandwidth plan. Unit: Mbit/s.
        :param _builtins.str instance_id: The ID of the cross-region acceleration bandwidth plan.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth value of the cross-region acceleration bandwidth plan. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the cross-region acceleration bandwidth plan.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetBasicEndpointsEndpointResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 basic_endpoint_name: _builtins.str,
                 endpoint_address: _builtins.str,
                 endpoint_group_id: _builtins.str,
                 endpoint_id: _builtins.str,
                 endpoint_sub_address: _builtins.str,
                 endpoint_sub_address_type: _builtins.str,
                 endpoint_type: _builtins.str,
                 endpoint_zone_id: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the Global Accelerator Basic Accelerator instance.
        :param _builtins.str basic_endpoint_name: The name of the Basic Endpoint.
        :param _builtins.str endpoint_address: The address of the Basic Endpoint.
        :param _builtins.str endpoint_group_id: The ID of the Basic Endpoint Group.
        :param _builtins.str endpoint_id: The ID of the Basic Endpoint.
        :param _builtins.str endpoint_sub_address: The sub address of the Basic Endpoint.
        :param _builtins.str endpoint_sub_address_type: The sub address type of the Basic Endpoint.
        :param _builtins.str endpoint_type: The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
        :param _builtins.str endpoint_zone_id: The zone id of the Basic Endpoint.
        :param _builtins.str id: The id of the Global Accelerator Basic Endpoint. It formats as `<endpoint_group_id>:<endpoint_id>`.
        :param _builtins.str status: The status of the Global Accelerator Basic Endpoint. Valid Value: `init`, `active`, `updating`, `binding`, `unbinding`, `deleting`, `bound`.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "basic_endpoint_name", basic_endpoint_name)
        pulumi.set(__self__, "endpoint_address", endpoint_address)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_sub_address", endpoint_sub_address)
        pulumi.set(__self__, "endpoint_sub_address_type", endpoint_sub_address_type)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "endpoint_zone_id", endpoint_zone_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="basicEndpointName")
    def basic_endpoint_name(self) -> _builtins.str:
        """
        The name of the Basic Endpoint.
        """
        return pulumi.get(self, "basic_endpoint_name")

    @_builtins.property
    @pulumi.getter(name="endpointAddress")
    def endpoint_address(self) -> _builtins.str:
        """
        The address of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_address")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the Basic Endpoint Group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The ID of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="endpointSubAddress")
    def endpoint_sub_address(self) -> _builtins.str:
        """
        The sub address of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_sub_address")

    @_builtins.property
    @pulumi.getter(name="endpointSubAddressType")
    def endpoint_sub_address_type(self) -> _builtins.str:
        """
        The sub address type of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_sub_address_type")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> _builtins.str:
        """
        The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter(name="endpointZoneId")
    def endpoint_zone_id(self) -> _builtins.str:
        """
        The zone id of the Basic Endpoint.
        """
        return pulumi.get(self, "endpoint_zone_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Basic Endpoint. It formats as `<endpoint_group_id>:<endpoint_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Global Accelerator Basic Endpoint. Valid Value: `init`, `active`, `updating`, `binding`, `unbinding`, `deleting`, `bound`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestinationResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 custom_routing_endpoint_group_destination_id: _builtins.str,
                 endpoint_group_id: _builtins.str,
                 from_port: _builtins.int,
                 id: _builtins.str,
                 listener_id: _builtins.str,
                 protocols: Sequence[_builtins.str],
                 to_port: _builtins.int):
        """
        :param _builtins.str accelerator_id: The ID of the GA instance.
        :param _builtins.str custom_routing_endpoint_group_destination_id: The ID of the Custom Routing Endpoint Group Destination.
        :param _builtins.str endpoint_group_id: The ID of the endpoint group.
        :param _builtins.int from_port: The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
        :param _builtins.str id: The id of the Global Accelerator Custom Routing Endpoint Group Destination. It formats as `<endpoint_group_id>:<custom_routing_endpoint_group_destination_id>`.
        :param _builtins.str listener_id: The ID of the listener.
        :param Sequence[_builtins.str] protocols: The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
        :param _builtins.int to_port: The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "custom_routing_endpoint_group_destination_id", custom_routing_endpoint_group_destination_id)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "to_port", to_port)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="customRoutingEndpointGroupDestinationId")
    def custom_routing_endpoint_group_destination_id(self) -> _builtins.str:
        """
        The ID of the Custom Routing Endpoint Group Destination.
        """
        return pulumi.get(self, "custom_routing_endpoint_group_destination_id")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> _builtins.int:
        """
        The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
        """
        return pulumi.get(self, "from_port")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Custom Routing Endpoint Group Destination. It formats as `<endpoint_group_id>:<custom_routing_endpoint_group_destination_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.str]:
        """
        The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> _builtins.int:
        """
        The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class GetCustomRoutingEndpointGroupsGroupResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 custom_routing_endpoint_group_name: _builtins.str,
                 description: _builtins.str,
                 endpoint_group_id: _builtins.str,
                 endpoint_group_ip_lists: Sequence[_builtins.str],
                 endpoint_group_region: _builtins.str,
                 endpoint_group_unconfirmed_ip_lists: Sequence[_builtins.str],
                 id: _builtins.str,
                 listener_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the GA instance.
        :param _builtins.str custom_routing_endpoint_group_name: The name of the endpoint group.
        :param _builtins.str description: The description of the endpoint group.
        :param _builtins.str endpoint_group_id: The ID of the endpoint group.
        :param Sequence[_builtins.str] endpoint_group_ip_lists: The list of endpoint group IP addresses.
        :param _builtins.str endpoint_group_region: The ID of the region where the endpoint group is created.
        :param Sequence[_builtins.str] endpoint_group_unconfirmed_ip_lists: The endpoint group IP addresses to be confirmed after the GA instance is upgraded.
        :param _builtins.str id: The id of the Custom Routing Endpoint Group.
        :param _builtins.str listener_id: The ID of the custom routing listener.
        :param _builtins.str status: The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "custom_routing_endpoint_group_name", custom_routing_endpoint_group_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "endpoint_group_ip_lists", endpoint_group_ip_lists)
        pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        pulumi.set(__self__, "endpoint_group_unconfirmed_ip_lists", endpoint_group_unconfirmed_ip_lists)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="customRoutingEndpointGroupName")
    def custom_routing_endpoint_group_name(self) -> _builtins.str:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "custom_routing_endpoint_group_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="endpointGroupIpLists")
    def endpoint_group_ip_lists(self) -> Sequence[_builtins.str]:
        """
        The list of endpoint group IP addresses.
        """
        return pulumi.get(self, "endpoint_group_ip_lists")

    @_builtins.property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> _builtins.str:
        """
        The ID of the region where the endpoint group is created.
        """
        return pulumi.get(self, "endpoint_group_region")

    @_builtins.property
    @pulumi.getter(name="endpointGroupUnconfirmedIpLists")
    def endpoint_group_unconfirmed_ip_lists(self) -> Sequence[_builtins.str]:
        """
        The endpoint group IP addresses to be confirmed after the GA instance is upgraded.
        """
        return pulumi.get(self, "endpoint_group_unconfirmed_ip_lists")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Custom Routing Endpoint Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the custom routing listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 address: _builtins.str,
                 custom_routing_endpoint_traffic_policy_id: _builtins.str,
                 endpoint_group_id: _builtins.str,
                 endpoint_id: _builtins.str,
                 id: _builtins.str,
                 listener_id: _builtins.str,
                 port_ranges: Sequence['outputs.GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyPortRangeResult']):
        """
        :param _builtins.str accelerator_id: The ID of the GA instance to which the traffic policies belong.
        :param _builtins.str address: The IP addresses of the traffic policies.
        :param _builtins.str custom_routing_endpoint_traffic_policy_id: The ID of the Custom Routing Endpoint Traffic Policy.
        :param _builtins.str endpoint_group_id: The ID of the endpoint group to which the traffic policies belong.
        :param _builtins.str endpoint_id: The ID of the endpoint to which the traffic policies belong.
        :param _builtins.str id: The id of the Global Accelerator Custom Routing Endpoint Traffic Policy. It formats as `<endpoint_id>:<custom_routing_endpoint_traffic_policy_id>`.
        :param _builtins.str listener_id: The ID of the listener to which the traffic policies belong.
        :param Sequence['GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyPortRangeArgs'] port_ranges: The port range of the traffic policy.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "custom_routing_endpoint_traffic_policy_id", custom_routing_endpoint_traffic_policy_id)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "port_ranges", port_ranges)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance to which the traffic policies belong.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IP addresses of the traffic policies.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="customRoutingEndpointTrafficPolicyId")
    def custom_routing_endpoint_traffic_policy_id(self) -> _builtins.str:
        """
        The ID of the Custom Routing Endpoint Traffic Policy.
        """
        return pulumi.get(self, "custom_routing_endpoint_traffic_policy_id")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the endpoint group to which the traffic policies belong.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The ID of the endpoint to which the traffic policies belong.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Custom Routing Endpoint Traffic Policy. It formats as `<endpoint_id>:<custom_routing_endpoint_traffic_policy_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener to which the traffic policies belong.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Sequence['outputs.GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyPortRangeResult']:
        """
        The port range of the traffic policy.
        """
        return pulumi.get(self, "port_ranges")


@pulumi.output_type
class GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyPortRangeResult(dict):
    def __init__(__self__, *,
                 from_port: _builtins.int,
                 to_port: _builtins.int):
        """
        :param _builtins.int from_port: The first port of the port range.
        :param _builtins.int to_port: The last port of the port range.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> _builtins.int:
        """
        The first port of the port range.
        """
        return pulumi.get(self, "from_port")

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> _builtins.int:
        """
        The last port of the port range.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class GetCustomRoutingEndpointsCustomRoutingEndpointResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 custom_routing_endpoint_id: _builtins.str,
                 endpoint: _builtins.str,
                 endpoint_group_id: _builtins.str,
                 id: _builtins.str,
                 listener_id: _builtins.str,
                 traffic_to_endpoint_policy: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the GA instance.
        :param _builtins.str custom_routing_endpoint_id: The ID of the Custom Routing Endpoint.
        :param _builtins.str endpoint: The ID of the endpoint (vSwitch).
        :param _builtins.str endpoint_group_id: The ID of the endpoint group.
        :param _builtins.str id: The id of the Global Accelerator Custom Routing Endpoint. It formats as `<endpoint_group_id>:<custom_routing_endpoint_id>`.
        :param _builtins.str listener_id: The ID of the custom routing listener.
        :param _builtins.str traffic_to_endpoint_policy: The access policy of traffic for the specified endpoint.
        :param _builtins.str type: The backend service type of the endpoint.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "custom_routing_endpoint_id", custom_routing_endpoint_id)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "traffic_to_endpoint_policy", traffic_to_endpoint_policy)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="customRoutingEndpointId")
    def custom_routing_endpoint_id(self) -> _builtins.str:
        """
        The ID of the Custom Routing Endpoint.
        """
        return pulumi.get(self, "custom_routing_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The ID of the endpoint (vSwitch).
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Global Accelerator Custom Routing Endpoint. It formats as `<endpoint_group_id>:<custom_routing_endpoint_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the custom routing listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="trafficToEndpointPolicy")
    def traffic_to_endpoint_policy(self) -> _builtins.str:
        """
        The access policy of traffic for the specified endpoint.
        """
        return pulumi.get(self, "traffic_to_endpoint_policy")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The backend service type of the endpoint.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCustomRoutingPortMappingsCustomRoutingPortMappingResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 accelerator_port: _builtins.int,
                 destination_socket_addresses: Sequence['outputs.GetCustomRoutingPortMappingsCustomRoutingPortMappingDestinationSocketAddressResult'],
                 endpoint_group_id: _builtins.str,
                 endpoint_group_region: _builtins.str,
                 endpoint_id: _builtins.str,
                 listener_id: _builtins.str,
                 protocols: Sequence[_builtins.str],
                 status: _builtins.str,
                 vswitch: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the GA instance.
        :param _builtins.int accelerator_port: The acceleration port.
        :param Sequence['GetCustomRoutingPortMappingsCustomRoutingPortMappingDestinationSocketAddressArgs'] destination_socket_addresses: The service IP address and port of the backend instance.
        :param _builtins.str endpoint_group_id: The ID of the endpoint group.
        :param _builtins.str endpoint_group_region: The ID of the region in which the endpoint group resides.
        :param _builtins.str endpoint_id: The ID of the endpoint.
        :param _builtins.str listener_id: The ID of the listener.
        :param Sequence[_builtins.str] protocols: The protocol of the backend service.
        :param _builtins.str status: The access policy of traffic for the backend instance. Valid Values: `allow`, `deny`.
        :param _builtins.str vswitch: The ID of the endpoint (vSwitch).
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "accelerator_port", accelerator_port)
        pulumi.set(__self__, "destination_socket_addresses", destination_socket_addresses)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vswitch", vswitch)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="acceleratorPort")
    def accelerator_port(self) -> _builtins.int:
        """
        The acceleration port.
        """
        return pulumi.get(self, "accelerator_port")

    @_builtins.property
    @pulumi.getter(name="destinationSocketAddresses")
    def destination_socket_addresses(self) -> Sequence['outputs.GetCustomRoutingPortMappingsCustomRoutingPortMappingDestinationSocketAddressResult']:
        """
        The service IP address and port of the backend instance.
        """
        return pulumi.get(self, "destination_socket_addresses")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> _builtins.str:
        """
        The ID of the region in which the endpoint group resides.
        """
        return pulumi.get(self, "endpoint_group_region")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.str]:
        """
        The protocol of the backend service.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The access policy of traffic for the backend instance. Valid Values: `allow`, `deny`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def vswitch(self) -> _builtins.str:
        """
        The ID of the endpoint (vSwitch).
        """
        return pulumi.get(self, "vswitch")


@pulumi.output_type
class GetCustomRoutingPortMappingsCustomRoutingPortMappingDestinationSocketAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str ip_address: The service IP address of the backend instance.
        :param _builtins.int port: The service port of the backend instance.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The service IP address of the backend instance.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The service port of the backend instance.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 accelerator_id: _builtins.str,
                 domain: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerator_id: The ID of the global acceleration instance.
        :param _builtins.str domain: The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
        :param _builtins.str id: The ID of the Ga Domain.
        :param _builtins.str status: The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the global acceleration instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ga Domain.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEndpointGroupIpAddressCidrBlocksEndpointGroupIpAddressCidrBlockResult(dict):
    def __init__(__self__, *,
                 endpoint_group_region: _builtins.str,
                 ip_address_cidr_blocks: Sequence[_builtins.str],
                 status: _builtins.str):
        """
        :param _builtins.str endpoint_group_region: The region ID of the endpoint group.
        :param Sequence[_builtins.str] ip_address_cidr_blocks: The CIDR blocks.
        :param _builtins.str status: The status of the list of endpoint group ip address cidr blocks.
        """
        pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        pulumi.set(__self__, "ip_address_cidr_blocks", ip_address_cidr_blocks)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> _builtins.str:
        """
        The region ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_region")

    @_builtins.property
    @pulumi.getter(name="ipAddressCidrBlocks")
    def ip_address_cidr_blocks(self) -> Sequence[_builtins.str]:
        """
        The CIDR blocks.
        """
        return pulumi.get(self, "ip_address_cidr_blocks")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the list of endpoint group ip address cidr blocks.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEndpointGroupsGroupResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 endpoint_configurations: Sequence['outputs.GetEndpointGroupsGroupEndpointConfigurationResult'],
                 endpoint_group_id: _builtins.str,
                 endpoint_group_ip_lists: Sequence[_builtins.str],
                 endpoint_group_region: _builtins.str,
                 health_check_interval_seconds: _builtins.int,
                 health_check_path: _builtins.str,
                 health_check_port: _builtins.int,
                 health_check_protocol: _builtins.str,
                 id: _builtins.str,
                 listener_id: _builtins.str,
                 name: _builtins.str,
                 port_overrides: Sequence['outputs.GetEndpointGroupsGroupPortOverrideResult'],
                 status: _builtins.str,
                 threshold_count: _builtins.int,
                 traffic_percentage: _builtins.int):
        """
        :param _builtins.str description: The description of the endpoint group.
        :param Sequence['GetEndpointGroupsGroupEndpointConfigurationArgs'] endpoint_configurations: The endpointConfigurations of the endpoint group.
        :param _builtins.str endpoint_group_id: The endpoint_group_id of the Endpoint Group.
        :param Sequence[_builtins.str] endpoint_group_ip_lists: (Available since v1.213.1) The list of endpoint group IP addresses.
        :param _builtins.str endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param _builtins.int health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param _builtins.str health_check_path: The path specified as the destination of the targets for health checks.
        :param _builtins.int health_check_port: The port that is used for health checks.
        :param _builtins.str health_check_protocol: The protocol that is used to connect to the targets for health checks.
        :param _builtins.str id: The ID of the Endpoint Group.
        :param _builtins.str listener_id: The ID of the listener that is associated with the endpoint group.
        :param _builtins.str name: The name of the endpoint group.
        :param Sequence['GetEndpointGroupsGroupPortOverrideArgs'] port_overrides: Mapping between listening port and forwarding port of boarding point.
        :param _builtins.str status: The status of the endpoint group. Valid values: `active`, `configuring`, `creating`, `init`.
        :param _builtins.int threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy.
        :param _builtins.int traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "endpoint_group_ip_lists", endpoint_group_ip_lists)
        pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        pulumi.set(__self__, "health_check_path", health_check_path)
        pulumi.set(__self__, "health_check_port", health_check_port)
        pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port_overrides", port_overrides)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "threshold_count", threshold_count)
        pulumi.set(__self__, "traffic_percentage", traffic_percentage)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> Sequence['outputs.GetEndpointGroupsGroupEndpointConfigurationResult']:
        """
        The endpointConfigurations of the endpoint group.
        """
        return pulumi.get(self, "endpoint_configurations")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        The endpoint_group_id of the Endpoint Group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="endpointGroupIpLists")
    def endpoint_group_ip_lists(self) -> Sequence[_builtins.str]:
        """
        (Available since v1.213.1) The list of endpoint group IP addresses.
        """
        return pulumi.get(self, "endpoint_group_ip_lists")

    @_builtins.property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> _builtins.str:
        """
        The ID of the region where the endpoint group is deployed.
        """
        return pulumi.get(self, "endpoint_group_region")

    @_builtins.property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> _builtins.int:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> _builtins.str:
        """
        The path specified as the destination of the targets for health checks.
        """
        return pulumi.get(self, "health_check_path")

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> _builtins.int:
        """
        The port that is used for health checks.
        """
        return pulumi.get(self, "health_check_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> _builtins.str:
        """
        The protocol that is used to connect to the targets for health checks.
        """
        return pulumi.get(self, "health_check_protocol")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Endpoint Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener that is associated with the endpoint group.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> Sequence['outputs.GetEndpointGroupsGroupPortOverrideResult']:
        """
        Mapping between listening port and forwarding port of boarding point.
        """
        return pulumi.get(self, "port_overrides")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the endpoint group. Valid values: `active`, `configuring`, `creating`, `init`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> _builtins.int:
        """
        The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy.
        """
        return pulumi.get(self, "threshold_count")

    @_builtins.property
    @pulumi.getter(name="trafficPercentage")
    def traffic_percentage(self) -> _builtins.int:
        """
        The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        return pulumi.get(self, "traffic_percentage")


@pulumi.output_type
class GetEndpointGroupsGroupEndpointConfigurationResult(dict):
    def __init__(__self__, *,
                 enable_clientip_preservation: _builtins.bool,
                 endpoint: _builtins.str,
                 probe_port: _builtins.int,
                 probe_protocol: _builtins.str,
                 type: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.bool enable_clientip_preservation: Indicates whether client IP addresses are reserved.
        :param _builtins.str endpoint: The IP address or domain name of Endpoint N in the endpoint group.
        :param _builtins.int probe_port: Probe Port.
        :param _builtins.str probe_protocol: Probe Protocol.
        :param _builtins.str type: The type of Endpoint N in the endpoint group.
        :param _builtins.int weight: The weight of Endpoint N in the endpoint group.
        """
        pulumi.set(__self__, "enable_clientip_preservation", enable_clientip_preservation)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "probe_port", probe_port)
        pulumi.set(__self__, "probe_protocol", probe_protocol)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="enableClientipPreservation")
    def enable_clientip_preservation(self) -> _builtins.bool:
        """
        Indicates whether client IP addresses are reserved.
        """
        return pulumi.get(self, "enable_clientip_preservation")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The IP address or domain name of Endpoint N in the endpoint group.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="probePort")
    def probe_port(self) -> _builtins.int:
        """
        Probe Port.
        """
        return pulumi.get(self, "probe_port")

    @_builtins.property
    @pulumi.getter(name="probeProtocol")
    def probe_protocol(self) -> _builtins.str:
        """
        Probe Protocol.
        """
        return pulumi.get(self, "probe_protocol")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Endpoint N in the endpoint group.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of Endpoint N in the endpoint group.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetEndpointGroupsGroupPortOverrideResult(dict):
    def __init__(__self__, *,
                 endpoint_port: _builtins.int,
                 listener_port: _builtins.int):
        """
        :param _builtins.int endpoint_port: Forwarding port.
        :param _builtins.int listener_port: Listener port.
        """
        pulumi.set(__self__, "endpoint_port", endpoint_port)
        pulumi.set(__self__, "listener_port", listener_port)

    @_builtins.property
    @pulumi.getter(name="endpointPort")
    def endpoint_port(self) -> _builtins.int:
        """
        Forwarding port.
        """
        return pulumi.get(self, "endpoint_port")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> _builtins.int:
        """
        Listener port.
        """
        return pulumi.get(self, "listener_port")


@pulumi.output_type
class GetForwardingRulesForwardingRuleResult(dict):
    def __init__(__self__, *,
                 forwarding_rule_id: _builtins.str,
                 forwarding_rule_name: _builtins.str,
                 forwarding_rule_status: _builtins.str,
                 id: _builtins.str,
                 listener_id: _builtins.str,
                 priority: _builtins.int,
                 rule_actions: Sequence['outputs.GetForwardingRulesForwardingRuleRuleActionResult'],
                 rule_conditions: Sequence['outputs.GetForwardingRulesForwardingRuleRuleConditionResult']):
        """
        :param _builtins.str forwarding_rule_id: Forwarding Policy ID.
        :param _builtins.str forwarding_rule_name: Forwarding policy name. The length of the name is 2-128 English or Chinese characters.
        :param _builtins.str forwarding_rule_status: Forwarding Policy Status.
        :param _builtins.str listener_id: The ID of the listener.
        :param _builtins.int priority: Forwarding policy priority.
        :param Sequence['GetForwardingRulesForwardingRuleRuleActionArgs'] rule_actions: The IP protocol used by the GA instance.
        :param Sequence['GetForwardingRulesForwardingRuleRuleConditionArgs'] rule_conditions: Forward action.
        """
        pulumi.set(__self__, "forwarding_rule_id", forwarding_rule_id)
        pulumi.set(__self__, "forwarding_rule_name", forwarding_rule_name)
        pulumi.set(__self__, "forwarding_rule_status", forwarding_rule_status)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_actions", rule_actions)
        pulumi.set(__self__, "rule_conditions", rule_conditions)

    @_builtins.property
    @pulumi.getter(name="forwardingRuleId")
    def forwarding_rule_id(self) -> _builtins.str:
        """
        Forwarding Policy ID.
        """
        return pulumi.get(self, "forwarding_rule_id")

    @_builtins.property
    @pulumi.getter(name="forwardingRuleName")
    def forwarding_rule_name(self) -> _builtins.str:
        """
        Forwarding policy name. The length of the name is 2-128 English or Chinese characters.
        """
        return pulumi.get(self, "forwarding_rule_name")

    @_builtins.property
    @pulumi.getter(name="forwardingRuleStatus")
    def forwarding_rule_status(self) -> _builtins.str:
        """
        Forwarding Policy Status.
        """
        return pulumi.get(self, "forwarding_rule_status")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Forwarding policy priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="ruleActions")
    def rule_actions(self) -> Sequence['outputs.GetForwardingRulesForwardingRuleRuleActionResult']:
        """
        The IP protocol used by the GA instance.
        """
        return pulumi.get(self, "rule_actions")

    @_builtins.property
    @pulumi.getter(name="ruleConditions")
    def rule_conditions(self) -> Sequence['outputs.GetForwardingRulesForwardingRuleRuleConditionResult']:
        """
        Forward action.
        """
        return pulumi.get(self, "rule_conditions")


@pulumi.output_type
class GetForwardingRulesForwardingRuleRuleActionResult(dict):
    def __init__(__self__, *,
                 forward_group_configs: Sequence['outputs.GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigResult'],
                 order: _builtins.int,
                 rule_action_type: _builtins.str):
        """
        :param Sequence['GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigArgs'] forward_group_configs: Forwarding configuration.
        :param _builtins.int order: Forwarding priority.
        :param _builtins.str rule_action_type: Forward action type.
        """
        pulumi.set(__self__, "forward_group_configs", forward_group_configs)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "rule_action_type", rule_action_type)

    @_builtins.property
    @pulumi.getter(name="forwardGroupConfigs")
    def forward_group_configs(self) -> Sequence['outputs.GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigResult']:
        """
        Forwarding configuration.
        """
        return pulumi.get(self, "forward_group_configs")

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.int:
        """
        Forwarding priority.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="ruleActionType")
    def rule_action_type(self) -> _builtins.str:
        """
        Forward action type.
        """
        return pulumi.get(self, "rule_action_type")


@pulumi.output_type
class GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigResult(dict):
    def __init__(__self__, *,
                 server_group_tuples: Sequence['outputs.GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigServerGroupTupleResult']):
        """
        :param Sequence['GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs'] server_group_tuples: Terminal node group configuration.
        """
        pulumi.set(__self__, "server_group_tuples", server_group_tuples)

    @_builtins.property
    @pulumi.getter(name="serverGroupTuples")
    def server_group_tuples(self) -> Sequence['outputs.GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigServerGroupTupleResult']:
        """
        Terminal node group configuration.
        """
        return pulumi.get(self, "server_group_tuples")


@pulumi.output_type
class GetForwardingRulesForwardingRuleRuleActionForwardGroupConfigServerGroupTupleResult(dict):
    def __init__(__self__, *,
                 endpoint_group_id: _builtins.str):
        """
        :param _builtins.str endpoint_group_id: Terminal node group ID.
        """
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> _builtins.str:
        """
        Terminal node group ID.
        """
        return pulumi.get(self, "endpoint_group_id")


@pulumi.output_type
class GetForwardingRulesForwardingRuleRuleConditionResult(dict):
    def __init__(__self__, *,
                 host_configs: Sequence['outputs.GetForwardingRulesForwardingRuleRuleConditionHostConfigResult'],
                 path_configs: Sequence['outputs.GetForwardingRulesForwardingRuleRuleConditionPathConfigResult'],
                 rule_condition_type: _builtins.str):
        """
        :param Sequence['GetForwardingRulesForwardingRuleRuleConditionHostConfigArgs'] host_configs: Domain name configuration information.
        :param Sequence['GetForwardingRulesForwardingRuleRuleConditionPathConfigArgs'] path_configs: Path configuration information.
        :param _builtins.str rule_condition_type: Forwarding condition type.
        """
        pulumi.set(__self__, "host_configs", host_configs)
        pulumi.set(__self__, "path_configs", path_configs)
        pulumi.set(__self__, "rule_condition_type", rule_condition_type)

    @_builtins.property
    @pulumi.getter(name="hostConfigs")
    def host_configs(self) -> Sequence['outputs.GetForwardingRulesForwardingRuleRuleConditionHostConfigResult']:
        """
        Domain name configuration information.
        """
        return pulumi.get(self, "host_configs")

    @_builtins.property
    @pulumi.getter(name="pathConfigs")
    def path_configs(self) -> Sequence['outputs.GetForwardingRulesForwardingRuleRuleConditionPathConfigResult']:
        """
        Path configuration information.
        """
        return pulumi.get(self, "path_configs")

    @_builtins.property
    @pulumi.getter(name="ruleConditionType")
    def rule_condition_type(self) -> _builtins.str:
        """
        Forwarding condition type.
        """
        return pulumi.get(self, "rule_condition_type")


@pulumi.output_type
class GetForwardingRulesForwardingRuleRuleConditionHostConfigResult(dict):
    def __init__(__self__, *,
                 values: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] values: The domain name is 3-128 characters long.
        """
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        The domain name is 3-128 characters long.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetForwardingRulesForwardingRuleRuleConditionPathConfigResult(dict):
    def __init__(__self__, *,
                 values: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] values: The domain name is 3-128 characters long.
        """
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        The domain name is 3-128 characters long.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetIpSetsSetResult(dict):
    def __init__(__self__, *,
                 accelerate_region_id: _builtins.str,
                 bandwidth: _builtins.int,
                 id: _builtins.str,
                 ip_address_lists: Sequence[_builtins.str],
                 ip_set_id: _builtins.str,
                 ip_version: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str accelerate_region_id: The ID of an acceleration region.
        :param _builtins.int bandwidth: The bandwidth allocated to the acceleration region.
        :param _builtins.str id: The ID of the Ip Set.
        :param Sequence[_builtins.str] ip_address_lists: The list of accelerated IP addresses in the acceleration region.
        :param _builtins.str ip_set_id: Accelerated area ID.
        :param _builtins.str ip_version: The IP protocol used by the GA instance.
        :param _builtins.str status: The status of the acceleration region. Valid values: `active`, `deleting`, `init`, `updating`.
        """
        pulumi.set(__self__, "accelerate_region_id", accelerate_region_id)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address_lists", ip_address_lists)
        pulumi.set(__self__, "ip_set_id", ip_set_id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accelerateRegionId")
    def accelerate_region_id(self) -> _builtins.str:
        """
        The ID of an acceleration region.
        """
        return pulumi.get(self, "accelerate_region_id")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth allocated to the acceleration region.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ip Set.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddressLists")
    def ip_address_lists(self) -> Sequence[_builtins.str]:
        """
        The list of accelerated IP addresses in the acceleration region.
        """
        return pulumi.get(self, "ip_address_lists")

    @_builtins.property
    @pulumi.getter(name="ipSetId")
    def ip_set_id(self) -> _builtins.str:
        """
        Accelerated area ID.
        """
        return pulumi.get(self, "ip_set_id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        The IP protocol used by the GA instance.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the acceleration region. Valid values: `active`, `deleting`, `init`, `updating`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetListenersListenerResult(dict):
    def __init__(__self__, *,
                 certificates: Sequence['outputs.GetListenersListenerCertificateResult'],
                 client_affinity: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 listener_id: _builtins.str,
                 name: _builtins.str,
                 port_ranges: Sequence['outputs.GetListenersListenerPortRangeResult'],
                 protocol: _builtins.str,
                 status: _builtins.str):
        """
        :param Sequence['GetListenersListenerCertificateArgs'] certificates: The certificates of the listener.
        :param _builtins.str client_affinity: The clientAffinity of the listener.
        :param _builtins.str description: The description of the listener.
        :param _builtins.str id: The ID of the Listener.
        :param _builtins.str listener_id: The listenerId of the listener.
        :param _builtins.str name: The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        :param Sequence['GetListenersListenerPortRangeArgs'] port_ranges: The portRanges of the listener.
        :param _builtins.str protocol: Type of network transport protocol monitored.
        :param _builtins.str status: The status of the listener. Valid values: `active`, `configuring`, `creating`.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "client_affinity", client_affinity)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port_ranges", port_ranges)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetListenersListenerCertificateResult']:
        """
        The certificates of the listener.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="clientAffinity")
    def client_affinity(self) -> _builtins.str:
        """
        The clientAffinity of the listener.
        """
        return pulumi.get(self, "client_affinity")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Listener.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The listenerId of the listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Sequence['outputs.GetListenersListenerPortRangeResult']:
        """
        The portRanges of the listener.
        """
        return pulumi.get(self, "port_ranges")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Type of network transport protocol monitored.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the listener. Valid values: `active`, `configuring`, `creating`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetListenersListenerCertificateResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: The ID of the Listener.
        :param _builtins.str type: The type of the certificate.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Listener.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the certificate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetListenersListenerPortRangeResult(dict):
    def __init__(__self__, *,
                 from_port: _builtins.int,
                 to_port: _builtins.int):
        """
        :param _builtins.int from_port: The initial listening port used to receive requests and forward them to terminal nodes.
        :param _builtins.int to_port: The end listening port used to receive requests and forward them to terminal nodes.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> _builtins.int:
        """
        The initial listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "from_port")

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> _builtins.int:
        """
        The end listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "to_port")


