# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 baseline_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]]] = None,
                 default_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] baseline_id: The baseline ID.
               
               If it is left blank, the system default baseline is used by default.
        :param pulumi.Input[_builtins.int] account_id: The ID of the enrolled account.
               - If you are creating a new resource account, this parameter is not required.
               - If you are enrolling a existing account to account factory, this parameter is required.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]] account_tags: The tags of the account See `account_tags` below.
        :param pulumi.Input[_builtins.str] default_domain_name: The domain name is used to qualify the login name of RAM users and RAM roles.
        :param pulumi.Input[_builtins.str] display_name: The account display name.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent resource folder.
               
               If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
               
               If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.int] payer_account_id: The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
        """
        pulumi.set(__self__, "baseline_id", baseline_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_name_prefix is not None:
            pulumi.set(__self__, "account_name_prefix", account_name_prefix)
        if account_tags is not None:
            pulumi.set(__self__, "account_tags", account_tags)
        if default_domain_name is not None:
            pulumi.set(__self__, "default_domain_name", default_domain_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if payer_account_id is not None:
            pulumi.set(__self__, "payer_account_id", payer_account_id)

    @_builtins.property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> pulumi.Input[_builtins.str]:
        """
        The baseline ID.

        If it is left blank, the system default baseline is used by default.
        """
        return pulumi.get(self, "baseline_id")

    @baseline_id.setter
    def baseline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "baseline_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the enrolled account.
        - If you are creating a new resource account, this parameter is not required.
        - If you are enrolling a existing account to account factory, this parameter is required.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="accountNamePrefix")
    def account_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account name prefix.
        - This parameter is required if you are creating a new resource account.
        - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "account_name_prefix")

    @account_name_prefix.setter
    def account_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]]]:
        """
        The tags of the account See `account_tags` below.
        """
        return pulumi.get(self, "account_tags")

    @account_tags.setter
    def account_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]]]):
        pulumi.set(self, "account_tags", value)

    @_builtins.property
    @pulumi.getter(name="defaultDomainName")
    def default_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name is used to qualify the login name of RAM users and RAM roles.
        """
        return pulumi.get(self, "default_domain_name")

    @default_domain_name.setter
    def default_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account display name.
        - This parameter is required if you are creating a new resource account.
        - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the parent resource folder.

        If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.

        If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
        """
        return pulumi.get(self, "payer_account_id")

    @payer_account_id.setter
    def payer_account_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payer_account_id", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]]] = None,
                 baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.int] account_id: The ID of the enrolled account.
               - If you are creating a new resource account, this parameter is not required.
               - If you are enrolling a existing account to account factory, this parameter is required.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]] account_tags: The tags of the account See `account_tags` below.
        :param pulumi.Input[_builtins.str] baseline_id: The baseline ID.
               
               If it is left blank, the system default baseline is used by default.
        :param pulumi.Input[_builtins.str] default_domain_name: The domain name is used to qualify the login name of RAM users and RAM roles.
        :param pulumi.Input[_builtins.str] display_name: The account display name.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent resource folder.
               
               If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
               
               If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.int] payer_account_id: The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
        :param pulumi.Input[_builtins.str] status: Account registration status. Value:
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_name_prefix is not None:
            pulumi.set(__self__, "account_name_prefix", account_name_prefix)
        if account_tags is not None:
            pulumi.set(__self__, "account_tags", account_tags)
        if baseline_id is not None:
            pulumi.set(__self__, "baseline_id", baseline_id)
        if default_domain_name is not None:
            pulumi.set(__self__, "default_domain_name", default_domain_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if payer_account_id is not None:
            pulumi.set(__self__, "payer_account_id", payer_account_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the enrolled account.
        - If you are creating a new resource account, this parameter is not required.
        - If you are enrolling a existing account to account factory, this parameter is required.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="accountNamePrefix")
    def account_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account name prefix.
        - This parameter is required if you are creating a new resource account.
        - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "account_name_prefix")

    @account_name_prefix.setter
    def account_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]]]:
        """
        The tags of the account See `account_tags` below.
        """
        return pulumi.get(self, "account_tags")

    @account_tags.setter
    def account_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountAccountTagArgs']]]]):
        pulumi.set(self, "account_tags", value)

    @_builtins.property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The baseline ID.

        If it is left blank, the system default baseline is used by default.
        """
        return pulumi.get(self, "baseline_id")

    @baseline_id.setter
    def baseline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultDomainName")
    def default_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name is used to qualify the login name of RAM users and RAM roles.
        """
        return pulumi.get(self, "default_domain_name")

    @default_domain_name.setter
    def default_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account display name.
        - This parameter is required if you are creating a new resource account.
        - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the parent resource folder.

        If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.

        If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
        """
        return pulumi.get(self, "payer_account_id")

    @payer_account_id.setter
    def payer_account_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payer_account_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account registration status. Value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:governance/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountAccountTagArgs', 'AccountAccountTagArgsDict']]]]] = None,
                 baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        Governance Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:governance/account:Account example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] account_id: The ID of the enrolled account.
               - If you are creating a new resource account, this parameter is not required.
               - If you are enrolling a existing account to account factory, this parameter is required.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountAccountTagArgs', 'AccountAccountTagArgsDict']]]] account_tags: The tags of the account See `account_tags` below.
        :param pulumi.Input[_builtins.str] baseline_id: The baseline ID.
               
               If it is left blank, the system default baseline is used by default.
        :param pulumi.Input[_builtins.str] default_domain_name: The domain name is used to qualify the login name of RAM users and RAM roles.
        :param pulumi.Input[_builtins.str] display_name: The account display name.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent resource folder.
               
               If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
               
               If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.int] payer_account_id: The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Governance Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:governance/account:Account example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountAccountTagArgs', 'AccountAccountTagArgsDict']]]]] = None,
                 baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payer_account_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["account_name_prefix"] = account_name_prefix
            __props__.__dict__["account_tags"] = account_tags
            if baseline_id is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_id'")
            __props__.__dict__["baseline_id"] = baseline_id
            __props__.__dict__["default_domain_name"] = default_domain_name
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["payer_account_id"] = payer_account_id
            __props__.__dict__["status"] = None
        super(Account, __self__).__init__(
            'alicloud:governance/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.int]] = None,
            account_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountAccountTagArgs', 'AccountAccountTagArgsDict']]]]] = None,
            baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            payer_account_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] account_id: The ID of the enrolled account.
               - If you are creating a new resource account, this parameter is not required.
               - If you are enrolling a existing account to account factory, this parameter is required.
        :param pulumi.Input[_builtins.str] account_name_prefix: Account name prefix.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountAccountTagArgs', 'AccountAccountTagArgsDict']]]] account_tags: The tags of the account See `account_tags` below.
        :param pulumi.Input[_builtins.str] baseline_id: The baseline ID.
               
               If it is left blank, the system default baseline is used by default.
        :param pulumi.Input[_builtins.str] default_domain_name: The domain name is used to qualify the login name of RAM users and RAM roles.
        :param pulumi.Input[_builtins.str] display_name: The account display name.
               - This parameter is required if you are creating a new resource account.
               - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the parent resource folder.
               
               If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
               
               If the registration application is applied to an existing account, this parameter does not need to be filled in.
        :param pulumi.Input[_builtins.int] payer_account_id: The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
        :param pulumi.Input[_builtins.str] status: Account registration status. Value:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["account_name_prefix"] = account_name_prefix
        __props__.__dict__["account_tags"] = account_tags
        __props__.__dict__["baseline_id"] = baseline_id
        __props__.__dict__["default_domain_name"] = default_domain_name
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["payer_account_id"] = payer_account_id
        __props__.__dict__["status"] = status
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the enrolled account.
        - If you are creating a new resource account, this parameter is not required.
        - If you are enrolling a existing account to account factory, this parameter is required.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="accountNamePrefix")
    def account_name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Account name prefix.
        - This parameter is required if you are creating a new resource account.
        - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "account_name_prefix")

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> pulumi.Output[Optional[Sequence['outputs.AccountAccountTag']]]:
        """
        The tags of the account See `account_tags` below.
        """
        return pulumi.get(self, "account_tags")

    @_builtins.property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The baseline ID.

        If it is left blank, the system default baseline is used by default.
        """
        return pulumi.get(self, "baseline_id")

    @_builtins.property
    @pulumi.getter(name="defaultDomainName")
    def default_domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain name is used to qualify the login name of RAM users and RAM roles.
        """
        return pulumi.get(self, "default_domain_name")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The account display name.
        - This parameter is required if you are creating a new resource account.
        - If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the parent resource folder.

        If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.

        If the registration application is applied to an existing account, this parameter does not need to be filled in.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
        """
        return pulumi.get(self, "payer_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Account registration status. Value:
        """
        return pulumi.get(self, "status")

