# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BaselineArgs', 'Baseline']

@pulumi.input_type
class BaselineArgs:
    def __init__(__self__, *,
                 baseline_items: Optional[pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]]] = None,
                 baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Baseline resource.
        :param pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]] baseline_items: List of baseline items.
               
               You can invoke [ListAccountFactoryBaselineItems](https://next.api.aliyun.com/document/governance/2021-01-20/ListAccountFactoryBaselineItems) to get a list of account factory baseline items supported by the Cloud Governance Center. See `baseline_items` below.
        :param pulumi.Input[_builtins.str] baseline_name: Baseline Name.
        :param pulumi.Input[_builtins.str] description: Baseline Description.
        """
        if baseline_items is not None:
            pulumi.set(__self__, "baseline_items", baseline_items)
        if baseline_name is not None:
            pulumi.set(__self__, "baseline_name", baseline_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="baselineItems")
    def baseline_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]]]:
        """
        List of baseline items.

        You can invoke [ListAccountFactoryBaselineItems](https://next.api.aliyun.com/document/governance/2021-01-20/ListAccountFactoryBaselineItems) to get a list of account factory baseline items supported by the Cloud Governance Center. See `baseline_items` below.
        """
        return pulumi.get(self, "baseline_items")

    @baseline_items.setter
    def baseline_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]]]):
        pulumi.set(self, "baseline_items", value)

    @_builtins.property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Baseline Name.
        """
        return pulumi.get(self, "baseline_name")

    @baseline_name.setter
    def baseline_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Baseline Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _BaselineState:
    def __init__(__self__, *,
                 baseline_items: Optional[pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]]] = None,
                 baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Baseline resources.
        :param pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]] baseline_items: List of baseline items.
               
               You can invoke [ListAccountFactoryBaselineItems](https://next.api.aliyun.com/document/governance/2021-01-20/ListAccountFactoryBaselineItems) to get a list of account factory baseline items supported by the Cloud Governance Center. See `baseline_items` below.
        :param pulumi.Input[_builtins.str] baseline_name: Baseline Name.
        :param pulumi.Input[_builtins.str] description: Baseline Description.
        """
        if baseline_items is not None:
            pulumi.set(__self__, "baseline_items", baseline_items)
        if baseline_name is not None:
            pulumi.set(__self__, "baseline_name", baseline_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="baselineItems")
    def baseline_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]]]:
        """
        List of baseline items.

        You can invoke [ListAccountFactoryBaselineItems](https://next.api.aliyun.com/document/governance/2021-01-20/ListAccountFactoryBaselineItems) to get a list of account factory baseline items supported by the Cloud Governance Center. See `baseline_items` below.
        """
        return pulumi.get(self, "baseline_items")

    @baseline_items.setter
    def baseline_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaselineBaselineItemArgs']]]]):
        pulumi.set(self, "baseline_items", value)

    @_builtins.property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Baseline Name.
        """
        return pulumi.get(self, "baseline_name")

    @baseline_name.setter
    def baseline_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Baseline Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.type_token("alicloud:governance/baseline:Baseline")
class Baseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BaselineBaselineItemArgs', 'BaselineBaselineItemArgsDict']]]]] = None,
                 baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Governance Baseline resource.

        Account Factory Baseline.

        For information about Governance Baseline and how to use it, see [What is Baseline](https://next.api.aliyun.com/document/governance/2021-01-20/CreateAccountFactoryBaseline).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        item_password_policy = config.get("itemPasswordPolicy")
        if item_password_policy is None:
            item_password_policy = "ACS-BP_ACCOUNT_FACTORY_RAM_USER_PASSWORD_POLICY"
        baseline_name_update = config.get("baselineNameUpdate")
        if baseline_name_update is None:
            baseline_name_update = "tf-auto-example-baseline-update"
        item_services = config.get("itemServices")
        if item_services is None:
            item_services = "ACS-BP_ACCOUNT_FACTORY_SUBSCRIBE_SERVICES"
        baseline_name = config.get("baselineName")
        if baseline_name is None:
            baseline_name = "tf-auto-example-baseline"
        item_ram_security = config.get("itemRamSecurity")
        if item_ram_security is None:
            item_ram_security = "ACS-BP_ACCOUNT_FACTORY_RAM_SECURITY_PREFERENCE"
        default_baseline = alicloud.governance.Baseline("default",
            baseline_items=[{
                "version": "1.0",
                "name": item_password_policy,
                "config": json.dumps({
                    "MinimumPasswordLength": 8,
                    "RequireLowercaseCharacters": True,
                    "RequireUppercaseCharacters": True,
                    "RequireNumbers": True,
                    "RequireSymbols": True,
                    "MaxPasswordAge": 0,
                    "HardExpiry": False,
                    "PasswordReusePrevention": 0,
                    "MaxLoginAttempts": 0,
                }),
            }],
            description=name,
            baseline_name=f"{name}-{default['result']}")
        ```

        ## Import

        Governance Baseline can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:governance/baseline:Baseline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BaselineBaselineItemArgs', 'BaselineBaselineItemArgsDict']]]] baseline_items: List of baseline items.
               
               You can invoke [ListAccountFactoryBaselineItems](https://next.api.aliyun.com/document/governance/2021-01-20/ListAccountFactoryBaselineItems) to get a list of account factory baseline items supported by the Cloud Governance Center. See `baseline_items` below.
        :param pulumi.Input[_builtins.str] baseline_name: Baseline Name.
        :param pulumi.Input[_builtins.str] description: Baseline Description.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BaselineArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Governance Baseline resource.

        Account Factory Baseline.

        For information about Governance Baseline and how to use it, see [What is Baseline](https://next.api.aliyun.com/document/governance/2021-01-20/CreateAccountFactoryBaseline).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        item_password_policy = config.get("itemPasswordPolicy")
        if item_password_policy is None:
            item_password_policy = "ACS-BP_ACCOUNT_FACTORY_RAM_USER_PASSWORD_POLICY"
        baseline_name_update = config.get("baselineNameUpdate")
        if baseline_name_update is None:
            baseline_name_update = "tf-auto-example-baseline-update"
        item_services = config.get("itemServices")
        if item_services is None:
            item_services = "ACS-BP_ACCOUNT_FACTORY_SUBSCRIBE_SERVICES"
        baseline_name = config.get("baselineName")
        if baseline_name is None:
            baseline_name = "tf-auto-example-baseline"
        item_ram_security = config.get("itemRamSecurity")
        if item_ram_security is None:
            item_ram_security = "ACS-BP_ACCOUNT_FACTORY_RAM_SECURITY_PREFERENCE"
        default_baseline = alicloud.governance.Baseline("default",
            baseline_items=[{
                "version": "1.0",
                "name": item_password_policy,
                "config": json.dumps({
                    "MinimumPasswordLength": 8,
                    "RequireLowercaseCharacters": True,
                    "RequireUppercaseCharacters": True,
                    "RequireNumbers": True,
                    "RequireSymbols": True,
                    "MaxPasswordAge": 0,
                    "HardExpiry": False,
                    "PasswordReusePrevention": 0,
                    "MaxLoginAttempts": 0,
                }),
            }],
            description=name,
            baseline_name=f"{name}-{default['result']}")
        ```

        ## Import

        Governance Baseline can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:governance/baseline:Baseline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BaselineBaselineItemArgs', 'BaselineBaselineItemArgsDict']]]]] = None,
                 baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaselineArgs.__new__(BaselineArgs)

            __props__.__dict__["baseline_items"] = baseline_items
            __props__.__dict__["baseline_name"] = baseline_name
            __props__.__dict__["description"] = description
        super(Baseline, __self__).__init__(
            'alicloud:governance/baseline:Baseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BaselineBaselineItemArgs', 'BaselineBaselineItemArgsDict']]]]] = None,
            baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None) -> 'Baseline':
        """
        Get an existing Baseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BaselineBaselineItemArgs', 'BaselineBaselineItemArgsDict']]]] baseline_items: List of baseline items.
               
               You can invoke [ListAccountFactoryBaselineItems](https://next.api.aliyun.com/document/governance/2021-01-20/ListAccountFactoryBaselineItems) to get a list of account factory baseline items supported by the Cloud Governance Center. See `baseline_items` below.
        :param pulumi.Input[_builtins.str] baseline_name: Baseline Name.
        :param pulumi.Input[_builtins.str] description: Baseline Description.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaselineState.__new__(_BaselineState)

        __props__.__dict__["baseline_items"] = baseline_items
        __props__.__dict__["baseline_name"] = baseline_name
        __props__.__dict__["description"] = description
        return Baseline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="baselineItems")
    def baseline_items(self) -> pulumi.Output[Optional[Sequence['outputs.BaselineBaselineItem']]]:
        """
        List of baseline items.

        You can invoke [ListAccountFactoryBaselineItems](https://next.api.aliyun.com/document/governance/2021-01-20/ListAccountFactoryBaselineItems) to get a list of account factory baseline items supported by the Cloud Governance Center. See `baseline_items` below.
        """
        return pulumi.get(self, "baseline_items")

    @_builtins.property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Baseline Name.
        """
        return pulumi.get(self, "baseline_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Baseline Description.
        """
        return pulumi.get(self, "description")

