# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 account_password: pulumi.Input[_builtins.str],
                 db_instance_id: pulumi.Input[_builtins.str],
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] account_name: The account name.
        :param pulumi.Input[_builtins.str] account_password: AccountPassword
        :param pulumi.Input[_builtins.str] db_instance_id: The Adb pg instance ID.
        :param pulumi.Input[_builtins.str] account_description: The description of the account.
        :param pulumi.Input[_builtins.str] account_type: Account type. The value range is as follows:
               
               Normal: Normal account number.
               
               Super: a high-privilege account.
        :param pulumi.Input[_builtins.str] database_name: Database name, with the following restrictions:
               - Can only contain letters, numbers and underscores.
               - Must start with a letter.
               - Length cannot exceed 63 characters.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_password", account_password)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Input[_builtins.str]:
        """
        AccountPassword
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Adb pg instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the account.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account type. The value range is as follows:

        Normal: Normal account number.

        Super: a high-privilege account.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database name, with the following restrictions:
        - Can only contain letters, numbers and underscores.
        - Must start with a letter.
        - Length cannot exceed 63 characters.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.str] account_description: The description of the account.
        :param pulumi.Input[_builtins.str] account_name: The account name.
        :param pulumi.Input[_builtins.str] account_password: AccountPassword
        :param pulumi.Input[_builtins.str] account_type: Account type. The value range is as follows:
               
               Normal: Normal account number.
               
               Super: a high-privilege account.
        :param pulumi.Input[_builtins.str] database_name: Database name, with the following restrictions:
               - Can only contain letters, numbers and underscores.
               - Must start with a letter.
               - Length cannot exceed 63 characters.
        :param pulumi.Input[_builtins.str] db_instance_id: The Adb pg instance ID.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the account.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AccountPassword
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account type. The value range is as follows:

        Normal: Normal account number.

        Super: a high-privilege account.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database name, with the following restrictions:
        - Can only contain letters, numbers and underscores.
        - Must start with a letter.
        - Length cannot exceed 63 characters.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Adb pg instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:gpdb/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GPDB Account resource.

        For information about GPDB Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/doc-detail/86924.htm).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.gpdb.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.ids[0])
        default_instance = alicloud.gpdb.Instance("default",
            db_instance_category="HighAvailability",
            db_instance_class="gpdb.group.segsdx1",
            db_instance_mode="StorageElastic",
            description=name,
            engine="gpdb",
            engine_version="6.0",
            zone_id=default.ids[0],
            instance_network_type="VPC",
            instance_spec="2C16G",
            payment_type="PayAsYouGo",
            seg_storage_type="cloud_essd",
            seg_node_num=4,
            storage_size=50,
            vpc_id=default_get_networks.ids[0],
            vswitch_id=default_get_switches.ids[0],
            ip_whitelists=[{
                "security_ip_list": "127.0.0.1",
            }])
        default_account = alicloud.gpdb.Account("default",
            account_name="tf_example",
            db_instance_id=default_instance.id,
            account_password="Example1234",
            account_description="tf_example")
        ```

        ## Import

        GPDB Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/account:Account example <db_instance_id>:<account_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: The description of the account.
        :param pulumi.Input[_builtins.str] account_name: The account name.
        :param pulumi.Input[_builtins.str] account_password: AccountPassword
        :param pulumi.Input[_builtins.str] account_type: Account type. The value range is as follows:
               
               Normal: Normal account number.
               
               Super: a high-privilege account.
        :param pulumi.Input[_builtins.str] database_name: Database name, with the following restrictions:
               - Can only contain letters, numbers and underscores.
               - Must start with a letter.
               - Length cannot exceed 63 characters.
        :param pulumi.Input[_builtins.str] db_instance_id: The Adb pg instance ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB Account resource.

        For information about GPDB Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/doc-detail/86924.htm).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.gpdb.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.ids[0])
        default_instance = alicloud.gpdb.Instance("default",
            db_instance_category="HighAvailability",
            db_instance_class="gpdb.group.segsdx1",
            db_instance_mode="StorageElastic",
            description=name,
            engine="gpdb",
            engine_version="6.0",
            zone_id=default.ids[0],
            instance_network_type="VPC",
            instance_spec="2C16G",
            payment_type="PayAsYouGo",
            seg_storage_type="cloud_essd",
            seg_node_num=4,
            storage_size=50,
            vpc_id=default_get_networks.ids[0],
            vswitch_id=default_get_switches.ids[0],
            ip_whitelists=[{
                "security_ip_list": "127.0.0.1",
            }])
        default_account = alicloud.gpdb.Account("default",
            account_name="tf_example",
            db_instance_id=default_instance.id,
            account_password="Example1234",
            account_description="tf_example")
        ```

        ## Import

        GPDB Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/account:Account example <db_instance_id>:<account_name>
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["account_description"] = account_description
            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if account_password is None and not opts.urn:
                raise TypeError("Missing required property 'account_password'")
            __props__.__dict__["account_password"] = None if account_password is None else pulumi.Output.secret(account_password)
            __props__.__dict__["account_type"] = account_type
            __props__.__dict__["database_name"] = database_name
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'alicloud:gpdb/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_description: Optional[pulumi.Input[_builtins.str]] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            account_password: Optional[pulumi.Input[_builtins.str]] = None,
            account_type: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: The description of the account.
        :param pulumi.Input[_builtins.str] account_name: The account name.
        :param pulumi.Input[_builtins.str] account_password: AccountPassword
        :param pulumi.Input[_builtins.str] account_type: Account type. The value range is as follows:
               
               Normal: Normal account number.
               
               Super: a high-privilege account.
        :param pulumi.Input[_builtins.str] database_name: Database name, with the following restrictions:
               - Can only contain letters, numbers and underscores.
               - Must start with a letter.
               - Length cannot exceed 63 characters.
        :param pulumi.Input[_builtins.str] db_instance_id: The Adb pg instance ID.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["account_description"] = account_description
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["account_type"] = account_type
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["status"] = status
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the account.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[_builtins.str]:
        """
        AccountPassword
        """
        return pulumi.get(self, "account_password")

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[_builtins.str]:
        """
        Account type. The value range is as follows:

        Normal: Normal account number.

        Super: a high-privilege account.
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Database name, with the following restrictions:
        - Can only contain letters, numbers and underscores.
        - Must start with a letter.
        - Length cannot exceed 63 characters.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Adb pg instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

