# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[_builtins.str],
                 db_instance_id: pulumi.Input[_builtins.str],
                 owner: pulumi.Input[_builtins.str],
                 character_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 collate: Optional[pulumi.Input[_builtins.str]] = None,
                 ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[_builtins.str] database_name: Database Name
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID
        :param pulumi.Input[_builtins.str] owner: Data Sheet owner
        :param pulumi.Input[_builtins.str] character_set_name: Character set, default value is UTF8
        :param pulumi.Input[_builtins.str] collate: Database locale parameters, specifying string comparison/collation
        :param pulumi.Input[_builtins.str] ctype: Database locale parameters, specifying character classification/case conversion rules
        :param pulumi.Input[_builtins.str] description: Database Description
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "owner", owner)
        if character_set_name is not None:
            pulumi.set(__self__, "character_set_name", character_set_name)
        if collate is not None:
            pulumi.set(__self__, "collate", collate)
        if ctype is not None:
            pulumi.set(__self__, "ctype", ctype)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        Database Name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Input[_builtins.str]:
        """
        Data Sheet owner
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Character set, default value is UTF8
        """
        return pulumi.get(self, "character_set_name")

    @character_set_name.setter
    def character_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set_name", value)

    @_builtins.property
    @pulumi.getter
    def collate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database locale parameters, specifying string comparison/collation
        """
        return pulumi.get(self, "collate")

    @collate.setter
    def collate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collate", value)

    @_builtins.property
    @pulumi.getter
    def ctype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database locale parameters, specifying character classification/case conversion rules
        """
        return pulumi.get(self, "ctype")

    @ctype.setter
    def ctype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ctype", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 character_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 collate: Optional[pulumi.Input[_builtins.str]] = None,
                 ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[_builtins.str] character_set_name: Character set, default value is UTF8
        :param pulumi.Input[_builtins.str] collate: Database locale parameters, specifying string comparison/collation
        :param pulumi.Input[_builtins.str] ctype: Database locale parameters, specifying character classification/case conversion rules
        :param pulumi.Input[_builtins.str] database_name: Database Name
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID
        :param pulumi.Input[_builtins.str] description: Database Description
        :param pulumi.Input[_builtins.str] owner: Data Sheet owner
        """
        if character_set_name is not None:
            pulumi.set(__self__, "character_set_name", character_set_name)
        if collate is not None:
            pulumi.set(__self__, "collate", collate)
        if ctype is not None:
            pulumi.set(__self__, "ctype", ctype)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)

    @_builtins.property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Character set, default value is UTF8
        """
        return pulumi.get(self, "character_set_name")

    @character_set_name.setter
    def character_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set_name", value)

    @_builtins.property
    @pulumi.getter
    def collate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database locale parameters, specifying string comparison/collation
        """
        return pulumi.get(self, "collate")

    @collate.setter
    def collate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collate", value)

    @_builtins.property
    @pulumi.getter
    def ctype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database locale parameters, specifying character classification/case conversion rules
        """
        return pulumi.get(self, "ctype")

    @ctype.setter
    def ctype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ctype", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database Name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Sheet owner
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)


@pulumi.type_token("alicloud:gpdb/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 collate: Optional[pulumi.Input[_builtins.str]] = None,
                 ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GPDB Database resource.

        For information about GPDB Database and how to use it, see [What is Database](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.232.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default35_okx_y = alicloud.vpc.Network("default35OkxY", cidr_block="192.168.0.0/16")
        defaultl8ha_q3 = alicloud.vpc.Switch("defaultl8haQ3",
            vpc_id=default35_okx_y.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default_tc08a9 = alicloud.gpdb.Instance("defaultTC08a9",
            instance_spec="2C8G",
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            engine="gpdb",
            zone_id="cn-beijing-h",
            vswitch_id=defaultl8ha_q3.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default35_okx_y.id,
            db_instance_mode="StorageElastic")
        default = alicloud.gpdb.Database("default",
            character_set_name="UTF8",
            owner="adbpgadmin",
            description="go-to-the-docks-for-french-fries",
            database_name="seagull",
            collate="en_US.utf8",
            ctype="en_US.utf8",
            db_instance_id=default_tc08a9.id)
        ```

        ## Import

        GPDB Database can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/database:Database example <db_instance_id>:<database_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set_name: Character set, default value is UTF8
        :param pulumi.Input[_builtins.str] collate: Database locale parameters, specifying string comparison/collation
        :param pulumi.Input[_builtins.str] ctype: Database locale parameters, specifying character classification/case conversion rules
        :param pulumi.Input[_builtins.str] database_name: Database Name
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID
        :param pulumi.Input[_builtins.str] description: Database Description
        :param pulumi.Input[_builtins.str] owner: Data Sheet owner
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB Database resource.

        For information about GPDB Database and how to use it, see [What is Database](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.232.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default35_okx_y = alicloud.vpc.Network("default35OkxY", cidr_block="192.168.0.0/16")
        defaultl8ha_q3 = alicloud.vpc.Switch("defaultl8haQ3",
            vpc_id=default35_okx_y.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default_tc08a9 = alicloud.gpdb.Instance("defaultTC08a9",
            instance_spec="2C8G",
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            engine="gpdb",
            zone_id="cn-beijing-h",
            vswitch_id=defaultl8ha_q3.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default35_okx_y.id,
            db_instance_mode="StorageElastic")
        default = alicloud.gpdb.Database("default",
            character_set_name="UTF8",
            owner="adbpgadmin",
            description="go-to-the-docks-for-french-fries",
            database_name="seagull",
            collate="en_US.utf8",
            ctype="en_US.utf8",
            db_instance_id=default_tc08a9.id)
        ```

        ## Import

        GPDB Database can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/database:Database example <db_instance_id>:<database_name>
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 collate: Optional[pulumi.Input[_builtins.str]] = None,
                 ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["character_set_name"] = character_set_name
            __props__.__dict__["collate"] = collate
            __props__.__dict__["ctype"] = ctype
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["description"] = description
            if owner is None and not opts.urn:
                raise TypeError("Missing required property 'owner'")
            __props__.__dict__["owner"] = owner
        super(Database, __self__).__init__(
            'alicloud:gpdb/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set_name: Optional[pulumi.Input[_builtins.str]] = None,
            collate: Optional[pulumi.Input[_builtins.str]] = None,
            ctype: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set_name: Character set, default value is UTF8
        :param pulumi.Input[_builtins.str] collate: Database locale parameters, specifying string comparison/collation
        :param pulumi.Input[_builtins.str] ctype: Database locale parameters, specifying character classification/case conversion rules
        :param pulumi.Input[_builtins.str] database_name: Database Name
        :param pulumi.Input[_builtins.str] db_instance_id: Instance ID
        :param pulumi.Input[_builtins.str] description: Database Description
        :param pulumi.Input[_builtins.str] owner: Data Sheet owner
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["character_set_name"] = character_set_name
        __props__.__dict__["collate"] = collate
        __props__.__dict__["ctype"] = ctype
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["description"] = description
        __props__.__dict__["owner"] = owner
        return Database(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Character set, default value is UTF8
        """
        return pulumi.get(self, "character_set_name")

    @_builtins.property
    @pulumi.getter
    def collate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Database locale parameters, specifying string comparison/collation
        """
        return pulumi.get(self, "collate")

    @_builtins.property
    @pulumi.getter
    def ctype(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Database locale parameters, specifying character classification/case conversion rules
        """
        return pulumi.get(self, "ctype")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        Database Name
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Database Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Data Sheet owner
        """
        return pulumi.get(self, "owner")

