# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HadoopDataSourceArgs', 'HadoopDataSource']

@pulumi.input_type
class HadoopDataSourceArgs:
    def __init__(__self__, *,
                 db_instance_id: pulumi.Input[_builtins.str],
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 emr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_core_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_create_type: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_hosts_address: Optional[pulumi.Input[_builtins.str]] = None,
                 hdfs_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hive_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 map_reduce_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 yarn_conf: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HadoopDataSource resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: The type of the data source. Valid values:
               
               *   mysql
               - postgresql
               
               *   hdfs
               - hive
        :param pulumi.Input[_builtins.str] emr_instance_id: The ID of the Emr instance.
        :param pulumi.Input[_builtins.str] hadoop_core_conf: The string that specifies the content of the Hadoop core-site.xml file.
        :param pulumi.Input[_builtins.str] hadoop_create_type: The type of the external service. Valid values:
               - emr: E-MapReduce (EMR) Hadoop cluster.
               - selfCreate: self-managed Hadoop cluster.
        :param pulumi.Input[_builtins.str] hadoop_hosts_address: The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        :param pulumi.Input[_builtins.str] hdfs_conf: The string that specifies the content of the Hadoop hdfs-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] hive_conf: The string that specifies the content of the Hadoop hive-site.xml file. This parameter must be specified when DataSourceType is set to Hive.
        :param pulumi.Input[_builtins.str] map_reduce_conf: The content of the Hadoop mapred-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] yarn_conf: The string that specifies the content of the Hadoop yarn-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        if data_source_description is not None:
            pulumi.set(__self__, "data_source_description", data_source_description)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if data_source_type is not None:
            pulumi.set(__self__, "data_source_type", data_source_type)
        if emr_instance_id is not None:
            pulumi.set(__self__, "emr_instance_id", emr_instance_id)
        if hadoop_core_conf is not None:
            pulumi.set(__self__, "hadoop_core_conf", hadoop_core_conf)
        if hadoop_create_type is not None:
            pulumi.set(__self__, "hadoop_create_type", hadoop_create_type)
        if hadoop_hosts_address is not None:
            pulumi.set(__self__, "hadoop_hosts_address", hadoop_hosts_address)
        if hdfs_conf is not None:
            pulumi.set(__self__, "hdfs_conf", hdfs_conf)
        if hive_conf is not None:
            pulumi.set(__self__, "hive_conf", hive_conf)
        if map_reduce_conf is not None:
            pulumi.set(__self__, "map_reduce_conf", map_reduce_conf)
        if yarn_conf is not None:
            pulumi.set(__self__, "yarn_conf", yarn_conf)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Description
        """
        return pulumi.get(self, "data_source_description")

    @data_source_description.setter
    def data_source_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_description", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the data source. Valid values:

        *   mysql
        - postgresql

        *   hdfs
        - hive
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="emrInstanceId")
    def emr_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Emr instance.
        """
        return pulumi.get(self, "emr_instance_id")

    @emr_instance_id.setter
    def emr_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "emr_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="hadoopCoreConf")
    def hadoop_core_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop core-site.xml file.
        """
        return pulumi.get(self, "hadoop_core_conf")

    @hadoop_core_conf.setter
    def hadoop_core_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hadoop_core_conf", value)

    @_builtins.property
    @pulumi.getter(name="hadoopCreateType")
    def hadoop_create_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the external service. Valid values:
        - emr: E-MapReduce (EMR) Hadoop cluster.
        - selfCreate: self-managed Hadoop cluster.
        """
        return pulumi.get(self, "hadoop_create_type")

    @hadoop_create_type.setter
    def hadoop_create_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hadoop_create_type", value)

    @_builtins.property
    @pulumi.getter(name="hadoopHostsAddress")
    def hadoop_hosts_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        """
        return pulumi.get(self, "hadoop_hosts_address")

    @hadoop_hosts_address.setter
    def hadoop_hosts_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hadoop_hosts_address", value)

    @_builtins.property
    @pulumi.getter(name="hdfsConf")
    def hdfs_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop hdfs-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "hdfs_conf")

    @hdfs_conf.setter
    def hdfs_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hdfs_conf", value)

    @_builtins.property
    @pulumi.getter(name="hiveConf")
    def hive_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop hive-site.xml file. This parameter must be specified when DataSourceType is set to Hive.
        """
        return pulumi.get(self, "hive_conf")

    @hive_conf.setter
    def hive_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hive_conf", value)

    @_builtins.property
    @pulumi.getter(name="mapReduceConf")
    def map_reduce_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the Hadoop mapred-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "map_reduce_conf")

    @map_reduce_conf.setter
    def map_reduce_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "map_reduce_conf", value)

    @_builtins.property
    @pulumi.getter(name="yarnConf")
    def yarn_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop yarn-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "yarn_conf")

    @yarn_conf.setter
    def yarn_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "yarn_conf", value)


@pulumi.input_type
class _HadoopDataSourceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 emr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_core_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_create_type: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_hosts_address: Optional[pulumi.Input[_builtins.str]] = None,
                 hdfs_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hive_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 map_reduce_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 yarn_conf: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HadoopDataSource resources.
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.int] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: The type of the data source. Valid values:
               
               *   mysql
               - postgresql
               
               *   hdfs
               - hive
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] emr_instance_id: The ID of the Emr instance.
        :param pulumi.Input[_builtins.str] hadoop_core_conf: The string that specifies the content of the Hadoop core-site.xml file.
        :param pulumi.Input[_builtins.str] hadoop_create_type: The type of the external service. Valid values:
               - emr: E-MapReduce (EMR) Hadoop cluster.
               - selfCreate: self-managed Hadoop cluster.
        :param pulumi.Input[_builtins.str] hadoop_hosts_address: The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        :param pulumi.Input[_builtins.str] hdfs_conf: The string that specifies the content of the Hadoop hdfs-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] hive_conf: The string that specifies the content of the Hadoop hive-site.xml file. This parameter must be specified when DataSourceType is set to Hive.
        :param pulumi.Input[_builtins.str] map_reduce_conf: The content of the Hadoop mapred-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] status: Data Source Status
        :param pulumi.Input[_builtins.str] yarn_conf: The string that specifies the content of the Hadoop yarn-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source_description is not None:
            pulumi.set(__self__, "data_source_description", data_source_description)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if data_source_type is not None:
            pulumi.set(__self__, "data_source_type", data_source_type)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if emr_instance_id is not None:
            pulumi.set(__self__, "emr_instance_id", emr_instance_id)
        if hadoop_core_conf is not None:
            pulumi.set(__self__, "hadoop_core_conf", hadoop_core_conf)
        if hadoop_create_type is not None:
            pulumi.set(__self__, "hadoop_create_type", hadoop_create_type)
        if hadoop_hosts_address is not None:
            pulumi.set(__self__, "hadoop_hosts_address", hadoop_hosts_address)
        if hdfs_conf is not None:
            pulumi.set(__self__, "hdfs_conf", hdfs_conf)
        if hive_conf is not None:
            pulumi.set(__self__, "hive_conf", hive_conf)
        if map_reduce_conf is not None:
            pulumi.set(__self__, "map_reduce_conf", map_reduce_conf)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if yarn_conf is not None:
            pulumi.set(__self__, "yarn_conf", yarn_conf)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Description
        """
        return pulumi.get(self, "data_source_description")

    @data_source_description.setter
    def data_source_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_description", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the data source. Valid values:

        *   mysql
        - postgresql

        *   hdfs
        - hive
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="emrInstanceId")
    def emr_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Emr instance.
        """
        return pulumi.get(self, "emr_instance_id")

    @emr_instance_id.setter
    def emr_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "emr_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="hadoopCoreConf")
    def hadoop_core_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop core-site.xml file.
        """
        return pulumi.get(self, "hadoop_core_conf")

    @hadoop_core_conf.setter
    def hadoop_core_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hadoop_core_conf", value)

    @_builtins.property
    @pulumi.getter(name="hadoopCreateType")
    def hadoop_create_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the external service. Valid values:
        - emr: E-MapReduce (EMR) Hadoop cluster.
        - selfCreate: self-managed Hadoop cluster.
        """
        return pulumi.get(self, "hadoop_create_type")

    @hadoop_create_type.setter
    def hadoop_create_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hadoop_create_type", value)

    @_builtins.property
    @pulumi.getter(name="hadoopHostsAddress")
    def hadoop_hosts_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        """
        return pulumi.get(self, "hadoop_hosts_address")

    @hadoop_hosts_address.setter
    def hadoop_hosts_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hadoop_hosts_address", value)

    @_builtins.property
    @pulumi.getter(name="hdfsConf")
    def hdfs_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop hdfs-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "hdfs_conf")

    @hdfs_conf.setter
    def hdfs_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hdfs_conf", value)

    @_builtins.property
    @pulumi.getter(name="hiveConf")
    def hive_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop hive-site.xml file. This parameter must be specified when DataSourceType is set to Hive.
        """
        return pulumi.get(self, "hive_conf")

    @hive_conf.setter
    def hive_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hive_conf", value)

    @_builtins.property
    @pulumi.getter(name="mapReduceConf")
    def map_reduce_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the Hadoop mapred-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "map_reduce_conf")

    @map_reduce_conf.setter
    def map_reduce_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "map_reduce_conf", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="yarnConf")
    def yarn_conf(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop yarn-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "yarn_conf")

    @yarn_conf.setter
    def yarn_conf(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "yarn_conf", value)


@pulumi.type_token("alicloud:gpdb/hadoopDataSource:HadoopDataSource")
class HadoopDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 emr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_core_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_create_type: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_hosts_address: Optional[pulumi.Input[_builtins.str]] = None,
                 hdfs_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hive_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 map_reduce_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 yarn_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GPDB Hadoop Data Source resource.

        Hadoop DataSource Config.

        For information about GPDB Hadoop Data Source and how to use it, see [What is Hadoop Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createhadoopdatasource).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id="cn-beijing-h")
        default_ecs_key_pair = alicloud.ecs.EcsKeyPair("default", key_pair_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_get_networks.ids[0])
        default_role = alicloud.ram.Role("default",
            name=name,
            document=\"\"\"    {
                \\"Statement\\": [
                {
                    \\"Action\\": \\"sts:AssumeRole\\",
                    \\"Effect\\": \\"Allow\\",
                    \\"Principal\\": {
                    \\"Service\\": [
                        \\"emr.aliyuncs.com\\",
                        \\"ecs.aliyuncs.com\\"
                    ]
                    }
                }
                ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            description="this is a role example.",
            force=True)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_keys = alicloud.kms.get_keys(status="Enabled")
        default_cluster = alicloud.emrv2.Cluster("default",
            node_groups=[
                {
                    "vswitch_ids": [default_get_switches.ids[0]],
                    "instance_types": ["ecs.g6.xlarge"],
                    "node_count": 1,
                    "spot_instance_remedy": False,
                    "data_disks": [{
                        "count": 3,
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                    }],
                    "node_group_name": "emr-master",
                    "payment_type": "PayAsYouGo",
                    "with_public_ip": False,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                        "count": 1,
                    },
                    "node_group_type": "MASTER",
                },
                {
                    "spot_instance_remedy": False,
                    "node_group_type": "CORE",
                    "vswitch_ids": [default_get_switches.ids[0]],
                    "node_count": 2,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "performance_level": "PL0",
                        "count": 1,
                        "category": "cloud_essd",
                        "size": 80,
                    },
                    "data_disks": [{
                        "count": 3,
                        "performance_level": "PL0",
                        "category": "cloud_essd",
                        "size": 80,
                    }],
                    "node_group_name": "emr-core",
                    "payment_type": "PayAsYouGo",
                    "instance_types": ["ecs.g6.xlarge"],
                    "with_public_ip": False,
                },
            ],
            deploy_mode="NORMAL",
            tags={
                "Created": "TF",
                "For": "example",
            },
            release_version="EMR-5.10.0",
            applications=[
                "HADOOP-COMMON",
                "HDFS",
                "YARN",
            ],
            node_attributes=[{
                "zone_id": "cn-beijing-h",
                "key_pair_name": default_ecs_key_pair.id,
                "data_disk_encrypted": True,
                "data_disk_kms_key_id": default_get_keys.ids[0],
                "vpc_id": default_get_networks.ids[0],
                "ram_role": default_role.name,
                "security_group_id": default_security_group.id,
            }],
            resource_group_id=default_get_resource_groups.ids[0],
            cluster_name=name,
            payment_type="PayAsYouGo",
            cluster_type="DATAFLOW")
        default_zoepvx = alicloud.gpdb.Instance("defaultZoepvx",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=default_get_switches.ids[0],
            storage_size=50,
            master_cu=4,
            vpc_id=default_get_networks.ids[0],
            db_instance_mode="StorageElastic",
            engine="gpdb",
            db_instance_category="Basic")
        defaulty_oxz1_k = alicloud.gpdb.ExternalDataService("defaultyOxz1K",
            service_name=name,
            db_instance_id=default_zoepvx.id,
            service_description=name,
            service_spec="8")
        default_hadoop_data_source = alicloud.gpdb.HadoopDataSource("default",
            hdfs_conf="aaa",
            data_source_name=defaulty_oxz1_k.service_name,
            yarn_conf="aaa",
            hive_conf="aaa",
            hadoop_create_type="emr",
            data_source_description=name,
            map_reduce_conf="aaa",
            data_source_type="hive",
            hadoop_core_conf="aaa",
            emr_instance_id=default_cluster.id,
            db_instance_id=default_zoepvx.id,
            hadoop_hosts_address="aaa")
        ```

        ## Import

        GPDB Hadoop Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/hadoopDataSource:HadoopDataSource example <db_instance_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: The type of the data source. Valid values:
               
               *   mysql
               - postgresql
               
               *   hdfs
               - hive
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] emr_instance_id: The ID of the Emr instance.
        :param pulumi.Input[_builtins.str] hadoop_core_conf: The string that specifies the content of the Hadoop core-site.xml file.
        :param pulumi.Input[_builtins.str] hadoop_create_type: The type of the external service. Valid values:
               - emr: E-MapReduce (EMR) Hadoop cluster.
               - selfCreate: self-managed Hadoop cluster.
        :param pulumi.Input[_builtins.str] hadoop_hosts_address: The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        :param pulumi.Input[_builtins.str] hdfs_conf: The string that specifies the content of the Hadoop hdfs-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] hive_conf: The string that specifies the content of the Hadoop hive-site.xml file. This parameter must be specified when DataSourceType is set to Hive.
        :param pulumi.Input[_builtins.str] map_reduce_conf: The content of the Hadoop mapred-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] yarn_conf: The string that specifies the content of the Hadoop yarn-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HadoopDataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB Hadoop Data Source resource.

        Hadoop DataSource Config.

        For information about GPDB Hadoop Data Source and how to use it, see [What is Hadoop Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createhadoopdatasource).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id="cn-beijing-h")
        default_ecs_key_pair = alicloud.ecs.EcsKeyPair("default", key_pair_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_get_networks.ids[0])
        default_role = alicloud.ram.Role("default",
            name=name,
            document=\"\"\"    {
                \\"Statement\\": [
                {
                    \\"Action\\": \\"sts:AssumeRole\\",
                    \\"Effect\\": \\"Allow\\",
                    \\"Principal\\": {
                    \\"Service\\": [
                        \\"emr.aliyuncs.com\\",
                        \\"ecs.aliyuncs.com\\"
                    ]
                    }
                }
                ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            description="this is a role example.",
            force=True)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_keys = alicloud.kms.get_keys(status="Enabled")
        default_cluster = alicloud.emrv2.Cluster("default",
            node_groups=[
                {
                    "vswitch_ids": [default_get_switches.ids[0]],
                    "instance_types": ["ecs.g6.xlarge"],
                    "node_count": 1,
                    "spot_instance_remedy": False,
                    "data_disks": [{
                        "count": 3,
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                    }],
                    "node_group_name": "emr-master",
                    "payment_type": "PayAsYouGo",
                    "with_public_ip": False,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                        "count": 1,
                    },
                    "node_group_type": "MASTER",
                },
                {
                    "spot_instance_remedy": False,
                    "node_group_type": "CORE",
                    "vswitch_ids": [default_get_switches.ids[0]],
                    "node_count": 2,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "performance_level": "PL0",
                        "count": 1,
                        "category": "cloud_essd",
                        "size": 80,
                    },
                    "data_disks": [{
                        "count": 3,
                        "performance_level": "PL0",
                        "category": "cloud_essd",
                        "size": 80,
                    }],
                    "node_group_name": "emr-core",
                    "payment_type": "PayAsYouGo",
                    "instance_types": ["ecs.g6.xlarge"],
                    "with_public_ip": False,
                },
            ],
            deploy_mode="NORMAL",
            tags={
                "Created": "TF",
                "For": "example",
            },
            release_version="EMR-5.10.0",
            applications=[
                "HADOOP-COMMON",
                "HDFS",
                "YARN",
            ],
            node_attributes=[{
                "zone_id": "cn-beijing-h",
                "key_pair_name": default_ecs_key_pair.id,
                "data_disk_encrypted": True,
                "data_disk_kms_key_id": default_get_keys.ids[0],
                "vpc_id": default_get_networks.ids[0],
                "ram_role": default_role.name,
                "security_group_id": default_security_group.id,
            }],
            resource_group_id=default_get_resource_groups.ids[0],
            cluster_name=name,
            payment_type="PayAsYouGo",
            cluster_type="DATAFLOW")
        default_zoepvx = alicloud.gpdb.Instance("defaultZoepvx",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=default_get_switches.ids[0],
            storage_size=50,
            master_cu=4,
            vpc_id=default_get_networks.ids[0],
            db_instance_mode="StorageElastic",
            engine="gpdb",
            db_instance_category="Basic")
        defaulty_oxz1_k = alicloud.gpdb.ExternalDataService("defaultyOxz1K",
            service_name=name,
            db_instance_id=default_zoepvx.id,
            service_description=name,
            service_spec="8")
        default_hadoop_data_source = alicloud.gpdb.HadoopDataSource("default",
            hdfs_conf="aaa",
            data_source_name=defaulty_oxz1_k.service_name,
            yarn_conf="aaa",
            hive_conf="aaa",
            hadoop_create_type="emr",
            data_source_description=name,
            map_reduce_conf="aaa",
            data_source_type="hive",
            hadoop_core_conf="aaa",
            emr_instance_id=default_cluster.id,
            db_instance_id=default_zoepvx.id,
            hadoop_hosts_address="aaa")
        ```

        ## Import

        GPDB Hadoop Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/hadoopDataSource:HadoopDataSource example <db_instance_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param HadoopDataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HadoopDataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 emr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_core_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_create_type: Optional[pulumi.Input[_builtins.str]] = None,
                 hadoop_hosts_address: Optional[pulumi.Input[_builtins.str]] = None,
                 hdfs_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 hive_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 map_reduce_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 yarn_conf: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HadoopDataSourceArgs.__new__(HadoopDataSourceArgs)

            __props__.__dict__["data_source_description"] = data_source_description
            __props__.__dict__["data_source_name"] = data_source_name
            __props__.__dict__["data_source_type"] = data_source_type
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["emr_instance_id"] = emr_instance_id
            __props__.__dict__["hadoop_core_conf"] = hadoop_core_conf
            __props__.__dict__["hadoop_create_type"] = hadoop_create_type
            __props__.__dict__["hadoop_hosts_address"] = hadoop_hosts_address
            __props__.__dict__["hdfs_conf"] = hdfs_conf
            __props__.__dict__["hive_conf"] = hive_conf
            __props__.__dict__["map_reduce_conf"] = map_reduce_conf
            __props__.__dict__["yarn_conf"] = yarn_conf
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_source_id"] = None
            __props__.__dict__["status"] = None
        super(HadoopDataSource, __self__).__init__(
            'alicloud:gpdb/hadoopDataSource:HadoopDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
            data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            emr_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            hadoop_core_conf: Optional[pulumi.Input[_builtins.str]] = None,
            hadoop_create_type: Optional[pulumi.Input[_builtins.str]] = None,
            hadoop_hosts_address: Optional[pulumi.Input[_builtins.str]] = None,
            hdfs_conf: Optional[pulumi.Input[_builtins.str]] = None,
            hive_conf: Optional[pulumi.Input[_builtins.str]] = None,
            map_reduce_conf: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            yarn_conf: Optional[pulumi.Input[_builtins.str]] = None) -> 'HadoopDataSource':
        """
        Get an existing HadoopDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.int] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: The type of the data source. Valid values:
               
               *   mysql
               - postgresql
               
               *   hdfs
               - hive
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] emr_instance_id: The ID of the Emr instance.
        :param pulumi.Input[_builtins.str] hadoop_core_conf: The string that specifies the content of the Hadoop core-site.xml file.
        :param pulumi.Input[_builtins.str] hadoop_create_type: The type of the external service. Valid values:
               - emr: E-MapReduce (EMR) Hadoop cluster.
               - selfCreate: self-managed Hadoop cluster.
        :param pulumi.Input[_builtins.str] hadoop_hosts_address: The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        :param pulumi.Input[_builtins.str] hdfs_conf: The string that specifies the content of the Hadoop hdfs-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] hive_conf: The string that specifies the content of the Hadoop hive-site.xml file. This parameter must be specified when DataSourceType is set to Hive.
        :param pulumi.Input[_builtins.str] map_reduce_conf: The content of the Hadoop mapred-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        :param pulumi.Input[_builtins.str] status: Data Source Status
        :param pulumi.Input[_builtins.str] yarn_conf: The string that specifies the content of the Hadoop yarn-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HadoopDataSourceState.__new__(_HadoopDataSourceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source_description"] = data_source_description
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["data_source_name"] = data_source_name
        __props__.__dict__["data_source_type"] = data_source_type
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["emr_instance_id"] = emr_instance_id
        __props__.__dict__["hadoop_core_conf"] = hadoop_core_conf
        __props__.__dict__["hadoop_create_type"] = hadoop_create_type
        __props__.__dict__["hadoop_hosts_address"] = hadoop_hosts_address
        __props__.__dict__["hdfs_conf"] = hdfs_conf
        __props__.__dict__["hive_conf"] = hive_conf
        __props__.__dict__["map_reduce_conf"] = map_reduce_conf
        __props__.__dict__["status"] = status
        __props__.__dict__["yarn_conf"] = yarn_conf
        return HadoopDataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Data Source Description
        """
        return pulumi.get(self, "data_source_description")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.int]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the data source. Valid values:

        *   mysql
        - postgresql

        *   hdfs
        - hive
        """
        return pulumi.get(self, "data_source_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="emrInstanceId")
    def emr_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Emr instance.
        """
        return pulumi.get(self, "emr_instance_id")

    @_builtins.property
    @pulumi.getter(name="hadoopCoreConf")
    def hadoop_core_conf(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop core-site.xml file.
        """
        return pulumi.get(self, "hadoop_core_conf")

    @_builtins.property
    @pulumi.getter(name="hadoopCreateType")
    def hadoop_create_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the external service. Valid values:
        - emr: E-MapReduce (EMR) Hadoop cluster.
        - selfCreate: self-managed Hadoop cluster.
        """
        return pulumi.get(self, "hadoop_create_type")

    @_builtins.property
    @pulumi.getter(name="hadoopHostsAddress")
    def hadoop_hosts_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        """
        return pulumi.get(self, "hadoop_hosts_address")

    @_builtins.property
    @pulumi.getter(name="hdfsConf")
    def hdfs_conf(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop hdfs-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "hdfs_conf")

    @_builtins.property
    @pulumi.getter(name="hiveConf")
    def hive_conf(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop hive-site.xml file. This parameter must be specified when DataSourceType is set to Hive.
        """
        return pulumi.get(self, "hive_conf")

    @_builtins.property
    @pulumi.getter(name="mapReduceConf")
    def map_reduce_conf(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The content of the Hadoop mapred-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "map_reduce_conf")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Data Source Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="yarnConf")
    def yarn_conf(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The string that specifies the content of the Hadoop yarn-site.xml file. This parameter must be specified when DataSourceType is set to HDFS.
        """
        return pulumi.get(self, "yarn_conf")

