# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerGroupArgs', 'ServerGroup']

@pulumi.input_type
class ServerGroupArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 connection_drain_config: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServerGroup resource.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
               
               > **NOTE:**  If `ServerGroupType` is set to `Instance`, only servers in the specified VPC can be added to the server group.
        :param pulumi.Input['ServerGroupConnectionDrainConfigArgs'] connection_drain_config: Connected graceful interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input['ServerGroupHealthCheckConfigArgs'] health_check_config: Health check configurations. See `health_check_config` below.
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               - `GENEVE`(default)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               - `5TCH` (default): specifies consistent hashing that is based on the following factors: source IP address, destination IP address, source port, protocol, and destination port. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `3TCH`: specifies consistent hashing that is based on the following factors: source IP address, destination IP address, and protocol. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `2TCH`: specifies consistent hashing that is based on the following factors: source IP address and destination IP address. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        :param pulumi.Input[_builtins.str] server_group_name: The server group name.
               
               The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to specify servers of the `Ecs`, `Eni`, or `Eci` type.
               - `Ip`: allows you to add servers of by specifying IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]] servers: The backend servers that you want to remove.
               
               > **NOTE:**  You can remove at most 200 backend servers in each call.
               See `servers` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag keys.
               
               You can specify at most 20 tags in each call.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if connection_drain_config is not None:
            pulumi.set(__self__, "connection_drain_config", connection_drain_config)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID.

        > **NOTE:**  If `ServerGroupType` is set to `Instance`, only servers in the specified VPC can be added to the server group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainConfig")
    def connection_drain_config(self) -> Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]:
        """
        Connected graceful interrupt configuration. See `connection_drain_config` below.
        """
        return pulumi.get(self, "connection_drain_config")

    @connection_drain_config.setter
    def connection_drain_config(self, value: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]):
        pulumi.set(self, "connection_drain_config", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]:
        """
        Health check configurations. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend protocol. Valid values:

        - `GENEVE`(default)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheduling algorithm. Valid values:

        - `5TCH` (default): specifies consistent hashing that is based on the following factors: source IP address, destination IP address, source port, protocol, and destination port. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        - `3TCH`: specifies consistent hashing that is based on the following factors: source IP address, destination IP address, and protocol. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        - `2TCH`: specifies consistent hashing that is based on the following factors: source IP address and destination IP address. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server group name.

        The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of server group. Valid values:

        - `Instance` (default): allows you to specify servers of the `Ecs`, `Eni`, or `Eci` type.
        - `Ip`: allows you to add servers of by specifying IP addresses.
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_type", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]:
        """
        The backend servers that you want to remove.

        > **NOTE:**  You can remove at most 200 backend servers in each call.
        See `servers` below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag keys.

        You can specify at most 20 tags in each call.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServerGroupState:
    def __init__(__self__, *,
                 connection_drain_config: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerGroup resources.
        :param pulumi.Input['ServerGroupConnectionDrainConfigArgs'] connection_drain_config: Connected graceful interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.str] create_time: The time when the resource was created. The time follows the ISO 8601 standard in the **yyyy-MM-ddTHH:mm:ssZ** format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input['ServerGroupHealthCheckConfigArgs'] health_check_config: Health check configurations. See `health_check_config` below.
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               - `GENEVE`(default)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               - `5TCH` (default): specifies consistent hashing that is based on the following factors: source IP address, destination IP address, source port, protocol, and destination port. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `3TCH`: specifies consistent hashing that is based on the following factors: source IP address, destination IP address, and protocol. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `2TCH`: specifies consistent hashing that is based on the following factors: source IP address and destination IP address. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        :param pulumi.Input[_builtins.str] server_group_name: The server group name.
               
               The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to specify servers of the `Ecs`, `Eni`, or `Eci` type.
               - `Ip`: allows you to add servers of by specifying IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]] servers: The backend servers that you want to remove.
               
               > **NOTE:**  You can remove at most 200 backend servers in each call.
               See `servers` below.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the backend server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag keys.
               
               You can specify at most 20 tags in each call.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
               
               > **NOTE:**  If `ServerGroupType` is set to `Instance`, only servers in the specified VPC can be added to the server group.
        """
        if connection_drain_config is not None:
            pulumi.set(__self__, "connection_drain_config", connection_drain_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="connectionDrainConfig")
    def connection_drain_config(self) -> Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]:
        """
        Connected graceful interrupt configuration. See `connection_drain_config` below.
        """
        return pulumi.get(self, "connection_drain_config")

    @connection_drain_config.setter
    def connection_drain_config(self, value: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]):
        pulumi.set(self, "connection_drain_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the resource was created. The time follows the ISO 8601 standard in the **yyyy-MM-ddTHH:mm:ssZ** format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]:
        """
        Health check configurations. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend protocol. Valid values:

        - `GENEVE`(default)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheduling algorithm. Valid values:

        - `5TCH` (default): specifies consistent hashing that is based on the following factors: source IP address, destination IP address, source port, protocol, and destination port. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        - `3TCH`: specifies consistent hashing that is based on the following factors: source IP address, destination IP address, and protocol. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        - `2TCH`: specifies consistent hashing that is based on the following factors: source IP address and destination IP address. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server group name.

        The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of server group. Valid values:

        - `Instance` (default): allows you to specify servers of the `Ecs`, `Eni`, or `Eci` type.
        - `Ip`: allows you to add servers of by specifying IP addresses.
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_type", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]:
        """
        The backend servers that you want to remove.

        > **NOTE:**  You can remove at most 200 backend servers in each call.
        See `servers` below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the backend server.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag keys.

        You can specify at most 20 tags in each call.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID.

        > **NOTE:**  If `ServerGroupType` is set to `Instance`, only servers in the specified VPC can be added to the server group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:gwlb/serverGroup:ServerGroup")
class ServerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_drain_config: Optional[pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GWLB Server Group resource.

        For information about GWLB Server Group and how to use it, see [What is Server Group](https://www.alibabacloud.com/help/en/slb/gateway-based-load-balancing-gwlb/developer-reference/api-gwlb-2024-04-15-createservergroup).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-wulanchabu"
        zone_id1 = config.get("zoneId1")
        if zone_id1 is None:
            zone_id1 = "cn-wulanchabu-b"
        default = alicloud.resourcemanager.get_resource_groups()
        default_eaxcvb = alicloud.vpc.Network("defaultEaxcvb",
            cidr_block="10.0.0.0/8",
            vpc_name="tf-gwlb-vpc")
        defaultc3u_vid = alicloud.vpc.Switch("defaultc3uVID",
            vpc_id=default_eaxcvb.id,
            zone_id=zone_id1,
            cidr_block="10.0.0.0/24",
            vswitch_name="tf-example-vsw1")
        default7_n_nx_rl = alicloud.ecs.SecurityGroup("default7NNxRl",
            description="sg",
            security_group_name="sg_name",
            vpc_id=default_eaxcvb.id,
            security_group_type="normal")
        default_h6_mcv_c = alicloud.ecs.Instance("defaultH6McvC",
            vswitch_id=defaultc3u_vid.id,
            image_id="aliyun_2_1903_x64_20G_alibase_20231221.vhd",
            instance_type="ecs.g6.large",
            system_disk_category="cloud_efficiency",
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=5,
            instance_name=std.format(input="%s4",
                args=[name]).result,
            description="tf-example-ecs",
            security_groups=[default7_n_nx_rl.id],
            availability_zone=defaultc3u_vid.zone_id,
            instance_charge_type="PostPaid")
        default_server_group = alicloud.gwlb.ServerGroup("default",
            dry_run=False,
            servers=[{
                "server_id": default_h6_mcv_c.id,
                "server_type": "Ecs",
            }],
            scheduler="5TCH",
            protocol="GENEVE",
            connection_drain_config={
                "connection_drain_enabled": True,
                "connection_drain_timeout": 1,
            },
            vpc_id=default_eaxcvb.id,
            server_group_type="Instance",
            server_group_name=name,
            health_check_config={
                "health_check_connect_port": 80,
                "health_check_enabled": True,
                "health_check_protocol": "HTTP",
                "health_check_connect_timeout": 5,
                "health_check_domain": "www.domain.com",
                "health_check_http_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                "health_check_interval": 10,
                "health_check_path": "/health-check",
                "healthy_threshold": 2,
                "unhealthy_threshold": 2,
            },
            resource_group_id=default.ids[0])
        ```

        ## Import

        GWLB Server Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gwlb/serverGroup:ServerGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']] connection_drain_config: Connected graceful interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']] health_check_config: Health check configurations. See `health_check_config` below.
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               - `GENEVE`(default)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               - `5TCH` (default): specifies consistent hashing that is based on the following factors: source IP address, destination IP address, source port, protocol, and destination port. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `3TCH`: specifies consistent hashing that is based on the following factors: source IP address, destination IP address, and protocol. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `2TCH`: specifies consistent hashing that is based on the following factors: source IP address and destination IP address. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        :param pulumi.Input[_builtins.str] server_group_name: The server group name.
               
               The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to specify servers of the `Ecs`, `Eni`, or `Eci` type.
               - `Ip`: allows you to add servers of by specifying IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]] servers: The backend servers that you want to remove.
               
               > **NOTE:**  You can remove at most 200 backend servers in each call.
               See `servers` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag keys.
               
               You can specify at most 20 tags in each call.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
               
               > **NOTE:**  If `ServerGroupType` is set to `Instance`, only servers in the specified VPC can be added to the server group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GWLB Server Group resource.

        For information about GWLB Server Group and how to use it, see [What is Server Group](https://www.alibabacloud.com/help/en/slb/gateway-based-load-balancing-gwlb/developer-reference/api-gwlb-2024-04-15-createservergroup).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-wulanchabu"
        zone_id1 = config.get("zoneId1")
        if zone_id1 is None:
            zone_id1 = "cn-wulanchabu-b"
        default = alicloud.resourcemanager.get_resource_groups()
        default_eaxcvb = alicloud.vpc.Network("defaultEaxcvb",
            cidr_block="10.0.0.0/8",
            vpc_name="tf-gwlb-vpc")
        defaultc3u_vid = alicloud.vpc.Switch("defaultc3uVID",
            vpc_id=default_eaxcvb.id,
            zone_id=zone_id1,
            cidr_block="10.0.0.0/24",
            vswitch_name="tf-example-vsw1")
        default7_n_nx_rl = alicloud.ecs.SecurityGroup("default7NNxRl",
            description="sg",
            security_group_name="sg_name",
            vpc_id=default_eaxcvb.id,
            security_group_type="normal")
        default_h6_mcv_c = alicloud.ecs.Instance("defaultH6McvC",
            vswitch_id=defaultc3u_vid.id,
            image_id="aliyun_2_1903_x64_20G_alibase_20231221.vhd",
            instance_type="ecs.g6.large",
            system_disk_category="cloud_efficiency",
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=5,
            instance_name=std.format(input="%s4",
                args=[name]).result,
            description="tf-example-ecs",
            security_groups=[default7_n_nx_rl.id],
            availability_zone=defaultc3u_vid.zone_id,
            instance_charge_type="PostPaid")
        default_server_group = alicloud.gwlb.ServerGroup("default",
            dry_run=False,
            servers=[{
                "server_id": default_h6_mcv_c.id,
                "server_type": "Ecs",
            }],
            scheduler="5TCH",
            protocol="GENEVE",
            connection_drain_config={
                "connection_drain_enabled": True,
                "connection_drain_timeout": 1,
            },
            vpc_id=default_eaxcvb.id,
            server_group_type="Instance",
            server_group_name=name,
            health_check_config={
                "health_check_connect_port": 80,
                "health_check_enabled": True,
                "health_check_protocol": "HTTP",
                "health_check_connect_timeout": 5,
                "health_check_domain": "www.domain.com",
                "health_check_http_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                "health_check_interval": 10,
                "health_check_path": "/health-check",
                "healthy_threshold": 2,
                "unhealthy_threshold": 2,
            },
            resource_group_id=default.ids[0])
        ```

        ## Import

        GWLB Server Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gwlb/serverGroup:ServerGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_drain_config: Optional[pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerGroupArgs.__new__(ServerGroupArgs)

            __props__.__dict__["connection_drain_config"] = connection_drain_config
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["health_check_config"] = health_check_config
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scheduler"] = scheduler
            __props__.__dict__["server_group_name"] = server_group_name
            __props__.__dict__["server_group_type"] = server_group_type
            __props__.__dict__["servers"] = servers
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(ServerGroup, __self__).__init__(
            'alicloud:gwlb/serverGroup:ServerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_drain_config: Optional[pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_config: Optional[pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scheduler: Optional[pulumi.Input[_builtins.str]] = None,
            server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerGroup':
        """
        Get an existing ServerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']] connection_drain_config: Connected graceful interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.str] create_time: The time when the resource was created. The time follows the ISO 8601 standard in the **yyyy-MM-ddTHH:mm:ssZ** format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']] health_check_config: Health check configurations. See `health_check_config` below.
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               - `GENEVE`(default)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               - `5TCH` (default): specifies consistent hashing that is based on the following factors: source IP address, destination IP address, source port, protocol, and destination port. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `3TCH`: specifies consistent hashing that is based on the following factors: source IP address, destination IP address, and protocol. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
               - `2TCH`: specifies consistent hashing that is based on the following factors: source IP address and destination IP address. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        :param pulumi.Input[_builtins.str] server_group_name: The server group name.
               
               The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to specify servers of the `Ecs`, `Eni`, or `Eci` type.
               - `Ip`: allows you to add servers of by specifying IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]] servers: The backend servers that you want to remove.
               
               > **NOTE:**  You can remove at most 200 backend servers in each call.
               See `servers` below.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the backend server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag keys.
               
               You can specify at most 20 tags in each call.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
               
               > **NOTE:**  If `ServerGroupType` is set to `Instance`, only servers in the specified VPC can be added to the server group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerGroupState.__new__(_ServerGroupState)

        __props__.__dict__["connection_drain_config"] = connection_drain_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["health_check_config"] = health_check_config
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scheduler"] = scheduler
        __props__.__dict__["server_group_name"] = server_group_name
        __props__.__dict__["server_group_type"] = server_group_type
        __props__.__dict__["servers"] = servers
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return ServerGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionDrainConfig")
    def connection_drain_config(self) -> pulumi.Output['outputs.ServerGroupConnectionDrainConfig']:
        """
        Connected graceful interrupt configuration. See `connection_drain_config` below.
        """
        return pulumi.get(self, "connection_drain_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the resource was created. The time follows the ISO 8601 standard in the **yyyy-MM-ddTHH:mm:ssZ** format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> pulumi.Output['outputs.ServerGroupHealthCheckConfig']:
        """
        Health check configurations. See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The backend protocol. Valid values:

        - `GENEVE`(default)
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> pulumi.Output[_builtins.str]:
        """
        The scheduling algorithm. Valid values:

        - `5TCH` (default): specifies consistent hashing that is based on the following factors: source IP address, destination IP address, source port, protocol, and destination port. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        - `3TCH`: specifies consistent hashing that is based on the following factors: source IP address, destination IP address, and protocol. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        - `2TCH`: specifies consistent hashing that is based on the following factors: source IP address and destination IP address. Requests that contain the same information based on the preceding factors are forwarded to the same backend server.
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The server group name.

        The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "server_group_name")

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of server group. Valid values:

        - `Instance` (default): allows you to specify servers of the `Ecs`, `Eni`, or `Eci` type.
        - `Ip`: allows you to add servers of by specifying IP addresses.
        """
        return pulumi.get(self, "server_group_type")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Optional[Sequence['outputs.ServerGroupServer']]]:
        """
        The backend servers that you want to remove.

        > **NOTE:**  You can remove at most 200 backend servers in each call.
        See `servers` below.
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of the backend server.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag keys.

        You can specify at most 20 tags in each call.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID.

        > **NOTE:**  If `ServerGroupType` is set to `Instance`, only servers in the specified VPC can be added to the server group.
        """
        return pulumi.get(self, "vpc_id")

