# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 core_instance_type: pulumi.Input[_builtins.str],
                 engine_version: pulumi.Input[_builtins.str],
                 master_instance_type: pulumi.Input[_builtins.str],
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 immediate_delete_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] core_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] engine_version: HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
        :param pulumi.Input[_builtins.str] master_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] account: The account of the cluster web ui. Size [0-128].
        :param pulumi.Input[_builtins.bool] auto_renew: Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] cold_storage_size: 0 or [800, 100000000], step:10-GB increments. 0 means is_cold_storage = false. [800, 100000000] means is_cold_storage = true.
        :param pulumi.Input[_builtins.int] core_disk_size: User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
               - Custom storage space, value range: [20, 64000].
               - Cluster [400, 64000], step:40-GB increments.
               - Single [20-500GB], step:1-GB increments.
        :param pulumi.Input[_builtins.str] core_disk_type: Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
        :param pulumi.Input[_builtins.int] core_instance_quantity: Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
        :param pulumi.Input[_builtins.int] duration: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
        :param pulumi.Input[_builtins.str] engine: Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
        :param pulumi.Input[_builtins.bool] immediate_delete_flag: The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
        :param pulumi.Input[_builtins.str] ip_white: The white ip list of the cluster.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
        :param pulumi.Input[_builtins.str] name: HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        :param pulumi.Input[_builtins.str] password: The password of the cluster web ui account. Size [0-128].
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: The security group resource of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        pulumi.set(__self__, "core_instance_type", core_instance_type)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "master_instance_type", master_instance_type)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if cold_storage_size is not None:
            pulumi.set(__self__, "cold_storage_size", cold_storage_size)
        if core_disk_size is not None:
            pulumi.set(__self__, "core_disk_size", core_disk_size)
        if core_disk_type is not None:
            pulumi.set(__self__, "core_disk_type", core_disk_type)
        if core_instance_quantity is not None:
            pulumi.set(__self__, "core_instance_quantity", core_instance_quantity)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if immediate_delete_flag is not None:
            pulumi.set(__self__, "immediate_delete_flag", immediate_delete_flag)
        if ip_white is not None:
            pulumi.set(__self__, "ip_white", ip_white)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="coreInstanceType")
    def core_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        """
        return pulumi.get(self, "core_instance_type")

    @core_instance_type.setter
    def core_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "core_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceType")
    def master_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        """
        return pulumi.get(self, "master_instance_type")

    @master_instance_type.setter
    def master_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "master_instance_type", value)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account of the cluster web ui. Size [0-128].
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        0 or [800, 100000000], step:10-GB increments. 0 means is_cold_storage = false. [800, 100000000] means is_cold_storage = true.
        """
        return pulumi.get(self, "cold_storage_size")

    @cold_storage_size.setter
    def cold_storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cold_storage_size", value)

    @_builtins.property
    @pulumi.getter(name="coreDiskSize")
    def core_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
        - Custom storage space, value range: [20, 64000].
        - Cluster [400, 64000], step:40-GB increments.
        - Single [20-500GB], step:1-GB increments.
        """
        return pulumi.get(self, "core_disk_size")

    @core_disk_size.setter
    def core_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "core_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="coreDiskType")
    def core_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
        """
        return pulumi.get(self, "core_disk_type")

    @core_disk_type.setter
    def core_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="coreInstanceQuantity")
    def core_instance_quantity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
        """
        return pulumi.get(self, "core_instance_quantity")

    @core_instance_quantity.setter
    def core_instance_quantity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "core_instance_quantity", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="immediateDeleteFlag")
    def immediate_delete_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
        """
        return pulumi.get(self, "immediate_delete_flag")

    @immediate_delete_flag.setter
    def immediate_delete_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immediate_delete_flag", value)

    @_builtins.property
    @pulumi.getter(name="ipWhite")
    def ip_white(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The white ip list of the cluster.
        """
        return pulumi.get(self, "ip_white")

    @ip_white.setter
    def ip_white(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_white", value)

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end_time", value)

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_start_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the cluster web ui account. Size [0-128].
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The security group resource of the cluster.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 core_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 immediate_delete_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 master_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slb_conn_addrs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSlbConnAddrArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ui_proxy_conn_addrs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceUiProxyConnAddrArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zk_conn_addrs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZkConnAddrArgs']]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] account: The account of the cluster web ui. Size [0-128].
        :param pulumi.Input[_builtins.bool] auto_renew: Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] cold_storage_size: 0 or [800, 100000000], step:10-GB increments. 0 means is_cold_storage = false. [800, 100000000] means is_cold_storage = true.
        :param pulumi.Input[_builtins.int] core_disk_size: User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
               - Custom storage space, value range: [20, 64000].
               - Cluster [400, 64000], step:40-GB increments.
               - Single [20-500GB], step:1-GB increments.
        :param pulumi.Input[_builtins.str] core_disk_type: Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
        :param pulumi.Input[_builtins.int] core_instance_quantity: Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
        :param pulumi.Input[_builtins.str] core_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
        :param pulumi.Input[_builtins.int] duration: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
        :param pulumi.Input[_builtins.str] engine: Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
        :param pulumi.Input[_builtins.str] engine_version: HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
        :param pulumi.Input[_builtins.bool] immediate_delete_flag: The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
        :param pulumi.Input[_builtins.str] ip_white: The white ip list of the cluster.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
        :param pulumi.Input[_builtins.int] master_instance_quantity: Count nodes of the master node.
        :param pulumi.Input[_builtins.str] master_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] name: HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        :param pulumi.Input[_builtins.str] password: The password of the cluster web ui account. Size [0-128].
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: The security group resource of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSlbConnAddrArgs']]] slb_conn_addrs: The slb service addresses of the cluster. See `slb_conn_addrs` below.
               
               > **NOTE:** Now only instance name can be change. The others(instance_type, disk_size, core_instance_quantity and so on) will be supported in the furture.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceUiProxyConnAddrArgs']]] ui_proxy_conn_addrs: The Web UI proxy addresses of the cluster. See `ui_proxy_conn_addrs` below.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceZkConnAddrArgs']]] zk_conn_addrs: The zookeeper addresses of the cluster. See `zk_conn_addrs` below.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if cold_storage_size is not None:
            pulumi.set(__self__, "cold_storage_size", cold_storage_size)
        if core_disk_size is not None:
            pulumi.set(__self__, "core_disk_size", core_disk_size)
        if core_disk_type is not None:
            pulumi.set(__self__, "core_disk_type", core_disk_type)
        if core_instance_quantity is not None:
            pulumi.set(__self__, "core_instance_quantity", core_instance_quantity)
        if core_instance_type is not None:
            pulumi.set(__self__, "core_instance_type", core_instance_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if immediate_delete_flag is not None:
            pulumi.set(__self__, "immediate_delete_flag", immediate_delete_flag)
        if ip_white is not None:
            pulumi.set(__self__, "ip_white", ip_white)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if master_instance_quantity is not None:
            pulumi.set(__self__, "master_instance_quantity", master_instance_quantity)
        if master_instance_type is not None:
            pulumi.set(__self__, "master_instance_type", master_instance_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if slb_conn_addrs is not None:
            pulumi.set(__self__, "slb_conn_addrs", slb_conn_addrs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ui_proxy_conn_addrs is not None:
            pulumi.set(__self__, "ui_proxy_conn_addrs", ui_proxy_conn_addrs)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zk_conn_addrs is not None:
            pulumi.set(__self__, "zk_conn_addrs", zk_conn_addrs)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account of the cluster web ui. Size [0-128].
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        0 or [800, 100000000], step:10-GB increments. 0 means is_cold_storage = false. [800, 100000000] means is_cold_storage = true.
        """
        return pulumi.get(self, "cold_storage_size")

    @cold_storage_size.setter
    def cold_storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cold_storage_size", value)

    @_builtins.property
    @pulumi.getter(name="coreDiskSize")
    def core_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
        - Custom storage space, value range: [20, 64000].
        - Cluster [400, 64000], step:40-GB increments.
        - Single [20-500GB], step:1-GB increments.
        """
        return pulumi.get(self, "core_disk_size")

    @core_disk_size.setter
    def core_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "core_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="coreDiskType")
    def core_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
        """
        return pulumi.get(self, "core_disk_type")

    @core_disk_type.setter
    def core_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="coreInstanceQuantity")
    def core_instance_quantity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
        """
        return pulumi.get(self, "core_instance_quantity")

    @core_instance_quantity.setter
    def core_instance_quantity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "core_instance_quantity", value)

    @_builtins.property
    @pulumi.getter(name="coreInstanceType")
    def core_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        """
        return pulumi.get(self, "core_instance_type")

    @core_instance_type.setter
    def core_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="immediateDeleteFlag")
    def immediate_delete_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
        """
        return pulumi.get(self, "immediate_delete_flag")

    @immediate_delete_flag.setter
    def immediate_delete_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immediate_delete_flag", value)

    @_builtins.property
    @pulumi.getter(name="ipWhite")
    def ip_white(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The white ip list of the cluster.
        """
        return pulumi.get(self, "ip_white")

    @ip_white.setter
    def ip_white(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_white", value)

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end_time", value)

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_start_time", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceQuantity")
    def master_instance_quantity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count nodes of the master node.
        """
        return pulumi.get(self, "master_instance_quantity")

    @master_instance_quantity.setter
    def master_instance_quantity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "master_instance_quantity", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceType")
    def master_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        """
        return pulumi.get(self, "master_instance_type")

    @master_instance_type.setter
    def master_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_instance_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the cluster web ui account. Size [0-128].
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The security group resource of the cluster.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="slbConnAddrs")
    def slb_conn_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSlbConnAddrArgs']]]]:
        """
        The slb service addresses of the cluster. See `slb_conn_addrs` below.

        > **NOTE:** Now only instance name can be change. The others(instance_type, disk_size, core_instance_quantity and so on) will be supported in the furture.
        """
        return pulumi.get(self, "slb_conn_addrs")

    @slb_conn_addrs.setter
    def slb_conn_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSlbConnAddrArgs']]]]):
        pulumi.set(self, "slb_conn_addrs", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="uiProxyConnAddrs")
    def ui_proxy_conn_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceUiProxyConnAddrArgs']]]]:
        """
        The Web UI proxy addresses of the cluster. See `ui_proxy_conn_addrs` below.
        """
        return pulumi.get(self, "ui_proxy_conn_addrs")

    @ui_proxy_conn_addrs.setter
    def ui_proxy_conn_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceUiProxyConnAddrArgs']]]]):
        pulumi.set(self, "ui_proxy_conn_addrs", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zkConnAddrs")
    def zk_conn_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZkConnAddrArgs']]]]:
        """
        The zookeeper addresses of the cluster. See `zk_conn_addrs` below.
        """
        return pulumi.get(self, "zk_conn_addrs")

    @zk_conn_addrs.setter
    def zk_conn_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZkConnAddrArgs']]]]):
        pulumi.set(self, "zk_conn_addrs", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:hbase/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 core_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 immediate_delete_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a HBase instance resource supports replica set instances only. The HBase provides stable, reliable, and automatic scalable database services.
        It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
        You can see detail product introduction [here](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/createcluster)

        > **NOTE:** Available since v1.67.0.

        > **NOTE:**  The following regions don't support create Classic network HBase instance.
        [`cn-hangzhou`,`cn-shanghai`,`cn-qingdao`,`cn-beijing`,`cn-shenzhen`,`ap-southeast-1a`,.....]
        The official website mark  more regions. or you can call [DescribeRegions](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/describeregions)

        > **NOTE:**  Create HBase instance or change instance type and storage would cost 15 minutes. Please make full preparation

        ## Example Usage

        ### Create a hbase instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.hbase.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[1].id)
        default_instance = alicloud.hbase.Instance("default",
            name=name,
            zone_id=default.zones[1].id,
            vswitch_id=default_get_switches.ids[0],
            vpc_id=default_get_networks.ids[0],
            engine="hbaseue",
            engine_version="2.0",
            master_instance_type="hbase.sn2.2xlarge",
            core_instance_type="hbase.sn2.2xlarge",
            core_instance_quantity=2,
            core_disk_type="cloud_efficiency",
            core_disk_size=400,
            pay_type="PostPaid",
            cold_storage_size=0,
            deletion_protection=False)
        ```

        this is a example for class netType instance. you can find more detail with the examples/hbase dir.

        ## Import

        HBase can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbase/instance:Instance example hb-wz96815u13k659fvd
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account: The account of the cluster web ui. Size [0-128].
        :param pulumi.Input[_builtins.bool] auto_renew: Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] cold_storage_size: 0 or [800, 100000000], step:10-GB increments. 0 means is_cold_storage = false. [800, 100000000] means is_cold_storage = true.
        :param pulumi.Input[_builtins.int] core_disk_size: User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
               - Custom storage space, value range: [20, 64000].
               - Cluster [400, 64000], step:40-GB increments.
               - Single [20-500GB], step:1-GB increments.
        :param pulumi.Input[_builtins.str] core_disk_type: Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
        :param pulumi.Input[_builtins.int] core_instance_quantity: Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
        :param pulumi.Input[_builtins.str] core_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
        :param pulumi.Input[_builtins.int] duration: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
        :param pulumi.Input[_builtins.str] engine: Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
        :param pulumi.Input[_builtins.str] engine_version: HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
        :param pulumi.Input[_builtins.bool] immediate_delete_flag: The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
        :param pulumi.Input[_builtins.str] ip_white: The white ip list of the cluster.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
        :param pulumi.Input[_builtins.str] master_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] name: HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        :param pulumi.Input[_builtins.str] password: The password of the cluster web ui account. Size [0-128].
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: The security group resource of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a HBase instance resource supports replica set instances only. The HBase provides stable, reliable, and automatic scalable database services.
        It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
        You can see detail product introduction [here](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/createcluster)

        > **NOTE:** Available since v1.67.0.

        > **NOTE:**  The following regions don't support create Classic network HBase instance.
        [`cn-hangzhou`,`cn-shanghai`,`cn-qingdao`,`cn-beijing`,`cn-shenzhen`,`ap-southeast-1a`,.....]
        The official website mark  more regions. or you can call [DescribeRegions](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/describeregions)

        > **NOTE:**  Create HBase instance or change instance type and storage would cost 15 minutes. Please make full preparation

        ## Example Usage

        ### Create a hbase instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.hbase.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[1].id)
        default_instance = alicloud.hbase.Instance("default",
            name=name,
            zone_id=default.zones[1].id,
            vswitch_id=default_get_switches.ids[0],
            vpc_id=default_get_networks.ids[0],
            engine="hbaseue",
            engine_version="2.0",
            master_instance_type="hbase.sn2.2xlarge",
            core_instance_type="hbase.sn2.2xlarge",
            core_instance_quantity=2,
            core_disk_type="cloud_efficiency",
            core_disk_size=400,
            pay_type="PostPaid",
            cold_storage_size=0,
            deletion_protection=False)
        ```

        this is a example for class netType instance. you can find more detail with the examples/hbase dir.

        ## Import

        HBase can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbase/instance:Instance example hb-wz96815u13k659fvd
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 core_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 core_instance_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 core_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 immediate_delete_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["account"] = account
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["cold_storage_size"] = cold_storage_size
            __props__.__dict__["core_disk_size"] = core_disk_size
            __props__.__dict__["core_disk_type"] = core_disk_type
            __props__.__dict__["core_instance_quantity"] = core_instance_quantity
            if core_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'core_instance_type'")
            __props__.__dict__["core_instance_type"] = core_instance_type
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["duration"] = duration
            __props__.__dict__["engine"] = engine
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["immediate_delete_flag"] = immediate_delete_flag
            __props__.__dict__["ip_white"] = ip_white
            __props__.__dict__["maintain_end_time"] = maintain_end_time
            __props__.__dict__["maintain_start_time"] = maintain_start_time
            if master_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'master_instance_type'")
            __props__.__dict__["master_instance_type"] = master_instance_type
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["pay_type"] = pay_type
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["master_instance_quantity"] = None
            __props__.__dict__["slb_conn_addrs"] = None
            __props__.__dict__["ui_proxy_conn_addrs"] = None
            __props__.__dict__["zk_conn_addrs"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:hbase/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            cold_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
            core_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            core_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            core_instance_quantity: Optional[pulumi.Input[_builtins.int]] = None,
            core_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            immediate_delete_flag: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_white: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            master_instance_quantity: Optional[pulumi.Input[_builtins.int]] = None,
            master_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            pay_type: Optional[pulumi.Input[_builtins.str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            slb_conn_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSlbConnAddrArgs', 'InstanceSlbConnAddrArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ui_proxy_conn_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceUiProxyConnAddrArgs', 'InstanceUiProxyConnAddrArgsDict']]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zk_conn_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceZkConnAddrArgs', 'InstanceZkConnAddrArgsDict']]]]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account: The account of the cluster web ui. Size [0-128].
        :param pulumi.Input[_builtins.bool] auto_renew: Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] cold_storage_size: 0 or [800, 100000000], step:10-GB increments. 0 means is_cold_storage = false. [800, 100000000] means is_cold_storage = true.
        :param pulumi.Input[_builtins.int] core_disk_size: User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
               - Custom storage space, value range: [20, 64000].
               - Cluster [400, 64000], step:40-GB increments.
               - Single [20-500GB], step:1-GB increments.
        :param pulumi.Input[_builtins.str] core_disk_type: Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
        :param pulumi.Input[_builtins.int] core_instance_quantity: Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
        :param pulumi.Input[_builtins.str] core_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
        :param pulumi.Input[_builtins.int] duration: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
        :param pulumi.Input[_builtins.str] engine: Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
        :param pulumi.Input[_builtins.str] engine_version: HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
        :param pulumi.Input[_builtins.bool] immediate_delete_flag: The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
        :param pulumi.Input[_builtins.str] ip_white: The white ip list of the cluster.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
        :param pulumi.Input[_builtins.int] master_instance_quantity: Count nodes of the master node.
        :param pulumi.Input[_builtins.str] master_instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] name: HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        :param pulumi.Input[_builtins.str] password: The password of the cluster web ui account. Size [0-128].
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: The security group resource of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceSlbConnAddrArgs', 'InstanceSlbConnAddrArgsDict']]]] slb_conn_addrs: The slb service addresses of the cluster. See `slb_conn_addrs` below.
               
               > **NOTE:** Now only instance name can be change. The others(instance_type, disk_size, core_instance_quantity and so on) will be supported in the furture.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceUiProxyConnAddrArgs', 'InstanceUiProxyConnAddrArgsDict']]]] ui_proxy_conn_addrs: The Web UI proxy addresses of the cluster. See `ui_proxy_conn_addrs` below.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceZkConnAddrArgs', 'InstanceZkConnAddrArgsDict']]]] zk_conn_addrs: The zookeeper addresses of the cluster. See `zk_conn_addrs` below.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["account"] = account
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["cold_storage_size"] = cold_storage_size
        __props__.__dict__["core_disk_size"] = core_disk_size
        __props__.__dict__["core_disk_type"] = core_disk_type
        __props__.__dict__["core_instance_quantity"] = core_instance_quantity
        __props__.__dict__["core_instance_type"] = core_instance_type
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["duration"] = duration
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["immediate_delete_flag"] = immediate_delete_flag
        __props__.__dict__["ip_white"] = ip_white
        __props__.__dict__["maintain_end_time"] = maintain_end_time
        __props__.__dict__["maintain_start_time"] = maintain_start_time
        __props__.__dict__["master_instance_quantity"] = master_instance_quantity
        __props__.__dict__["master_instance_type"] = master_instance_type
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["pay_type"] = pay_type
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["slb_conn_addrs"] = slb_conn_addrs
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ui_proxy_conn_addrs"] = ui_proxy_conn_addrs
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zk_conn_addrs"] = zk_conn_addrs
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The account of the cluster web ui. Size [0-128].
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[_builtins.bool]:
        """
        Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        0 or [800, 100000000], step:10-GB increments. 0 means is_cold_storage = false. [800, 100000000] means is_cold_storage = true.
        """
        return pulumi.get(self, "cold_storage_size")

    @_builtins.property
    @pulumi.getter(name="coreDiskSize")
    def core_disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
        - Custom storage space, value range: [20, 64000].
        - Cluster [400, 64000], step:40-GB increments.
        - Single [20-500GB], step:1-GB increments.
        """
        return pulumi.get(self, "core_disk_size")

    @_builtins.property
    @pulumi.getter(name="coreDiskType")
    def core_disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
        """
        return pulumi.get(self, "core_disk_type")

    @_builtins.property
    @pulumi.getter(name="coreInstanceQuantity")
    def core_instance_quantity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
        """
        return pulumi.get(self, "core_instance_quantity")

    @_builtins.property
    @pulumi.getter(name="coreInstanceType")
    def core_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        """
        return pulumi.get(self, "core_instance_type")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[_builtins.int]:
        """
        1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="immediateDeleteFlag")
    def immediate_delete_flag(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
        """
        return pulumi.get(self, "immediate_delete_flag")

    @_builtins.property
    @pulumi.getter(name="ipWhite")
    def ip_white(self) -> pulumi.Output[_builtins.str]:
        """
        The white ip list of the cluster.
        """
        return pulumi.get(self, "ip_white")

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
        """
        return pulumi.get(self, "maintain_end_time")

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
        """
        return pulumi.get(self, "maintain_start_time")

    @_builtins.property
    @pulumi.getter(name="masterInstanceQuantity")
    def master_instance_quantity(self) -> pulumi.Output[_builtins.int]:
        """
        Count nodes of the master node.
        """
        return pulumi.get(self, "master_instance_quantity")

    @_builtins.property
    @pulumi.getter(name="masterInstanceType")
    def master_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
        """
        return pulumi.get(self, "master_instance_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the cluster web ui account. Size [0-128].
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
        """
        return pulumi.get(self, "pay_type")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The security group resource of the cluster.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="slbConnAddrs")
    def slb_conn_addrs(self) -> pulumi.Output[Sequence['outputs.InstanceSlbConnAddr']]:
        """
        The slb service addresses of the cluster. See `slb_conn_addrs` below.

        > **NOTE:** Now only instance name can be change. The others(instance_type, disk_size, core_instance_quantity and so on) will be supported in the furture.
        """
        return pulumi.get(self, "slb_conn_addrs")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="uiProxyConnAddrs")
    def ui_proxy_conn_addrs(self) -> pulumi.Output[Sequence['outputs.InstanceUiProxyConnAddr']]:
        """
        The Web UI proxy addresses of the cluster. See `ui_proxy_conn_addrs` below.
        """
        return pulumi.get(self, "ui_proxy_conn_addrs")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zkConnAddrs")
    def zk_conn_addrs(self) -> pulumi.Output[Sequence['outputs.InstanceZkConnAddr']]:
        """
        The zookeeper addresses of the cluster. See `zk_conn_addrs` below.
        """
        return pulumi.get(self, "zk_conn_addrs")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        return pulumi.get(self, "zone_id")

