# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EcsBackupPlanArgs', 'EcsBackupPlan']

@pulumi.input_type
class EcsBackupPlanArgs:
    def __init__(__self__, *,
                 backup_type: pulumi.Input[_builtins.str],
                 ecs_backup_plan_name: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 retention: pulumi.Input[_builtins.str],
                 schedule: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 update_paths: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a EcsBackupPlan resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] ecs_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] instance_id: The ID of ECS instance. The ecs backup client must have been installed on the host.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] detail: The detail of the backup plan.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] exclude: Exclude path. String of Json list, up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param pulumi.Input[_builtins.str] include: Include path. String of Json list, up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param pulumi.Input[_builtins.str] options: Windows operating system with application consistency using VSS, e.g: `{\\"UseVSS\\":false}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. e.g. `["/home", "/var"]`. **Note** If `path` is empty, it means that all directories will be backed up.
        :param pulumi.Input[_builtins.str] speed_limit: Flow control. The format is: `{start}|{end}|{bandwidth}`. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        :param pulumi.Input[_builtins.bool] update_paths: Attribute update_paths has been deprecated in v1.139.0+, and you do not need to set it anymore.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "ecs_backup_plan_name", ecs_backup_plan_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "vault_id", vault_id)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if detail is not None:
            pulumi.set(__self__, "detail", detail)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if speed_limit is not None:
            pulumi.set(__self__, "speed_limit", speed_limit)
        if update_paths is not None:
            warnings.warn("""Attribute update_paths has been deprecated in v1.139.0+ and you do not need to set it anymore.""", DeprecationWarning)
            pulumi.log.warn("""update_paths is deprecated: Attribute update_paths has been deprecated in v1.139.0+ and you do not need to set it anymore.""")
        if update_paths is not None:
            pulumi.set(__self__, "update_paths", update_paths)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Input[_builtins.str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="ecsBackupPlanName")
    def ecs_backup_plan_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ecs_backup_plan_name")

    @ecs_backup_plan_name.setter
    def ecs_backup_plan_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ecs_backup_plan_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of ECS instance. The ecs backup client must have been installed on the host.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Input[_builtins.str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[_builtins.str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detail of the backup plan.
        """
        return pulumi.get(self, "detail")

    @detail.setter
    def detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detail", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Exclude path. String of Json list, up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude", value)

    @_builtins.property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Include path. String of Json list, up to 255 characters. e.g. `"[\\"/var\\"]"`
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Windows operating system with application consistency using VSS, e.g: `{\\"UseVSS\\":false}`.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of backup path. e.g. `["/home", "/var"]`. **Note** If `path` is empty, it means that all directories will be backed up.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flow control. The format is: `{start}|{end}|{bandwidth}`. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        """
        return pulumi.get(self, "speed_limit")

    @speed_limit.setter
    def speed_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "speed_limit", value)

    @_builtins.property
    @pulumi.getter(name="updatePaths")
    @_utilities.deprecated("""Attribute update_paths has been deprecated in v1.139.0+ and you do not need to set it anymore.""")
    def update_paths(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Attribute update_paths has been deprecated in v1.139.0+, and you do not need to set it anymore.
        """
        return pulumi.get(self, "update_paths")

    @update_paths.setter
    def update_paths(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_paths", value)


@pulumi.input_type
class _EcsBackupPlanState:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 update_paths: Optional[pulumi.Input[_builtins.bool]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EcsBackupPlan resources.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] detail: The detail of the backup plan.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] ecs_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] exclude: Exclude path. String of Json list, up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param pulumi.Input[_builtins.str] include: Include path. String of Json list, up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param pulumi.Input[_builtins.str] instance_id: The ID of ECS instance. The ecs backup client must have been installed on the host.
        :param pulumi.Input[_builtins.str] options: Windows operating system with application consistency using VSS, e.g: `{\\"UseVSS\\":false}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. e.g. `["/home", "/var"]`. **Note** If `path` is empty, it means that all directories will be backed up.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] speed_limit: Flow control. The format is: `{start}|{end}|{bandwidth}`. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        :param pulumi.Input[_builtins.bool] update_paths: Attribute update_paths has been deprecated in v1.139.0+, and you do not need to set it anymore.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if detail is not None:
            pulumi.set(__self__, "detail", detail)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if ecs_backup_plan_name is not None:
            pulumi.set(__self__, "ecs_backup_plan_name", ecs_backup_plan_name)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if speed_limit is not None:
            pulumi.set(__self__, "speed_limit", speed_limit)
        if update_paths is not None:
            warnings.warn("""Attribute update_paths has been deprecated in v1.139.0+ and you do not need to set it anymore.""", DeprecationWarning)
            pulumi.log.warn("""update_paths is deprecated: Attribute update_paths has been deprecated in v1.139.0+ and you do not need to set it anymore.""")
        if update_paths is not None:
            pulumi.set(__self__, "update_paths", update_paths)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detail of the backup plan.
        """
        return pulumi.get(self, "detail")

    @detail.setter
    def detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detail", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="ecsBackupPlanName")
    def ecs_backup_plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ecs_backup_plan_name")

    @ecs_backup_plan_name.setter
    def ecs_backup_plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecs_backup_plan_name", value)

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Exclude path. String of Json list, up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude", value)

    @_builtins.property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Include path. String of Json list, up to 255 characters. e.g. `"[\\"/var\\"]"`
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of ECS instance. The ecs backup client must have been installed on the host.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Windows operating system with application consistency using VSS, e.g: `{\\"UseVSS\\":false}`.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of backup path. e.g. `["/home", "/var"]`. **Note** If `path` is empty, it means that all directories will be backed up.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flow control. The format is: `{start}|{end}|{bandwidth}`. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        """
        return pulumi.get(self, "speed_limit")

    @speed_limit.setter
    def speed_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "speed_limit", value)

    @_builtins.property
    @pulumi.getter(name="updatePaths")
    @_utilities.deprecated("""Attribute update_paths has been deprecated in v1.139.0+ and you do not need to set it anymore.""")
    def update_paths(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Attribute update_paths has been deprecated in v1.139.0+, and you do not need to set it anymore.
        """
        return pulumi.get(self, "update_paths")

    @update_paths.setter
    def update_paths(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_paths", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("alicloud:hbr/ecsBackupPlan:EcsBackupPlan")
class EcsBackupPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 update_paths: Optional[pulumi.Input[_builtins.bool]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a HBR Ecs Backup Plan resource.

        For information about HBR Ecs Backup Plan and how to use it, see [What is Ecs Backup Plan](https://www.alibabacloud.com/help/doc-detail/186574.htm).

        > **NOTE:** Available since v1.132.0.

        > **NOTE:** Deprecated since v1.249.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.249.0`. Please use new resource hbr.Policy and alicloud_hbr_policy_binding.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        example = alicloud.get_zones(available_resource_creation="Instance")
        example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=example_network.id,
            zone_id=example.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name="terraform-example",
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            image_id=example_get_images.images[0].id,
            instance_type=example_get_instance_types.instance_types[0].id,
            availability_zone=example.zones[0].id,
            security_groups=[example_security_group.id],
            instance_name="terraform-example",
            internet_charge_type="PayByBandwidth",
            vswitch_id=example_switch.id)
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example_vault = alicloud.hbr.Vault("example", vault_name=f"terraform-example-{default['result']}")
        example_ecs_backup_plan = alicloud.hbr.EcsBackupPlan("example",
            ecs_backup_plan_name="terraform-example",
            instance_id=example_instance.id,
            vault_id=example_vault.id,
            retention="1",
            schedule="I|1602673264|PT2H",
            backup_type="COMPLETE",
            speed_limit="0:24:5120",
            paths=[
                "/home",
                "/var",
            ],
            exclude="  [\\\\\\"/home/exclude\\\\\\"]\\n",
            include="  [\\\\\\"/home/include\\\\\\"]\\n")
        ```

        ## Notice

        **About Backup path rules:**
        1. If there is no wildcard `*`, you can enter 8 items of path.
        2. When using wildcard `*`, only one item of path can be input, and wildcards like `/*/*` are supported.
        3. Each item of path only supports absolute paths, for example starting with `/`, `\\`, `C:\\`, `D:\\`.

        **About Restrictions:**
        1. When using `VSS`: multiple paths, UNC paths, wildcards, and excluded files not supported.
        2. When using `UNC`: VSS not supported, wildcards not supported, and files to be excluded are not supported.

        **About include/exclude path rules:**
        1. Supports up to 8 paths, including paths using wildcards `*`.
        2. If the path does not contain `/`, then `*` matches multiple path names or file names, for example `*abc*` will match `/abc/`, `/d/eabcd/`, `/a/abc`; `*.txt` will match all files with an extension `.txt`.
        3. If the path contains `/`, each `*` only matches a single-level path or file name. For example, `/a/*/*/` share will match `/a/b/c/share`, but not `/a/d/share`.
        4. If the path ends with `/`, it means the folder matches. For example, `*tmp/` will match `/a/b/aaatmp/`, `/tmp/` and so on.
        5. The path separator takes Linux system `/` as an example, if it is Windows system, please replace it with `\\`.

        ## Import

        HBR Ecs Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/ecsBackupPlan:EcsBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] detail: The detail of the backup plan.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] ecs_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] exclude: Exclude path. String of Json list, up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param pulumi.Input[_builtins.str] include: Include path. String of Json list, up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param pulumi.Input[_builtins.str] instance_id: The ID of ECS instance. The ecs backup client must have been installed on the host.
        :param pulumi.Input[_builtins.str] options: Windows operating system with application consistency using VSS, e.g: `{\\"UseVSS\\":false}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. e.g. `["/home", "/var"]`. **Note** If `path` is empty, it means that all directories will be backed up.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] speed_limit: Flow control. The format is: `{start}|{end}|{bandwidth}`. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        :param pulumi.Input[_builtins.bool] update_paths: Attribute update_paths has been deprecated in v1.139.0+, and you do not need to set it anymore.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsBackupPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a HBR Ecs Backup Plan resource.

        For information about HBR Ecs Backup Plan and how to use it, see [What is Ecs Backup Plan](https://www.alibabacloud.com/help/doc-detail/186574.htm).

        > **NOTE:** Available since v1.132.0.

        > **NOTE:** Deprecated since v1.249.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.249.0`. Please use new resource hbr.Policy and alicloud_hbr_policy_binding.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        example = alicloud.get_zones(available_resource_creation="Instance")
        example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=example_network.id,
            zone_id=example.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name="terraform-example",
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            image_id=example_get_images.images[0].id,
            instance_type=example_get_instance_types.instance_types[0].id,
            availability_zone=example.zones[0].id,
            security_groups=[example_security_group.id],
            instance_name="terraform-example",
            internet_charge_type="PayByBandwidth",
            vswitch_id=example_switch.id)
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example_vault = alicloud.hbr.Vault("example", vault_name=f"terraform-example-{default['result']}")
        example_ecs_backup_plan = alicloud.hbr.EcsBackupPlan("example",
            ecs_backup_plan_name="terraform-example",
            instance_id=example_instance.id,
            vault_id=example_vault.id,
            retention="1",
            schedule="I|1602673264|PT2H",
            backup_type="COMPLETE",
            speed_limit="0:24:5120",
            paths=[
                "/home",
                "/var",
            ],
            exclude="  [\\\\\\"/home/exclude\\\\\\"]\\n",
            include="  [\\\\\\"/home/include\\\\\\"]\\n")
        ```

        ## Notice

        **About Backup path rules:**
        1. If there is no wildcard `*`, you can enter 8 items of path.
        2. When using wildcard `*`, only one item of path can be input, and wildcards like `/*/*` are supported.
        3. Each item of path only supports absolute paths, for example starting with `/`, `\\`, `C:\\`, `D:\\`.

        **About Restrictions:**
        1. When using `VSS`: multiple paths, UNC paths, wildcards, and excluded files not supported.
        2. When using `UNC`: VSS not supported, wildcards not supported, and files to be excluded are not supported.

        **About include/exclude path rules:**
        1. Supports up to 8 paths, including paths using wildcards `*`.
        2. If the path does not contain `/`, then `*` matches multiple path names or file names, for example `*abc*` will match `/abc/`, `/d/eabcd/`, `/a/abc`; `*.txt` will match all files with an extension `.txt`.
        3. If the path contains `/`, each `*` only matches a single-level path or file name. For example, `/a/*/*/` share will match `/a/b/c/share`, but not `/a/d/share`.
        4. If the path ends with `/`, it means the folder matches. For example, `*tmp/` will match `/a/b/aaatmp/`, `/tmp/` and so on.
        5. The path separator takes Linux system `/` as an example, if it is Windows system, please replace it with `\\`.

        ## Import

        HBR Ecs Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/ecsBackupPlan:EcsBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcsBackupPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsBackupPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 update_paths: Optional[pulumi.Input[_builtins.bool]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsBackupPlanArgs.__new__(EcsBackupPlanArgs)

            if backup_type is None and not opts.urn:
                raise TypeError("Missing required property 'backup_type'")
            __props__.__dict__["backup_type"] = backup_type
            __props__.__dict__["cross_account_role_name"] = cross_account_role_name
            __props__.__dict__["cross_account_type"] = cross_account_type
            __props__.__dict__["cross_account_user_id"] = cross_account_user_id
            __props__.__dict__["detail"] = detail
            __props__.__dict__["disabled"] = disabled
            if ecs_backup_plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'ecs_backup_plan_name'")
            __props__.__dict__["ecs_backup_plan_name"] = ecs_backup_plan_name
            __props__.__dict__["exclude"] = exclude
            __props__.__dict__["include"] = include
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["options"] = options
            __props__.__dict__["paths"] = paths
            if retention is None and not opts.urn:
                raise TypeError("Missing required property 'retention'")
            __props__.__dict__["retention"] = retention
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["speed_limit"] = speed_limit
            __props__.__dict__["update_paths"] = update_paths
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(EcsBackupPlan, __self__).__init__(
            'alicloud:hbr/ecsBackupPlan:EcsBackupPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
            detail: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ecs_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            exclude: Optional[pulumi.Input[_builtins.str]] = None,
            include: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[_builtins.str]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            retention: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
            update_paths: Optional[pulumi.Input[_builtins.bool]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EcsBackupPlan':
        """
        Get an existing EcsBackupPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.str] detail: The detail of the backup plan.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] ecs_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] exclude: Exclude path. String of Json list, up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param pulumi.Input[_builtins.str] include: Include path. String of Json list, up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param pulumi.Input[_builtins.str] instance_id: The ID of ECS instance. The ecs backup client must have been installed on the host.
        :param pulumi.Input[_builtins.str] options: Windows operating system with application consistency using VSS, e.g: `{\\"UseVSS\\":false}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. e.g. `["/home", "/var"]`. **Note** If `path` is empty, it means that all directories will be backed up.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] speed_limit: Flow control. The format is: `{start}|{end}|{bandwidth}`. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        :param pulumi.Input[_builtins.bool] update_paths: Attribute update_paths has been deprecated in v1.139.0+, and you do not need to set it anymore.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsBackupPlanState.__new__(_EcsBackupPlanState)

        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["cross_account_role_name"] = cross_account_role_name
        __props__.__dict__["cross_account_type"] = cross_account_type
        __props__.__dict__["cross_account_user_id"] = cross_account_user_id
        __props__.__dict__["detail"] = detail
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["ecs_backup_plan_name"] = ecs_backup_plan_name
        __props__.__dict__["exclude"] = exclude
        __props__.__dict__["include"] = include
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["options"] = options
        __props__.__dict__["paths"] = paths
        __props__.__dict__["retention"] = retention
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["speed_limit"] = speed_limit
        __props__.__dict__["update_paths"] = update_paths
        __props__.__dict__["vault_id"] = vault_id
        return EcsBackupPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[_builtins.str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @_builtins.property
    @pulumi.getter
    def detail(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The detail of the backup plan.
        """
        return pulumi.get(self, "detail")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="ecsBackupPlanName")
    def ecs_backup_plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ecs_backup_plan_name")

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Exclude path. String of Json list, up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        """
        return pulumi.get(self, "exclude")

    @_builtins.property
    @pulumi.getter
    def include(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Include path. String of Json list, up to 255 characters. e.g. `"[\\"/var\\"]"`
        """
        return pulumi.get(self, "include")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of ECS instance. The ecs backup client must have been installed on the host.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Windows operating system with application consistency using VSS, e.g: `{\\"UseVSS\\":false}`.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of backup path. e.g. `["/home", "/var"]`. **Note** If `path` is empty, it means that all directories will be backed up.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Output[_builtins.str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[_builtins.str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Flow control. The format is: `{start}|{end}|{bandwidth}`. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        """
        return pulumi.get(self, "speed_limit")

    @_builtins.property
    @pulumi.getter(name="updatePaths")
    @_utilities.deprecated("""Attribute update_paths has been deprecated in v1.139.0+ and you do not need to set it anymore.""")
    def update_paths(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Attribute update_paths has been deprecated in v1.139.0+, and you do not need to set it anymore.
        """
        return pulumi.get(self, "update_paths")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")

