# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHanaBackupClientsResult',
    'AwaitableGetHanaBackupClientsResult',
    'get_hana_backup_clients',
    'get_hana_backup_clients_output',
]

@pulumi.output_type
class GetHanaBackupClientsResult:
    """
    A collection of values returned by getHanaBackupClients.
    """
    def __init__(__self__, client_id=None, cluster_id=None, hana_backup_clients=None, id=None, ids=None, output_file=None, page_number=None, page_size=None, status=None, vault_id=None):
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if hana_backup_clients and not isinstance(hana_backup_clients, list):
            raise TypeError("Expected argument 'hana_backup_clients' to be a list")
        pulumi.set(__self__, "hana_backup_clients", hana_backup_clients)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backup client.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="hanaBackupClients")
    def hana_backup_clients(self) -> Sequence['outputs.GetHanaBackupClientsHanaBackupClientResult']:
        """
        A list of Hana Backup Clients. Each element contains the following attributes:
        """
        return pulumi.get(self, "hana_backup_clients")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the backup client.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetHanaBackupClientsResult(GetHanaBackupClientsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHanaBackupClientsResult(
            client_id=self.client_id,
            cluster_id=self.cluster_id,
            hana_backup_clients=self.hana_backup_clients,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status,
            vault_id=self.vault_id)


def get_hana_backup_clients(client_id: Optional[_builtins.str] = None,
                            cluster_id: Optional[_builtins.str] = None,
                            ids: Optional[Sequence[_builtins.str]] = None,
                            output_file: Optional[_builtins.str] = None,
                            page_number: Optional[_builtins.int] = None,
                            page_size: Optional[_builtins.int] = None,
                            status: Optional[_builtins.str] = None,
                            vault_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHanaBackupClientsResult:
    """
    This data source provides the Hybrid Backup Recovery (HBR) Hana Backup Clients of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.198.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.hbr.get_hana_backup_clients(ids=["example_id"],
        vault_id="your_vault_id")
    pulumi.export("hbrHanaBackupClientsId1", ids.hana_backup_clients[0].id)
    ```


    :param _builtins.str client_id: The ID of the backup client.
    :param _builtins.str cluster_id: The ID of the SAP HANA instance.
    :param Sequence[_builtins.str] ids: A list of Hana Backup Client IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
    :param _builtins.str vault_id: The ID of the backup vault.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:hbr/getHanaBackupClients:getHanaBackupClients', __args__, opts=opts, typ=GetHanaBackupClientsResult).value

    return AwaitableGetHanaBackupClientsResult(
        client_id=pulumi.get(__ret__, 'client_id'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        hana_backup_clients=pulumi.get(__ret__, 'hana_backup_clients'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'),
        vault_id=pulumi.get(__ret__, 'vault_id'))
def get_hana_backup_clients_output(client_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                   page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                   status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHanaBackupClientsResult]:
    """
    This data source provides the Hybrid Backup Recovery (HBR) Hana Backup Clients of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.198.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.hbr.get_hana_backup_clients(ids=["example_id"],
        vault_id="your_vault_id")
    pulumi.export("hbrHanaBackupClientsId1", ids.hana_backup_clients[0].id)
    ```


    :param _builtins.str client_id: The ID of the backup client.
    :param _builtins.str cluster_id: The ID of the SAP HANA instance.
    :param Sequence[_builtins.str] ids: A list of Hana Backup Client IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
    :param _builtins.str vault_id: The ID of the backup vault.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:hbr/getHanaBackupClients:getHanaBackupClients', __args__, opts=opts, typ=GetHanaBackupClientsResult)
    return __ret__.apply(lambda __response__: GetHanaBackupClientsResult(
        client_id=pulumi.get(__response__, 'client_id'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        hana_backup_clients=pulumi.get(__response__, 'hana_backup_clients'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        status=pulumi.get(__response__, 'status'),
        vault_id=pulumi.get(__response__, 'vault_id')))
