# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, id=None, ids=None, instances=None, output_file=None, page_number=None, page_size=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Instance IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        A list of Instance Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            id=self.id,
            ids=self.ids,
            instances=self.instances,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size)


def get_instances(ids: Optional[Sequence[_builtins.str]] = None,
                  output_file: Optional[_builtins.str] = None,
                  page_number: Optional[_builtins.int] = None,
                  page_size: Optional[_builtins.int] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    This data source provides Kms Instance available to the user.[What is Instance](https://www.alibabacloud.com/help/en/)

    > **NOTE:** Available since v1.242.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    current = alicloud.get_account()
    vpc_amp_instance_example = alicloud.vpc.Network("vpc-amp-instance-example",
        cidr_block="172.16.0.0/12",
        vpc_name=name)
    vswitch = alicloud.vpc.Switch("vswitch",
        vpc_id=vpc_amp_instance_example.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    vswitch_j = alicloud.vpc.Switch("vswitch-j",
        vpc_id=vpc_amp_instance_example.id,
        zone_id="cn-hangzhou-j",
        cidr_block="172.16.2.0/24")
    share_vpc = alicloud.vpc.Network("shareVPC",
        cidr_block="172.16.0.0/12",
        vpc_name=std.format(input="%s3",
            args=[name]).result)
    share_vswitch = alicloud.vpc.Switch("shareVswitch",
        vpc_id=share_vpc.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    share__vpc2 = alicloud.vpc.Network("share-VPC2",
        cidr_block="172.16.0.0/12",
        vpc_name=std.format(input="%s5",
            args=[name]).result)
    share_vswitch2 = alicloud.vpc.Switch("share-vswitch2",
        vpc_id=share__vpc2.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    share__vpc3 = alicloud.vpc.Network("share-VPC3",
        cidr_block="172.16.0.0/12",
        vpc_name=std.format(input="%s7",
            args=[name]).result)
    share_vsw3 = alicloud.vpc.Switch("share-vsw3",
        vpc_id=share__vpc3.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    default_instance = alicloud.kms.Instance("default",
        vpc_num=7,
        key_num=1000,
        secret_num=0,
        spec=1000,
        renew_status="ManualRenewal",
        product_version="3",
        renew_period=3,
        vpc_id=vswitch.vpc_id,
        zone_ids=[
            "cn-hangzhou-k",
            "cn-hangzhou-j",
        ],
        vswitch_ids=[vswitch.id],
        bind_vpcs=[
            {
                "vpc_id": share_vswitch.vpc_id,
                "region_id": "cn-hangzhou",
                "vswitch_id": share_vswitch.id,
                "vpc_owner_id": current.id,
            },
            {
                "vpc_id": share_vswitch2.vpc_id,
                "region_id": "cn-hangzhou",
                "vswitch_id": share_vswitch2.id,
                "vpc_owner_id": current.id,
            },
            {
                "vpc_id": share_vsw3.vpc_id,
                "region_id": "cn-hangzhou",
                "vswitch_id": share_vsw3.id,
                "vpc_owner_id": current.id,
            },
        ],
        log="0",
        period=1,
        log_storage=0,
        payment_type="Subscription")
    default = alicloud.kms.get_instances_output(ids=[default_instance.id])
    pulumi.export("alicloudKmsInstanceExampleId", default.instances[0].instance_id)
    ```


    :param Sequence[_builtins.str] ids: A list of Instance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:kms/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instances=pulumi.get(__ret__, 'instances'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'))
def get_instances_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    This data source provides Kms Instance available to the user.[What is Instance](https://www.alibabacloud.com/help/en/)

    > **NOTE:** Available since v1.242.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    current = alicloud.get_account()
    vpc_amp_instance_example = alicloud.vpc.Network("vpc-amp-instance-example",
        cidr_block="172.16.0.0/12",
        vpc_name=name)
    vswitch = alicloud.vpc.Switch("vswitch",
        vpc_id=vpc_amp_instance_example.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    vswitch_j = alicloud.vpc.Switch("vswitch-j",
        vpc_id=vpc_amp_instance_example.id,
        zone_id="cn-hangzhou-j",
        cidr_block="172.16.2.0/24")
    share_vpc = alicloud.vpc.Network("shareVPC",
        cidr_block="172.16.0.0/12",
        vpc_name=std.format(input="%s3",
            args=[name]).result)
    share_vswitch = alicloud.vpc.Switch("shareVswitch",
        vpc_id=share_vpc.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    share__vpc2 = alicloud.vpc.Network("share-VPC2",
        cidr_block="172.16.0.0/12",
        vpc_name=std.format(input="%s5",
            args=[name]).result)
    share_vswitch2 = alicloud.vpc.Switch("share-vswitch2",
        vpc_id=share__vpc2.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    share__vpc3 = alicloud.vpc.Network("share-VPC3",
        cidr_block="172.16.0.0/12",
        vpc_name=std.format(input="%s7",
            args=[name]).result)
    share_vsw3 = alicloud.vpc.Switch("share-vsw3",
        vpc_id=share__vpc3.id,
        zone_id="cn-hangzhou-k",
        cidr_block="172.16.1.0/24")
    default_instance = alicloud.kms.Instance("default",
        vpc_num=7,
        key_num=1000,
        secret_num=0,
        spec=1000,
        renew_status="ManualRenewal",
        product_version="3",
        renew_period=3,
        vpc_id=vswitch.vpc_id,
        zone_ids=[
            "cn-hangzhou-k",
            "cn-hangzhou-j",
        ],
        vswitch_ids=[vswitch.id],
        bind_vpcs=[
            {
                "vpc_id": share_vswitch.vpc_id,
                "region_id": "cn-hangzhou",
                "vswitch_id": share_vswitch.id,
                "vpc_owner_id": current.id,
            },
            {
                "vpc_id": share_vswitch2.vpc_id,
                "region_id": "cn-hangzhou",
                "vswitch_id": share_vswitch2.id,
                "vpc_owner_id": current.id,
            },
            {
                "vpc_id": share_vsw3.vpc_id,
                "region_id": "cn-hangzhou",
                "vswitch_id": share_vsw3.id,
                "vpc_owner_id": current.id,
            },
        ],
        log="0",
        period=1,
        log_storage=0,
        payment_type="Subscription")
    default = alicloud.kms.get_instances_output(ids=[default_instance.id])
    pulumi.export("alicloudKmsInstanceExampleId", default.instances[0].instance_id)
    ```


    :param Sequence[_builtins.str] ids: A list of Instance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:kms/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instances=pulumi.get(__response__, 'instances'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size')))
