# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyArgs', 'Key']

@pulumi.input_type
class KeyArgs:
    def __init__(__self__, *,
                 automatic_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_description: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 key_state: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Key resource.
        :param pulumi.Input[_builtins.str] automatic_rotation: Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] deletion_protection: Specifies whether to enable deletion protection. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] deletion_protection_description: The description of deletion protection. **NOTE:** `deletion_protection_description` takes effect only if `deletion_protection` is set to `Enabled`.
        :param pulumi.Input[_builtins.int] deletion_window_in_days: Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
        :param pulumi.Input[_builtins.str] description: The description of the key.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] is_enabled: Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
               
               > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
               
               > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
               
               > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
        :param pulumi.Input[_builtins.str] key_spec: The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
        :param pulumi.Input[_builtins.str] key_state: Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
        :param pulumi.Input[_builtins.str] key_usage: The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
               - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
               - `SIGN/VERIFY`: Generates or verifies a digital signature.
        :param pulumi.Input[_builtins.str] origin: The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
        :param pulumi.Input[_builtins.int] pending_window_in_days: The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`. **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
        :param pulumi.Input[_builtins.str] policy: The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
        :param pulumi.Input[_builtins.str] protection_level: The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
        :param pulumi.Input[_builtins.str] rotation_interval: The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval. **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
        :param pulumi.Input[_builtins.str] status: The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if automatic_rotation is not None:
            pulumi.set(__self__, "automatic_rotation", automatic_rotation)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deletion_protection_description is not None:
            pulumi.set(__self__, "deletion_protection_description", deletion_protection_description)
        if deletion_window_in_days is not None:
            warnings.warn("""Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.""", DeprecationWarning)
            pulumi.log.warn("""deletion_window_in_days is deprecated: Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.""")
        if deletion_window_in_days is not None:
            pulumi.set(__self__, "deletion_window_in_days", deletion_window_in_days)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if is_enabled is not None:
            warnings.warn("""Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state` instead.""", DeprecationWarning)
            pulumi.log.warn("""is_enabled is deprecated: Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state` instead.""")
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key_spec is not None:
            pulumi.set(__self__, "key_spec", key_spec)
        if key_state is not None:
            warnings.warn("""Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.""", DeprecationWarning)
            pulumi.log.warn("""key_state is deprecated: Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.""")
        if key_state is not None:
            pulumi.set(__self__, "key_state", key_state)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if pending_window_in_days is not None:
            pulumi.set(__self__, "pending_window_in_days", pending_window_in_days)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if protection_level is not None:
            pulumi.set(__self__, "protection_level", protection_level)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="automaticRotation")
    def automatic_rotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "automatic_rotation")

    @automatic_rotation.setter
    def automatic_rotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_rotation", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable deletion protection. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionDescription")
    def deletion_protection_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of deletion protection. **NOTE:** `deletion_protection_description` takes effect only if `deletion_protection` is set to `Enabled`.
        """
        return pulumi.get(self, "deletion_protection_description")

    @deletion_protection_description.setter
    def deletion_protection_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection_description", value)

    @_builtins.property
    @pulumi.getter(name="deletionWindowInDays")
    @_utilities.deprecated("""Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.""")
    def deletion_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
        """
        return pulumi.get(self, "deletion_window_in_days")

    @deletion_window_in_days.setter
    def deletion_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deletion_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    @_utilities.deprecated("""Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state` instead.""")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.

        > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.

        > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.

        > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
        """
        return pulumi.get(self, "key_spec")

    @key_spec.setter
    def key_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_spec", value)

    @_builtins.property
    @pulumi.getter(name="keyState")
    @_utilities.deprecated("""Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.""")
    def key_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
        """
        return pulumi.get(self, "key_state")

    @key_state.setter
    def key_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_state", value)

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
        - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
        - `SIGN/VERIFY`: Generates or verifies a digital signature.
        """
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_usage", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter(name="pendingWindowInDays")
    def pending_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`. **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
        """
        return pulumi.get(self, "pending_window_in_days")

    @pending_window_in_days.setter
    def pending_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pending_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
        """
        return pulumi.get(self, "protection_level")

    @protection_level.setter
    def protection_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_level", value)

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval. **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_interval", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _KeyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_date: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_description: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 key_state: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 last_rotation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 material_expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 next_rotation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_key_version: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Key resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the key.
        :param pulumi.Input[_builtins.str] automatic_rotation: Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] creation_date: The time when the CMK was created.
        :param pulumi.Input[_builtins.str] creator: The creator of the CMK.
        :param pulumi.Input[_builtins.str] delete_date: The time at which the CMK is scheduled for deletion.
        :param pulumi.Input[_builtins.str] deletion_protection: Specifies whether to enable deletion protection. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] deletion_protection_description: The description of deletion protection. **NOTE:** `deletion_protection_description` takes effect only if `deletion_protection` is set to `Enabled`.
        :param pulumi.Input[_builtins.int] deletion_window_in_days: Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
        :param pulumi.Input[_builtins.str] description: The description of the key.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] is_enabled: Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
               
               > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
               
               > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
               
               > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
        :param pulumi.Input[_builtins.str] key_spec: The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
        :param pulumi.Input[_builtins.str] key_state: Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
        :param pulumi.Input[_builtins.str] key_usage: The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
               - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
               - `SIGN/VERIFY`: Generates or verifies a digital signature.
        :param pulumi.Input[_builtins.str] last_rotation_date: The time when the last rotation was performed.
        :param pulumi.Input[_builtins.str] material_expire_time: The time when the key material expires.
        :param pulumi.Input[_builtins.str] next_rotation_date: The time when the next rotation will be performed.
        :param pulumi.Input[_builtins.str] origin: The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
        :param pulumi.Input[_builtins.int] pending_window_in_days: The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`. **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
        :param pulumi.Input[_builtins.str] policy: The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
        :param pulumi.Input[_builtins.str] primary_key_version: The ID of the current primary key version of the symmetric CMK.
        :param pulumi.Input[_builtins.str] protection_level: The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
        :param pulumi.Input[_builtins.str] rotation_interval: The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval. **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
        :param pulumi.Input[_builtins.str] status: The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if automatic_rotation is not None:
            pulumi.set(__self__, "automatic_rotation", automatic_rotation)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if delete_date is not None:
            pulumi.set(__self__, "delete_date", delete_date)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deletion_protection_description is not None:
            pulumi.set(__self__, "deletion_protection_description", deletion_protection_description)
        if deletion_window_in_days is not None:
            warnings.warn("""Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.""", DeprecationWarning)
            pulumi.log.warn("""deletion_window_in_days is deprecated: Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.""")
        if deletion_window_in_days is not None:
            pulumi.set(__self__, "deletion_window_in_days", deletion_window_in_days)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if is_enabled is not None:
            warnings.warn("""Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state` instead.""", DeprecationWarning)
            pulumi.log.warn("""is_enabled is deprecated: Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state` instead.""")
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key_spec is not None:
            pulumi.set(__self__, "key_spec", key_spec)
        if key_state is not None:
            warnings.warn("""Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.""", DeprecationWarning)
            pulumi.log.warn("""key_state is deprecated: Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.""")
        if key_state is not None:
            pulumi.set(__self__, "key_state", key_state)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if last_rotation_date is not None:
            pulumi.set(__self__, "last_rotation_date", last_rotation_date)
        if material_expire_time is not None:
            pulumi.set(__self__, "material_expire_time", material_expire_time)
        if next_rotation_date is not None:
            pulumi.set(__self__, "next_rotation_date", next_rotation_date)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if pending_window_in_days is not None:
            pulumi.set(__self__, "pending_window_in_days", pending_window_in_days)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if primary_key_version is not None:
            pulumi.set(__self__, "primary_key_version", primary_key_version)
        if protection_level is not None:
            pulumi.set(__self__, "protection_level", protection_level)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the key.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="automaticRotation")
    def automatic_rotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "automatic_rotation")

    @automatic_rotation.setter
    def automatic_rotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_rotation", value)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the CMK was created.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator of the CMK.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter(name="deleteDate")
    def delete_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the CMK is scheduled for deletion.
        """
        return pulumi.get(self, "delete_date")

    @delete_date.setter
    def delete_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_date", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable deletion protection. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionDescription")
    def deletion_protection_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of deletion protection. **NOTE:** `deletion_protection_description` takes effect only if `deletion_protection` is set to `Enabled`.
        """
        return pulumi.get(self, "deletion_protection_description")

    @deletion_protection_description.setter
    def deletion_protection_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection_description", value)

    @_builtins.property
    @pulumi.getter(name="deletionWindowInDays")
    @_utilities.deprecated("""Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.""")
    def deletion_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
        """
        return pulumi.get(self, "deletion_window_in_days")

    @deletion_window_in_days.setter
    def deletion_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deletion_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    @_utilities.deprecated("""Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state` instead.""")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.

        > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.

        > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.

        > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
        """
        return pulumi.get(self, "key_spec")

    @key_spec.setter
    def key_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_spec", value)

    @_builtins.property
    @pulumi.getter(name="keyState")
    @_utilities.deprecated("""Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.""")
    def key_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
        """
        return pulumi.get(self, "key_state")

    @key_state.setter
    def key_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_state", value)

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
        - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
        - `SIGN/VERIFY`: Generates or verifies a digital signature.
        """
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_usage", value)

    @_builtins.property
    @pulumi.getter(name="lastRotationDate")
    def last_rotation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the last rotation was performed.
        """
        return pulumi.get(self, "last_rotation_date")

    @last_rotation_date.setter
    def last_rotation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_rotation_date", value)

    @_builtins.property
    @pulumi.getter(name="materialExpireTime")
    def material_expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the key material expires.
        """
        return pulumi.get(self, "material_expire_time")

    @material_expire_time.setter
    def material_expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "material_expire_time", value)

    @_builtins.property
    @pulumi.getter(name="nextRotationDate")
    def next_rotation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the next rotation will be performed.
        """
        return pulumi.get(self, "next_rotation_date")

    @next_rotation_date.setter
    def next_rotation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_rotation_date", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter(name="pendingWindowInDays")
    def pending_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`. **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
        """
        return pulumi.get(self, "pending_window_in_days")

    @pending_window_in_days.setter
    def pending_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pending_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="primaryKeyVersion")
    def primary_key_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the current primary key version of the symmetric CMK.
        """
        return pulumi.get(self, "primary_key_version")

    @primary_key_version.setter
    def primary_key_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_key_version", value)

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
        """
        return pulumi.get(self, "protection_level")

    @protection_level.setter
    def protection_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_level", value)

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval. **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_interval", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:kms/key:Key")
class Key(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_description: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 key_state: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a KMS Key resource.

        For information about KMS Key and how to use it, see [What is Key](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createkey).

        > **NOTE:** Available since v1.85.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.kms.Key("default",
            description="Hello KMS",
            status="Enabled",
            pending_window_in_days=7)
        ```

        ## Import

        KMS Key can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/key:Key example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automatic_rotation: Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] deletion_protection: Specifies whether to enable deletion protection. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] deletion_protection_description: The description of deletion protection. **NOTE:** `deletion_protection_description` takes effect only if `deletion_protection` is set to `Enabled`.
        :param pulumi.Input[_builtins.int] deletion_window_in_days: Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
        :param pulumi.Input[_builtins.str] description: The description of the key.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] is_enabled: Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
               
               > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
               
               > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
               
               > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
        :param pulumi.Input[_builtins.str] key_spec: The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
        :param pulumi.Input[_builtins.str] key_state: Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
        :param pulumi.Input[_builtins.str] key_usage: The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
               - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
               - `SIGN/VERIFY`: Generates or verifies a digital signature.
        :param pulumi.Input[_builtins.str] origin: The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
        :param pulumi.Input[_builtins.int] pending_window_in_days: The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`. **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
        :param pulumi.Input[_builtins.str] policy: The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
        :param pulumi.Input[_builtins.str] protection_level: The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
        :param pulumi.Input[_builtins.str] rotation_interval: The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval. **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
        :param pulumi.Input[_builtins.str] status: The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[KeyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a KMS Key resource.

        For information about KMS Key and how to use it, see [What is Key](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createkey).

        > **NOTE:** Available since v1.85.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.kms.Key("default",
            description="Hello KMS",
            status="Enabled",
            pending_window_in_days=7)
        ```

        ## Import

        KMS Key can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/key:Key example <id>
        ```

        :param str resource_name: The name of the resource.
        :param KeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_description: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 key_state: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyArgs.__new__(KeyArgs)

            __props__.__dict__["automatic_rotation"] = automatic_rotation
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["deletion_protection_description"] = deletion_protection_description
            __props__.__dict__["deletion_window_in_days"] = deletion_window_in_days
            __props__.__dict__["description"] = description
            __props__.__dict__["dkms_instance_id"] = dkms_instance_id
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["key_spec"] = key_spec
            __props__.__dict__["key_state"] = key_state
            __props__.__dict__["key_usage"] = key_usage
            __props__.__dict__["origin"] = origin
            __props__.__dict__["pending_window_in_days"] = pending_window_in_days
            __props__.__dict__["policy"] = policy
            __props__.__dict__["protection_level"] = protection_level
            __props__.__dict__["rotation_interval"] = rotation_interval
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["delete_date"] = None
            __props__.__dict__["last_rotation_date"] = None
            __props__.__dict__["material_expire_time"] = None
            __props__.__dict__["next_rotation_date"] = None
            __props__.__dict__["primary_key_version"] = None
        super(Key, __self__).__init__(
            'alicloud:kms/key:Key',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            automatic_rotation: Optional[pulumi.Input[_builtins.str]] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            delete_date: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection_description: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            key_spec: Optional[pulumi.Input[_builtins.str]] = None,
            key_state: Optional[pulumi.Input[_builtins.str]] = None,
            key_usage: Optional[pulumi.Input[_builtins.str]] = None,
            last_rotation_date: Optional[pulumi.Input[_builtins.str]] = None,
            material_expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            next_rotation_date: Optional[pulumi.Input[_builtins.str]] = None,
            origin: Optional[pulumi.Input[_builtins.str]] = None,
            pending_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            primary_key_version: Optional[pulumi.Input[_builtins.str]] = None,
            protection_level: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Key':
        """
        Get an existing Key resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the key.
        :param pulumi.Input[_builtins.str] automatic_rotation: Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] creation_date: The time when the CMK was created.
        :param pulumi.Input[_builtins.str] creator: The creator of the CMK.
        :param pulumi.Input[_builtins.str] delete_date: The time at which the CMK is scheduled for deletion.
        :param pulumi.Input[_builtins.str] deletion_protection: Specifies whether to enable deletion protection. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        :param pulumi.Input[_builtins.str] deletion_protection_description: The description of deletion protection. **NOTE:** `deletion_protection_description` takes effect only if `deletion_protection` is set to `Enabled`.
        :param pulumi.Input[_builtins.int] deletion_window_in_days: Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
        :param pulumi.Input[_builtins.str] description: The description of the key.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] is_enabled: Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
               
               > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
               
               > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
               
               > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
        :param pulumi.Input[_builtins.str] key_spec: The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
        :param pulumi.Input[_builtins.str] key_state: Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
        :param pulumi.Input[_builtins.str] key_usage: The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
               - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
               - `SIGN/VERIFY`: Generates or verifies a digital signature.
        :param pulumi.Input[_builtins.str] last_rotation_date: The time when the last rotation was performed.
        :param pulumi.Input[_builtins.str] material_expire_time: The time when the key material expires.
        :param pulumi.Input[_builtins.str] next_rotation_date: The time when the next rotation will be performed.
        :param pulumi.Input[_builtins.str] origin: The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
        :param pulumi.Input[_builtins.int] pending_window_in_days: The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`. **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
        :param pulumi.Input[_builtins.str] policy: The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
        :param pulumi.Input[_builtins.str] primary_key_version: The ID of the current primary key version of the symmetric CMK.
        :param pulumi.Input[_builtins.str] protection_level: The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
        :param pulumi.Input[_builtins.str] rotation_interval: The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval. **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
        :param pulumi.Input[_builtins.str] status: The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyState.__new__(_KeyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["automatic_rotation"] = automatic_rotation
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["creator"] = creator
        __props__.__dict__["delete_date"] = delete_date
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["deletion_protection_description"] = deletion_protection_description
        __props__.__dict__["deletion_window_in_days"] = deletion_window_in_days
        __props__.__dict__["description"] = description
        __props__.__dict__["dkms_instance_id"] = dkms_instance_id
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["key_spec"] = key_spec
        __props__.__dict__["key_state"] = key_state
        __props__.__dict__["key_usage"] = key_usage
        __props__.__dict__["last_rotation_date"] = last_rotation_date
        __props__.__dict__["material_expire_time"] = material_expire_time
        __props__.__dict__["next_rotation_date"] = next_rotation_date
        __props__.__dict__["origin"] = origin
        __props__.__dict__["pending_window_in_days"] = pending_window_in_days
        __props__.__dict__["policy"] = policy
        __props__.__dict__["primary_key_version"] = primary_key_version
        __props__.__dict__["protection_level"] = protection_level
        __props__.__dict__["rotation_interval"] = rotation_interval
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Key(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the key.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="automaticRotation")
    def automatic_rotation(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "automatic_rotation")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the CMK was created.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        The creator of the CMK.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="deleteDate")
    def delete_date(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the CMK is scheduled for deletion.
        """
        return pulumi.get(self, "delete_date")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable deletion protection. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionDescription")
    def deletion_protection_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of deletion protection. **NOTE:** `deletion_protection_description` takes effect only if `deletion_protection` is set to `Enabled`.
        """
        return pulumi.get(self, "deletion_protection_description")

    @_builtins.property
    @pulumi.getter(name="deletionWindowInDays")
    @_utilities.deprecated("""Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.""")
    def deletion_window_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
        """
        return pulumi.get(self, "deletion_window_in_days")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    @_utilities.deprecated("""Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state` instead.""")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.

        > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.

        > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.

        > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
        """
        return pulumi.get(self, "key_spec")

    @_builtins.property
    @pulumi.getter(name="keyState")
    @_utilities.deprecated("""Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.""")
    def key_state(self) -> pulumi.Output[_builtins.str]:
        """
        Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
        """
        return pulumi.get(self, "key_state")

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> pulumi.Output[_builtins.str]:
        """
        The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
        - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
        - `SIGN/VERIFY`: Generates or verifies a digital signature.
        """
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="lastRotationDate")
    def last_rotation_date(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the last rotation was performed.
        """
        return pulumi.get(self, "last_rotation_date")

    @_builtins.property
    @pulumi.getter(name="materialExpireTime")
    def material_expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the key material expires.
        """
        return pulumi.get(self, "material_expire_time")

    @_builtins.property
    @pulumi.getter(name="nextRotationDate")
    def next_rotation_date(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the next rotation will be performed.
        """
        return pulumi.get(self, "next_rotation_date")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> pulumi.Output[_builtins.str]:
        """
        The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter(name="pendingWindowInDays")
    def pending_window_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`. **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
        """
        return pulumi.get(self, "pending_window_in_days")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="primaryKeyVersion")
    def primary_key_version(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the current primary key version of the symmetric CMK.
        """
        return pulumi.get(self, "primary_key_version")

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
        """
        return pulumi.get(self, "protection_level")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval. **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
        """
        return pulumi.get(self, "rotation_interval")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

