# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceClassesResult',
    'AwaitableGetInstanceClassesResult',
    'get_instance_classes',
    'get_instance_classes_output',
]

@pulumi.output_type
class GetInstanceClassesResult:
    """
    A collection of values returned by getInstanceClasses.
    """
    def __init__(__self__, architecture=None, classes=None, edition_type=None, engine=None, engine_version=None, id=None, instance_charge_type=None, instance_classes=None, node_type=None, output_file=None, package_type=None, performance_type=None, product_type=None, series_type=None, shard_number=None, sorted_by=None, storage_type=None, zone_id=None):
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if classes and not isinstance(classes, list):
            raise TypeError("Expected argument 'classes' to be a list")
        pulumi.set(__self__, "classes", classes)
        if edition_type and not isinstance(edition_type, str):
            raise TypeError("Expected argument 'edition_type' to be a str")
        pulumi.set(__self__, "edition_type", edition_type)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_charge_type and not isinstance(instance_charge_type, str):
            raise TypeError("Expected argument 'instance_charge_type' to be a str")
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_classes and not isinstance(instance_classes, list):
            raise TypeError("Expected argument 'instance_classes' to be a list")
        pulumi.set(__self__, "instance_classes", instance_classes)
        if node_type and not isinstance(node_type, str):
            raise TypeError("Expected argument 'node_type' to be a str")
        pulumi.set(__self__, "node_type", node_type)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if performance_type and not isinstance(performance_type, str):
            raise TypeError("Expected argument 'performance_type' to be a str")
        pulumi.set(__self__, "performance_type", performance_type)
        if product_type and not isinstance(product_type, str):
            raise TypeError("Expected argument 'product_type' to be a str")
        pulumi.set(__self__, "product_type", product_type)
        if series_type and not isinstance(series_type, str):
            raise TypeError("Expected argument 'series_type' to be a str")
        pulumi.set(__self__, "series_type", series_type)
        if shard_number and not isinstance(shard_number, int):
            raise TypeError("Expected argument 'shard_number' to be a int")
        pulumi.set(__self__, "shard_number", shard_number)
        if sorted_by and not isinstance(sorted_by, str):
            raise TypeError("Expected argument 'sorted_by' to be a str")
        pulumi.set(__self__, "sorted_by", sorted_by)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter
    def classes(self) -> Sequence['outputs.GetInstanceClassesClassResult']:
        """
        A list of KVStore available instance classes when the `sorted_by` is "Price". include:
        """
        return pulumi.get(self, "classes")

    @_builtins.property
    @pulumi.getter(name="editionType")
    def edition_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "edition_type")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceClasses")
    def instance_classes(self) -> Sequence[_builtins.str]:
        """
        A list of KVStore available instance classes.
        """
        return pulumi.get(self, "instance_classes")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="packageType")
    @_utilities.deprecated("""The parameter 'package_type' has been deprecated from 1.68.0.""")
    def package_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="performanceType")
    @_utilities.deprecated("""The parameter 'performance_type' has been deprecated from 1.68.0.""")
    def performance_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "performance_type")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter(name="seriesType")
    def series_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "series_type")

    @_builtins.property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "shard_number")

    @_builtins.property
    @pulumi.getter(name="sortedBy")
    def sorted_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sorted_by")

    @_builtins.property
    @pulumi.getter(name="storageType")
    @_utilities.deprecated("""The parameter 'storage_type' has been deprecated from 1.68.0.""")
    def storage_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        return pulumi.get(self, "zone_id")


class AwaitableGetInstanceClassesResult(GetInstanceClassesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceClassesResult(
            architecture=self.architecture,
            classes=self.classes,
            edition_type=self.edition_type,
            engine=self.engine,
            engine_version=self.engine_version,
            id=self.id,
            instance_charge_type=self.instance_charge_type,
            instance_classes=self.instance_classes,
            node_type=self.node_type,
            output_file=self.output_file,
            package_type=self.package_type,
            performance_type=self.performance_type,
            product_type=self.product_type,
            series_type=self.series_type,
            shard_number=self.shard_number,
            sorted_by=self.sorted_by,
            storage_type=self.storage_type,
            zone_id=self.zone_id)


def get_instance_classes(architecture: Optional[_builtins.str] = None,
                         edition_type: Optional[_builtins.str] = None,
                         engine: Optional[_builtins.str] = None,
                         engine_version: Optional[_builtins.str] = None,
                         instance_charge_type: Optional[_builtins.str] = None,
                         node_type: Optional[_builtins.str] = None,
                         output_file: Optional[_builtins.str] = None,
                         package_type: Optional[_builtins.str] = None,
                         performance_type: Optional[_builtins.str] = None,
                         product_type: Optional[_builtins.str] = None,
                         series_type: Optional[_builtins.str] = None,
                         shard_number: Optional[_builtins.int] = None,
                         sorted_by: Optional[_builtins.str] = None,
                         storage_type: Optional[_builtins.str] = None,
                         zone_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceClassesResult:
    """
    This data source provides the Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance classes resource available info of Alibaba Cloud.

    > **NOTE:** Available since v1.49.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    resources = alicloud.get_zones(available_resource_creation="KVStore")
    resources_get_instance_classes = alicloud.kvstore.get_instance_classes(zone_id=resources.zones[0].id,
        instance_charge_type="PrePaid",
        engine="Redis",
        engine_version="5.0",
        output_file="./classes.txt")
    pulumi.export("firstKvstoreInstanceClass", resources_get_instance_classes.instance_classes)
    ```


    :param _builtins.str architecture: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance system architecture required by the user. Valid values: `standard`, `cluster` and `rwsplit`.
    :param _builtins.str edition_type: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance edition type required by the user. Valid values: `Community` and `Enterprise`.
    :param _builtins.str engine: Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
    :param _builtins.str engine_version: Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/en/redis/developer-reference/api-r-kvstore-2015-01-01-createinstance-redis) `EngineVersion`. Value of Memcache should be empty.
    :param _builtins.str instance_charge_type: Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
    :param _builtins.str node_type: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance node type required by the user. Valid values: `double`, `single`, `readone`, `readthree` and `readfive`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi up`).
    :param _builtins.str package_type: It has been deprecated from 1.68.0.
    :param _builtins.str performance_type: It has been deprecated from 1.68.0.
    :param _builtins.str product_type: The type of the service. Valid values:
           * Local: a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance with a local disk.
           * OnECS: a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance with a standard disk. This type is available only on the Alibaba Cloud China site.
    :param _builtins.str series_type: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance series type required by the user. Valid values: `enhanced_performance_type` and `hybrid_storage`.
    :param _builtins.int shard_number: The number of shard.Valid values: `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`.
    :param _builtins.str storage_type: It has been deprecated from 1.68.0.
    :param _builtins.str zone_id: The Zone to launch the Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance.
    """
    __args__ = dict()
    __args__['architecture'] = architecture
    __args__['editionType'] = edition_type
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['instanceChargeType'] = instance_charge_type
    __args__['nodeType'] = node_type
    __args__['outputFile'] = output_file
    __args__['packageType'] = package_type
    __args__['performanceType'] = performance_type
    __args__['productType'] = product_type
    __args__['seriesType'] = series_type
    __args__['shardNumber'] = shard_number
    __args__['sortedBy'] = sorted_by
    __args__['storageType'] = storage_type
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:kvstore/getInstanceClasses:getInstanceClasses', __args__, opts=opts, typ=GetInstanceClassesResult).value

    return AwaitableGetInstanceClassesResult(
        architecture=pulumi.get(__ret__, 'architecture'),
        classes=pulumi.get(__ret__, 'classes'),
        edition_type=pulumi.get(__ret__, 'edition_type'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        id=pulumi.get(__ret__, 'id'),
        instance_charge_type=pulumi.get(__ret__, 'instance_charge_type'),
        instance_classes=pulumi.get(__ret__, 'instance_classes'),
        node_type=pulumi.get(__ret__, 'node_type'),
        output_file=pulumi.get(__ret__, 'output_file'),
        package_type=pulumi.get(__ret__, 'package_type'),
        performance_type=pulumi.get(__ret__, 'performance_type'),
        product_type=pulumi.get(__ret__, 'product_type'),
        series_type=pulumi.get(__ret__, 'series_type'),
        shard_number=pulumi.get(__ret__, 'shard_number'),
        sorted_by=pulumi.get(__ret__, 'sorted_by'),
        storage_type=pulumi.get(__ret__, 'storage_type'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_instance_classes_output(architecture: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                edition_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                engine: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                engine_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                instance_charge_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                node_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                package_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                performance_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                product_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                series_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                shard_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                sorted_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                storage_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceClassesResult]:
    """
    This data source provides the Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance classes resource available info of Alibaba Cloud.

    > **NOTE:** Available since v1.49.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    resources = alicloud.get_zones(available_resource_creation="KVStore")
    resources_get_instance_classes = alicloud.kvstore.get_instance_classes(zone_id=resources.zones[0].id,
        instance_charge_type="PrePaid",
        engine="Redis",
        engine_version="5.0",
        output_file="./classes.txt")
    pulumi.export("firstKvstoreInstanceClass", resources_get_instance_classes.instance_classes)
    ```


    :param _builtins.str architecture: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance system architecture required by the user. Valid values: `standard`, `cluster` and `rwsplit`.
    :param _builtins.str edition_type: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance edition type required by the user. Valid values: `Community` and `Enterprise`.
    :param _builtins.str engine: Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
    :param _builtins.str engine_version: Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/en/redis/developer-reference/api-r-kvstore-2015-01-01-createinstance-redis) `EngineVersion`. Value of Memcache should be empty.
    :param _builtins.str instance_charge_type: Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
    :param _builtins.str node_type: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance node type required by the user. Valid values: `double`, `single`, `readone`, `readthree` and `readfive`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi up`).
    :param _builtins.str package_type: It has been deprecated from 1.68.0.
    :param _builtins.str performance_type: It has been deprecated from 1.68.0.
    :param _builtins.str product_type: The type of the service. Valid values:
           * Local: a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance with a local disk.
           * OnECS: a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance with a standard disk. This type is available only on the Alibaba Cloud China site.
    :param _builtins.str series_type: The Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance series type required by the user. Valid values: `enhanced_performance_type` and `hybrid_storage`.
    :param _builtins.int shard_number: The number of shard.Valid values: `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`.
    :param _builtins.str storage_type: It has been deprecated from 1.68.0.
    :param _builtins.str zone_id: The Zone to launch the Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance.
    """
    __args__ = dict()
    __args__['architecture'] = architecture
    __args__['editionType'] = edition_type
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['instanceChargeType'] = instance_charge_type
    __args__['nodeType'] = node_type
    __args__['outputFile'] = output_file
    __args__['packageType'] = package_type
    __args__['performanceType'] = performance_type
    __args__['productType'] = product_type
    __args__['seriesType'] = series_type
    __args__['shardNumber'] = shard_number
    __args__['sortedBy'] = sorted_by
    __args__['storageType'] = storage_type
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:kvstore/getInstanceClasses:getInstanceClasses', __args__, opts=opts, typ=GetInstanceClassesResult)
    return __ret__.apply(lambda __response__: GetInstanceClassesResult(
        architecture=pulumi.get(__response__, 'architecture'),
        classes=pulumi.get(__response__, 'classes'),
        edition_type=pulumi.get(__response__, 'edition_type'),
        engine=pulumi.get(__response__, 'engine'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        id=pulumi.get(__response__, 'id'),
        instance_charge_type=pulumi.get(__response__, 'instance_charge_type'),
        instance_classes=pulumi.get(__response__, 'instance_classes'),
        node_type=pulumi.get(__response__, 'node_type'),
        output_file=pulumi.get(__response__, 'output_file'),
        package_type=pulumi.get(__response__, 'package_type'),
        performance_type=pulumi.get(__response__, 'performance_type'),
        product_type=pulumi.get(__response__, 'product_type'),
        series_type=pulumi.get(__response__, 'series_type'),
        shard_number=pulumi.get(__response__, 'shard_number'),
        sorted_by=pulumi.get(__response__, 'sorted_by'),
        storage_type=pulumi.get(__response__, 'storage_type'),
        zone_id=pulumi.get(__response__, 'zone_id')))
