# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceParameterArgs',
    'InstanceParameterArgsDict',
    'InstanceReplicaSetArgs',
    'InstanceReplicaSetArgsDict',
    'PublicNetworkAddressReplicaSetArgs',
    'PublicNetworkAddressReplicaSetArgsDict',
    'ServerlessInstanceSecurityIpGroupArgs',
    'ServerlessInstanceSecurityIpGroupArgsDict',
    'ShardingInstanceConfigServerListArgs',
    'ShardingInstanceConfigServerListArgsDict',
    'ShardingInstanceMongoListArgs',
    'ShardingInstanceMongoListArgsDict',
    'ShardingInstanceShardListArgs',
    'ShardingInstanceShardListArgsDict',
    'ShardingNetworkPrivateAddressNetworkAddressArgs',
    'ShardingNetworkPrivateAddressNetworkAddressArgsDict',
    'ShardingNetworkPublicAddressNetworkAddressArgs',
    'ShardingNetworkPublicAddressNetworkAddressArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceParameterArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the parameter.
        """
        value: pulumi.Input[_builtins.str]
        """
        The value of the parameter.
        """
elif False:
    InstanceParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the parameter.
        :param pulumi.Input[_builtins.str] value: The value of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class InstanceReplicaSetArgsDict(TypedDict):
        connection_domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection address of the node.
        """
        connection_port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection port of the node.
        """
        network_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network type of the instance. Valid values:`Classic`, `VPC`.
        """
        replica_set_role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The role of the node.
        """
        role_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The id of the role.
        """
        vpc_cloud_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        VPC instance ID.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
        """
        vswitch_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
elif False:
    InstanceReplicaSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceReplicaSetArgs:
    def __init__(__self__, *,
                 connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_port: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_set_role: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_cloud_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] connection_domain: The connection address of the node.
        :param pulumi.Input[_builtins.str] connection_port: The connection port of the node.
        :param pulumi.Input[_builtins.str] network_type: The network type of the instance. Valid values:`Classic`, `VPC`.
        :param pulumi.Input[_builtins.str] replica_set_role: The role of the node.
        :param pulumi.Input[_builtins.str] role_id: The id of the role.
        :param pulumi.Input[_builtins.str] vpc_cloud_instance_id: VPC instance ID.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        """
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_port is not None:
            pulumi.set(__self__, "connection_port", connection_port)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if replica_set_role is not None:
            pulumi.set(__self__, "replica_set_role", replica_set_role)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if vpc_cloud_instance_id is not None:
            pulumi.set(__self__, "vpc_cloud_instance_id", vpc_cloud_instance_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection address of the node.
        """
        return pulumi.get(self, "connection_domain")

    @connection_domain.setter
    def connection_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_domain", value)

    @_builtins.property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection port of the node.
        """
        return pulumi.get(self, "connection_port")

    @connection_port.setter
    def connection_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_port", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the instance. Valid values:`Classic`, `VPC`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="replicaSetRole")
    def replica_set_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the node.
        """
        return pulumi.get(self, "replica_set_role")

    @replica_set_role.setter
    def replica_set_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_set_role", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcCloudInstanceId")
    def vpc_cloud_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC instance ID.
        """
        return pulumi.get(self, "vpc_cloud_instance_id")

    @vpc_cloud_instance_id.setter
    def vpc_cloud_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_cloud_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


if not MYPY:
    class PublicNetworkAddressReplicaSetArgsDict(TypedDict):
        connection_domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection address of the node.
        """
        connection_port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection port of the node.
        """
        connection_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection type.
        """
        network_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network type, should be always "Public".
        """
        replica_set_role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The role of the node.
        """
        role_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The id of the role.
        """
elif False:
    PublicNetworkAddressReplicaSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PublicNetworkAddressReplicaSetArgs:
    def __init__(__self__, *,
                 connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_port: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_set_role: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] connection_domain: The connection address of the node.
        :param pulumi.Input[_builtins.str] connection_port: The connection port of the node.
        :param pulumi.Input[_builtins.str] connection_type: The connection type.
        :param pulumi.Input[_builtins.str] network_type: The network type, should be always "Public".
        :param pulumi.Input[_builtins.str] replica_set_role: The role of the node.
        :param pulumi.Input[_builtins.str] role_id: The id of the role.
        """
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_port is not None:
            pulumi.set(__self__, "connection_port", connection_port)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if replica_set_role is not None:
            pulumi.set(__self__, "replica_set_role", replica_set_role)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection address of the node.
        """
        return pulumi.get(self, "connection_domain")

    @connection_domain.setter
    def connection_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_domain", value)

    @_builtins.property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection port of the node.
        """
        return pulumi.get(self, "connection_port")

    @connection_port.setter
    def connection_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_port", value)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection type.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type, should be always "Public".
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="replicaSetRole")
    def replica_set_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the node.
        """
        return pulumi.get(self, "replica_set_role")

    @replica_set_role.setter
    def replica_set_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_set_role", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)


if not MYPY:
    class ServerlessInstanceSecurityIpGroupArgsDict(TypedDict):
        security_ip_group_attribute: NotRequired[pulumi.Input[_builtins.str]]
        """
        The attribute of the IP whitelist. This parameter is empty by default.
        """
        security_ip_group_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the IP whitelist.
        """
        security_ip_list: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP addresses in the whitelist.
        """
elif False:
    ServerlessInstanceSecurityIpGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessInstanceSecurityIpGroupArgs:
    def __init__(__self__, *,
                 security_ip_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_list: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] security_ip_group_attribute: The attribute of the IP whitelist. This parameter is empty by default.
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the IP whitelist.
        :param pulumi.Input[_builtins.str] security_ip_list: The IP addresses in the whitelist.
        """
        if security_ip_group_attribute is not None:
            pulumi.set(__self__, "security_ip_group_attribute", security_ip_group_attribute)
        if security_ip_group_name is not None:
            pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        if security_ip_list is not None:
            pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute of the IP whitelist. This parameter is empty by default.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @security_ip_group_attribute.setter
    def security_ip_group_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_attribute", value)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP whitelist.
        """
        return pulumi.get(self, "security_ip_group_name")

    @security_ip_group_name.setter
    def security_ip_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP addresses in the whitelist.
        """
        return pulumi.get(self, "security_ip_list")

    @security_ip_list.setter
    def security_ip_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_list", value)


if not MYPY:
    class ShardingInstanceConfigServerListArgsDict(TypedDict):
        connect_string: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection address of the Config Server node.
        """
        max_connections: NotRequired[pulumi.Input[_builtins.int]]
        """
        The max connections of the Config Server node.
        """
        max_iops: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum IOPS of the Config Server node.
        """
        node_class: NotRequired[pulumi.Input[_builtins.str]]
        """
        The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
        """
        node_description: NotRequired[pulumi.Input[_builtins.str]]
        """
        The description of the Config Server node.
        """
        node_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Config Server node.
        """
        node_storage: NotRequired[pulumi.Input[_builtins.int]]
        """
        The storage space of the ConfigServer node.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The connection port of the Config Server node.
        """
elif False:
    ShardingInstanceConfigServerListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardingInstanceConfigServerListArgs:
    def __init__(__self__, *,
                 connect_string: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 max_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 node_class: Optional[pulumi.Input[_builtins.str]] = None,
                 node_description: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] connect_string: The connection address of the Config Server node.
        :param pulumi.Input[_builtins.int] max_connections: The max connections of the Config Server node.
        :param pulumi.Input[_builtins.int] max_iops: The maximum IOPS of the Config Server node.
        :param pulumi.Input[_builtins.str] node_class: The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
        :param pulumi.Input[_builtins.str] node_description: The description of the Config Server node.
        :param pulumi.Input[_builtins.str] node_id: The ID of the Config Server node.
        :param pulumi.Input[_builtins.int] node_storage: The storage space of the ConfigServer node.
        :param pulumi.Input[_builtins.int] port: The connection port of the Config Server node.
        """
        if connect_string is not None:
            pulumi.set(__self__, "connect_string", connect_string)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)
        if node_class is not None:
            pulumi.set(__self__, "node_class", node_class)
        if node_description is not None:
            pulumi.set(__self__, "node_description", node_description)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_storage is not None:
            pulumi.set(__self__, "node_storage", node_storage)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection address of the Config Server node.
        """
        return pulumi.get(self, "connect_string")

    @connect_string.setter
    def connect_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_string", value)

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max connections of the Config Server node.
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_connections", value)

    @_builtins.property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum IOPS of the Config Server node.
        """
        return pulumi.get(self, "max_iops")

    @max_iops.setter
    def max_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_iops", value)

    @_builtins.property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
        """
        return pulumi.get(self, "node_class")

    @node_class.setter
    def node_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_class", value)

    @_builtins.property
    @pulumi.getter(name="nodeDescription")
    def node_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Config Server node.
        """
        return pulumi.get(self, "node_description")

    @node_description.setter
    def node_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_description", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Config Server node.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeStorage")
    def node_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage space of the ConfigServer node.
        """
        return pulumi.get(self, "node_storage")

    @node_storage.setter
    def node_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_storage", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The connection port of the Config Server node.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ShardingInstanceMongoListArgsDict(TypedDict):
        node_class: pulumi.Input[_builtins.str]
        """
        The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        connect_string: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection address of the Config Server node.
        """
        node_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Config Server node.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The connection port of the Config Server node.
        """
elif False:
    ShardingInstanceMongoListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardingInstanceMongoListArgs:
    def __init__(__self__, *,
                 node_class: pulumi.Input[_builtins.str],
                 connect_string: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] node_class: The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        :param pulumi.Input[_builtins.str] connect_string: The connection address of the Config Server node.
        :param pulumi.Input[_builtins.str] node_id: The ID of the Config Server node.
        :param pulumi.Input[_builtins.int] port: The connection port of the Config Server node.
        """
        pulumi.set(__self__, "node_class", node_class)
        if connect_string is not None:
            pulumi.set(__self__, "connect_string", connect_string)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        return pulumi.get(self, "node_class")

    @node_class.setter
    def node_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_class", value)

    @_builtins.property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection address of the Config Server node.
        """
        return pulumi.get(self, "connect_string")

    @connect_string.setter
    def connect_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_string", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Config Server node.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The connection port of the Config Server node.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ShardingInstanceShardListArgsDict(TypedDict):
        node_class: pulumi.Input[_builtins.str]
        """
        The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        node_storage: pulumi.Input[_builtins.int]
        """
        The storage space of the shard node.
        - Custom storage space; value range: [10, 1,000]
        - 10-GB increments. Unit: GB.
        """
        node_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Config Server node.
        """
        readonly_replicas: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
        """
elif False:
    ShardingInstanceShardListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardingInstanceShardListArgs:
    def __init__(__self__, *,
                 node_class: pulumi.Input[_builtins.str],
                 node_storage: pulumi.Input[_builtins.int],
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 readonly_replicas: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] node_class: The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        :param pulumi.Input[_builtins.int] node_storage: The storage space of the shard node.
               - Custom storage space; value range: [10, 1,000]
               - 10-GB increments. Unit: GB.
        :param pulumi.Input[_builtins.str] node_id: The ID of the Config Server node.
        :param pulumi.Input[_builtins.int] readonly_replicas: The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
        """
        pulumi.set(__self__, "node_class", node_class)
        pulumi.set(__self__, "node_storage", node_storage)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if readonly_replicas is not None:
            pulumi.set(__self__, "readonly_replicas", readonly_replicas)

    @_builtins.property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        return pulumi.get(self, "node_class")

    @node_class.setter
    def node_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_class", value)

    @_builtins.property
    @pulumi.getter(name="nodeStorage")
    def node_storage(self) -> pulumi.Input[_builtins.int]:
        """
        The storage space of the shard node.
        - Custom storage space; value range: [10, 1,000]
        - 10-GB increments. Unit: GB.
        """
        return pulumi.get(self, "node_storage")

    @node_storage.setter
    def node_storage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_storage", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Config Server node.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="readonlyReplicas")
    def readonly_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
        """
        return pulumi.get(self, "readonly_replicas")

    @readonly_replicas.setter
    def readonly_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "readonly_replicas", value)


if not MYPY:
    class ShardingNetworkPrivateAddressNetworkAddressArgsDict(TypedDict):
        expired_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The remaining duration of the classic network endpoint.
        """
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP address of the instance.
        """
        network_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection string of the instance.
        """
        network_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network type of the instance.
        """
        node_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Shard node or ConfigServer node.
        """
        node_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the node.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The port that is used to connect to the instance.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The role of the node.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the VPC.
        """
        vswitch_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the vSwitch in the VPC.
        """
elif False:
    ShardingNetworkPrivateAddressNetworkAddressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardingNetworkPrivateAddressNetworkAddressArgs:
    def __init__(__self__, *,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expired_time: The remaining duration of the classic network endpoint.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the instance.
        :param pulumi.Input[_builtins.str] network_address: The connection string of the instance.
        :param pulumi.Input[_builtins.str] network_type: The network type of the instance.
        :param pulumi.Input[_builtins.str] node_id: The ID of the Shard node or ConfigServer node.
        :param pulumi.Input[_builtins.str] node_type: The type of the node.
        :param pulumi.Input[_builtins.str] port: The port that is used to connect to the instance.
        :param pulumi.Input[_builtins.str] role: The role of the node.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch in the VPC.
        """
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remaining duration of the classic network endpoint.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string of the instance.
        """
        return pulumi.get(self, "network_address")

    @network_address.setter
    def network_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_address", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the instance.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Shard node or ConfigServer node.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port that is used to connect to the instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch in the VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


if not MYPY:
    class ShardingNetworkPublicAddressNetworkAddressArgsDict(TypedDict):
        expired_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP address of the instance.
        """
        network_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The endpoint of the instance.
        """
        network_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network type.
        """
        node_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        node_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the node.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The port number.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The role of the node.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the VPC.
        """
        vswitch_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The vSwitch ID of the VPC.
        """
elif False:
    ShardingNetworkPublicAddressNetworkAddressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardingNetworkPublicAddressNetworkAddressArgs:
    def __init__(__self__, *,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the instance.
        :param pulumi.Input[_builtins.str] network_address: The endpoint of the instance.
        :param pulumi.Input[_builtins.str] network_type: The network type.
        :param pulumi.Input[_builtins.str] node_id: The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        :param pulumi.Input[_builtins.str] node_type: The type of the node.
        :param pulumi.Input[_builtins.str] port: The port number.
        :param pulumi.Input[_builtins.str] role: The role of the node.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID of the VPC.
        """
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @network_address.setter
    def network_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_address", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


