# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateSrvNetworkAddressArgs', 'PrivateSrvNetworkAddress']

@pulumi.input_type
class PrivateSrvNetworkAddressArgs:
    def __init__(__self__, *,
                 db_instance_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PrivateSrvNetworkAddress resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)


@pulumi.input_type
class _PrivateSrvNetworkAddressState:
    def __init__(__self__, *,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_srv_connection_string_uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateSrvNetworkAddress resources.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] private_srv_connection_string_uri: Private network SRV highly available connection address
        """
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if private_srv_connection_string_uri is not None:
            pulumi.set(__self__, "private_srv_connection_string_uri", private_srv_connection_string_uri)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="privateSrvConnectionStringUri")
    def private_srv_connection_string_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private network SRV highly available connection address
        """
        return pulumi.get(self, "private_srv_connection_string_uri")

    @private_srv_connection_string_uri.setter
    def private_srv_connection_string_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_srv_connection_string_uri", value)


@pulumi.type_token("alicloud:mongodb/privateSrvNetworkAddress:PrivateSrvNetworkAddress")
class PrivateSrvNetworkAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Mongo D B Private Srv Network Address resource.

        Private network SRV highly available link address.

        For information about Mongo D B Private Srv Network Address and how to use it, see [What is Private Srv Network Address](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id = config.get("zoneId")
        if zone_id is None:
            zone_id = "cn-shanghai-b"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-shanghai"
        defaultie35_cw = alicloud.vpc.Network("defaultie35CW",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        defaultg0_dcar = alicloud.vpc.Switch("defaultg0DCAR",
            vpc_id=defaultie35_cw.id,
            zone_id=zone_id,
            cidr_block="10.0.0.0/24")
        default_hr_zmx_c = alicloud.mongodb.Instance("defaultHrZmxC",
            engine_version="4.4",
            storage_type="cloud_essd1",
            vswitch_id=defaultg0_dcar.id,
            db_instance_storage=20,
            vpc_id=defaultie35_cw.id,
            db_instance_class="mdb.shard.4x.large.d",
            storage_engine="WiredTiger",
            network_type="VPC",
            zone_id=zone_id)
        default = alicloud.mongodb.PrivateSrvNetworkAddress("default", db_instance_id=default_hr_zmx_c.id)
        ```

        ## Import

        Mongo D B Private Srv Network Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mongodb/privateSrvNetworkAddress:PrivateSrvNetworkAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateSrvNetworkAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Mongo D B Private Srv Network Address resource.

        Private network SRV highly available link address.

        For information about Mongo D B Private Srv Network Address and how to use it, see [What is Private Srv Network Address](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id = config.get("zoneId")
        if zone_id is None:
            zone_id = "cn-shanghai-b"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-shanghai"
        defaultie35_cw = alicloud.vpc.Network("defaultie35CW",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        defaultg0_dcar = alicloud.vpc.Switch("defaultg0DCAR",
            vpc_id=defaultie35_cw.id,
            zone_id=zone_id,
            cidr_block="10.0.0.0/24")
        default_hr_zmx_c = alicloud.mongodb.Instance("defaultHrZmxC",
            engine_version="4.4",
            storage_type="cloud_essd1",
            vswitch_id=defaultg0_dcar.id,
            db_instance_storage=20,
            vpc_id=defaultie35_cw.id,
            db_instance_class="mdb.shard.4x.large.d",
            storage_engine="WiredTiger",
            network_type="VPC",
            zone_id=zone_id)
        default = alicloud.mongodb.PrivateSrvNetworkAddress("default", db_instance_id=default_hr_zmx_c.id)
        ```

        ## Import

        Mongo D B Private Srv Network Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mongodb/privateSrvNetworkAddress:PrivateSrvNetworkAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PrivateSrvNetworkAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateSrvNetworkAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateSrvNetworkAddressArgs.__new__(PrivateSrvNetworkAddressArgs)

            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["private_srv_connection_string_uri"] = None
        super(PrivateSrvNetworkAddress, __self__).__init__(
            'alicloud:mongodb/privateSrvNetworkAddress:PrivateSrvNetworkAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_srv_connection_string_uri: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateSrvNetworkAddress':
        """
        Get an existing PrivateSrvNetworkAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] private_srv_connection_string_uri: Private network SRV highly available connection address
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateSrvNetworkAddressState.__new__(_PrivateSrvNetworkAddressState)

        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["private_srv_connection_string_uri"] = private_srv_connection_string_uri
        return PrivateSrvNetworkAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="privateSrvConnectionStringUri")
    def private_srv_connection_string_uri(self) -> pulumi.Output[_builtins.str]:
        """
        Private network SRV highly available connection address
        """
        return pulumi.get(self, "private_srv_connection_string_uri")

