# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MscSubContractArgs', 'MscSubContract']

@pulumi.input_type
class MscSubContractArgs:
    def __init__(__self__, *,
                 contact_name: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 mobile: pulumi.Input[_builtins.str],
                 position: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a MscSubContract resource.
        :param pulumi.Input[_builtins.str] contact_name: The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
        :param pulumi.Input[_builtins.str] email: The User's Contact Email Address.
        :param pulumi.Input[_builtins.str] mobile: The User's Telephone.
        :param pulumi.Input[_builtins.str] position: The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
               
               > **NOTE:** When the user creates a contact, the user should use `get_msc_sub_contact_verification_message` to receive the verification message and confirm it.
        """
        pulumi.set(__self__, "contact_name", contact_name)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "mobile", mobile)
        pulumi.set(__self__, "position", position)

    @_builtins.property
    @pulumi.getter(name="contactName")
    def contact_name(self) -> pulumi.Input[_builtins.str]:
        """
        The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
        """
        return pulumi.get(self, "contact_name")

    @contact_name.setter
    def contact_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contact_name", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The User's Contact Email Address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def mobile(self) -> pulumi.Input[_builtins.str]:
        """
        The User's Telephone.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mobile", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Input[_builtins.str]:
        """
        The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.

        > **NOTE:** When the user creates a contact, the user should use `get_msc_sub_contact_verification_message` to receive the verification message and confirm it.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "position", value)


@pulumi.input_type
class _MscSubContractState:
    def __init__(__self__, *,
                 contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MscSubContract resources.
        :param pulumi.Input[_builtins.str] contact_name: The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
        :param pulumi.Input[_builtins.str] email: The User's Contact Email Address.
        :param pulumi.Input[_builtins.str] mobile: The User's Telephone.
        :param pulumi.Input[_builtins.str] position: The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
               
               > **NOTE:** When the user creates a contact, the user should use `get_msc_sub_contact_verification_message` to receive the verification message and confirm it.
        """
        if contact_name is not None:
            pulumi.set(__self__, "contact_name", contact_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if position is not None:
            pulumi.set(__self__, "position", position)

    @_builtins.property
    @pulumi.getter(name="contactName")
    def contact_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
        """
        return pulumi.get(self, "contact_name")

    @contact_name.setter
    def contact_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contact_name", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User's Contact Email Address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User's Telephone.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.

        > **NOTE:** When the user creates a contact, the user should use `get_msc_sub_contact_verification_message` to receive the verification message and confirm it.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)


@pulumi.type_token("alicloud:index/mscSubContract:MscSubContract")
class MscSubContract(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Msc Sub Contact resource.

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.MscSubContract("default",
            contact_name=name,
            position="CEO",
            email="123@163.com",
            mobile="15388888888")
        ```

        ## Import

        Msc Sub Contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:index/mscSubContract:MscSubContract example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contact_name: The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
        :param pulumi.Input[_builtins.str] email: The User's Contact Email Address.
        :param pulumi.Input[_builtins.str] mobile: The User's Telephone.
        :param pulumi.Input[_builtins.str] position: The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
               
               > **NOTE:** When the user creates a contact, the user should use `get_msc_sub_contact_verification_message` to receive the verification message and confirm it.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MscSubContractArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Msc Sub Contact resource.

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.MscSubContract("default",
            contact_name=name,
            position="CEO",
            email="123@163.com",
            mobile="15388888888")
        ```

        ## Import

        Msc Sub Contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:index/mscSubContract:MscSubContract example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MscSubContractArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MscSubContractArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MscSubContractArgs.__new__(MscSubContractArgs)

            if contact_name is None and not opts.urn:
                raise TypeError("Missing required property 'contact_name'")
            __props__.__dict__["contact_name"] = contact_name
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if mobile is None and not opts.urn:
                raise TypeError("Missing required property 'mobile'")
            __props__.__dict__["mobile"] = mobile
            if position is None and not opts.urn:
                raise TypeError("Missing required property 'position'")
            __props__.__dict__["position"] = position
        super(MscSubContract, __self__).__init__(
            'alicloud:index/mscSubContract:MscSubContract',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_name: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            mobile: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None) -> 'MscSubContract':
        """
        Get an existing MscSubContract resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contact_name: The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
        :param pulumi.Input[_builtins.str] email: The User's Contact Email Address.
        :param pulumi.Input[_builtins.str] mobile: The User's Telephone.
        :param pulumi.Input[_builtins.str] position: The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
               
               > **NOTE:** When the user creates a contact, the user should use `get_msc_sub_contact_verification_message` to receive the verification message and confirm it.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MscSubContractState.__new__(_MscSubContractState)

        __props__.__dict__["contact_name"] = contact_name
        __props__.__dict__["email"] = email
        __props__.__dict__["mobile"] = mobile
        __props__.__dict__["position"] = position
        return MscSubContract(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contactName")
    def contact_name(self) -> pulumi.Output[_builtins.str]:
        """
        The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
        """
        return pulumi.get(self, "contact_name")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The User's Contact Email Address.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def mobile(self) -> pulumi.Output[_builtins.str]:
        """
        The User's Telephone.
        """
        return pulumi.get(self, "mobile")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.

        > **NOTE:** When the user creates a contact, the user should use `get_msc_sub_contact_verification_message` to receive the verification message and confirm it.
        """
        return pulumi.get(self, "position")

