# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, cluster_alias_name=None, clusters=None, enable_details=None, id=None, ids=None, name_regex=None, names=None, output_file=None, request_pars=None, status=None):
        if cluster_alias_name and not isinstance(cluster_alias_name, str):
            raise TypeError("Expected argument 'cluster_alias_name' to be a str")
        pulumi.set(__self__, "cluster_alias_name", cluster_alias_name)
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if request_pars and not isinstance(request_pars, str):
            raise TypeError("Expected argument 'request_pars' to be a str")
        pulumi.set(__self__, "request_pars", request_pars)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="clusterAliasName")
    def cluster_alias_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cluster_alias_name")

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetClustersClusterResult']:
        """
        A list of MSE Clusters. Each element contains the following attributes:
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of MSE Cluster ids.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of MSE Cluster names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="requestPars")
    def request_pars(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "request_pars")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of MSE Cluster.
        """
        return pulumi.get(self, "status")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            cluster_alias_name=self.cluster_alias_name,
            clusters=self.clusters,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            request_pars=self.request_pars,
            status=self.status)


def get_clusters(cluster_alias_name: Optional[_builtins.str] = None,
                 enable_details: Optional[_builtins.bool] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 request_pars: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    This data source provides a list of MSE Clusters in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.94.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Create resource
    example = alicloud.get_zones(available_resource_creation="VSwitch")
    example_network = alicloud.vpc.Network("example",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    example_switch = alicloud.vpc.Switch("example",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=example_network.id,
        zone_id=example.zones[0].id)
    example_cluster = alicloud.mse.Cluster("example",
        cluster_specification="MSE_SC_1_2_60_c",
        cluster_type="Nacos-Ans",
        cluster_version="NACOS_2_0_0",
        instance_count=3,
        net_type="privatenet",
        pub_network_flow="1",
        connection_type="slb",
        cluster_alias_name="terraform-example",
        mse_version="mse_pro",
        vswitch_id=example_switch.id,
        vpc_id=example_network.id)
    # Declare the data source
    example_get_clusters = pulumi.Output.all(
        id=example_cluster.id,
        cluster_alias_name=example_cluster.cluster_alias_name
    ).apply(lambda resolved_outputs: alicloud.mse.get_clusters_output(enable_details=True,
        ids=[resolved_outputs['id']],
        status="INIT_SUCCESS",
        name_regex=resolved_outputs['cluster_alias_name']))

    pulumi.export("instanceId", example_get_clusters.clusters[0].id)
    ```


    :param _builtins.str cluster_alias_name: The alias name of MSE Cluster.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of MSE Cluster ids. It is formatted to `<instance_id>`
    :param _builtins.str name_regex: A regex string to filter the results by the cluster alias name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str request_pars: The extended request parameters. The JSON format is supported.
    :param _builtins.str status: The status of MSE Cluster. Valid: `DESTROY_FAILED`, `DESTROY_ING`, `DESTROY_SUCCESS`, `INIT_FAILED`, `INIT_ING`, `INIT_SUCCESS`, `INIT_TIME_OUT`, `RESTART_FAILED`, `RESTART_ING`, `RESTART_SUCCESS`, `SCALE_FAILED`, `SCALE_ING`, `SCALE_SUCCESS`
    """
    __args__ = dict()
    __args__['clusterAliasName'] = cluster_alias_name
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['requestPars'] = request_pars
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:mse/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        cluster_alias_name=pulumi.get(__ret__, 'cluster_alias_name'),
        clusters=pulumi.get(__ret__, 'clusters'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        request_pars=pulumi.get(__ret__, 'request_pars'),
        status=pulumi.get(__ret__, 'status'))
def get_clusters_output(cluster_alias_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        request_pars: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClustersResult]:
    """
    This data source provides a list of MSE Clusters in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.94.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Create resource
    example = alicloud.get_zones(available_resource_creation="VSwitch")
    example_network = alicloud.vpc.Network("example",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    example_switch = alicloud.vpc.Switch("example",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=example_network.id,
        zone_id=example.zones[0].id)
    example_cluster = alicloud.mse.Cluster("example",
        cluster_specification="MSE_SC_1_2_60_c",
        cluster_type="Nacos-Ans",
        cluster_version="NACOS_2_0_0",
        instance_count=3,
        net_type="privatenet",
        pub_network_flow="1",
        connection_type="slb",
        cluster_alias_name="terraform-example",
        mse_version="mse_pro",
        vswitch_id=example_switch.id,
        vpc_id=example_network.id)
    # Declare the data source
    example_get_clusters = pulumi.Output.all(
        id=example_cluster.id,
        cluster_alias_name=example_cluster.cluster_alias_name
    ).apply(lambda resolved_outputs: alicloud.mse.get_clusters_output(enable_details=True,
        ids=[resolved_outputs['id']],
        status="INIT_SUCCESS",
        name_regex=resolved_outputs['cluster_alias_name']))

    pulumi.export("instanceId", example_get_clusters.clusters[0].id)
    ```


    :param _builtins.str cluster_alias_name: The alias name of MSE Cluster.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of MSE Cluster ids. It is formatted to `<instance_id>`
    :param _builtins.str name_regex: A regex string to filter the results by the cluster alias name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str request_pars: The extended request parameters. The JSON format is supported.
    :param _builtins.str status: The status of MSE Cluster. Valid: `DESTROY_FAILED`, `DESTROY_ING`, `DESTROY_SUCCESS`, `INIT_FAILED`, `INIT_ING`, `INIT_SUCCESS`, `INIT_TIME_OUT`, `RESTART_FAILED`, `RESTART_ING`, `RESTART_SUCCESS`, `SCALE_FAILED`, `SCALE_ING`, `SCALE_SUCCESS`
    """
    __args__ = dict()
    __args__['clusterAliasName'] = cluster_alias_name
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['requestPars'] = request_pars
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:mse/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult)
    return __ret__.apply(lambda __response__: GetClustersResult(
        cluster_alias_name=pulumi.get(__response__, 'cluster_alias_name'),
        clusters=pulumi.get(__response__, 'clusters'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        request_pars=pulumi.get(__response__, 'request_pars'),
        status=pulumi.get(__response__, 'status')))
