# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccessGroupArgs', 'AccessGroup']

@pulumi.input_type
class AccessGroupArgs:
    def __init__(__self__, *,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessGroup resource.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.str] access_group_type: Permission group types, including Vpc.
        :param pulumi.Input[_builtins.str] description: Permission group description information.
        :param pulumi.Input[_builtins.str] file_system_type: File system type. Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
        :param pulumi.Input[_builtins.str] type: Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
        """
        if access_group_name is not None:
            pulumi.set(__self__, "access_group_name", access_group_name)
        if access_group_type is not None:
            pulumi.set(__self__, "access_group_type", access_group_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            warnings.warn("""Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type' instead.""")
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "access_group_name")

    @access_group_name.setter
    def access_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_name", value)

    @_builtins.property
    @pulumi.getter(name="accessGroupType")
    def access_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Permission group types, including Vpc.
        """
        return pulumi.get(self, "access_group_type")

    @access_group_type.setter
    def access_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Permission group description information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File system type. Value:
        - standard (default): Universal NAS
        - extreme: extreme NAS
        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type' instead.""")
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _AccessGroupState:
    def __init__(__self__, *,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessGroup resources.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.str] access_group_type: Permission group types, including Vpc.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.218.0) Creation time.
        :param pulumi.Input[_builtins.str] description: Permission group description information.
        :param pulumi.Input[_builtins.str] file_system_type: File system type. Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.256.0) The region ID.
        :param pulumi.Input[_builtins.str] type: Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
        """
        if access_group_name is not None:
            pulumi.set(__self__, "access_group_name", access_group_name)
        if access_group_type is not None:
            pulumi.set(__self__, "access_group_type", access_group_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if type is not None:
            warnings.warn("""Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type' instead.""")
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "access_group_name")

    @access_group_name.setter
    def access_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_name", value)

    @_builtins.property
    @pulumi.getter(name="accessGroupType")
    def access_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Permission group types, including Vpc.
        """
        return pulumi.get(self, "access_group_type")

    @access_group_type.setter
    def access_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.218.0) Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Permission group description information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File system type. Value:
        - standard (default): Universal NAS
        - extreme: extreme NAS
        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.256.0) The region ID.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type' instead.""")
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:nas/accessGroup:AccessGroup")
class AccessGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a NAS Access Group resource. File system Access Group.

        In NAS, the permission group acts as a whitelist that allows you to restrict file system access. You can allow specified IP addresses or CIDR blocks to access the file system, and assign different levels of access permission to different IP addresses or CIDR blocks by adding rules to the permission group.
        For information about NAS Access Group and how to use it, see [What is NAS Access Group](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createaccessgroup)

        > **NOTE:** Available since v1.33.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        foo = alicloud.nas.AccessGroup("foo",
            access_group_name=f"terraform-example-{default['result']}",
            access_group_type="Vpc",
            description="terraform-example",
            file_system_type="extreme")
        ```

        ## Import

        NAS Access Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/accessGroup:AccessGroup example <access_group_name>:<file_system_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.str] access_group_type: Permission group types, including Vpc.
        :param pulumi.Input[_builtins.str] description: Permission group description information.
        :param pulumi.Input[_builtins.str] file_system_type: File system type. Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
        :param pulumi.Input[_builtins.str] type: Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccessGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NAS Access Group resource. File system Access Group.

        In NAS, the permission group acts as a whitelist that allows you to restrict file system access. You can allow specified IP addresses or CIDR blocks to access the file system, and assign different levels of access permission to different IP addresses or CIDR blocks by adding rules to the permission group.
        For information about NAS Access Group and how to use it, see [What is NAS Access Group](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createaccessgroup)

        > **NOTE:** Available since v1.33.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        foo = alicloud.nas.AccessGroup("foo",
            access_group_name=f"terraform-example-{default['result']}",
            access_group_type="Vpc",
            description="terraform-example",
            file_system_type="extreme")
        ```

        ## Import

        NAS Access Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/accessGroup:AccessGroup example <access_group_name>:<file_system_type>
        ```

        :param str resource_name: The name of the resource.
        :param AccessGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessGroupArgs.__new__(AccessGroupArgs)

            __props__.__dict__["access_group_name"] = access_group_name
            __props__.__dict__["access_group_type"] = access_group_type
            __props__.__dict__["description"] = description
            __props__.__dict__["file_system_type"] = file_system_type
            __props__.__dict__["name"] = name
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
        super(AccessGroup, __self__).__init__(
            'alicloud:nas/accessGroup:AccessGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            access_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessGroup':
        """
        Get an existing AccessGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.str] access_group_type: Permission group types, including Vpc.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.218.0) Creation time.
        :param pulumi.Input[_builtins.str] description: Permission group description information.
        :param pulumi.Input[_builtins.str] file_system_type: File system type. Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.256.0) The region ID.
        :param pulumi.Input[_builtins.str] type: Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessGroupState.__new__(_AccessGroupState)

        __props__.__dict__["access_group_name"] = access_group_name
        __props__.__dict__["access_group_type"] = access_group_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_type"] = file_system_type
        __props__.__dict__["name"] = name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["type"] = type
        return AccessGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "access_group_name")

    @_builtins.property
    @pulumi.getter(name="accessGroupType")
    def access_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        Permission group types, including Vpc.
        """
        return pulumi.get(self, "access_group_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.218.0) Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Permission group description information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        File system type. Value:
        - standard (default): Universal NAS
        - extreme: extreme NAS
        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "file_system_type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.218.0. New field 'access_group_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field 'name' has been deprecated from provider version 1.218.0. New field 'access_group_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.256.0) The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'type' has been deprecated since provider version 1.218.0. New field 'access_group_type' instead.""")
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Field 'type' has been deprecated from provider version 1.218.0. New field 'access_group_type' instead.
        """
        return pulumi.get(self, "type")

