# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 listener_port: pulumi.Input[_builtins.int],
                 listener_protocol: pulumi.Input[_builtins.str],
                 load_balancer_id: pulumi.Input[_builtins.str],
                 server_group_id: pulumi.Input[_builtins.str],
                 alpn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alpn_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 end_port: Optional[pulumi.Input[_builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 mss: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_config: Optional[pulumi.Input['ListenerProxyProtocolConfigArgs']] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start_port: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[_builtins.int] listener_port: The listener port. Valid values: `0` to `65535`.
               If you set the value to `0`, the listener listens by port range. If you set the value to `0`, you must specify `StartPort` and `EndPort`.
        :param pulumi.Input[_builtins.str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, and `TCPSSL`.
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Network Load Balancer (NLB) instance.
        :param pulumi.Input[_builtins.str] server_group_id: The ID of the server group.
        :param pulumi.Input[_builtins.bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN). Valid values:
        :param pulumi.Input[_builtins.str] alpn_policy: The ALPN policy. Valid values:
               - `HTTP1Only`: uses only HTTP 1.x. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               - `HTTP2Only`: uses only HTTP 2.0.
               - `HTTP2Optional`: preferentially uses HTTP 1.x over HTTP 2.0. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0, and the priority of HTTP 1.0 is higher than the priority of HTTP 2.0.
               - `HTTP2Preferred`: preferentially uses HTTP 2.0 over HTTP 1.x. The priority of HTTP 2.0 is higher than the priority of HTTP 1.1, and the priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               
               > **NOTE:**  This parameter is required if AlpnEnabled is set to true.
               
               > **NOTE:**  Effective only for TCPSSL listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  Only one CA certificate is supported.
        :param pulumi.Input[_builtins.bool] ca_enabled: Specifies whether to enable mutual authentication. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  This parameter takes effect only for TCPSSL listeners.
        :param pulumi.Input[_builtins.int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: `0` to `1000000`. `0` specifies that the number of connections is unlimited.
        :param pulumi.Input[_builtins.int] end_port: The last port in the listener port range. Valid values: `0` to `65535`. The number of the last port must be greater than the number of the first port.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.int] idle_timeout: The timeout period of idle connections. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[_builtins.str] listener_description: Enter a name for the listener.
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[_builtins.int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: `0` to `1500`. `0` specifies that the maximum segment size remains unchanged.
               
               > **NOTE:**  This parameter is supported only by TCP listeners and listeners that use SSL over TCP.
        :param pulumi.Input['ListenerProxyProtocolConfigArgs'] proxy_protocol_config: The Proxy Protocol is used to carry the VpcId, PrivateLinkEpId, and PrivateLinkEpsId information to the backend server for configuration. See `proxy_protocol_config` below.
        :param pulumi.Input[_builtins.bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers. Valid values:
        :param pulumi.Input[_builtins.bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring. Valid values:
        :param pulumi.Input[_builtins.str] security_policy_id: The security policy ID. System security policies and custom security policies are supported.
               
               Valid values: `tls_cipher_policy\\_1\\_0` (default), `tls_cipher_policy\\_1\\_1`, `tls_cipher_policy\\_1\\_2`, `tls_cipher_policy\\_1\\_2\\_strict`, and `tls_cipher_policy\\_1\\_2\\_strict_with\\_1\\_3`.
               
               > **NOTE:**  This parameter takes effect only for listeners that use SSL over TCP.
        :param pulumi.Input[_builtins.int] start_port: The first port in the listener port range. Valid values: `0` to `65535`.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`, `Stopped`. When you want to enable this instance, you can set the property value to `Running`;
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        if alpn_enabled is not None:
            pulumi.set(__self__, "alpn_enabled", alpn_enabled)
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if ca_certificate_ids is not None:
            pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        if ca_enabled is not None:
            pulumi.set(__self__, "ca_enabled", ca_enabled)
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if mss is not None:
            pulumi.set(__self__, "mss", mss)
        if proxy_protocol_config is not None:
            pulumi.set(__self__, "proxy_protocol_config", proxy_protocol_config)
        if proxy_protocol_enabled is not None:
            pulumi.set(__self__, "proxy_protocol_enabled", proxy_protocol_enabled)
        if sec_sensor_enabled is not None:
            pulumi.set(__self__, "sec_sensor_enabled", sec_sensor_enabled)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if start_port is not None:
            pulumi.set(__self__, "start_port", start_port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Input[_builtins.int]:
        """
        The listener port. Valid values: `0` to `65535`.
        If you set the value to `0`, the listener listens by port range. If you set the value to `0`, you must specify `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "listener_port", value)

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, and `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_protocol", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Network Load Balancer (NLB) instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_group_id", value)

    @_builtins.property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Application-Layer Protocol Negotiation (ALPN). Valid values:
        """
        return pulumi.get(self, "alpn_enabled")

    @alpn_enabled.setter
    def alpn_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alpn_enabled", value)

    @_builtins.property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ALPN policy. Valid values:
        - `HTTP1Only`: uses only HTTP 1.x. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
        - `HTTP2Only`: uses only HTTP 2.0.
        - `HTTP2Optional`: preferentially uses HTTP 1.x over HTTP 2.0. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0, and the priority of HTTP 1.0 is higher than the priority of HTTP 2.0.
        - `HTTP2Preferred`: preferentially uses HTTP 2.0 over HTTP 1.x. The priority of HTTP 2.0 is higher than the priority of HTTP 1.1, and the priority of HTTP 1.1 is higher than the priority of HTTP 1.0.

        > **NOTE:**  This parameter is required if AlpnEnabled is set to true.

        > **NOTE:**  Effective only for TCPSSL listener.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alpn_policy", value)

    @_builtins.property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. 

        > **NOTE:**  Only one CA certificate is supported.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @ca_certificate_ids.setter
    def ca_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ca_certificate_ids", value)

    @_builtins.property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable mutual authentication. Valid values:
        """
        return pulumi.get(self, "ca_enabled")

    @ca_enabled.setter
    def ca_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ca_enabled", value)

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. 

        > **NOTE:**  This parameter takes effect only for TCPSSL listeners.
        """
        return pulumi.get(self, "certificate_ids")

    @certificate_ids.setter
    def certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "certificate_ids", value)

    @_builtins.property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections that can be created per second on the NLB instance. Valid values: `0` to `1000000`. `0` specifies that the number of connections is unlimited.
        """
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cps", value)

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The last port in the listener port range. Valid values: `0` to `65535`. The number of the last port must be greater than the number of the first port.

        > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_port", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period of idle connections. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enter a name for the listener.
        The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_description", value)

    @_builtins.property
    @pulumi.getter
    def mss(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size of a TCP segment. Unit: bytes. Valid values: `0` to `1500`. `0` specifies that the maximum segment size remains unchanged.

        > **NOTE:**  This parameter is supported only by TCP listeners and listeners that use SSL over TCP.
        """
        return pulumi.get(self, "mss")

    @mss.setter
    def mss(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mss", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolConfig")
    def proxy_protocol_config(self) -> Optional[pulumi.Input['ListenerProxyProtocolConfigArgs']]:
        """
        The Proxy Protocol is used to carry the VpcId, PrivateLinkEpId, and PrivateLinkEpsId information to the backend server for configuration. See `proxy_protocol_config` below.
        """
        return pulumi.get(self, "proxy_protocol_config")

    @proxy_protocol_config.setter
    def proxy_protocol_config(self, value: Optional[pulumi.Input['ListenerProxyProtocolConfigArgs']]):
        pulumi.set(self, "proxy_protocol_config", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers. Valid values:
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @proxy_protocol_enabled.setter
    def proxy_protocol_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxy_protocol_enabled", value)

    @_builtins.property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable fine-grained monitoring. Valid values:
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @sec_sensor_enabled.setter
    def sec_sensor_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sec_sensor_enabled", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security policy ID. System security policies and custom security policies are supported.

        Valid values: `tls_cipher_policy\\_1\\_0` (default), `tls_cipher_policy\\_1\\_1`, `tls_cipher_policy\\_1\\_2`, `tls_cipher_policy\\_1\\_2\\_strict`, and `tls_cipher_policy\\_1\\_2\\_strict_with\\_1\\_3`.

        > **NOTE:**  This parameter takes effect only for listeners that use SSL over TCP.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The first port in the listener port range. Valid values: `0` to `65535`.

        > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_port", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Running`, `Stopped`. When you want to enable this instance, you can set the property value to `Running`;
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 alpn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alpn_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 end_port: Optional[pulumi.Input[_builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mss: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_config: Optional[pulumi.Input['ListenerProxyProtocolConfigArgs']] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start_port: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[_builtins.bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN). Valid values:
        :param pulumi.Input[_builtins.str] alpn_policy: The ALPN policy. Valid values:
               - `HTTP1Only`: uses only HTTP 1.x. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               - `HTTP2Only`: uses only HTTP 2.0.
               - `HTTP2Optional`: preferentially uses HTTP 1.x over HTTP 2.0. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0, and the priority of HTTP 1.0 is higher than the priority of HTTP 2.0.
               - `HTTP2Preferred`: preferentially uses HTTP 2.0 over HTTP 1.x. The priority of HTTP 2.0 is higher than the priority of HTTP 1.1, and the priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               
               > **NOTE:**  This parameter is required if AlpnEnabled is set to true.
               
               > **NOTE:**  Effective only for TCPSSL listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  Only one CA certificate is supported.
        :param pulumi.Input[_builtins.bool] ca_enabled: Specifies whether to enable mutual authentication. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  This parameter takes effect only for TCPSSL listeners.
        :param pulumi.Input[_builtins.int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: `0` to `1000000`. `0` specifies that the number of connections is unlimited.
        :param pulumi.Input[_builtins.int] end_port: The last port in the listener port range. Valid values: `0` to `65535`. The number of the last port must be greater than the number of the first port.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.int] idle_timeout: The timeout period of idle connections. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[_builtins.str] listener_description: Enter a name for the listener.
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[_builtins.int] listener_port: The listener port. Valid values: `0` to `65535`.
               If you set the value to `0`, the listener listens by port range. If you set the value to `0`, you must specify `StartPort` and `EndPort`.
        :param pulumi.Input[_builtins.str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, and `TCPSSL`.
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Network Load Balancer (NLB) instance.
        :param pulumi.Input[_builtins.int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: `0` to `1500`. `0` specifies that the maximum segment size remains unchanged.
               
               > **NOTE:**  This parameter is supported only by TCP listeners and listeners that use SSL over TCP.
        :param pulumi.Input['ListenerProxyProtocolConfigArgs'] proxy_protocol_config: The Proxy Protocol is used to carry the VpcId, PrivateLinkEpId, and PrivateLinkEpsId information to the backend server for configuration. See `proxy_protocol_config` below.
        :param pulumi.Input[_builtins.bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers. Valid values:
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the Network Load Balancer (NLB) instance is deployed.
               You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/doc-detail/443657.html) operation to query the most recent region list.
        :param pulumi.Input[_builtins.bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring. Valid values:
        :param pulumi.Input[_builtins.str] security_policy_id: The security policy ID. System security policies and custom security policies are supported.
               
               Valid values: `tls_cipher_policy\\_1\\_0` (default), `tls_cipher_policy\\_1\\_1`, `tls_cipher_policy\\_1\\_2`, `tls_cipher_policy\\_1\\_2\\_strict`, and `tls_cipher_policy\\_1\\_2\\_strict_with\\_1\\_3`.
               
               > **NOTE:**  This parameter takes effect only for listeners that use SSL over TCP.
        :param pulumi.Input[_builtins.str] server_group_id: The ID of the server group.
        :param pulumi.Input[_builtins.int] start_port: The first port in the listener port range. Valid values: `0` to `65535`.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`, `Stopped`. When you want to enable this instance, you can set the property value to `Running`;
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        if alpn_enabled is not None:
            pulumi.set(__self__, "alpn_enabled", alpn_enabled)
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if ca_certificate_ids is not None:
            pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        if ca_enabled is not None:
            pulumi.set(__self__, "ca_enabled", ca_enabled)
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if listener_protocol is not None:
            pulumi.set(__self__, "listener_protocol", listener_protocol)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if mss is not None:
            pulumi.set(__self__, "mss", mss)
        if proxy_protocol_config is not None:
            pulumi.set(__self__, "proxy_protocol_config", proxy_protocol_config)
        if proxy_protocol_enabled is not None:
            pulumi.set(__self__, "proxy_protocol_enabled", proxy_protocol_enabled)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if sec_sensor_enabled is not None:
            pulumi.set(__self__, "sec_sensor_enabled", sec_sensor_enabled)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if start_port is not None:
            pulumi.set(__self__, "start_port", start_port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable Application-Layer Protocol Negotiation (ALPN). Valid values:
        """
        return pulumi.get(self, "alpn_enabled")

    @alpn_enabled.setter
    def alpn_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alpn_enabled", value)

    @_builtins.property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ALPN policy. Valid values:
        - `HTTP1Only`: uses only HTTP 1.x. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
        - `HTTP2Only`: uses only HTTP 2.0.
        - `HTTP2Optional`: preferentially uses HTTP 1.x over HTTP 2.0. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0, and the priority of HTTP 1.0 is higher than the priority of HTTP 2.0.
        - `HTTP2Preferred`: preferentially uses HTTP 2.0 over HTTP 1.x. The priority of HTTP 2.0 is higher than the priority of HTTP 1.1, and the priority of HTTP 1.1 is higher than the priority of HTTP 1.0.

        > **NOTE:**  This parameter is required if AlpnEnabled is set to true.

        > **NOTE:**  Effective only for TCPSSL listener.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alpn_policy", value)

    @_builtins.property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. 

        > **NOTE:**  Only one CA certificate is supported.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @ca_certificate_ids.setter
    def ca_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ca_certificate_ids", value)

    @_builtins.property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable mutual authentication. Valid values:
        """
        return pulumi.get(self, "ca_enabled")

    @ca_enabled.setter
    def ca_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ca_enabled", value)

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. 

        > **NOTE:**  This parameter takes effect only for TCPSSL listeners.
        """
        return pulumi.get(self, "certificate_ids")

    @certificate_ids.setter
    def certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "certificate_ids", value)

    @_builtins.property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections that can be created per second on the NLB instance. Valid values: `0` to `1000000`. `0` specifies that the number of connections is unlimited.
        """
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cps", value)

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The last port in the listener port range. Valid values: `0` to `65535`. The number of the last port must be greater than the number of the first port.

        > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_port", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period of idle connections. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enter a name for the listener.
        The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_description", value)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The listener port. Valid values: `0` to `65535`.
        If you set the value to `0`, the listener listens by port range. If you set the value to `0`, you must specify `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "listener_port", value)

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, and `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_protocol", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Network Load Balancer (NLB) instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter
    def mss(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size of a TCP segment. Unit: bytes. Valid values: `0` to `1500`. `0` specifies that the maximum segment size remains unchanged.

        > **NOTE:**  This parameter is supported only by TCP listeners and listeners that use SSL over TCP.
        """
        return pulumi.get(self, "mss")

    @mss.setter
    def mss(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mss", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolConfig")
    def proxy_protocol_config(self) -> Optional[pulumi.Input['ListenerProxyProtocolConfigArgs']]:
        """
        The Proxy Protocol is used to carry the VpcId, PrivateLinkEpId, and PrivateLinkEpsId information to the backend server for configuration. See `proxy_protocol_config` below.
        """
        return pulumi.get(self, "proxy_protocol_config")

    @proxy_protocol_config.setter
    def proxy_protocol_config(self, value: Optional[pulumi.Input['ListenerProxyProtocolConfigArgs']]):
        pulumi.set(self, "proxy_protocol_config", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers. Valid values:
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @proxy_protocol_enabled.setter
    def proxy_protocol_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxy_protocol_enabled", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the Network Load Balancer (NLB) instance is deployed.
        You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/doc-detail/443657.html) operation to query the most recent region list.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable fine-grained monitoring. Valid values:
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @sec_sensor_enabled.setter
    def sec_sensor_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sec_sensor_enabled", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security policy ID. System security policies and custom security policies are supported.

        Valid values: `tls_cipher_policy\\_1\\_0` (default), `tls_cipher_policy\\_1\\_1`, `tls_cipher_policy\\_1\\_2`, `tls_cipher_policy\\_1\\_2\\_strict`, and `tls_cipher_policy\\_1\\_2\\_strict_with\\_1\\_3`.

        > **NOTE:**  This parameter takes effect only for listeners that use SSL over TCP.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_id", value)

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The first port in the listener port range. Valid values: `0` to `65535`.

        > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_port", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Running`, `Stopped`. When you want to enable this instance, you can set the property value to `Running`;
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:nlb/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alpn_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 end_port: Optional[pulumi.Input[_builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mss: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_config: Optional[pulumi.Input[Union['ListenerProxyProtocolConfigArgs', 'ListenerProxyProtocolConfigArgsDict']]] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start_port: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Network Load Balancer (NLB) Listener resource.

        For information about Network Load Balancer (NLB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/server-load-balancer/latest/api-nlb-2022-04-30-createlistener).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[1].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_load_balancer = alicloud.nlb.LoadBalancer("default",
            load_balancer_name=name,
            resource_group_id=default.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch.id,
                    "zone_id": default_get_zones.zones[0].id,
                },
                {
                    "vswitch_id": default1.id,
                    "zone_id": default_get_zones.zones[1].id,
                },
            ])
        default_server_group = alicloud.nlb.ServerGroup("default",
            resource_group_id=default.ids[0],
            server_group_name=name,
            server_group_type="Instance",
            vpc_id=default_network.id,
            scheduler="Wrr",
            protocol="TCP",
            connection_drain_enabled=True,
            connection_drain_timeout=60,
            address_ip_version="Ipv4",
            health_check={
                "health_check_enabled": True,
                "health_check_type": "TCP",
                "health_check_connect_port": 0,
                "healthy_threshold": 2,
                "unhealthy_threshold": 2,
                "health_check_connect_timeout": 5,
                "health_check_interval": 10,
                "http_check_method": "GET",
                "health_check_http_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
            },
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_listener = alicloud.nlb.Listener("default",
            listener_protocol="TCP",
            listener_port=80,
            listener_description=name,
            load_balancer_id=default_load_balancer.id,
            server_group_id=default_server_group.id,
            idle_timeout=900,
            proxy_protocol_enabled=True,
            cps=10000,
            mss=0)
        ```

        ## Import

        Network Load Balancer (NLB) Listener can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN). Valid values:
        :param pulumi.Input[_builtins.str] alpn_policy: The ALPN policy. Valid values:
               - `HTTP1Only`: uses only HTTP 1.x. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               - `HTTP2Only`: uses only HTTP 2.0.
               - `HTTP2Optional`: preferentially uses HTTP 1.x over HTTP 2.0. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0, and the priority of HTTP 1.0 is higher than the priority of HTTP 2.0.
               - `HTTP2Preferred`: preferentially uses HTTP 2.0 over HTTP 1.x. The priority of HTTP 2.0 is higher than the priority of HTTP 1.1, and the priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               
               > **NOTE:**  This parameter is required if AlpnEnabled is set to true.
               
               > **NOTE:**  Effective only for TCPSSL listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  Only one CA certificate is supported.
        :param pulumi.Input[_builtins.bool] ca_enabled: Specifies whether to enable mutual authentication. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  This parameter takes effect only for TCPSSL listeners.
        :param pulumi.Input[_builtins.int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: `0` to `1000000`. `0` specifies that the number of connections is unlimited.
        :param pulumi.Input[_builtins.int] end_port: The last port in the listener port range. Valid values: `0` to `65535`. The number of the last port must be greater than the number of the first port.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.int] idle_timeout: The timeout period of idle connections. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[_builtins.str] listener_description: Enter a name for the listener.
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[_builtins.int] listener_port: The listener port. Valid values: `0` to `65535`.
               If you set the value to `0`, the listener listens by port range. If you set the value to `0`, you must specify `StartPort` and `EndPort`.
        :param pulumi.Input[_builtins.str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, and `TCPSSL`.
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Network Load Balancer (NLB) instance.
        :param pulumi.Input[_builtins.int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: `0` to `1500`. `0` specifies that the maximum segment size remains unchanged.
               
               > **NOTE:**  This parameter is supported only by TCP listeners and listeners that use SSL over TCP.
        :param pulumi.Input[Union['ListenerProxyProtocolConfigArgs', 'ListenerProxyProtocolConfigArgsDict']] proxy_protocol_config: The Proxy Protocol is used to carry the VpcId, PrivateLinkEpId, and PrivateLinkEpsId information to the backend server for configuration. See `proxy_protocol_config` below.
        :param pulumi.Input[_builtins.bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers. Valid values:
        :param pulumi.Input[_builtins.bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring. Valid values:
        :param pulumi.Input[_builtins.str] security_policy_id: The security policy ID. System security policies and custom security policies are supported.
               
               Valid values: `tls_cipher_policy\\_1\\_0` (default), `tls_cipher_policy\\_1\\_1`, `tls_cipher_policy\\_1\\_2`, `tls_cipher_policy\\_1\\_2\\_strict`, and `tls_cipher_policy\\_1\\_2\\_strict_with\\_1\\_3`.
               
               > **NOTE:**  This parameter takes effect only for listeners that use SSL over TCP.
        :param pulumi.Input[_builtins.str] server_group_id: The ID of the server group.
        :param pulumi.Input[_builtins.int] start_port: The first port in the listener port range. Valid values: `0` to `65535`.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`, `Stopped`. When you want to enable this instance, you can set the property value to `Running`;
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Network Load Balancer (NLB) Listener resource.

        For information about Network Load Balancer (NLB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/server-load-balancer/latest/api-nlb-2022-04-30-createlistener).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[1].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_load_balancer = alicloud.nlb.LoadBalancer("default",
            load_balancer_name=name,
            resource_group_id=default.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch.id,
                    "zone_id": default_get_zones.zones[0].id,
                },
                {
                    "vswitch_id": default1.id,
                    "zone_id": default_get_zones.zones[1].id,
                },
            ])
        default_server_group = alicloud.nlb.ServerGroup("default",
            resource_group_id=default.ids[0],
            server_group_name=name,
            server_group_type="Instance",
            vpc_id=default_network.id,
            scheduler="Wrr",
            protocol="TCP",
            connection_drain_enabled=True,
            connection_drain_timeout=60,
            address_ip_version="Ipv4",
            health_check={
                "health_check_enabled": True,
                "health_check_type": "TCP",
                "health_check_connect_port": 0,
                "healthy_threshold": 2,
                "unhealthy_threshold": 2,
                "health_check_connect_timeout": 5,
                "health_check_interval": 10,
                "http_check_method": "GET",
                "health_check_http_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
            },
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_listener = alicloud.nlb.Listener("default",
            listener_protocol="TCP",
            listener_port=80,
            listener_description=name,
            load_balancer_id=default_load_balancer.id,
            server_group_id=default_server_group.id,
            idle_timeout=900,
            proxy_protocol_enabled=True,
            cps=10000,
            mss=0)
        ```

        ## Import

        Network Load Balancer (NLB) Listener can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alpn_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 end_port: Optional[pulumi.Input[_builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mss: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_config: Optional[pulumi.Input[Union['ListenerProxyProtocolConfigArgs', 'ListenerProxyProtocolConfigArgsDict']]] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start_port: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["alpn_enabled"] = alpn_enabled
            __props__.__dict__["alpn_policy"] = alpn_policy
            __props__.__dict__["ca_certificate_ids"] = ca_certificate_ids
            __props__.__dict__["ca_enabled"] = ca_enabled
            __props__.__dict__["certificate_ids"] = certificate_ids
            __props__.__dict__["cps"] = cps
            __props__.__dict__["end_port"] = end_port
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["listener_description"] = listener_description
            if listener_port is None and not opts.urn:
                raise TypeError("Missing required property 'listener_port'")
            __props__.__dict__["listener_port"] = listener_port
            if listener_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'listener_protocol'")
            __props__.__dict__["listener_protocol"] = listener_protocol
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["mss"] = mss
            __props__.__dict__["proxy_protocol_config"] = proxy_protocol_config
            __props__.__dict__["proxy_protocol_enabled"] = proxy_protocol_enabled
            __props__.__dict__["sec_sensor_enabled"] = sec_sensor_enabled
            __props__.__dict__["security_policy_id"] = security_policy_id
            if server_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_group_id'")
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["start_port"] = start_port
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["region_id"] = None
        super(Listener, __self__).__init__(
            'alicloud:nlb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alpn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            alpn_policy: Optional[pulumi.Input[_builtins.str]] = None,
            ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cps: Optional[pulumi.Input[_builtins.int]] = None,
            end_port: Optional[pulumi.Input[_builtins.int]] = None,
            idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            listener_description: Optional[pulumi.Input[_builtins.str]] = None,
            listener_port: Optional[pulumi.Input[_builtins.int]] = None,
            listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            mss: Optional[pulumi.Input[_builtins.int]] = None,
            proxy_protocol_config: Optional[pulumi.Input[Union['ListenerProxyProtocolConfigArgs', 'ListenerProxyProtocolConfigArgsDict']]] = None,
            proxy_protocol_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            sec_sensor_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            start_port: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN). Valid values:
        :param pulumi.Input[_builtins.str] alpn_policy: The ALPN policy. Valid values:
               - `HTTP1Only`: uses only HTTP 1.x. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               - `HTTP2Only`: uses only HTTP 2.0.
               - `HTTP2Optional`: preferentially uses HTTP 1.x over HTTP 2.0. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0, and the priority of HTTP 1.0 is higher than the priority of HTTP 2.0.
               - `HTTP2Preferred`: preferentially uses HTTP 2.0 over HTTP 1.x. The priority of HTTP 2.0 is higher than the priority of HTTP 1.1, and the priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
               
               > **NOTE:**  This parameter is required if AlpnEnabled is set to true.
               
               > **NOTE:**  Effective only for TCPSSL listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  Only one CA certificate is supported.
        :param pulumi.Input[_builtins.bool] ca_enabled: Specifies whether to enable mutual authentication. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. 
               
               > **NOTE:**  This parameter takes effect only for TCPSSL listeners.
        :param pulumi.Input[_builtins.int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: `0` to `1000000`. `0` specifies that the number of connections is unlimited.
        :param pulumi.Input[_builtins.int] end_port: The last port in the listener port range. Valid values: `0` to `65535`. The number of the last port must be greater than the number of the first port.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.int] idle_timeout: The timeout period of idle connections. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[_builtins.str] listener_description: Enter a name for the listener.
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[_builtins.int] listener_port: The listener port. Valid values: `0` to `65535`.
               If you set the value to `0`, the listener listens by port range. If you set the value to `0`, you must specify `StartPort` and `EndPort`.
        :param pulumi.Input[_builtins.str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, and `TCPSSL`.
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Network Load Balancer (NLB) instance.
        :param pulumi.Input[_builtins.int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: `0` to `1500`. `0` specifies that the maximum segment size remains unchanged.
               
               > **NOTE:**  This parameter is supported only by TCP listeners and listeners that use SSL over TCP.
        :param pulumi.Input[Union['ListenerProxyProtocolConfigArgs', 'ListenerProxyProtocolConfigArgsDict']] proxy_protocol_config: The Proxy Protocol is used to carry the VpcId, PrivateLinkEpId, and PrivateLinkEpsId information to the backend server for configuration. See `proxy_protocol_config` below.
        :param pulumi.Input[_builtins.bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers. Valid values:
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the Network Load Balancer (NLB) instance is deployed.
               You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/doc-detail/443657.html) operation to query the most recent region list.
        :param pulumi.Input[_builtins.bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring. Valid values:
        :param pulumi.Input[_builtins.str] security_policy_id: The security policy ID. System security policies and custom security policies are supported.
               
               Valid values: `tls_cipher_policy\\_1\\_0` (default), `tls_cipher_policy\\_1\\_1`, `tls_cipher_policy\\_1\\_2`, `tls_cipher_policy\\_1\\_2\\_strict`, and `tls_cipher_policy\\_1\\_2\\_strict_with\\_1\\_3`.
               
               > **NOTE:**  This parameter takes effect only for listeners that use SSL over TCP.
        :param pulumi.Input[_builtins.str] server_group_id: The ID of the server group.
        :param pulumi.Input[_builtins.int] start_port: The first port in the listener port range. Valid values: `0` to `65535`.
               
               > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`, `Stopped`. When you want to enable this instance, you can set the property value to `Running`;
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["alpn_enabled"] = alpn_enabled
        __props__.__dict__["alpn_policy"] = alpn_policy
        __props__.__dict__["ca_certificate_ids"] = ca_certificate_ids
        __props__.__dict__["ca_enabled"] = ca_enabled
        __props__.__dict__["certificate_ids"] = certificate_ids
        __props__.__dict__["cps"] = cps
        __props__.__dict__["end_port"] = end_port
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["listener_description"] = listener_description
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["listener_protocol"] = listener_protocol
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["mss"] = mss
        __props__.__dict__["proxy_protocol_config"] = proxy_protocol_config
        __props__.__dict__["proxy_protocol_enabled"] = proxy_protocol_enabled
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["sec_sensor_enabled"] = sec_sensor_enabled
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["server_group_id"] = server_group_id
        __props__.__dict__["start_port"] = start_port
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Listener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable Application-Layer Protocol Negotiation (ALPN). Valid values:
        """
        return pulumi.get(self, "alpn_enabled")

    @_builtins.property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ALPN policy. Valid values:
        - `HTTP1Only`: uses only HTTP 1.x. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0.
        - `HTTP2Only`: uses only HTTP 2.0.
        - `HTTP2Optional`: preferentially uses HTTP 1.x over HTTP 2.0. The priority of HTTP 1.1 is higher than the priority of HTTP 1.0, and the priority of HTTP 1.0 is higher than the priority of HTTP 2.0.
        - `HTTP2Preferred`: preferentially uses HTTP 2.0 over HTTP 1.x. The priority of HTTP 2.0 is higher than the priority of HTTP 1.1, and the priority of HTTP 1.1 is higher than the priority of HTTP 1.0.

        > **NOTE:**  This parameter is required if AlpnEnabled is set to true.

        > **NOTE:**  Effective only for TCPSSL listener.
        """
        return pulumi.get(self, "alpn_policy")

    @_builtins.property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. 

        > **NOTE:**  Only one CA certificate is supported.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @_builtins.property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable mutual authentication. Valid values:
        """
        return pulumi.get(self, "ca_enabled")

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. 

        > **NOTE:**  This parameter takes effect only for TCPSSL listeners.
        """
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter
    def cps(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of connections that can be created per second on the NLB instance. Valid values: `0` to `1000000`. `0` specifies that the number of connections is unlimited.
        """
        return pulumi.get(self, "cps")

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The last port in the listener port range. Valid values: `0` to `65535`. The number of the last port must be greater than the number of the first port.

        > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        """
        return pulumi.get(self, "end_port")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The timeout period of idle connections. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enter a name for the listener.
        The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        """
        return pulumi.get(self, "listener_description")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[_builtins.int]:
        """
        The listener port. Valid values: `0` to `65535`.
        If you set the value to `0`, the listener listens by port range. If you set the value to `0`, you must specify `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, and `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Network Load Balancer (NLB) instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def mss(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum size of a TCP segment. Unit: bytes. Valid values: `0` to `1500`. `0` specifies that the maximum segment size remains unchanged.

        > **NOTE:**  This parameter is supported only by TCP listeners and listeners that use SSL over TCP.
        """
        return pulumi.get(self, "mss")

    @_builtins.property
    @pulumi.getter(name="proxyProtocolConfig")
    def proxy_protocol_config(self) -> pulumi.Output['outputs.ListenerProxyProtocolConfig']:
        """
        The Proxy Protocol is used to carry the VpcId, PrivateLinkEpId, and PrivateLinkEpsId information to the backend server for configuration. See `proxy_protocol_config` below.
        """
        return pulumi.get(self, "proxy_protocol_config")

    @_builtins.property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers. Valid values:
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the Network Load Balancer (NLB) instance is deployed.
        You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/doc-detail/443657.html) operation to query the most recent region list.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable fine-grained monitoring. Valid values:
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The security policy ID. System security policies and custom security policies are supported.

        Valid values: `tls_cipher_policy\\_1\\_0` (default), `tls_cipher_policy\\_1\\_1`, `tls_cipher_policy\\_1\\_2`, `tls_cipher_policy\\_1\\_2\\_strict`, and `tls_cipher_policy\\_1\\_2\\_strict_with\\_1\\_3`.

        > **NOTE:**  This parameter takes effect only for listeners that use SSL over TCP.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The first port in the listener port range. Valid values: `0` to `65535`.

        > **NOTE:**  This parameter is required when `ListenerPort` is set to `0`.
        """
        return pulumi.get(self, "start_port")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `Running`, `Stopped`. When you want to enable this instance, you can set the property value to `Running`;
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

