# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPatchBaselinesResult',
    'AwaitableGetPatchBaselinesResult',
    'get_patch_baselines',
    'get_patch_baselines_output',
]

@pulumi.output_type
class GetPatchBaselinesResult:
    """
    A collection of values returned by getPatchBaselines.
    """
    def __init__(__self__, baselines=None, enable_details=None, id=None, ids=None, name_regex=None, names=None, operation_system=None, output_file=None, share_type=None):
        if baselines and not isinstance(baselines, list):
            raise TypeError("Expected argument 'baselines' to be a list")
        pulumi.set(__self__, "baselines", baselines)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if operation_system and not isinstance(operation_system, str):
            raise TypeError("Expected argument 'operation_system' to be a str")
        pulumi.set(__self__, "operation_system", operation_system)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if share_type and not isinstance(share_type, str):
            raise TypeError("Expected argument 'share_type' to be a str")
        pulumi.set(__self__, "share_type", share_type)

    @_builtins.property
    @pulumi.getter
    def baselines(self) -> Sequence['outputs.GetPatchBaselinesBaselineResult']:
        return pulumi.get(self, "baselines")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="operationSystem")
    def operation_system(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "operation_system")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "share_type")


class AwaitableGetPatchBaselinesResult(GetPatchBaselinesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPatchBaselinesResult(
            baselines=self.baselines,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            operation_system=self.operation_system,
            output_file=self.output_file,
            share_type=self.share_type)


def get_patch_baselines(enable_details: Optional[_builtins.bool] = None,
                        ids: Optional[Sequence[_builtins.str]] = None,
                        name_regex: Optional[_builtins.str] = None,
                        operation_system: Optional[_builtins.str] = None,
                        output_file: Optional[_builtins.str] = None,
                        share_type: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPatchBaselinesResult:
    """
    This data source provides the Oos Patch Baselines of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.146.0+.


    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Patch Baseline IDs. Its element value is same as Patch Baseline Name.
    :param _builtins.str name_regex: A regex string to filter results by Patch Baseline name.
    :param _builtins.str operation_system: Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str share_type: Patch baseline sharing type. Valid values: `Private`, `Public`.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['operationSystem'] = operation_system
    __args__['outputFile'] = output_file
    __args__['shareType'] = share_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:oos/getPatchBaselines:getPatchBaselines', __args__, opts=opts, typ=GetPatchBaselinesResult).value

    return AwaitableGetPatchBaselinesResult(
        baselines=pulumi.get(__ret__, 'baselines'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        operation_system=pulumi.get(__ret__, 'operation_system'),
        output_file=pulumi.get(__ret__, 'output_file'),
        share_type=pulumi.get(__ret__, 'share_type'))
def get_patch_baselines_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               operation_system: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               share_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPatchBaselinesResult]:
    """
    This data source provides the Oos Patch Baselines of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.146.0+.


    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Patch Baseline IDs. Its element value is same as Patch Baseline Name.
    :param _builtins.str name_regex: A regex string to filter results by Patch Baseline name.
    :param _builtins.str operation_system: Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str share_type: Patch baseline sharing type. Valid values: `Private`, `Public`.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['operationSystem'] = operation_system
    __args__['outputFile'] = output_file
    __args__['shareType'] = share_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:oos/getPatchBaselines:getPatchBaselines', __args__, opts=opts, typ=GetPatchBaselinesResult)
    return __ret__.apply(lambda __response__: GetPatchBaselinesResult(
        baselines=pulumi.get(__response__, 'baselines'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        operation_system=pulumi.get(__response__, 'operation_system'),
        output_file=pulumi.get(__response__, 'output_file'),
        share_type=pulumi.get(__response__, 'share_type')))
