# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApplicationGroupsGroupResult',
    'GetApplicationsApplicationResult',
    'GetExecutionsExecutionResult',
    'GetParametersParameterResult',
    'GetPatchBaselinesBaselineResult',
    'GetSecretParametersParameterResult',
    'GetStateConfigurationsConfigurationResult',
    'GetTemplatesTemplateResult',
]

@pulumi.output_type
class GetApplicationGroupsGroupResult(dict):
    def __init__(__self__, *,
                 application_group_name: _builtins.str,
                 application_name: _builtins.str,
                 cms_group_id: _builtins.str,
                 create_time: _builtins.str,
                 deploy_region_id: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 import_tag_key: _builtins.str,
                 import_tag_value: _builtins.str,
                 update_time: _builtins.str):
        """
        :param _builtins.str application_group_name: The name of the Application group.
        :param _builtins.str application_name: The name of the Application.
        :param _builtins.str cms_group_id: The ID of the cloud monitor group.
        :param _builtins.str create_time: The Creation time of the resource.
        :param _builtins.str deploy_region_id: The region ID of the deployment.
        :param _builtins.str description: Application group description information.
        :param _builtins.str id: The ID of the Application Group. Its value is same as Queue Name.
        :param _builtins.str import_tag_key: Label key.
        :param _builtins.str import_tag_value: Label value.
        :param _builtins.str update_time: The Update time of the resource.
        """
        pulumi.set(__self__, "application_group_name", application_group_name)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "cms_group_id", cms_group_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "deploy_region_id", deploy_region_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "import_tag_key", import_tag_key)
        pulumi.set(__self__, "import_tag_value", import_tag_value)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="applicationGroupName")
    def application_group_name(self) -> _builtins.str:
        """
        The name of the Application group.
        """
        return pulumi.get(self, "application_group_name")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        The name of the Application.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="cmsGroupId")
    def cms_group_id(self) -> _builtins.str:
        """
        The ID of the cloud monitor group.
        """
        return pulumi.get(self, "cms_group_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The Creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deployRegionId")
    def deploy_region_id(self) -> _builtins.str:
        """
        The region ID of the deployment.
        """
        return pulumi.get(self, "deploy_region_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Application group description information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Application Group. Its value is same as Queue Name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="importTagKey")
    def import_tag_key(self) -> _builtins.str:
        """
        Label key.
        """
        return pulumi.get(self, "import_tag_key")

    @_builtins.property
    @pulumi.getter(name="importTagValue")
    def import_tag_value(self) -> _builtins.str:
        """
        Label value.
        """
        return pulumi.get(self, "import_tag_value")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The Update time of the resource.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 application_name: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 resource_group_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 update_time: _builtins.str):
        """
        :param _builtins.str application_name: The name of the application.
        :param _builtins.str create_time: The Created time of the application.
        :param _builtins.str description: Application group description information.
        :param _builtins.str id: The ID of the Application. The value is formate as <application_name>.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        :param _builtins.str update_time: The Updated time of the application.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        The name of the application.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The Created time of the application.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Application group description information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Application. The value is formate as <application_name>.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The Updated time of the application.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetExecutionsExecutionResult(dict):
    def __init__(__self__, *,
                 category: _builtins.str,
                 counters: _builtins.str,
                 create_date: _builtins.str,
                 end_date: _builtins.str,
                 executed_by: _builtins.str,
                 execution_id: _builtins.str,
                 id: _builtins.str,
                 is_parent: _builtins.bool,
                 mode: _builtins.str,
                 outputs: _builtins.str,
                 parameters: _builtins.str,
                 parent_execution_id: _builtins.str,
                 ram_role: _builtins.str,
                 start_date: _builtins.str,
                 status: _builtins.str,
                 status_message: _builtins.str,
                 status_reason: _builtins.str,
                 template_id: _builtins.str,
                 template_name: _builtins.str,
                 template_version: _builtins.str,
                 update_date: _builtins.str):
        """
        :param _builtins.str category: The category of template. Valid: `AlarmTrigger`, `EventTrigger`, `Other` and `TimerTrigger`.
        :param _builtins.str counters: The counters of OOS Execution.
        :param _builtins.str create_date: The time when the execution was created.
        :param _builtins.str end_date: The time when the execution was ended.
        :param _builtins.str executed_by: The user who execute the template.
        :param _builtins.str execution_id: ID of the OOS Executions.
        :param _builtins.str id: ID of the OOS Executions.
        :param _builtins.bool is_parent: Whether to include subtasks.
        :param _builtins.str mode: The mode of OOS Execution. Valid: `Automatic`, `Debug`.
        :param _builtins.str outputs: The outputs of OOS Executions.
        :param _builtins.str parameters: The parameters required by the template
        :param _builtins.str parent_execution_id: The id of parent OOS Execution.
        :param _builtins.str ram_role: The role that executes the current template.
        :param _builtins.str start_date: The time when the template was started.
        :param _builtins.str status: The Status of OOS Execution. Valid: `Cancelled`, `Failed`, `Queued`, `Running`, `Started`, `Success`, `Waiting`.
        :param _builtins.str status_message: The message of status.
        :param _builtins.str status_reason: The reason of status.
        :param _builtins.str template_id: The id of execution template.
        :param _builtins.str template_name: The name of execution template.
        :param _builtins.str template_version: The version of execution template.
        :param _builtins.str update_date: The time when the template was updated.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "counters", counters)
        pulumi.set(__self__, "create_date", create_date)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "executed_by", executed_by)
        pulumi.set(__self__, "execution_id", execution_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_parent", is_parent)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "outputs", outputs)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "parent_execution_id", parent_execution_id)
        pulumi.set(__self__, "ram_role", ram_role)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "status_reason", status_reason)
        pulumi.set(__self__, "template_id", template_id)
        pulumi.set(__self__, "template_name", template_name)
        pulumi.set(__self__, "template_version", template_version)
        pulumi.set(__self__, "update_date", update_date)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        The category of template. Valid: `AlarmTrigger`, `EventTrigger`, `Other` and `TimerTrigger`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def counters(self) -> _builtins.str:
        """
        The counters of OOS Execution.
        """
        return pulumi.get(self, "counters")

    @_builtins.property
    @pulumi.getter(name="createDate")
    def create_date(self) -> _builtins.str:
        """
        The time when the execution was created.
        """
        return pulumi.get(self, "create_date")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        """
        The time when the execution was ended.
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="executedBy")
    def executed_by(self) -> _builtins.str:
        """
        The user who execute the template.
        """
        return pulumi.get(self, "executed_by")

    @_builtins.property
    @pulumi.getter(name="executionId")
    def execution_id(self) -> _builtins.str:
        """
        ID of the OOS Executions.
        """
        return pulumi.get(self, "execution_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the OOS Executions.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isParent")
    def is_parent(self) -> _builtins.bool:
        """
        Whether to include subtasks.
        """
        return pulumi.get(self, "is_parent")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The mode of OOS Execution. Valid: `Automatic`, `Debug`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def outputs(self) -> _builtins.str:
        """
        The outputs of OOS Executions.
        """
        return pulumi.get(self, "outputs")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> _builtins.str:
        """
        The parameters required by the template
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="parentExecutionId")
    def parent_execution_id(self) -> _builtins.str:
        """
        The id of parent OOS Execution.
        """
        return pulumi.get(self, "parent_execution_id")

    @_builtins.property
    @pulumi.getter(name="ramRole")
    def ram_role(self) -> _builtins.str:
        """
        The role that executes the current template.
        """
        return pulumi.get(self, "ram_role")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The time when the template was started.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Status of OOS Execution. Valid: `Cancelled`, `Failed`, `Queued`, `Running`, `Started`, `Success`, `Waiting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> _builtins.str:
        """
        The message of status.
        """
        return pulumi.get(self, "status_message")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        The reason of status.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> _builtins.str:
        """
        The id of execution template.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        The name of execution template.
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> _builtins.str:
        """
        The version of execution template.
        """
        return pulumi.get(self, "template_version")

    @_builtins.property
    @pulumi.getter(name="updateDate")
    def update_date(self) -> _builtins.str:
        """
        The time when the template was updated.
        """
        return pulumi.get(self, "update_date")


@pulumi.output_type
class GetParametersParameterResult(dict):
    def __init__(__self__, *,
                 constraints: _builtins.str,
                 create_time: _builtins.str,
                 created_by: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 parameter_id: _builtins.str,
                 parameter_name: _builtins.str,
                 parameter_version: _builtins.int,
                 resource_group_id: _builtins.str,
                 share_type: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 updated_by: _builtins.str,
                 updated_date: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str constraints: The constraints of the common parameter. **Note:** `constraints` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str create_time: The time when the common parameter was created.
        :param _builtins.str created_by: The user who created the common parameter.
        :param _builtins.str description: The description of the common parameter.
        :param _builtins.str id: The ID of the Parameter. Its value is same as `parameter_name`.
        :param _builtins.str parameter_id: The ID of the common parameter.
        :param _builtins.str parameter_name: The name of the common parameter. You can enter a keyword to query parameter names in fuzzy match mode.
        :param _builtins.int parameter_version: The version number of the common parameter.
        :param _builtins.str resource_group_id: The ID of the Resource Group.
        :param _builtins.str share_type: The share type of the common parameter.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str type: The data type of the common parameter. Valid values: `String`, `StringList`.
        :param _builtins.str updated_by: The user who updated the common parameter.
        :param _builtins.str updated_date: The time when the common parameter was updated.
        :param _builtins.str value: (Available since v1.231.0) The value of the common parameter. **Note:** `value` takes effect only if `enable_details` is set to `true`.
        """
        pulumi.set(__self__, "constraints", constraints)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parameter_id", parameter_id)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_version", parameter_version)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_by", updated_by)
        pulumi.set(__self__, "updated_date", updated_date)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> _builtins.str:
        """
        The constraints of the common parameter. **Note:** `constraints` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "constraints")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the common parameter was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The user who created the common parameter.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the common parameter.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Parameter. Its value is same as `parameter_name`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="parameterId")
    def parameter_id(self) -> _builtins.str:
        """
        The ID of the common parameter.
        """
        return pulumi.get(self, "parameter_id")

    @_builtins.property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> _builtins.str:
        """
        The name of the common parameter. You can enter a keyword to query parameter names in fuzzy match mode.
        """
        return pulumi.get(self, "parameter_name")

    @_builtins.property
    @pulumi.getter(name="parameterVersion")
    def parameter_version(self) -> _builtins.int:
        """
        The version number of the common parameter.
        """
        return pulumi.get(self, "parameter_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the Resource Group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        The share type of the common parameter.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The data type of the common parameter. Valid values: `String`, `StringList`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        The user who updated the common parameter.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> _builtins.str:
        """
        The time when the common parameter was updated.
        """
        return pulumi.get(self, "updated_date")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        (Available since v1.231.0) The value of the common parameter. **Note:** `value` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPatchBaselinesBaselineResult(dict):
    def __init__(__self__, *,
                 approval_rules: _builtins.str,
                 create_time: _builtins.str,
                 created_by: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 is_default: _builtins.bool,
                 operation_system: _builtins.str,
                 patch_baseline_id: _builtins.str,
                 patch_baseline_name: _builtins.str,
                 share_type: _builtins.str,
                 updated_by: _builtins.str,
                 updated_date: _builtins.str):
        """
        :param _builtins.str approval_rules: Accept the rules.
        :param _builtins.str create_time: The create time of patch baselines.
        :param _builtins.str created_by: The user who created the patch baselines.
        :param _builtins.str description: Patches baseline description information.
        :param _builtins.str id: The ID of the Patch Baseline. Its value is same as `patch_baseline_name`.
        :param _builtins.bool is_default: Whether it is the default patch baseline.
        :param _builtins.str operation_system: Operating system type.
        :param _builtins.str patch_baseline_id: Patch baseline ID.
        :param _builtins.str patch_baseline_name: The name of the patch baseline.
        :param _builtins.str share_type: Patch baseline sharing type.
        :param _builtins.str updated_by: The user who updated the patch baselines.
        :param _builtins.str updated_date: The update time of patch baselines.
        """
        pulumi.set(__self__, "approval_rules", approval_rules)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "operation_system", operation_system)
        pulumi.set(__self__, "patch_baseline_id", patch_baseline_id)
        pulumi.set(__self__, "patch_baseline_name", patch_baseline_name)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "updated_by", updated_by)
        pulumi.set(__self__, "updated_date", updated_date)

    @_builtins.property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> _builtins.str:
        """
        Accept the rules.
        """
        return pulumi.get(self, "approval_rules")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The create time of patch baselines.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The user who created the patch baselines.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Patches baseline description information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Patch Baseline. Its value is same as `patch_baseline_name`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether it is the default patch baseline.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="operationSystem")
    def operation_system(self) -> _builtins.str:
        """
        Operating system type.
        """
        return pulumi.get(self, "operation_system")

    @_builtins.property
    @pulumi.getter(name="patchBaselineId")
    def patch_baseline_id(self) -> _builtins.str:
        """
        Patch baseline ID.
        """
        return pulumi.get(self, "patch_baseline_id")

    @_builtins.property
    @pulumi.getter(name="patchBaselineName")
    def patch_baseline_name(self) -> _builtins.str:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_name")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        Patch baseline sharing type.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        The user who updated the patch baselines.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> _builtins.str:
        """
        The update time of patch baselines.
        """
        return pulumi.get(self, "updated_date")


@pulumi.output_type
class GetSecretParametersParameterResult(dict):
    def __init__(__self__, *,
                 constraints: _builtins.str,
                 create_time: _builtins.str,
                 created_by: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 key_id: _builtins.str,
                 parameter_version: _builtins.int,
                 resource_group_id: _builtins.str,
                 secret_parameter_id: _builtins.str,
                 secret_parameter_name: _builtins.str,
                 share_type: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 updated_by: _builtins.str,
                 updated_date: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str constraints: The constraints of the encryption parameter. **Note:** `constraints` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str create_time: The time when the encryption parameter was created.
        :param _builtins.str created_by: The user who created the encryption parameter.
        :param _builtins.str description: The description of the encryption parameter.
        :param _builtins.str id: The ID of the Secret Parameter.
        :param _builtins.str key_id: The ID of the key of Key Management Service (KMS) that is used for encryption.
        :param _builtins.int parameter_version: The version number of the encryption parameter.
        :param _builtins.str resource_group_id: The ID of the Resource Group.
        :param _builtins.str secret_parameter_id: The ID of the encryption parameter.
        :param _builtins.str secret_parameter_name: The name of the Secret Parameter.
        :param _builtins.str share_type: The share type of the encryption parameter.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str type: The type of the parameter.
        :param _builtins.str updated_by: The user who updated the encryption parameter.
        :param _builtins.str updated_date: The time when the encryption parameter was updated.
        :param _builtins.str value: (Available since v1.231.0) The value of the encryption parameter. **Note:** `value` takes effect only if `with_decryption` is set to `true`.
        """
        pulumi.set(__self__, "constraints", constraints)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "parameter_version", parameter_version)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "secret_parameter_id", secret_parameter_id)
        pulumi.set(__self__, "secret_parameter_name", secret_parameter_name)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_by", updated_by)
        pulumi.set(__self__, "updated_date", updated_date)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> _builtins.str:
        """
        The constraints of the encryption parameter. **Note:** `constraints` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "constraints")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the encryption parameter was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The user who created the encryption parameter.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the encryption parameter.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Secret Parameter.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The ID of the key of Key Management Service (KMS) that is used for encryption.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="parameterVersion")
    def parameter_version(self) -> _builtins.int:
        """
        The version number of the encryption parameter.
        """
        return pulumi.get(self, "parameter_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the Resource Group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="secretParameterId")
    def secret_parameter_id(self) -> _builtins.str:
        """
        The ID of the encryption parameter.
        """
        return pulumi.get(self, "secret_parameter_id")

    @_builtins.property
    @pulumi.getter(name="secretParameterName")
    def secret_parameter_name(self) -> _builtins.str:
        """
        The name of the Secret Parameter.
        """
        return pulumi.get(self, "secret_parameter_name")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        The share type of the encryption parameter.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the parameter.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        The user who updated the encryption parameter.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> _builtins.str:
        """
        The time when the encryption parameter was updated.
        """
        return pulumi.get(self, "updated_date")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        (Available since v1.231.0) The value of the encryption parameter. **Note:** `value` takes effect only if `with_decryption` is set to `true`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetStateConfigurationsConfigurationResult(dict):
    def __init__(__self__, *,
                 configure_mode: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 parameters: _builtins.str,
                 resource_group_id: _builtins.str,
                 schedule_expression: _builtins.str,
                 schedule_type: _builtins.str,
                 state_configuration_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 targets: _builtins.str,
                 template_id: _builtins.str,
                 template_name: _builtins.str,
                 template_version: _builtins.str,
                 update_time: _builtins.str):
        """
        :param _builtins.str configure_mode: The configuration mode.
        :param _builtins.str create_time: The creation time.
        :param _builtins.str description: The description.
        :param _builtins.str id: The ID of the State Configuration.
        :param _builtins.str parameters: The parameters.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param _builtins.str schedule_expression: The schedule expression.
        :param _builtins.str schedule_type: The schedule type.
        :param _builtins.str state_configuration_id: The ID of the final state configuration.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        :param _builtins.str targets: The target resource.
        :param _builtins.str template_id: The ID of the template.
        :param _builtins.str template_name: The name of the template.
        :param _builtins.str template_version: The version of the template.
        :param _builtins.str update_time: The time when the configuration is updated.
        """
        pulumi.set(__self__, "configure_mode", configure_mode)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        pulumi.set(__self__, "schedule_type", schedule_type)
        pulumi.set(__self__, "state_configuration_id", state_configuration_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "template_id", template_id)
        pulumi.set(__self__, "template_name", template_name)
        pulumi.set(__self__, "template_version", template_version)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="configureMode")
    def configure_mode(self) -> _builtins.str:
        """
        The configuration mode.
        """
        return pulumi.get(self, "configure_mode")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the State Configuration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> _builtins.str:
        """
        The parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> _builtins.str:
        """
        The schedule expression.
        """
        return pulumi.get(self, "schedule_expression")

    @_builtins.property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> _builtins.str:
        """
        The schedule type.
        """
        return pulumi.get(self, "schedule_type")

    @_builtins.property
    @pulumi.getter(name="stateConfigurationId")
    def state_configuration_id(self) -> _builtins.str:
        """
        The ID of the final state configuration.
        """
        return pulumi.get(self, "state_configuration_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> _builtins.str:
        """
        The target resource.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> _builtins.str:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> _builtins.str:
        """
        The version of the template.
        """
        return pulumi.get(self, "template_version")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time when the configuration is updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetTemplatesTemplateResult(dict):
    def __init__(__self__, *,
                 category: _builtins.str,
                 created_by: _builtins.str,
                 created_date: _builtins.str,
                 description: _builtins.str,
                 has_trigger: _builtins.bool,
                 id: _builtins.str,
                 share_type: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 template_format: _builtins.str,
                 template_id: _builtins.str,
                 template_name: _builtins.str,
                 template_type: _builtins.str,
                 template_version: _builtins.str,
                 updated_by: _builtins.str,
                 updated_date: _builtins.str):
        """
        :param _builtins.str category: The category of template.
        :param _builtins.str created_by: The creator of the template.
        :param _builtins.str created_date: The template whose creation time is less than or equal to the specified time. The format is: YYYY-MM-DDThh:mm::ssZ.
        :param _builtins.str description: Description of the OOS Template.
        :param _builtins.bool has_trigger: Is it triggered successfully.
        :param _builtins.str id: ID of the OOS Template. The value is same as template_name.
        :param _builtins.str share_type: The sharing type of the template. Valid values: `Private`, `Public`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str template_format: The format of the template. Valid values: `JSON`, `YAML`.
        :param _builtins.str template_id: ID of the OOS Template resource.
        :param _builtins.str template_name: Name of the OOS Template.
        :param _builtins.str template_type: The type of OOS Template.
        :param _builtins.str template_version: Version of the OOS Template.
        :param _builtins.str updated_by: The user who updated the template.
        :param _builtins.str updated_date: The time when the template was updated.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "has_trigger", has_trigger)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "template_format", template_format)
        pulumi.set(__self__, "template_id", template_id)
        pulumi.set(__self__, "template_name", template_name)
        pulumi.set(__self__, "template_type", template_type)
        pulumi.set(__self__, "template_version", template_version)
        pulumi.set(__self__, "updated_by", updated_by)
        pulumi.set(__self__, "updated_date", updated_date)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        The category of template.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The creator of the template.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        The template whose creation time is less than or equal to the specified time. The format is: YYYY-MM-DDThh:mm::ssZ.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the OOS Template.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hasTrigger")
    def has_trigger(self) -> _builtins.bool:
        """
        Is it triggered successfully.
        """
        return pulumi.get(self, "has_trigger")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the OOS Template. The value is same as template_name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        The sharing type of the template. Valid values: `Private`, `Public`.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateFormat")
    def template_format(self) -> _builtins.str:
        """
        The format of the template. Valid values: `JSON`, `YAML`.
        """
        return pulumi.get(self, "template_format")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> _builtins.str:
        """
        ID of the OOS Template resource.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        Name of the OOS Template.
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> _builtins.str:
        """
        The type of OOS Template.
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> _builtins.str:
        """
        Version of the OOS Template.
        """
        return pulumi.get(self, "template_version")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        The user who updated the template.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> _builtins.str:
        """
        The time when the template was updated.
        """
        return pulumi.get(self, "updated_date")


