# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketStyleArgs', 'BucketStyle']

@pulumi.input_type
class BucketStyleArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 content: pulumi.Input[_builtins.str],
                 style_name: pulumi.Input[_builtins.str],
                 category: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketStyle resource.
        :param pulumi.Input[_builtins.str] bucket: Storage space to which the picture style belongs
        :param pulumi.Input[_builtins.str] content: The Image style content can contain single or multiple image processing parameters.
        :param pulumi.Input[_builtins.str] style_name: Image Style Name
        :param pulumi.Input[_builtins.str] category: Style category, valid values: image, document, video.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "style_name", style_name)
        if category is not None:
            pulumi.set(__self__, "category", category)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Storage space to which the picture style belongs
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The Image style content can contain single or multiple image processing parameters.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="styleName")
    def style_name(self) -> pulumi.Input[_builtins.str]:
        """
        Image Style Name
        """
        return pulumi.get(self, "style_name")

    @style_name.setter
    def style_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "style_name", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Style category, valid values: image, document, video.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)


@pulumi.input_type
class _BucketStyleState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 style_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketStyle resources.
        :param pulumi.Input[_builtins.str] bucket: Storage space to which the picture style belongs
        :param pulumi.Input[_builtins.str] category: Style category, valid values: image, document, video.
        :param pulumi.Input[_builtins.str] content: The Image style content can contain single or multiple image processing parameters.
        :param pulumi.Input[_builtins.str] create_time: Image Style Creation Time
        :param pulumi.Input[_builtins.str] style_name: Image Style Name
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if style_name is not None:
            pulumi.set(__self__, "style_name", style_name)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage space to which the picture style belongs
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Style category, valid values: image, document, video.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Image style content can contain single or multiple image processing parameters.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image Style Creation Time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="styleName")
    def style_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image Style Name
        """
        return pulumi.get(self, "style_name")

    @style_name.setter
    def style_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "style_name", value)


@pulumi.type_token("alicloud:oss/bucketStyle:BucketStyle")
class BucketStyle(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 style_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a OSS Bucket Style resource.

        Image styles that contain single or multiple image processing parameters.

        For information about OSS Bucket Style and how to use it, see [What is Bucket Style](https://next.api.alibabacloud.com/document/Oss/2019-05-17/PutStyle).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        default_bucket_style = alicloud.oss.BucketStyle("default",
            bucket=create_bucket.id,
            style_name="style-933",
            content="image/resize,p_75,w_75",
            category="document")
        ```

        ## Import

        OSS Bucket Style can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketStyle:BucketStyle example <bucket>:<style_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Storage space to which the picture style belongs
        :param pulumi.Input[_builtins.str] category: Style category, valid values: image, document, video.
        :param pulumi.Input[_builtins.str] content: The Image style content can contain single or multiple image processing parameters.
        :param pulumi.Input[_builtins.str] style_name: Image Style Name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketStyleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OSS Bucket Style resource.

        Image styles that contain single or multiple image processing parameters.

        For information about OSS Bucket Style and how to use it, see [What is Bucket Style](https://next.api.alibabacloud.com/document/Oss/2019-05-17/PutStyle).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        default_bucket_style = alicloud.oss.BucketStyle("default",
            bucket=create_bucket.id,
            style_name="style-933",
            content="image/resize,p_75,w_75",
            category="document")
        ```

        ## Import

        OSS Bucket Style can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketStyle:BucketStyle example <bucket>:<style_name>
        ```

        :param str resource_name: The name of the resource.
        :param BucketStyleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketStyleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 style_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketStyleArgs.__new__(BucketStyleArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["category"] = category
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if style_name is None and not opts.urn:
                raise TypeError("Missing required property 'style_name'")
            __props__.__dict__["style_name"] = style_name
            __props__.__dict__["create_time"] = None
        super(BucketStyle, __self__).__init__(
            'alicloud:oss/bucketStyle:BucketStyle',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            style_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketStyle':
        """
        Get an existing BucketStyle resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Storage space to which the picture style belongs
        :param pulumi.Input[_builtins.str] category: Style category, valid values: image, document, video.
        :param pulumi.Input[_builtins.str] content: The Image style content can contain single or multiple image processing parameters.
        :param pulumi.Input[_builtins.str] create_time: Image Style Creation Time
        :param pulumi.Input[_builtins.str] style_name: Image Style Name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketStyleState.__new__(_BucketStyleState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["category"] = category
        __props__.__dict__["content"] = content
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["style_name"] = style_name
        return BucketStyle(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Storage space to which the picture style belongs
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Style category, valid values: image, document, video.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The Image style content can contain single or multiple image processing parameters.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Image Style Creation Time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="styleName")
    def style_name(self) -> pulumi.Output[_builtins.str]:
        """
        Image Style Name
        """
        return pulumi.get(self, "style_name")

