# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceRunArgs', 'WorkspaceRun']

@pulumi.input_type
class WorkspaceRunArgs:
    def __init__(__self__, *,
                 experiment_id: pulumi.Input[_builtins.str],
                 run_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceRun resource.
        :param pulumi.Input[_builtins.str] experiment_id: Resource attribute field of the experiment ID to which Run belongs
        :param pulumi.Input[_builtins.str] run_name: The name of the resource
        :param pulumi.Input[_builtins.str] source_id: Attribute Resource field representing the source task ID
        :param pulumi.Input[_builtins.str] source_type: Resource attribute fields representing the source type
        """
        pulumi.set(__self__, "experiment_id", experiment_id)
        if run_name is not None:
            pulumi.set(__self__, "run_name", run_name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource attribute field of the experiment ID to which Run belongs
        """
        return pulumi.get(self, "experiment_id")

    @experiment_id.setter
    def experiment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "experiment_id", value)

    @_builtins.property
    @pulumi.getter(name="runName")
    def run_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "run_name")

    @run_name.setter
    def run_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute Resource field representing the source task ID
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute fields representing the source type
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)


@pulumi.input_type
class _WorkspaceRunState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceRun resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] experiment_id: Resource attribute field of the experiment ID to which Run belongs
        :param pulumi.Input[_builtins.str] run_name: The name of the resource
        :param pulumi.Input[_builtins.str] source_id: Attribute Resource field representing the source task ID
        :param pulumi.Input[_builtins.str] source_type: Resource attribute fields representing the source type
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if experiment_id is not None:
            pulumi.set(__self__, "experiment_id", experiment_id)
        if run_name is not None:
            pulumi.set(__self__, "run_name", run_name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute field of the experiment ID to which Run belongs
        """
        return pulumi.get(self, "experiment_id")

    @experiment_id.setter
    def experiment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "experiment_id", value)

    @_builtins.property
    @pulumi.getter(name="runName")
    def run_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "run_name")

    @run_name.setter
    def run_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute Resource field representing the source task ID
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute fields representing the source type
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)


@pulumi.type_token("alicloud:pai/workspaceRun:WorkspaceRun")
class WorkspaceRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace Run resource.

        For information about PAI Workspace Run and how to use it, see [What is Run](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateRun).

        > **NOTE:** Available since v1.236.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_caf_ua9 = alicloud.pai.WorkspaceWorkspace("defaultCAFUa9",
            description=name,
            display_name=name,
            workspace_name=name,
            env_types=["prod"])
        default_q_rw_wbv = alicloud.pai.WorkspaceExperiment("defaultQRwWbv",
            accessibility="PRIVATE",
            artifact_uri="oss://example.oss-cn-hangzhou.aliyuncs.com/example/",
            experiment_name=std.format(input="%s1",
                args=[name]).result,
            workspace_id=default_caf_ua9.id)
        default = alicloud.pai.WorkspaceRun("default",
            source_type="TrainingService",
            source_id="759",
            run_name=name,
            experiment_id=default_q_rw_wbv.id)
        ```

        ## Import

        PAI Workspace Run can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceRun:WorkspaceRun example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] experiment_id: Resource attribute field of the experiment ID to which Run belongs
        :param pulumi.Input[_builtins.str] run_name: The name of the resource
        :param pulumi.Input[_builtins.str] source_id: Attribute Resource field representing the source task ID
        :param pulumi.Input[_builtins.str] source_type: Resource attribute fields representing the source type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace Run resource.

        For information about PAI Workspace Run and how to use it, see [What is Run](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateRun).

        > **NOTE:** Available since v1.236.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_caf_ua9 = alicloud.pai.WorkspaceWorkspace("defaultCAFUa9",
            description=name,
            display_name=name,
            workspace_name=name,
            env_types=["prod"])
        default_q_rw_wbv = alicloud.pai.WorkspaceExperiment("defaultQRwWbv",
            accessibility="PRIVATE",
            artifact_uri="oss://example.oss-cn-hangzhou.aliyuncs.com/example/",
            experiment_name=std.format(input="%s1",
                args=[name]).result,
            workspace_id=default_caf_ua9.id)
        default = alicloud.pai.WorkspaceRun("default",
            source_type="TrainingService",
            source_id="759",
            run_name=name,
            experiment_id=default_q_rw_wbv.id)
        ```

        ## Import

        PAI Workspace Run can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceRun:WorkspaceRun example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceRunArgs.__new__(WorkspaceRunArgs)

            if experiment_id is None and not opts.urn:
                raise TypeError("Missing required property 'experiment_id'")
            __props__.__dict__["experiment_id"] = experiment_id
            __props__.__dict__["run_name"] = run_name
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["create_time"] = None
        super(WorkspaceRun, __self__).__init__(
            'alicloud:pai/workspaceRun:WorkspaceRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            experiment_id: Optional[pulumi.Input[_builtins.str]] = None,
            run_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceRun':
        """
        Get an existing WorkspaceRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] experiment_id: Resource attribute field of the experiment ID to which Run belongs
        :param pulumi.Input[_builtins.str] run_name: The name of the resource
        :param pulumi.Input[_builtins.str] source_id: Attribute Resource field representing the source task ID
        :param pulumi.Input[_builtins.str] source_type: Resource attribute fields representing the source type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceRunState.__new__(_WorkspaceRunState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["experiment_id"] = experiment_id
        __props__.__dict__["run_name"] = run_name
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["source_type"] = source_type
        return WorkspaceRun(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="experimentId")
    def experiment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource attribute field of the experiment ID to which Run belongs
        """
        return pulumi.get(self, "experiment_id")

    @_builtins.property
    @pulumi.getter(name="runName")
    def run_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "run_name")

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Attribute Resource field representing the source task ID
        """
        return pulumi.get(self, "source_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource attribute fields representing the source type
        """
        return pulumi.get(self, "source_type")

