# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceUserConfigArgs', 'WorkspaceUserConfig']

@pulumi.input_type
class WorkspaceUserConfigArgs:
    def __init__(__self__, *,
                 category_name: pulumi.Input[_builtins.str],
                 config_key: pulumi.Input[_builtins.str],
                 config_value: pulumi.Input[_builtins.str],
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceUserConfig resource.
        :param pulumi.Input[_builtins.str] category_name: The category. Valid values: `DataPrivacyConfig`.
        :param pulumi.Input[_builtins.str] config_key: The key of the configuration.
        :param pulumi.Input[_builtins.str] config_value: The value of the configuration.
        :param pulumi.Input[_builtins.str] scope: The scope. Default value: `owner`. Valid values: `owner`, `subUser`.
        """
        pulumi.set(__self__, "category_name", category_name)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "config_value", config_value)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="categoryName")
    def category_name(self) -> pulumi.Input[_builtins.str]:
        """
        The category. Valid values: `DataPrivacyConfig`.
        """
        return pulumi.get(self, "category_name")

    @category_name.setter
    def category_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category_name", value)

    @_builtins.property
    @pulumi.getter(name="configKey")
    def config_key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the configuration.
        """
        return pulumi.get(self, "config_key")

    @config_key.setter
    def config_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_key", value)

    @_builtins.property
    @pulumi.getter(name="configValue")
    def config_value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the configuration.
        """
        return pulumi.get(self, "config_value")

    @config_value.setter
    def config_value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_value", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope. Default value: `owner`. Valid values: `owner`, `subUser`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _WorkspaceUserConfigState:
    def __init__(__self__, *,
                 category_name: Optional[pulumi.Input[_builtins.str]] = None,
                 config_key: Optional[pulumi.Input[_builtins.str]] = None,
                 config_value: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceUserConfig resources.
        :param pulumi.Input[_builtins.str] category_name: The category. Valid values: `DataPrivacyConfig`.
        :param pulumi.Input[_builtins.str] config_key: The key of the configuration.
        :param pulumi.Input[_builtins.str] config_value: The value of the configuration.
        :param pulumi.Input[_builtins.str] scope: The scope. Default value: `owner`. Valid values: `owner`, `subUser`.
        """
        if category_name is not None:
            pulumi.set(__self__, "category_name", category_name)
        if config_key is not None:
            pulumi.set(__self__, "config_key", config_key)
        if config_value is not None:
            pulumi.set(__self__, "config_value", config_value)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="categoryName")
    def category_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category. Valid values: `DataPrivacyConfig`.
        """
        return pulumi.get(self, "category_name")

    @category_name.setter
    def category_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category_name", value)

    @_builtins.property
    @pulumi.getter(name="configKey")
    def config_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the configuration.
        """
        return pulumi.get(self, "config_key")

    @config_key.setter
    def config_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_key", value)

    @_builtins.property
    @pulumi.getter(name="configValue")
    def config_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the configuration.
        """
        return pulumi.get(self, "config_value")

    @config_value.setter
    def config_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_value", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope. Default value: `owner`. Valid values: `owner`, `subUser`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("alicloud:pai/workspaceUserConfig:WorkspaceUserConfig")
class WorkspaceUserConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category_name: Optional[pulumi.Input[_builtins.str]] = None,
                 config_key: Optional[pulumi.Input[_builtins.str]] = None,
                 config_value: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace User Config resource.

        For information about PAI Workspace User Config and how to use it, see [What is User Config](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-setuserconfigs).

        > **NOTE:** Available since v1.250.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.pai.WorkspaceUserConfig("default",
            category_name="DataPrivacyConfig",
            config_key="customizePAIAssumedRole",
            config_value=name)
        ```

        ## Import

        PAI Workspace User Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceUserConfig:WorkspaceUserConfig example <category_name>:<config_key>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category_name: The category. Valid values: `DataPrivacyConfig`.
        :param pulumi.Input[_builtins.str] config_key: The key of the configuration.
        :param pulumi.Input[_builtins.str] config_value: The value of the configuration.
        :param pulumi.Input[_builtins.str] scope: The scope. Default value: `owner`. Valid values: `owner`, `subUser`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceUserConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace User Config resource.

        For information about PAI Workspace User Config and how to use it, see [What is User Config](https://www.alibabacloud.com/help/en/pai/developer-reference/api-aiworkspace-2021-02-04-setuserconfigs).

        > **NOTE:** Available since v1.250.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.pai.WorkspaceUserConfig("default",
            category_name="DataPrivacyConfig",
            config_key="customizePAIAssumedRole",
            config_value=name)
        ```

        ## Import

        PAI Workspace User Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceUserConfig:WorkspaceUserConfig example <category_name>:<config_key>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceUserConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceUserConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category_name: Optional[pulumi.Input[_builtins.str]] = None,
                 config_key: Optional[pulumi.Input[_builtins.str]] = None,
                 config_value: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceUserConfigArgs.__new__(WorkspaceUserConfigArgs)

            if category_name is None and not opts.urn:
                raise TypeError("Missing required property 'category_name'")
            __props__.__dict__["category_name"] = category_name
            if config_key is None and not opts.urn:
                raise TypeError("Missing required property 'config_key'")
            __props__.__dict__["config_key"] = config_key
            if config_value is None and not opts.urn:
                raise TypeError("Missing required property 'config_value'")
            __props__.__dict__["config_value"] = config_value
            __props__.__dict__["scope"] = scope
        super(WorkspaceUserConfig, __self__).__init__(
            'alicloud:pai/workspaceUserConfig:WorkspaceUserConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category_name: Optional[pulumi.Input[_builtins.str]] = None,
            config_key: Optional[pulumi.Input[_builtins.str]] = None,
            config_value: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceUserConfig':
        """
        Get an existing WorkspaceUserConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category_name: The category. Valid values: `DataPrivacyConfig`.
        :param pulumi.Input[_builtins.str] config_key: The key of the configuration.
        :param pulumi.Input[_builtins.str] config_value: The value of the configuration.
        :param pulumi.Input[_builtins.str] scope: The scope. Default value: `owner`. Valid values: `owner`, `subUser`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceUserConfigState.__new__(_WorkspaceUserConfigState)

        __props__.__dict__["category_name"] = category_name
        __props__.__dict__["config_key"] = config_key
        __props__.__dict__["config_value"] = config_value
        __props__.__dict__["scope"] = scope
        return WorkspaceUserConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="categoryName")
    def category_name(self) -> pulumi.Output[_builtins.str]:
        """
        The category. Valid values: `DataPrivacyConfig`.
        """
        return pulumi.get(self, "category_name")

    @_builtins.property
    @pulumi.getter(name="configKey")
    def config_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the configuration.
        """
        return pulumi.get(self, "config_key")

    @_builtins.property
    @pulumi.getter(name="configValue")
    def config_value(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the configuration.
        """
        return pulumi.get(self, "config_value")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        The scope. Default value: `owner`. Valid values: `owner`, `subUser`.
        """
        return pulumi.get(self, "scope")

