# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountPrivilegeArgs', 'AccountPrivilege']

@pulumi.input_type
class AccountPrivilegeArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 db_cluster_id: pulumi.Input[_builtins.str],
                 db_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 account_privilege: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountPrivilege resource.
        :param pulumi.Input[_builtins.str] account_name: A specified account name.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_names: List of specified database name.
        :param pulumi.Input[_builtins.str] account_privilege: The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        pulumi.set(__self__, "db_names", db_names)
        if account_privilege is not None:
            pulumi.set(__self__, "account_privilege", account_privilege)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        A specified account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of cluster in which account belongs.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbNames")
    def db_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of specified database name.
        """
        return pulumi.get(self, "db_names")

    @db_names.setter
    def db_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "db_names", value)

    @_builtins.property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
        """
        return pulumi.get(self, "account_privilege")

    @account_privilege.setter
    def account_privilege(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_privilege", value)


@pulumi.input_type
class _AccountPrivilegeState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AccountPrivilege resources.
        :param pulumi.Input[_builtins.str] account_name: A specified account name.
        :param pulumi.Input[_builtins.str] account_privilege: The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_names: List of specified database name.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_privilege is not None:
            pulumi.set(__self__, "account_privilege", account_privilege)
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if db_names is not None:
            pulumi.set(__self__, "db_names", db_names)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A specified account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
        """
        return pulumi.get(self, "account_privilege")

    @account_privilege.setter
    def account_privilege(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_privilege", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of cluster in which account belongs.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbNames")
    def db_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of specified database name.
        """
        return pulumi.get(self, "db_names")

    @db_names.setter
    def db_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_names", value)


@pulumi.type_token("alicloud:polardb/accountPrivilege:AccountPrivilege")
class AccountPrivilege(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a PolarDB account privilege resource and used to grant several database some access privilege. A database can be granted by multiple account.

        > **NOTE:** Available in v1.67.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            pay_type="PostPaid",
            category="Normal")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("default",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_account = alicloud.polardb.Account("default",
            db_cluster_id=default_cluster.id,
            account_name="terraform_example",
            account_password="Example1234",
            account_description="terraform-example")
        default_database = alicloud.polardb.Database("default",
            db_cluster_id=default_cluster.id,
            db_name="terraform-example")
        default_account_privilege = alicloud.polardb.AccountPrivilege("default",
            db_cluster_id=default_cluster.id,
            account_name=default_account.account_name,
            account_privilege="ReadOnly",
            db_names=[default_database.db_name])
        ```

        ## Import

        PolarDB account privilege can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/accountPrivilege:AccountPrivilege example "pc-12345:tf_account:ReadOnly"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: A specified account name.
        :param pulumi.Input[_builtins.str] account_privilege: The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_names: List of specified database name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountPrivilegeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PolarDB account privilege resource and used to grant several database some access privilege. A database can be granted by multiple account.

        > **NOTE:** Available in v1.67.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            pay_type="PostPaid",
            category="Normal")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("default",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_account = alicloud.polardb.Account("default",
            db_cluster_id=default_cluster.id,
            account_name="terraform_example",
            account_password="Example1234",
            account_description="terraform-example")
        default_database = alicloud.polardb.Database("default",
            db_cluster_id=default_cluster.id,
            db_name="terraform-example")
        default_account_privilege = alicloud.polardb.AccountPrivilege("default",
            db_cluster_id=default_cluster.id,
            account_name=default_account.account_name,
            account_privilege="ReadOnly",
            db_names=[default_database.db_name])
        ```

        ## Import

        PolarDB account privilege can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/accountPrivilege:AccountPrivilege example "pc-12345:tf_account:ReadOnly"
        ```

        :param str resource_name: The name of the resource.
        :param AccountPrivilegeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountPrivilegeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountPrivilegeArgs.__new__(AccountPrivilegeArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["account_privilege"] = account_privilege
            if db_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_id'")
            __props__.__dict__["db_cluster_id"] = db_cluster_id
            if db_names is None and not opts.urn:
                raise TypeError("Missing required property 'db_names'")
            __props__.__dict__["db_names"] = db_names
        super(AccountPrivilege, __self__).__init__(
            'alicloud:polardb/accountPrivilege:AccountPrivilege',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            account_privilege: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AccountPrivilege':
        """
        Get an existing AccountPrivilege resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: A specified account name.
        :param pulumi.Input[_builtins.str] account_privilege: The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_names: List of specified database name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountPrivilegeState.__new__(_AccountPrivilegeState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_privilege"] = account_privilege
        __props__.__dict__["db_cluster_id"] = db_cluster_id
        __props__.__dict__["db_names"] = db_names
        return AccountPrivilege(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        A specified account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
        """
        return pulumi.get(self, "account_privilege")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of cluster in which account belongs.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbNames")
    def db_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of specified database name.
        """
        return pulumi.get(self, "db_names")

