# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcEndpointServiceResourcesResult',
    'AwaitableGetVpcEndpointServiceResourcesResult',
    'get_vpc_endpoint_service_resources',
    'get_vpc_endpoint_service_resources_output',
]

@pulumi.output_type
class GetVpcEndpointServiceResourcesResult:
    """
    A collection of values returned by getVpcEndpointServiceResources.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, resources=None, service_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Vpc Endpoint Service Resource IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetVpcEndpointServiceResourcesResourceResult']:
        """
        A list of Privatelink Vpc Endpoint Service Resources. Each element contains the following attributes:
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        return pulumi.get(self, "service_id")


class AwaitableGetVpcEndpointServiceResourcesResult(GetVpcEndpointServiceResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcEndpointServiceResourcesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            resources=self.resources,
            service_id=self.service_id)


def get_vpc_endpoint_service_resources(output_file: Optional[_builtins.str] = None,
                                       service_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcEndpointServiceResourcesResult:
    """
    This data source provides the Privatelink Vpc Endpoint Service Resources of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.110.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.privatelink.get_vpc_endpoint_service_resources(service_id="epsrv-gw8ii1xxxx")
    pulumi.export("firstPrivatelinkVpcEndpointServiceResourceId", example.resources[0].id)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str service_id: The ID of Vpc Endpoint Service.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:privatelink/getVpcEndpointServiceResources:getVpcEndpointServiceResources', __args__, opts=opts, typ=GetVpcEndpointServiceResourcesResult).value

    return AwaitableGetVpcEndpointServiceResourcesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resources=pulumi.get(__ret__, 'resources'),
        service_id=pulumi.get(__ret__, 'service_id'))
def get_vpc_endpoint_service_resources_output(output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              service_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcEndpointServiceResourcesResult]:
    """
    This data source provides the Privatelink Vpc Endpoint Service Resources of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.110.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.privatelink.get_vpc_endpoint_service_resources(service_id="epsrv-gw8ii1xxxx")
    pulumi.export("firstPrivatelinkVpcEndpointServiceResourceId", example.resources[0].id)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str service_id: The ID of Vpc Endpoint Service.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:privatelink/getVpcEndpointServiceResources:getVpcEndpointServiceResources', __args__, opts=opts, typ=GetVpcEndpointServiceResourcesResult)
    return __ret__.apply(lambda __response__: GetVpcEndpointServiceResourcesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        resources=pulumi.get(__response__, 'resources'),
        service_id=pulumi.get(__response__, 'service_id')))
