# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 endpoint_name: pulumi.Input[_builtins.str],
                 ip_configs: pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]],
                 security_group_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vpc_region_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vpc_region_id: The Region of the VPC.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "ip_configs", ip_configs)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_region_id", vpc_region_id)

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]:
        """
        The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        """
        return pulumi.get(self, "ip_configs")

    @ip_configs.setter
    def ip_configs(self, value: pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]):
        pulumi.set(self, "ip_configs", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Security Group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcRegionId")
    def vpc_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Region of the VPC.
        """
        return pulumi.get(self, "vpc_region_id")

    @vpc_region_id.setter
    def vpc_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_region_id", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_region_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vpc_region_id: The Region of the VPC.
        """
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if ip_configs is not None:
            pulumi.set(__self__, "ip_configs", ip_configs)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_region_id is not None:
            pulumi.set(__self__, "vpc_region_id", vpc_region_id)

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]]:
        """
        The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        """
        return pulumi.get(self, "ip_configs")

    @ip_configs.setter
    def ip_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]]):
        pulumi.set(self, "ip_configs", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Security Group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcRegionId")
    def vpc_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region of the VPC.
        """
        return pulumi.get(self, "vpc_region_id")

    @vpc_region_id.setter
    def vpc_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_region_id", value)


@pulumi.type_token("alicloud:pvtz/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigArgs', 'EndpointIpConfigArgsDict']]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Private Zone Endpoint resource.

        For information about Private Zone Endpoint and how to use it, see [What is Endpoint](https://www.alibabacloud.com/help/en/privatezone/latest/add-endpoint).

        > **NOTE:** Available since v1.143.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "example_name"
        default = alicloud.pvtz.get_resolver_zones(status="NORMAL")
        default_get_regions = alicloud.get_regions(current=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
                vpc_id=default_network.id,
                cidr_block=default_network.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                    newbits=8,
                    netnum=range["value"])).apply(lambda invoke: invoke.result),
                zone_id=default.zones[range["value"]].zone_id))
        default_security_group = alicloud.ecs.SecurityGroup("default",
            vpc_id=default_network.id,
            name=name)
        default_endpoint = alicloud.pvtz.Endpoint("default",
            endpoint_name=name,
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vpc_region_id=default_get_regions.regions[0].id,
            ip_configs=[
                {
                    "zone_id": default_switch[0].zone_id,
                    "cidr_block": default_switch[0].cidr_block,
                    "vswitch_id": default_switch[0].id,
                },
                {
                    "zone_id": default_switch[1].zone_id,
                    "cidr_block": default_switch[1].cidr_block,
                    "vswitch_id": default_switch[1].id,
                },
            ])
        ```

        ## Import

        Private Zone Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pvtz/endpoint:Endpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigArgs', 'EndpointIpConfigArgsDict']]]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vpc_region_id: The Region of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Private Zone Endpoint resource.

        For information about Private Zone Endpoint and how to use it, see [What is Endpoint](https://www.alibabacloud.com/help/en/privatezone/latest/add-endpoint).

        > **NOTE:** Available since v1.143.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "example_name"
        default = alicloud.pvtz.get_resolver_zones(status="NORMAL")
        default_get_regions = alicloud.get_regions(current=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
                vpc_id=default_network.id,
                cidr_block=default_network.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                    newbits=8,
                    netnum=range["value"])).apply(lambda invoke: invoke.result),
                zone_id=default.zones[range["value"]].zone_id))
        default_security_group = alicloud.ecs.SecurityGroup("default",
            vpc_id=default_network.id,
            name=name)
        default_endpoint = alicloud.pvtz.Endpoint("default",
            endpoint_name=name,
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vpc_region_id=default_get_regions.regions[0].id,
            ip_configs=[
                {
                    "zone_id": default_switch[0].zone_id,
                    "cidr_block": default_switch[0].cidr_block,
                    "vswitch_id": default_switch[0].id,
                },
                {
                    "zone_id": default_switch[1].zone_id,
                    "cidr_block": default_switch[1].cidr_block,
                    "vswitch_id": default_switch[1].id,
                },
            ])
        ```

        ## Import

        Private Zone Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pvtz/endpoint:Endpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigArgs', 'EndpointIpConfigArgsDict']]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__.__dict__["endpoint_name"] = endpoint_name
            if ip_configs is None and not opts.urn:
                raise TypeError("Missing required property 'ip_configs'")
            __props__.__dict__["ip_configs"] = ip_configs
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vpc_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_region_id'")
            __props__.__dict__["vpc_region_id"] = vpc_region_id
            __props__.__dict__["status"] = None
        super(Endpoint, __self__).__init__(
            'alicloud:pvtz/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigArgs', 'EndpointIpConfigArgsDict']]]]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_region_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigArgs', 'EndpointIpConfigArgsDict']]]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vpc_region_id: The Region of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["ip_configs"] = ip_configs
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_region_id"] = vpc_region_id
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "endpoint_name")

    @_builtins.property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> pulumi.Output[Sequence['outputs.EndpointIpConfig']]:
        """
        The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        """
        return pulumi.get(self, "ip_configs")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Security Group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcRegionId")
    def vpc_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Region of the VPC.
        """
        return pulumi.get(self, "vpc_region_id")

