# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTemplateApplicationsResult',
    'AwaitableGetTemplateApplicationsResult',
    'get_template_applications',
    'get_template_applications_output',
]

@pulumi.output_type
class GetTemplateApplicationsResult:
    """
    A collection of values returned by getTemplateApplications.
    """
    def __init__(__self__, applications=None, batch_quota_application_id=None, id=None, ids=None, output_file=None, product_code=None, quota_action_code=None, quota_category=None):
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if batch_quota_application_id and not isinstance(batch_quota_application_id, str):
            raise TypeError("Expected argument 'batch_quota_application_id' to be a str")
        pulumi.set(__self__, "batch_quota_application_id", batch_quota_application_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if product_code and not isinstance(product_code, str):
            raise TypeError("Expected argument 'product_code' to be a str")
        pulumi.set(__self__, "product_code", product_code)
        if quota_action_code and not isinstance(quota_action_code, str):
            raise TypeError("Expected argument 'quota_action_code' to be a str")
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        if quota_category and not isinstance(quota_category, str):
            raise TypeError("Expected argument 'quota_category' to be a str")
        pulumi.set(__self__, "quota_category", quota_category)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.GetTemplateApplicationsApplicationResult']:
        """
        A list of Template Applications Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="batchQuotaApplicationId")
    def batch_quota_application_id(self) -> Optional[_builtins.str]:
        """
        The ID of the quota application batch.
        """
        return pulumi.get(self, "batch_quota_application_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Template Applications IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[_builtins.str]:
        """
        Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        """
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> Optional[_builtins.str]:
        """
        The quota ID.
        """
        return pulumi.get(self, "quota_action_code")

    @_builtins.property
    @pulumi.getter(name="quotaCategory")
    def quota_category(self) -> Optional[_builtins.str]:
        """
        The quota type. Value:-CommonQuota (default): Generic quota.-FlowControl:API rate quota.-WhiteListLabel: Equity quota.
        """
        return pulumi.get(self, "quota_category")


class AwaitableGetTemplateApplicationsResult(GetTemplateApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplateApplicationsResult(
            applications=self.applications,
            batch_quota_application_id=self.batch_quota_application_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            product_code=self.product_code,
            quota_action_code=self.quota_action_code,
            quota_category=self.quota_category)


def get_template_applications(batch_quota_application_id: Optional[_builtins.str] = None,
                              ids: Optional[Sequence[_builtins.str]] = None,
                              output_file: Optional[_builtins.str] = None,
                              product_code: Optional[_builtins.str] = None,
                              quota_action_code: Optional[_builtins.str] = None,
                              quota_category: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplateApplicationsResult:
    """
    This data source provides Quotas Template Applications available to the user.[What is Template Applications](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaapplicationsfortemplate)

    > **NOTE:** Available since v1.214.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
    default_template_applications = alicloud.quotas.TemplateApplications("default",
        quota_action_code="vpc_whitelist/ha_vip_whitelist",
        product_code="vpc",
        quota_category="FlowControl",
        aliyun_uids=[default.ids[0]],
        desire_value=6,
        notice_type=0,
        env_language="zh",
        reason="example",
        dimensions=[
            {
                "key": "apiName",
                "value": "GetProductQuotaDimension",
            },
            {
                "key": "apiVersion",
                "value": "2020-05-10",
            },
            {
                "key": "regionId",
                "value": "cn-hangzhou",
            },
        ])
    default_get_template_applications = alicloud.quotas.get_template_applications_output(ids=[default_template_applications.id],
        product_code="vpc",
        quota_action_code="vpc_whitelist/ha_vip_whitelist",
        quota_category="FlowControl")
    pulumi.export("alicloudQuotasTemplateApplicationsExampleId", default_get_template_applications.applications[0].id)
    ```


    :param _builtins.str batch_quota_application_id: The ID of the quota application batch.
    :param Sequence[_builtins.str] ids: A list of Template Applications IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product_code: Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
    :param _builtins.str quota_action_code: The quota ID.
    :param _builtins.str quota_category: The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
    """
    __args__ = dict()
    __args__['batchQuotaApplicationId'] = batch_quota_application_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['productCode'] = product_code
    __args__['quotaActionCode'] = quota_action_code
    __args__['quotaCategory'] = quota_category
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:quotas/getTemplateApplications:getTemplateApplications', __args__, opts=opts, typ=GetTemplateApplicationsResult).value

    return AwaitableGetTemplateApplicationsResult(
        applications=pulumi.get(__ret__, 'applications'),
        batch_quota_application_id=pulumi.get(__ret__, 'batch_quota_application_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        product_code=pulumi.get(__ret__, 'product_code'),
        quota_action_code=pulumi.get(__ret__, 'quota_action_code'),
        quota_category=pulumi.get(__ret__, 'quota_category'))
def get_template_applications_output(batch_quota_application_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     product_code: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     quota_action_code: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     quota_category: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTemplateApplicationsResult]:
    """
    This data source provides Quotas Template Applications available to the user.[What is Template Applications](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaapplicationsfortemplate)

    > **NOTE:** Available since v1.214.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
    default_template_applications = alicloud.quotas.TemplateApplications("default",
        quota_action_code="vpc_whitelist/ha_vip_whitelist",
        product_code="vpc",
        quota_category="FlowControl",
        aliyun_uids=[default.ids[0]],
        desire_value=6,
        notice_type=0,
        env_language="zh",
        reason="example",
        dimensions=[
            {
                "key": "apiName",
                "value": "GetProductQuotaDimension",
            },
            {
                "key": "apiVersion",
                "value": "2020-05-10",
            },
            {
                "key": "regionId",
                "value": "cn-hangzhou",
            },
        ])
    default_get_template_applications = alicloud.quotas.get_template_applications_output(ids=[default_template_applications.id],
        product_code="vpc",
        quota_action_code="vpc_whitelist/ha_vip_whitelist",
        quota_category="FlowControl")
    pulumi.export("alicloudQuotasTemplateApplicationsExampleId", default_get_template_applications.applications[0].id)
    ```


    :param _builtins.str batch_quota_application_id: The ID of the quota application batch.
    :param Sequence[_builtins.str] ids: A list of Template Applications IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product_code: Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
    :param _builtins.str quota_action_code: The quota ID.
    :param _builtins.str quota_category: The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
    """
    __args__ = dict()
    __args__['batchQuotaApplicationId'] = batch_quota_application_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['productCode'] = product_code
    __args__['quotaActionCode'] = quota_action_code
    __args__['quotaCategory'] = quota_category
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:quotas/getTemplateApplications:getTemplateApplications', __args__, opts=opts, typ=GetTemplateApplicationsResult)
    return __ret__.apply(lambda __response__: GetTemplateApplicationsResult(
        applications=pulumi.get(__response__, 'applications'),
        batch_quota_application_id=pulumi.get(__response__, 'batch_quota_application_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        product_code=pulumi.get(__response__, 'product_code'),
        quota_action_code=pulumi.get(__response__, 'quota_action_code'),
        quota_category=pulumi.get(__response__, 'quota_category')))
