# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QuotaAlarmArgs', 'QuotaAlarm']

@pulumi.input_type
class QuotaAlarmArgs:
    def __init__(__self__, *,
                 product_code: pulumi.Input[_builtins.str],
                 quota_action_code: pulumi.Input[_builtins.str],
                 quota_alarm_name: pulumi.Input[_builtins.str],
                 quota_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_percent: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_type: Optional[pulumi.Input[_builtins.str]] = None,
                 web_hook: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a QuotaAlarm resource.
        :param pulumi.Input[_builtins.str] product_code: The Product Code.
        :param pulumi.Input[_builtins.str] quota_action_code: The Quota Action Code.
        :param pulumi.Input[_builtins.str] quota_alarm_name: The name of Quota Alarm.
        :param pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]] quota_dimensions: The Quota Dimensions. See `quota_dimensions` below.
        :param pulumi.Input[_builtins.float] threshold: The threshold of Quota Alarm.
        :param pulumi.Input[_builtins.float] threshold_percent: The threshold percent of Quota Alarm.
        :param pulumi.Input[_builtins.str] threshold_type: Quota alarm type. Value:
               - used: Quota used alarm.
               - usable: alarm for the remaining available quota.
        :param pulumi.Input[_builtins.str] web_hook: The WebHook of Quota Alarm.
        """
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        pulumi.set(__self__, "quota_alarm_name", quota_alarm_name)
        if quota_dimensions is not None:
            pulumi.set(__self__, "quota_dimensions", quota_dimensions)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_percent is not None:
            pulumi.set(__self__, "threshold_percent", threshold_percent)
        if threshold_type is not None:
            pulumi.set(__self__, "threshold_type", threshold_type)
        if web_hook is not None:
            pulumi.set(__self__, "web_hook", web_hook)

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> pulumi.Input[_builtins.str]:
        """
        The Product Code.
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_code", value)

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> pulumi.Input[_builtins.str]:
        """
        The Quota Action Code.
        """
        return pulumi.get(self, "quota_action_code")

    @quota_action_code.setter
    def quota_action_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "quota_action_code", value)

    @_builtins.property
    @pulumi.getter(name="quotaAlarmName")
    def quota_alarm_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of Quota Alarm.
        """
        return pulumi.get(self, "quota_alarm_name")

    @quota_alarm_name.setter
    def quota_alarm_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "quota_alarm_name", value)

    @_builtins.property
    @pulumi.getter(name="quotaDimensions")
    def quota_dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]]]:
        """
        The Quota Dimensions. See `quota_dimensions` below.
        """
        return pulumi.get(self, "quota_dimensions")

    @quota_dimensions.setter
    def quota_dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]]]):
        pulumi.set(self, "quota_dimensions", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The threshold of Quota Alarm.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The threshold percent of Quota Alarm.
        """
        return pulumi.get(self, "threshold_percent")

    @threshold_percent.setter
    def threshold_percent(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "threshold_percent", value)

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota alarm type. Value:
        - used: Quota used alarm.
        - usable: alarm for the remaining available quota.
        """
        return pulumi.get(self, "threshold_type")

    @threshold_type.setter
    def threshold_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threshold_type", value)

    @_builtins.property
    @pulumi.getter(name="webHook")
    def web_hook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WebHook of Quota Alarm.
        """
        return pulumi.get(self, "web_hook")

    @web_hook.setter
    def web_hook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_hook", value)


@pulumi.input_type
class _QuotaAlarmState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_action_code: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_percent: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_type: Optional[pulumi.Input[_builtins.str]] = None,
                 web_hook: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering QuotaAlarm resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] product_code: The Product Code.
        :param pulumi.Input[_builtins.str] quota_action_code: The Quota Action Code.
        :param pulumi.Input[_builtins.str] quota_alarm_name: The name of Quota Alarm.
        :param pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]] quota_dimensions: The Quota Dimensions. See `quota_dimensions` below.
        :param pulumi.Input[_builtins.float] threshold: The threshold of Quota Alarm.
        :param pulumi.Input[_builtins.float] threshold_percent: The threshold percent of Quota Alarm.
        :param pulumi.Input[_builtins.str] threshold_type: Quota alarm type. Value:
               - used: Quota used alarm.
               - usable: alarm for the remaining available quota.
        :param pulumi.Input[_builtins.str] web_hook: The WebHook of Quota Alarm.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if product_code is not None:
            pulumi.set(__self__, "product_code", product_code)
        if quota_action_code is not None:
            pulumi.set(__self__, "quota_action_code", quota_action_code)
        if quota_alarm_name is not None:
            pulumi.set(__self__, "quota_alarm_name", quota_alarm_name)
        if quota_dimensions is not None:
            pulumi.set(__self__, "quota_dimensions", quota_dimensions)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_percent is not None:
            pulumi.set(__self__, "threshold_percent", threshold_percent)
        if threshold_type is not None:
            pulumi.set(__self__, "threshold_type", threshold_type)
        if web_hook is not None:
            pulumi.set(__self__, "web_hook", web_hook)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Product Code.
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_code", value)

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Quota Action Code.
        """
        return pulumi.get(self, "quota_action_code")

    @quota_action_code.setter
    def quota_action_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_action_code", value)

    @_builtins.property
    @pulumi.getter(name="quotaAlarmName")
    def quota_alarm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of Quota Alarm.
        """
        return pulumi.get(self, "quota_alarm_name")

    @quota_alarm_name.setter
    def quota_alarm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_alarm_name", value)

    @_builtins.property
    @pulumi.getter(name="quotaDimensions")
    def quota_dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]]]:
        """
        The Quota Dimensions. See `quota_dimensions` below.
        """
        return pulumi.get(self, "quota_dimensions")

    @quota_dimensions.setter
    def quota_dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaAlarmQuotaDimensionArgs']]]]):
        pulumi.set(self, "quota_dimensions", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The threshold of Quota Alarm.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The threshold percent of Quota Alarm.
        """
        return pulumi.get(self, "threshold_percent")

    @threshold_percent.setter
    def threshold_percent(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "threshold_percent", value)

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota alarm type. Value:
        - used: Quota used alarm.
        - usable: alarm for the remaining available quota.
        """
        return pulumi.get(self, "threshold_type")

    @threshold_type.setter
    def threshold_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threshold_type", value)

    @_builtins.property
    @pulumi.getter(name="webHook")
    def web_hook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WebHook of Quota Alarm.
        """
        return pulumi.get(self, "web_hook")

    @web_hook.setter
    def web_hook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_hook", value)


@pulumi.type_token("alicloud:quotas/quotaAlarm:QuotaAlarm")
class QuotaAlarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_action_code: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaAlarmQuotaDimensionArgs', 'QuotaAlarmQuotaDimensionArgsDict']]]]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_percent: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_type: Optional[pulumi.Input[_builtins.str]] = None,
                 web_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Quotas Quota Alarm resource.

        For information about Quotas Quota Alarm and how to use it, see [What is Quota Alarm](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaalarm).

        > **NOTE:** Available since v1.116.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_quota_alarm = alicloud.quotas.QuotaAlarm("default",
            quota_action_code="q_desktop-count",
            quota_dimensions=[{
                "key": "regionId",
                "value": "cn-hangzhou",
            }],
            threshold_percent=80,
            product_code="gws",
            quota_alarm_name=f"{name}-{default['result']}",
            threshold_type="used")
        ```

        ## Import

        Quotas Quota Alarm can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:quotas/quotaAlarm:QuotaAlarm example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] product_code: The Product Code.
        :param pulumi.Input[_builtins.str] quota_action_code: The Quota Action Code.
        :param pulumi.Input[_builtins.str] quota_alarm_name: The name of Quota Alarm.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QuotaAlarmQuotaDimensionArgs', 'QuotaAlarmQuotaDimensionArgsDict']]]] quota_dimensions: The Quota Dimensions. See `quota_dimensions` below.
        :param pulumi.Input[_builtins.float] threshold: The threshold of Quota Alarm.
        :param pulumi.Input[_builtins.float] threshold_percent: The threshold percent of Quota Alarm.
        :param pulumi.Input[_builtins.str] threshold_type: Quota alarm type. Value:
               - used: Quota used alarm.
               - usable: alarm for the remaining available quota.
        :param pulumi.Input[_builtins.str] web_hook: The WebHook of Quota Alarm.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QuotaAlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Quotas Quota Alarm resource.

        For information about Quotas Quota Alarm and how to use it, see [What is Quota Alarm](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaalarm).

        > **NOTE:** Available since v1.116.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_quota_alarm = alicloud.quotas.QuotaAlarm("default",
            quota_action_code="q_desktop-count",
            quota_dimensions=[{
                "key": "regionId",
                "value": "cn-hangzhou",
            }],
            threshold_percent=80,
            product_code="gws",
            quota_alarm_name=f"{name}-{default['result']}",
            threshold_type="used")
        ```

        ## Import

        Quotas Quota Alarm can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:quotas/quotaAlarm:QuotaAlarm example <id>
        ```

        :param str resource_name: The name of the resource.
        :param QuotaAlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuotaAlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_action_code: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaAlarmQuotaDimensionArgs', 'QuotaAlarmQuotaDimensionArgsDict']]]]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_percent: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold_type: Optional[pulumi.Input[_builtins.str]] = None,
                 web_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuotaAlarmArgs.__new__(QuotaAlarmArgs)

            if product_code is None and not opts.urn:
                raise TypeError("Missing required property 'product_code'")
            __props__.__dict__["product_code"] = product_code
            if quota_action_code is None and not opts.urn:
                raise TypeError("Missing required property 'quota_action_code'")
            __props__.__dict__["quota_action_code"] = quota_action_code
            if quota_alarm_name is None and not opts.urn:
                raise TypeError("Missing required property 'quota_alarm_name'")
            __props__.__dict__["quota_alarm_name"] = quota_alarm_name
            __props__.__dict__["quota_dimensions"] = quota_dimensions
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["threshold_percent"] = threshold_percent
            __props__.__dict__["threshold_type"] = threshold_type
            __props__.__dict__["web_hook"] = web_hook
            __props__.__dict__["create_time"] = None
        super(QuotaAlarm, __self__).__init__(
            'alicloud:quotas/quotaAlarm:QuotaAlarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            product_code: Optional[pulumi.Input[_builtins.str]] = None,
            quota_action_code: Optional[pulumi.Input[_builtins.str]] = None,
            quota_alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
            quota_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaAlarmQuotaDimensionArgs', 'QuotaAlarmQuotaDimensionArgsDict']]]]] = None,
            threshold: Optional[pulumi.Input[_builtins.float]] = None,
            threshold_percent: Optional[pulumi.Input[_builtins.float]] = None,
            threshold_type: Optional[pulumi.Input[_builtins.str]] = None,
            web_hook: Optional[pulumi.Input[_builtins.str]] = None) -> 'QuotaAlarm':
        """
        Get an existing QuotaAlarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] product_code: The Product Code.
        :param pulumi.Input[_builtins.str] quota_action_code: The Quota Action Code.
        :param pulumi.Input[_builtins.str] quota_alarm_name: The name of Quota Alarm.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QuotaAlarmQuotaDimensionArgs', 'QuotaAlarmQuotaDimensionArgsDict']]]] quota_dimensions: The Quota Dimensions. See `quota_dimensions` below.
        :param pulumi.Input[_builtins.float] threshold: The threshold of Quota Alarm.
        :param pulumi.Input[_builtins.float] threshold_percent: The threshold percent of Quota Alarm.
        :param pulumi.Input[_builtins.str] threshold_type: Quota alarm type. Value:
               - used: Quota used alarm.
               - usable: alarm for the remaining available quota.
        :param pulumi.Input[_builtins.str] web_hook: The WebHook of Quota Alarm.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuotaAlarmState.__new__(_QuotaAlarmState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["product_code"] = product_code
        __props__.__dict__["quota_action_code"] = quota_action_code
        __props__.__dict__["quota_alarm_name"] = quota_alarm_name
        __props__.__dict__["quota_dimensions"] = quota_dimensions
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["threshold_percent"] = threshold_percent
        __props__.__dict__["threshold_type"] = threshold_type
        __props__.__dict__["web_hook"] = web_hook
        return QuotaAlarm(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> pulumi.Output[_builtins.str]:
        """
        The Product Code.
        """
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> pulumi.Output[_builtins.str]:
        """
        The Quota Action Code.
        """
        return pulumi.get(self, "quota_action_code")

    @_builtins.property
    @pulumi.getter(name="quotaAlarmName")
    def quota_alarm_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of Quota Alarm.
        """
        return pulumi.get(self, "quota_alarm_name")

    @_builtins.property
    @pulumi.getter(name="quotaDimensions")
    def quota_dimensions(self) -> pulumi.Output[Optional[Sequence['outputs.QuotaAlarmQuotaDimension']]]:
        """
        The Quota Dimensions. See `quota_dimensions` below.
        """
        return pulumi.get(self, "quota_dimensions")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The threshold of Quota Alarm.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The threshold percent of Quota Alarm.
        """
        return pulumi.get(self, "threshold_percent")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> pulumi.Output[_builtins.str]:
        """
        Quota alarm type. Value:
        - used: Quota used alarm.
        - usable: alarm for the remaining available quota.
        """
        return pulumi.get(self, "threshold_type")

    @_builtins.property
    @pulumi.getter(name="webHook")
    def web_hook(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The WebHook of Quota Alarm.
        """
        return pulumi.get(self, "web_hook")

