# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccountAliasResult',
    'AwaitableGetAccountAliasResult',
    'get_account_alias',
    'get_account_alias_output',
]

@pulumi.output_type
class GetAccountAliasResult:
    """
    A collection of values returned by getAccountAlias.
    """
    def __init__(__self__, account_alias=None, id=None, output_file=None):
        if account_alias and not isinstance(account_alias, str):
            raise TypeError("Expected argument 'account_alias' to be a str")
        pulumi.set(__self__, "account_alias", account_alias)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="accountAlias")
    def account_alias(self) -> _builtins.str:
        """
        Alias of the account.
        """
        return pulumi.get(self, "account_alias")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetAccountAliasResult(GetAccountAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountAliasResult(
            account_alias=self.account_alias,
            id=self.id,
            output_file=self.output_file)


def get_account_alias(output_file: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountAliasResult:
    """
    This data source provides an alias for the Alibaba Cloud account.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    alias_ds = alicloud.ram.get_account_alias(output_file="alias.txt")
    pulumi.export("accountAlias", alias_ds.account_alias)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ram/getAccountAlias:getAccountAlias', __args__, opts=opts, typ=GetAccountAliasResult).value

    return AwaitableGetAccountAliasResult(
        account_alias=pulumi.get(__ret__, 'account_alias'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_account_alias_output(output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountAliasResult]:
    """
    This data source provides an alias for the Alibaba Cloud account.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    alias_ds = alicloud.ram.get_account_alias(output_file="alias.txt")
    pulumi.export("accountAlias", alias_ds.account_alias)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ram/getAccountAlias:getAccountAlias', __args__, opts=opts, typ=GetAccountAliasResult)
    return __ret__.apply(lambda __response__: GetAccountAliasResult(
        account_alias=pulumi.get(__response__, 'account_alias'),
        id=pulumi.get(__response__, 'id'),
        output_file=pulumi.get(__response__, 'output_file')))
