# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecurityPreferenceArgs', 'SecurityPreference']

@pulumi.input_type
class SecurityPreferenceArgs:
    def __init__(__self__, *,
                 allow_user_to_change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_login_with_passkey: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_personal_ding_talk: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_network_masks: Optional[pulumi.Input[_builtins.str]] = None,
                 login_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 mfa_operation_for_login: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_for_risk_login: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecurityPreference resource.
        :param pulumi.Input[_builtins.bool] allow_user_to_change_password: Whether to allow RAM users to manage their own passwords. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_login_with_passkey: Whether to allow RAM users to log on using a passkey. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_access_keys: Whether to allow RAM users to manage their own access keys. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_mfa_devices: Whether to allow RAM users to manage multi-factor authentication devices. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_personal_ding_talk: Whether to allow RAM users to independently manage the binding and unbinding of personal DingTalk. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] enable_save_mfa_ticket: Whether to save the verification status of a RAM user after logging in using multi-factor authentication. The validity period is 7 days. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] enforce_mfa_for_login: Field `enforce_mfa_for_login` has been deprecated from provider version 1.248.0. New field `mfa_operation_for_login` instead. 
               Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[_builtins.str] login_network_masks: The login mask. The logon mask determines which IP addresses are affected by the logon console, including password logon and single sign-on (SSO), but API calls made using the access key are not affected.
               - If the mask is specified, RAM users can only log on from the specified IP address.
               - If you do not specify any mask, the login console function will apply to the entire network.
               
               When you need to configure multiple login masks, use a semicolon (;) to separate them, for example: 192.168.0.0/16;10.0.0.0/8.
               
               Configure a maximum of 40 logon masks, with a total length of 512 characters.
        :param pulumi.Input[_builtins.int] login_session_duration: The validity period of the logon session of RAM users.
               Valid values: 1 to 24. Unit: hours.
               Default value: 6.
        :param pulumi.Input[_builtins.str] mfa_operation_for_login: MFA must be used during logon (replace the original EnforceMFAForLogin parameter, the original parameter is still valid, we recommend that you update it to a new parameter). Value:
               - mandatory: mandatory for all RAM users. The original value of EnforceMFAForLogin is true.
               - independent (default): depends on the independent configuration of each RAM user. The original value of EnforceMFAForLogin is false.
               - adaptive: Used only during abnormal login.
        :param pulumi.Input[_builtins.str] operation_for_risk_login: Whether MFA is verified twice during abnormal logon. Value:
               - autonomous (default): Skip, do not force binding.
               - enforceVerify: Force binding validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] verification_types: Means of multi-factor authentication. Value:
               - sms: secure phone.
               - email: Secure mailbox.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if allow_user_to_change_password is not None:
            pulumi.set(__self__, "allow_user_to_change_password", allow_user_to_change_password)
        if allow_user_to_login_with_passkey is not None:
            pulumi.set(__self__, "allow_user_to_login_with_passkey", allow_user_to_login_with_passkey)
        if allow_user_to_manage_access_keys is not None:
            pulumi.set(__self__, "allow_user_to_manage_access_keys", allow_user_to_manage_access_keys)
        if allow_user_to_manage_mfa_devices is not None:
            pulumi.set(__self__, "allow_user_to_manage_mfa_devices", allow_user_to_manage_mfa_devices)
        if allow_user_to_manage_personal_ding_talk is not None:
            pulumi.set(__self__, "allow_user_to_manage_personal_ding_talk", allow_user_to_manage_personal_ding_talk)
        if enable_save_mfa_ticket is not None:
            pulumi.set(__self__, "enable_save_mfa_ticket", enable_save_mfa_ticket)
        if enforce_mfa_for_login is not None:
            pulumi.set(__self__, "enforce_mfa_for_login", enforce_mfa_for_login)
        if login_network_masks is not None:
            pulumi.set(__self__, "login_network_masks", login_network_masks)
        if login_session_duration is not None:
            pulumi.set(__self__, "login_session_duration", login_session_duration)
        if mfa_operation_for_login is not None:
            pulumi.set(__self__, "mfa_operation_for_login", mfa_operation_for_login)
        if operation_for_risk_login is not None:
            pulumi.set(__self__, "operation_for_risk_login", operation_for_risk_login)
        if verification_types is not None:
            pulumi.set(__self__, "verification_types", verification_types)

    @_builtins.property
    @pulumi.getter(name="allowUserToChangePassword")
    def allow_user_to_change_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to manage their own passwords. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_change_password")

    @allow_user_to_change_password.setter
    def allow_user_to_change_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_change_password", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToLoginWithPasskey")
    def allow_user_to_login_with_passkey(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to log on using a passkey. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_login_with_passkey")

    @allow_user_to_login_with_passkey.setter
    def allow_user_to_login_with_passkey(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_login_with_passkey", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToManageAccessKeys")
    def allow_user_to_manage_access_keys(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to manage their own access keys. Value:
        - true: Allow.
        - false (default): Not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_access_keys")

    @allow_user_to_manage_access_keys.setter
    def allow_user_to_manage_access_keys(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_manage_access_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToManageMfaDevices")
    def allow_user_to_manage_mfa_devices(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to manage multi-factor authentication devices. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_mfa_devices")

    @allow_user_to_manage_mfa_devices.setter
    def allow_user_to_manage_mfa_devices(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_manage_mfa_devices", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToManagePersonalDingTalk")
    def allow_user_to_manage_personal_ding_talk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to independently manage the binding and unbinding of personal DingTalk. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_personal_ding_talk")

    @allow_user_to_manage_personal_ding_talk.setter
    def allow_user_to_manage_personal_ding_talk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_manage_personal_ding_talk", value)

    @_builtins.property
    @pulumi.getter(name="enableSaveMfaTicket")
    def enable_save_mfa_ticket(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to save the verification status of a RAM user after logging in using multi-factor authentication. The validity period is 7 days. Value:
        - true: Allow.
        - false (default): Not allowed.
        """
        return pulumi.get(self, "enable_save_mfa_ticket")

    @enable_save_mfa_ticket.setter
    def enable_save_mfa_ticket(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_save_mfa_ticket", value)

    @_builtins.property
    @pulumi.getter(name="enforceMfaForLogin")
    def enforce_mfa_for_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `enforce_mfa_for_login` has been deprecated from provider version 1.248.0. New field `mfa_operation_for_login` instead. 
        Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enforce_mfa_for_login")

    @enforce_mfa_for_login.setter
    def enforce_mfa_for_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_mfa_for_login", value)

    @_builtins.property
    @pulumi.getter(name="loginNetworkMasks")
    def login_network_masks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The login mask. The logon mask determines which IP addresses are affected by the logon console, including password logon and single sign-on (SSO), but API calls made using the access key are not affected.
        - If the mask is specified, RAM users can only log on from the specified IP address.
        - If you do not specify any mask, the login console function will apply to the entire network.

        When you need to configure multiple login masks, use a semicolon (;) to separate them, for example: 192.168.0.0/16;10.0.0.0/8.

        Configure a maximum of 40 logon masks, with a total length of 512 characters.
        """
        return pulumi.get(self, "login_network_masks")

    @login_network_masks.setter
    def login_network_masks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_network_masks", value)

    @_builtins.property
    @pulumi.getter(name="loginSessionDuration")
    def login_session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The validity period of the logon session of RAM users.
        Valid values: 1 to 24. Unit: hours.
        Default value: 6.
        """
        return pulumi.get(self, "login_session_duration")

    @login_session_duration.setter
    def login_session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "login_session_duration", value)

    @_builtins.property
    @pulumi.getter(name="mfaOperationForLogin")
    def mfa_operation_for_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MFA must be used during logon (replace the original EnforceMFAForLogin parameter, the original parameter is still valid, we recommend that you update it to a new parameter). Value:
        - mandatory: mandatory for all RAM users. The original value of EnforceMFAForLogin is true.
        - independent (default): depends on the independent configuration of each RAM user. The original value of EnforceMFAForLogin is false.
        - adaptive: Used only during abnormal login.
        """
        return pulumi.get(self, "mfa_operation_for_login")

    @mfa_operation_for_login.setter
    def mfa_operation_for_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mfa_operation_for_login", value)

    @_builtins.property
    @pulumi.getter(name="operationForRiskLogin")
    def operation_for_risk_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether MFA is verified twice during abnormal logon. Value:
        - autonomous (default): Skip, do not force binding.
        - enforceVerify: Force binding validation.
        """
        return pulumi.get(self, "operation_for_risk_login")

    @operation_for_risk_login.setter
    def operation_for_risk_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_for_risk_login", value)

    @_builtins.property
    @pulumi.getter(name="verificationTypes")
    def verification_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Means of multi-factor authentication. Value:
        - sms: secure phone.
        - email: Secure mailbox.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "verification_types")

    @verification_types.setter
    def verification_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "verification_types", value)


@pulumi.input_type
class _SecurityPreferenceState:
    def __init__(__self__, *,
                 allow_user_to_change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_login_with_passkey: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_personal_ding_talk: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_network_masks: Optional[pulumi.Input[_builtins.str]] = None,
                 login_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 mfa_operation_for_login: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_for_risk_login: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecurityPreference resources.
        :param pulumi.Input[_builtins.bool] allow_user_to_change_password: Whether to allow RAM users to manage their own passwords. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_login_with_passkey: Whether to allow RAM users to log on using a passkey. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_access_keys: Whether to allow RAM users to manage their own access keys. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_mfa_devices: Whether to allow RAM users to manage multi-factor authentication devices. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_personal_ding_talk: Whether to allow RAM users to independently manage the binding and unbinding of personal DingTalk. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] enable_save_mfa_ticket: Whether to save the verification status of a RAM user after logging in using multi-factor authentication. The validity period is 7 days. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] enforce_mfa_for_login: Field `enforce_mfa_for_login` has been deprecated from provider version 1.248.0. New field `mfa_operation_for_login` instead. 
               Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[_builtins.str] login_network_masks: The login mask. The logon mask determines which IP addresses are affected by the logon console, including password logon and single sign-on (SSO), but API calls made using the access key are not affected.
               - If the mask is specified, RAM users can only log on from the specified IP address.
               - If you do not specify any mask, the login console function will apply to the entire network.
               
               When you need to configure multiple login masks, use a semicolon (;) to separate them, for example: 192.168.0.0/16;10.0.0.0/8.
               
               Configure a maximum of 40 logon masks, with a total length of 512 characters.
        :param pulumi.Input[_builtins.int] login_session_duration: The validity period of the logon session of RAM users.
               Valid values: 1 to 24. Unit: hours.
               Default value: 6.
        :param pulumi.Input[_builtins.str] mfa_operation_for_login: MFA must be used during logon (replace the original EnforceMFAForLogin parameter, the original parameter is still valid, we recommend that you update it to a new parameter). Value:
               - mandatory: mandatory for all RAM users. The original value of EnforceMFAForLogin is true.
               - independent (default): depends on the independent configuration of each RAM user. The original value of EnforceMFAForLogin is false.
               - adaptive: Used only during abnormal login.
        :param pulumi.Input[_builtins.str] operation_for_risk_login: Whether MFA is verified twice during abnormal logon. Value:
               - autonomous (default): Skip, do not force binding.
               - enforceVerify: Force binding validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] verification_types: Means of multi-factor authentication. Value:
               - sms: secure phone.
               - email: Secure mailbox.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if allow_user_to_change_password is not None:
            pulumi.set(__self__, "allow_user_to_change_password", allow_user_to_change_password)
        if allow_user_to_login_with_passkey is not None:
            pulumi.set(__self__, "allow_user_to_login_with_passkey", allow_user_to_login_with_passkey)
        if allow_user_to_manage_access_keys is not None:
            pulumi.set(__self__, "allow_user_to_manage_access_keys", allow_user_to_manage_access_keys)
        if allow_user_to_manage_mfa_devices is not None:
            pulumi.set(__self__, "allow_user_to_manage_mfa_devices", allow_user_to_manage_mfa_devices)
        if allow_user_to_manage_personal_ding_talk is not None:
            pulumi.set(__self__, "allow_user_to_manage_personal_ding_talk", allow_user_to_manage_personal_ding_talk)
        if enable_save_mfa_ticket is not None:
            pulumi.set(__self__, "enable_save_mfa_ticket", enable_save_mfa_ticket)
        if enforce_mfa_for_login is not None:
            pulumi.set(__self__, "enforce_mfa_for_login", enforce_mfa_for_login)
        if login_network_masks is not None:
            pulumi.set(__self__, "login_network_masks", login_network_masks)
        if login_session_duration is not None:
            pulumi.set(__self__, "login_session_duration", login_session_duration)
        if mfa_operation_for_login is not None:
            pulumi.set(__self__, "mfa_operation_for_login", mfa_operation_for_login)
        if operation_for_risk_login is not None:
            pulumi.set(__self__, "operation_for_risk_login", operation_for_risk_login)
        if verification_types is not None:
            pulumi.set(__self__, "verification_types", verification_types)

    @_builtins.property
    @pulumi.getter(name="allowUserToChangePassword")
    def allow_user_to_change_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to manage their own passwords. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_change_password")

    @allow_user_to_change_password.setter
    def allow_user_to_change_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_change_password", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToLoginWithPasskey")
    def allow_user_to_login_with_passkey(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to log on using a passkey. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_login_with_passkey")

    @allow_user_to_login_with_passkey.setter
    def allow_user_to_login_with_passkey(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_login_with_passkey", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToManageAccessKeys")
    def allow_user_to_manage_access_keys(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to manage their own access keys. Value:
        - true: Allow.
        - false (default): Not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_access_keys")

    @allow_user_to_manage_access_keys.setter
    def allow_user_to_manage_access_keys(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_manage_access_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToManageMfaDevices")
    def allow_user_to_manage_mfa_devices(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to manage multi-factor authentication devices. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_mfa_devices")

    @allow_user_to_manage_mfa_devices.setter
    def allow_user_to_manage_mfa_devices(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_manage_mfa_devices", value)

    @_builtins.property
    @pulumi.getter(name="allowUserToManagePersonalDingTalk")
    def allow_user_to_manage_personal_ding_talk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow RAM users to independently manage the binding and unbinding of personal DingTalk. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_personal_ding_talk")

    @allow_user_to_manage_personal_ding_talk.setter
    def allow_user_to_manage_personal_ding_talk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_to_manage_personal_ding_talk", value)

    @_builtins.property
    @pulumi.getter(name="enableSaveMfaTicket")
    def enable_save_mfa_ticket(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to save the verification status of a RAM user after logging in using multi-factor authentication. The validity period is 7 days. Value:
        - true: Allow.
        - false (default): Not allowed.
        """
        return pulumi.get(self, "enable_save_mfa_ticket")

    @enable_save_mfa_ticket.setter
    def enable_save_mfa_ticket(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_save_mfa_ticket", value)

    @_builtins.property
    @pulumi.getter(name="enforceMfaForLogin")
    def enforce_mfa_for_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `enforce_mfa_for_login` has been deprecated from provider version 1.248.0. New field `mfa_operation_for_login` instead. 
        Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enforce_mfa_for_login")

    @enforce_mfa_for_login.setter
    def enforce_mfa_for_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_mfa_for_login", value)

    @_builtins.property
    @pulumi.getter(name="loginNetworkMasks")
    def login_network_masks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The login mask. The logon mask determines which IP addresses are affected by the logon console, including password logon and single sign-on (SSO), but API calls made using the access key are not affected.
        - If the mask is specified, RAM users can only log on from the specified IP address.
        - If you do not specify any mask, the login console function will apply to the entire network.

        When you need to configure multiple login masks, use a semicolon (;) to separate them, for example: 192.168.0.0/16;10.0.0.0/8.

        Configure a maximum of 40 logon masks, with a total length of 512 characters.
        """
        return pulumi.get(self, "login_network_masks")

    @login_network_masks.setter
    def login_network_masks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_network_masks", value)

    @_builtins.property
    @pulumi.getter(name="loginSessionDuration")
    def login_session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The validity period of the logon session of RAM users.
        Valid values: 1 to 24. Unit: hours.
        Default value: 6.
        """
        return pulumi.get(self, "login_session_duration")

    @login_session_duration.setter
    def login_session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "login_session_duration", value)

    @_builtins.property
    @pulumi.getter(name="mfaOperationForLogin")
    def mfa_operation_for_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MFA must be used during logon (replace the original EnforceMFAForLogin parameter, the original parameter is still valid, we recommend that you update it to a new parameter). Value:
        - mandatory: mandatory for all RAM users. The original value of EnforceMFAForLogin is true.
        - independent (default): depends on the independent configuration of each RAM user. The original value of EnforceMFAForLogin is false.
        - adaptive: Used only during abnormal login.
        """
        return pulumi.get(self, "mfa_operation_for_login")

    @mfa_operation_for_login.setter
    def mfa_operation_for_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mfa_operation_for_login", value)

    @_builtins.property
    @pulumi.getter(name="operationForRiskLogin")
    def operation_for_risk_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether MFA is verified twice during abnormal logon. Value:
        - autonomous (default): Skip, do not force binding.
        - enforceVerify: Force binding validation.
        """
        return pulumi.get(self, "operation_for_risk_login")

    @operation_for_risk_login.setter
    def operation_for_risk_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_for_risk_login", value)

    @_builtins.property
    @pulumi.getter(name="verificationTypes")
    def verification_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Means of multi-factor authentication. Value:
        - sms: secure phone.
        - email: Secure mailbox.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "verification_types")

    @verification_types.setter
    def verification_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "verification_types", value)


@pulumi.type_token("alicloud:ram/securityPreference:SecurityPreference")
class SecurityPreference(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_user_to_change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_login_with_passkey: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_personal_ding_talk: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_network_masks: Optional[pulumi.Input[_builtins.str]] = None,
                 login_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 mfa_operation_for_login: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_for_risk_login: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        RAM Security Preference can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/securityPreference:SecurityPreference example 
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_user_to_change_password: Whether to allow RAM users to manage their own passwords. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_login_with_passkey: Whether to allow RAM users to log on using a passkey. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_access_keys: Whether to allow RAM users to manage their own access keys. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_mfa_devices: Whether to allow RAM users to manage multi-factor authentication devices. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_personal_ding_talk: Whether to allow RAM users to independently manage the binding and unbinding of personal DingTalk. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] enable_save_mfa_ticket: Whether to save the verification status of a RAM user after logging in using multi-factor authentication. The validity period is 7 days. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] enforce_mfa_for_login: Field `enforce_mfa_for_login` has been deprecated from provider version 1.248.0. New field `mfa_operation_for_login` instead. 
               Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[_builtins.str] login_network_masks: The login mask. The logon mask determines which IP addresses are affected by the logon console, including password logon and single sign-on (SSO), but API calls made using the access key are not affected.
               - If the mask is specified, RAM users can only log on from the specified IP address.
               - If you do not specify any mask, the login console function will apply to the entire network.
               
               When you need to configure multiple login masks, use a semicolon (;) to separate them, for example: 192.168.0.0/16;10.0.0.0/8.
               
               Configure a maximum of 40 logon masks, with a total length of 512 characters.
        :param pulumi.Input[_builtins.int] login_session_duration: The validity period of the logon session of RAM users.
               Valid values: 1 to 24. Unit: hours.
               Default value: 6.
        :param pulumi.Input[_builtins.str] mfa_operation_for_login: MFA must be used during logon (replace the original EnforceMFAForLogin parameter, the original parameter is still valid, we recommend that you update it to a new parameter). Value:
               - mandatory: mandatory for all RAM users. The original value of EnforceMFAForLogin is true.
               - independent (default): depends on the independent configuration of each RAM user. The original value of EnforceMFAForLogin is false.
               - adaptive: Used only during abnormal login.
        :param pulumi.Input[_builtins.str] operation_for_risk_login: Whether MFA is verified twice during abnormal logon. Value:
               - autonomous (default): Skip, do not force binding.
               - enforceVerify: Force binding validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] verification_types: Means of multi-factor authentication. Value:
               - sms: secure phone.
               - email: Secure mailbox.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityPreferenceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        RAM Security Preference can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/securityPreference:SecurityPreference example 
        ```

        :param str resource_name: The name of the resource.
        :param SecurityPreferenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityPreferenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_user_to_change_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_login_with_passkey: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_to_manage_personal_ding_talk: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_network_masks: Optional[pulumi.Input[_builtins.str]] = None,
                 login_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 mfa_operation_for_login: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_for_risk_login: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityPreferenceArgs.__new__(SecurityPreferenceArgs)

            __props__.__dict__["allow_user_to_change_password"] = allow_user_to_change_password
            __props__.__dict__["allow_user_to_login_with_passkey"] = allow_user_to_login_with_passkey
            __props__.__dict__["allow_user_to_manage_access_keys"] = allow_user_to_manage_access_keys
            __props__.__dict__["allow_user_to_manage_mfa_devices"] = allow_user_to_manage_mfa_devices
            __props__.__dict__["allow_user_to_manage_personal_ding_talk"] = allow_user_to_manage_personal_ding_talk
            __props__.__dict__["enable_save_mfa_ticket"] = enable_save_mfa_ticket
            __props__.__dict__["enforce_mfa_for_login"] = enforce_mfa_for_login
            __props__.__dict__["login_network_masks"] = login_network_masks
            __props__.__dict__["login_session_duration"] = login_session_duration
            __props__.__dict__["mfa_operation_for_login"] = mfa_operation_for_login
            __props__.__dict__["operation_for_risk_login"] = operation_for_risk_login
            __props__.__dict__["verification_types"] = verification_types
        super(SecurityPreference, __self__).__init__(
            'alicloud:ram/securityPreference:SecurityPreference',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_user_to_change_password: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_user_to_login_with_passkey: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_user_to_manage_access_keys: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_user_to_manage_mfa_devices: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_user_to_manage_personal_ding_talk: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_save_mfa_ticket: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_mfa_for_login: Optional[pulumi.Input[_builtins.bool]] = None,
            login_network_masks: Optional[pulumi.Input[_builtins.str]] = None,
            login_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
            mfa_operation_for_login: Optional[pulumi.Input[_builtins.str]] = None,
            operation_for_risk_login: Optional[pulumi.Input[_builtins.str]] = None,
            verification_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecurityPreference':
        """
        Get an existing SecurityPreference resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_user_to_change_password: Whether to allow RAM users to manage their own passwords. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_login_with_passkey: Whether to allow RAM users to log on using a passkey. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_access_keys: Whether to allow RAM users to manage their own access keys. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_mfa_devices: Whether to allow RAM users to manage multi-factor authentication devices. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] allow_user_to_manage_personal_ding_talk: Whether to allow RAM users to independently manage the binding and unbinding of personal DingTalk. Value:
               - true (default): Allowed.
               - false: not allowed.
        :param pulumi.Input[_builtins.bool] enable_save_mfa_ticket: Whether to save the verification status of a RAM user after logging in using multi-factor authentication. The validity period is 7 days. Value:
               - true: Allow.
               - false (default): Not allowed.
        :param pulumi.Input[_builtins.bool] enforce_mfa_for_login: Field `enforce_mfa_for_login` has been deprecated from provider version 1.248.0. New field `mfa_operation_for_login` instead. 
               Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[_builtins.str] login_network_masks: The login mask. The logon mask determines which IP addresses are affected by the logon console, including password logon and single sign-on (SSO), but API calls made using the access key are not affected.
               - If the mask is specified, RAM users can only log on from the specified IP address.
               - If you do not specify any mask, the login console function will apply to the entire network.
               
               When you need to configure multiple login masks, use a semicolon (;) to separate them, for example: 192.168.0.0/16;10.0.0.0/8.
               
               Configure a maximum of 40 logon masks, with a total length of 512 characters.
        :param pulumi.Input[_builtins.int] login_session_duration: The validity period of the logon session of RAM users.
               Valid values: 1 to 24. Unit: hours.
               Default value: 6.
        :param pulumi.Input[_builtins.str] mfa_operation_for_login: MFA must be used during logon (replace the original EnforceMFAForLogin parameter, the original parameter is still valid, we recommend that you update it to a new parameter). Value:
               - mandatory: mandatory for all RAM users. The original value of EnforceMFAForLogin is true.
               - independent (default): depends on the independent configuration of each RAM user. The original value of EnforceMFAForLogin is false.
               - adaptive: Used only during abnormal login.
        :param pulumi.Input[_builtins.str] operation_for_risk_login: Whether MFA is verified twice during abnormal logon. Value:
               - autonomous (default): Skip, do not force binding.
               - enforceVerify: Force binding validation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] verification_types: Means of multi-factor authentication. Value:
               - sms: secure phone.
               - email: Secure mailbox.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityPreferenceState.__new__(_SecurityPreferenceState)

        __props__.__dict__["allow_user_to_change_password"] = allow_user_to_change_password
        __props__.__dict__["allow_user_to_login_with_passkey"] = allow_user_to_login_with_passkey
        __props__.__dict__["allow_user_to_manage_access_keys"] = allow_user_to_manage_access_keys
        __props__.__dict__["allow_user_to_manage_mfa_devices"] = allow_user_to_manage_mfa_devices
        __props__.__dict__["allow_user_to_manage_personal_ding_talk"] = allow_user_to_manage_personal_ding_talk
        __props__.__dict__["enable_save_mfa_ticket"] = enable_save_mfa_ticket
        __props__.__dict__["enforce_mfa_for_login"] = enforce_mfa_for_login
        __props__.__dict__["login_network_masks"] = login_network_masks
        __props__.__dict__["login_session_duration"] = login_session_duration
        __props__.__dict__["mfa_operation_for_login"] = mfa_operation_for_login
        __props__.__dict__["operation_for_risk_login"] = operation_for_risk_login
        __props__.__dict__["verification_types"] = verification_types
        return SecurityPreference(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowUserToChangePassword")
    def allow_user_to_change_password(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow RAM users to manage their own passwords. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_change_password")

    @_builtins.property
    @pulumi.getter(name="allowUserToLoginWithPasskey")
    def allow_user_to_login_with_passkey(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow RAM users to log on using a passkey. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_login_with_passkey")

    @_builtins.property
    @pulumi.getter(name="allowUserToManageAccessKeys")
    def allow_user_to_manage_access_keys(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow RAM users to manage their own access keys. Value:
        - true: Allow.
        - false (default): Not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_access_keys")

    @_builtins.property
    @pulumi.getter(name="allowUserToManageMfaDevices")
    def allow_user_to_manage_mfa_devices(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow RAM users to manage multi-factor authentication devices. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_mfa_devices")

    @_builtins.property
    @pulumi.getter(name="allowUserToManagePersonalDingTalk")
    def allow_user_to_manage_personal_ding_talk(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow RAM users to independently manage the binding and unbinding of personal DingTalk. Value:
        - true (default): Allowed.
        - false: not allowed.
        """
        return pulumi.get(self, "allow_user_to_manage_personal_ding_talk")

    @_builtins.property
    @pulumi.getter(name="enableSaveMfaTicket")
    def enable_save_mfa_ticket(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to save the verification status of a RAM user after logging in using multi-factor authentication. The validity period is 7 days. Value:
        - true: Allow.
        - false (default): Not allowed.
        """
        return pulumi.get(self, "enable_save_mfa_ticket")

    @_builtins.property
    @pulumi.getter(name="enforceMfaForLogin")
    def enforce_mfa_for_login(self) -> pulumi.Output[_builtins.bool]:
        """
        Field `enforce_mfa_for_login` has been deprecated from provider version 1.248.0. New field `mfa_operation_for_login` instead. 
        Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enforce_mfa_for_login")

    @_builtins.property
    @pulumi.getter(name="loginNetworkMasks")
    def login_network_masks(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The login mask. The logon mask determines which IP addresses are affected by the logon console, including password logon and single sign-on (SSO), but API calls made using the access key are not affected.
        - If the mask is specified, RAM users can only log on from the specified IP address.
        - If you do not specify any mask, the login console function will apply to the entire network.

        When you need to configure multiple login masks, use a semicolon (;) to separate them, for example: 192.168.0.0/16;10.0.0.0/8.

        Configure a maximum of 40 logon masks, with a total length of 512 characters.
        """
        return pulumi.get(self, "login_network_masks")

    @_builtins.property
    @pulumi.getter(name="loginSessionDuration")
    def login_session_duration(self) -> pulumi.Output[_builtins.int]:
        """
        The validity period of the logon session of RAM users.
        Valid values: 1 to 24. Unit: hours.
        Default value: 6.
        """
        return pulumi.get(self, "login_session_duration")

    @_builtins.property
    @pulumi.getter(name="mfaOperationForLogin")
    def mfa_operation_for_login(self) -> pulumi.Output[_builtins.str]:
        """
        MFA must be used during logon (replace the original EnforceMFAForLogin parameter, the original parameter is still valid, we recommend that you update it to a new parameter). Value:
        - mandatory: mandatory for all RAM users. The original value of EnforceMFAForLogin is true.
        - independent (default): depends on the independent configuration of each RAM user. The original value of EnforceMFAForLogin is false.
        - adaptive: Used only during abnormal login.
        """
        return pulumi.get(self, "mfa_operation_for_login")

    @_builtins.property
    @pulumi.getter(name="operationForRiskLogin")
    def operation_for_risk_login(self) -> pulumi.Output[_builtins.str]:
        """
        Whether MFA is verified twice during abnormal logon. Value:
        - autonomous (default): Skip, do not force binding.
        - enforceVerify: Force binding validation.
        """
        return pulumi.get(self, "operation_for_risk_login")

    @_builtins.property
    @pulumi.getter(name="verificationTypes")
    def verification_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Means of multi-factor authentication. Value:
        - sms: secure phone.
        - email: Secure mailbox.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "verification_types")

