# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomDeploymentSetArgs', 'CustomDeploymentSet']

@pulumi.input_type
class CustomDeploymentSetArgs:
    def __init__(__self__, *,
                 custom_deployment_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 on_unable_to_redeploy_failed_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDeploymentSet resource.
        :param pulumi.Input[_builtins.str] custom_deployment_set_name: The name of the resource
        :param pulumi.Input[_builtins.str] description: Deployment set description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.int] group_count: Set the number of groups for the deployment set group high availability policy. Value range: 1~7.
               
               Default value: 3
               
               > **NOTE:**  This parameter takes effect only when 'Strategy = AvailabilityGroup.
        :param pulumi.Input[_builtins.str] on_unable_to_redeploy_failed_instance: After the instance in the deployment set is down and migrated, there is no emergency solution for the scattered instance inventory. Value range:
               - `CancelMembershipAndStart`: removes the instance from the deployment set and starts the instance immediately after the instance is down and migrated.
               - `KeepStopped`: The deployment set of the instance is maintained. The instance remains in the stopped state.
               
               Default value: CancelMembershipAndStart.
        :param pulumi.Input[_builtins.str] strategy: Deployment strategy. Value range:
               - `Availability`: High Availability policy.
               - `AvailabilityGroup`: the high availability policy of the deployment set group.
               - `LowLatency`: Network low latency policy.
               
               Default value: Availability.
        """
        if custom_deployment_set_name is not None:
            pulumi.set(__self__, "custom_deployment_set_name", custom_deployment_set_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_count is not None:
            pulumi.set(__self__, "group_count", group_count)
        if on_unable_to_redeploy_failed_instance is not None:
            pulumi.set(__self__, "on_unable_to_redeploy_failed_instance", on_unable_to_redeploy_failed_instance)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @_builtins.property
    @pulumi.getter(name="customDeploymentSetName")
    def custom_deployment_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "custom_deployment_set_name")

    @custom_deployment_set_name.setter
    def custom_deployment_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_deployment_set_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment set description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupCount")
    def group_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the number of groups for the deployment set group high availability policy. Value range: 1~7.

        Default value: 3

        > **NOTE:**  This parameter takes effect only when 'Strategy = AvailabilityGroup.
        """
        return pulumi.get(self, "group_count")

    @group_count.setter
    def group_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_count", value)

    @_builtins.property
    @pulumi.getter(name="onUnableToRedeployFailedInstance")
    def on_unable_to_redeploy_failed_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        After the instance in the deployment set is down and migrated, there is no emergency solution for the scattered instance inventory. Value range:
        - `CancelMembershipAndStart`: removes the instance from the deployment set and starts the instance immediately after the instance is down and migrated.
        - `KeepStopped`: The deployment set of the instance is maintained. The instance remains in the stopped state.

        Default value: CancelMembershipAndStart.
        """
        return pulumi.get(self, "on_unable_to_redeploy_failed_instance")

    @on_unable_to_redeploy_failed_instance.setter
    def on_unable_to_redeploy_failed_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_unable_to_redeploy_failed_instance", value)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment strategy. Value range:
        - `Availability`: High Availability policy.
        - `AvailabilityGroup`: the high availability policy of the deployment set group.
        - `LowLatency`: Network low latency policy.

        Default value: Availability.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strategy", value)


@pulumi.input_type
class _CustomDeploymentSetState:
    def __init__(__self__, *,
                 custom_deployment_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 on_unable_to_redeploy_failed_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomDeploymentSet resources.
        :param pulumi.Input[_builtins.str] custom_deployment_set_name: The name of the resource
        :param pulumi.Input[_builtins.str] description: Deployment set description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.int] group_count: Set the number of groups for the deployment set group high availability policy. Value range: 1~7.
               
               Default value: 3
               
               > **NOTE:**  This parameter takes effect only when 'Strategy = AvailabilityGroup.
        :param pulumi.Input[_builtins.str] on_unable_to_redeploy_failed_instance: After the instance in the deployment set is down and migrated, there is no emergency solution for the scattered instance inventory. Value range:
               - `CancelMembershipAndStart`: removes the instance from the deployment set and starts the instance immediately after the instance is down and migrated.
               - `KeepStopped`: The deployment set of the instance is maintained. The instance remains in the stopped state.
               
               Default value: CancelMembershipAndStart.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] strategy: Deployment strategy. Value range:
               - `Availability`: High Availability policy.
               - `AvailabilityGroup`: the high availability policy of the deployment set group.
               - `LowLatency`: Network low latency policy.
               
               Default value: Availability.
        """
        if custom_deployment_set_name is not None:
            pulumi.set(__self__, "custom_deployment_set_name", custom_deployment_set_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_count is not None:
            pulumi.set(__self__, "group_count", group_count)
        if on_unable_to_redeploy_failed_instance is not None:
            pulumi.set(__self__, "on_unable_to_redeploy_failed_instance", on_unable_to_redeploy_failed_instance)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @_builtins.property
    @pulumi.getter(name="customDeploymentSetName")
    def custom_deployment_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "custom_deployment_set_name")

    @custom_deployment_set_name.setter
    def custom_deployment_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_deployment_set_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment set description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupCount")
    def group_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the number of groups for the deployment set group high availability policy. Value range: 1~7.

        Default value: 3

        > **NOTE:**  This parameter takes effect only when 'Strategy = AvailabilityGroup.
        """
        return pulumi.get(self, "group_count")

    @group_count.setter
    def group_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_count", value)

    @_builtins.property
    @pulumi.getter(name="onUnableToRedeployFailedInstance")
    def on_unable_to_redeploy_failed_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        After the instance in the deployment set is down and migrated, there is no emergency solution for the scattered instance inventory. Value range:
        - `CancelMembershipAndStart`: removes the instance from the deployment set and starts the instance immediately after the instance is down and migrated.
        - `KeepStopped`: The deployment set of the instance is maintained. The instance remains in the stopped state.

        Default value: CancelMembershipAndStart.
        """
        return pulumi.get(self, "on_unable_to_redeploy_failed_instance")

    @on_unable_to_redeploy_failed_instance.setter
    def on_unable_to_redeploy_failed_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_unable_to_redeploy_failed_instance", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment strategy. Value range:
        - `Availability`: High Availability policy.
        - `AvailabilityGroup`: the high availability policy of the deployment set group.
        - `LowLatency`: Network low latency policy.

        Default value: Availability.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strategy", value)


@pulumi.type_token("alicloud:rds/customDeploymentSet:CustomDeploymentSet")
class CustomDeploymentSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_deployment_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 on_unable_to_redeploy_failed_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RDS Custom Deployment Set resource.

        Custom Deployment set.

        For information about RDS Custom Deployment Set and how to use it, see [What is Custom Deployment Set](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.235.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.rds.CustomDeploymentSet("default",
            on_unable_to_redeploy_failed_instance="CancelMembershipAndStart",
            custom_deployment_set_name=name,
            description="2024:11:19 1010:1111:0808",
            group_count=3,
            strategy="Availability")
        ```

        ## Import

        RDS Custom Deployment Set can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/customDeploymentSet:CustomDeploymentSet example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_deployment_set_name: The name of the resource
        :param pulumi.Input[_builtins.str] description: Deployment set description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.int] group_count: Set the number of groups for the deployment set group high availability policy. Value range: 1~7.
               
               Default value: 3
               
               > **NOTE:**  This parameter takes effect only when 'Strategy = AvailabilityGroup.
        :param pulumi.Input[_builtins.str] on_unable_to_redeploy_failed_instance: After the instance in the deployment set is down and migrated, there is no emergency solution for the scattered instance inventory. Value range:
               - `CancelMembershipAndStart`: removes the instance from the deployment set and starts the instance immediately after the instance is down and migrated.
               - `KeepStopped`: The deployment set of the instance is maintained. The instance remains in the stopped state.
               
               Default value: CancelMembershipAndStart.
        :param pulumi.Input[_builtins.str] strategy: Deployment strategy. Value range:
               - `Availability`: High Availability policy.
               - `AvailabilityGroup`: the high availability policy of the deployment set group.
               - `LowLatency`: Network low latency policy.
               
               Default value: Availability.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CustomDeploymentSetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RDS Custom Deployment Set resource.

        Custom Deployment set.

        For information about RDS Custom Deployment Set and how to use it, see [What is Custom Deployment Set](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.235.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.rds.CustomDeploymentSet("default",
            on_unable_to_redeploy_failed_instance="CancelMembershipAndStart",
            custom_deployment_set_name=name,
            description="2024:11:19 1010:1111:0808",
            group_count=3,
            strategy="Availability")
        ```

        ## Import

        RDS Custom Deployment Set can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/customDeploymentSet:CustomDeploymentSet example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CustomDeploymentSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDeploymentSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_deployment_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 on_unable_to_redeploy_failed_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDeploymentSetArgs.__new__(CustomDeploymentSetArgs)

            __props__.__dict__["custom_deployment_set_name"] = custom_deployment_set_name
            __props__.__dict__["description"] = description
            __props__.__dict__["group_count"] = group_count
            __props__.__dict__["on_unable_to_redeploy_failed_instance"] = on_unable_to_redeploy_failed_instance
            __props__.__dict__["strategy"] = strategy
            __props__.__dict__["status"] = None
        super(CustomDeploymentSet, __self__).__init__(
            'alicloud:rds/customDeploymentSet:CustomDeploymentSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_deployment_set_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            group_count: Optional[pulumi.Input[_builtins.int]] = None,
            on_unable_to_redeploy_failed_instance: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            strategy: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomDeploymentSet':
        """
        Get an existing CustomDeploymentSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_deployment_set_name: The name of the resource
        :param pulumi.Input[_builtins.str] description: Deployment set description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.int] group_count: Set the number of groups for the deployment set group high availability policy. Value range: 1~7.
               
               Default value: 3
               
               > **NOTE:**  This parameter takes effect only when 'Strategy = AvailabilityGroup.
        :param pulumi.Input[_builtins.str] on_unable_to_redeploy_failed_instance: After the instance in the deployment set is down and migrated, there is no emergency solution for the scattered instance inventory. Value range:
               - `CancelMembershipAndStart`: removes the instance from the deployment set and starts the instance immediately after the instance is down and migrated.
               - `KeepStopped`: The deployment set of the instance is maintained. The instance remains in the stopped state.
               
               Default value: CancelMembershipAndStart.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] strategy: Deployment strategy. Value range:
               - `Availability`: High Availability policy.
               - `AvailabilityGroup`: the high availability policy of the deployment set group.
               - `LowLatency`: Network low latency policy.
               
               Default value: Availability.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDeploymentSetState.__new__(_CustomDeploymentSetState)

        __props__.__dict__["custom_deployment_set_name"] = custom_deployment_set_name
        __props__.__dict__["description"] = description
        __props__.__dict__["group_count"] = group_count
        __props__.__dict__["on_unable_to_redeploy_failed_instance"] = on_unable_to_redeploy_failed_instance
        __props__.__dict__["status"] = status
        __props__.__dict__["strategy"] = strategy
        return CustomDeploymentSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customDeploymentSetName")
    def custom_deployment_set_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "custom_deployment_set_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deployment set description information. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupCount")
    def group_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set the number of groups for the deployment set group high availability policy. Value range: 1~7.

        Default value: 3

        > **NOTE:**  This parameter takes effect only when 'Strategy = AvailabilityGroup.
        """
        return pulumi.get(self, "group_count")

    @_builtins.property
    @pulumi.getter(name="onUnableToRedeployFailedInstance")
    def on_unable_to_redeploy_failed_instance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        After the instance in the deployment set is down and migrated, there is no emergency solution for the scattered instance inventory. Value range:
        - `CancelMembershipAndStart`: removes the instance from the deployment set and starts the instance immediately after the instance is down and migrated.
        - `KeepStopped`: The deployment set of the instance is maintained. The instance remains in the stopped state.

        Default value: CancelMembershipAndStart.
        """
        return pulumi.get(self, "on_unable_to_redeploy_failed_instance")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment strategy. Value range:
        - `Availability`: High Availability policy.
        - `AvailabilityGroup`: the high availability policy of the deployment set group.
        - `LowLatency`: Network low latency policy.

        Default value: Availability.
        """
        return pulumi.get(self, "strategy")

