# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TairInstanceArgs', 'TairInstance']

@pulumi.input_type
class TairInstanceArgs:
    def __init__(__self__, *,
                 instance_class: pulumi.Input[_builtins.str],
                 instance_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 intranet_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_access: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_commands: Optional[pulumi.Input[_builtins.str]] = None,
                 param_repl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 param_semisync_repl_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 param_sentinel_compat_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recover_config_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 src_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tair_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TairInstance resource.
        :param pulumi.Input[_builtins.str] instance_class: The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
        :param pulumi.Input[_builtins.str] instance_type: The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC).
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance is connected.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
        :param pulumi.Input[_builtins.str] auto_renew_period: The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
        :param pulumi.Input[_builtins.str] backup_id: You can set the BackupId parameter to the backup set ID of the source instance. The system uses the data stored in the backup set to create an instance. You can call the DescribeBackups operation to query backup set IDs. If the source instance is a cluster instance, set the BackupId parameter to the backup set IDs of all shards of the source instance, separated by commas (,).
               
               If your instance is a cloud-native cluster instance, we recommend that you use DescribeClusterBackupList to query the backup set ID of the cluster instance. Then, set the ClusterBackupId request parameter to the backup set ID to clone the cluster instance. This eliminates the need to specify the backup set ID of each shard.
        :param pulumi.Input[_builtins.str] cluster_backup_id: This parameter is supported for specific new cluster instances. You can query the backup set ID by calling the DescribeClusterBackupList operation. If this parameter is supported, you can specify the backup set ID. In this case, you do not need to specify the BackupId parameter. If this parameter is not supported, set the BackupId parameter to the IDs of backup sets in all shards of the source instance, separated by commas (,).
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix of the endpoint the instance, which must consist of lowercase letters and numbers and start with a lowercase letter.
        :param pulumi.Input[_builtins.str] effective_time: The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
        :param pulumi.Input[_builtins.str] engine_version: Database version. Default value: 1.0.
               
               Rules for transferring parameters of different tair product types:
               
               tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0.
               
               tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0.
               
               tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of a distributed (Global Distributed Cache) instance, which indicates whether to use the newly created instance as a sub-instance of a distributed instance. You can use this method to create a distributed instance.
               
               1. Enter true if you want the new instance to be the first child instance.
               
               2. If you want the new instance to be used as the second and third sub-instances, enter the distributed instance ID.
               
               3. Not as a distributed instance, you do not need to enter any values.
        :param pulumi.Input[_builtins.int] intranet_bandwidth: Instance intranet bandwidth
        :param pulumi.Input[_builtins.str] modify_mode: The modification method when modifying the IP whitelist. The value includes Cover (default): overwrite the original whitelist; Append: Append the whitelist; Delete: Delete the whitelist.
        :param pulumi.Input[_builtins.str] node_type: The node type. For cloud-native instances, input MASTER_SLAVE (master-replica) or STAND_ALONE (standalone). For classic instances, input double (master-replica) or single (standalone).
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_enabled: sentinel compatibility mode, applicable to non-cluster instances. For more information about parameters, see yes or no in the https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance, valid values: yes, no. The default value is no.
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_access: Whether to allow Sentinel commands to be executed without secrets when Sentinel mode is enabled. Value: yes: enabled. After the command is enabled, you can directly run the Sentinel command in the VPC without enabling the password-free feature. no: the default value, disabled. For parameters, see https://help.aliyun.com/zh/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_commands: After sentinel mode and the# no_loose_sentinel-password-free-access parameter are enabled, you can use this parameter to add additional secret-free command lists (empty by default). After setting, you can execute the corresponding command on any connection without secret, please operate carefully. Commands are written in lowercase letters, and multiple commands are separated by commas (,). See https://help.aliyun.com/zh/redis/user-guide/parameter-support for details
        :param pulumi.Input[_builtins.str] param_repl_mode: The value is semisync or async. The default value is async.
               
               The default data synchronization mode is asynchronous replication. To modify the data synchronization mode, refer to https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_semisync_repl_timeout: The degradation threshold time of the semi-synchronous replication mode. This parameter value is required only when semi-synchronous replication is enabled. The unit is milliseconds, and the range is 10ms to 60000ms. The default value is 500ms. Please refer to: https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_sentinel_compat_enable: sentinel compatibility mode, applicable to instances in the cluster architecture proxy connection mode or read/write splitting architecture. For more information about the parameters, see https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance. The value is 0 or 1. The default value is 0.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default Subscription.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
        :param pulumi.Input[_builtins.int] port: The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
        :param pulumi.Input[_builtins.int] read_only_count: Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions:
               
               If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture.
               
               If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
        :param pulumi.Input[_builtins.str] recover_config_mode: Whether to restore the account, kernel parameters, and whitelist (config) information from the original backup set when creating an instance using a specified backup set. The default value is empty, indicating that the account, kernel parameters, and whitelist information are not restored from the original backup set. This parameter is only applicable to Cloud Native instances, and the account, kernel parameters, and whitelist information must have been saved in the original backup set.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
        :param pulumi.Input[_builtins.str] security_group_id: Security group id
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the IP address whitelist. You cannot modify the whitelist that is generated by the system. If you do not specify this parameter, the default whitelist is modified by default.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in the whitelist. Up to 1,000 IP addresses can be specified in a whitelist. Separate multiple IP addresses with a comma (,). Specify an IP address in the 0.0.0.0/0, 10.23.12.24, or 10.23.12.24/24 format. In CIDR block 10.23.12.24/24, /24 specifies the length of the prefix of an IP address. The prefix length ranges from 1 to 32.
        :param pulumi.Input[_builtins.int] shard_count: The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
        :param pulumi.Input[_builtins.int] slave_read_only_count: Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance.
               
               Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
        :param pulumi.Input[_builtins.str] src_db_instance_id: If you want to create an instance based on the backup set of an existing instance, set this parameter to the ID of the source instance. preceding three parameters. After you specify the SrcDBInstanceId parameter, use the BackupId, ClusterBackupId (recommended for cloud-native cluster instances), or RestoreTime parameter to specify the backup set or the specific point in time that you want to use to create an instance. The SrcDBInstanceId parameter must be used in combination with one of the preceding three parameters.
        :param pulumi.Input[_builtins.str] ssl_enabled: Modifies SSL encryption configurations. Valid values: 1. Disable (The SSL encryption is disabled) 2. Enable (The SSL encryption is enabled)  3. Update (The SSL certificate is updated)
        :param pulumi.Input[_builtins.str] storage_performance_level: The storage type. Valid values: PL1, PL2, and PL3. This parameter is available only when the value of InstanceType is tair_essd, that is, when an ESSD disk instance is selected.
               
               If the ESSD instance type is 4C, 8C, or 16C, you can specify the storage type as PL1.
               
               If the type of ESSD instance you select is 8C, 16C, 32C, or 52C, you can specify the storage type as PL2.
               
               If the ESSD instance type is 16C, 32C, or 52C, you can specify the storage type as PL3.
        :param pulumi.Input[_builtins.int] storage_size_gb: Different specifications have different value ranges. When the instance_type value is tair_essd and the disk type is ESSD, this attribute takes effect and is required. When a Tair disk is an SSD, see-https://help.aliyun.com/zh/redis/product-overview/capacity-storage-type. The capacity field is defined as different fixed values according to different specifications, and does not need to be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] tair_instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] vpc_auth_mode: The VPC authentication mode. Valid values: Open (enables password authentication), Close (disables password authentication and enables [password-free access](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/enable-password-free-access)).
        """
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if cluster_backup_id is not None:
            pulumi.set(__self__, "cluster_backup_id", cluster_backup_id)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_upgrade is not None:
            pulumi.set(__self__, "force_upgrade", force_upgrade)
        if global_instance_id is not None:
            pulumi.set(__self__, "global_instance_id", global_instance_id)
        if intranet_bandwidth is not None:
            pulumi.set(__self__, "intranet_bandwidth", intranet_bandwidth)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if param_no_loose_sentinel_enabled is not None:
            pulumi.set(__self__, "param_no_loose_sentinel_enabled", param_no_loose_sentinel_enabled)
        if param_no_loose_sentinel_password_free_access is not None:
            pulumi.set(__self__, "param_no_loose_sentinel_password_free_access", param_no_loose_sentinel_password_free_access)
        if param_no_loose_sentinel_password_free_commands is not None:
            pulumi.set(__self__, "param_no_loose_sentinel_password_free_commands", param_no_loose_sentinel_password_free_commands)
        if param_repl_mode is not None:
            pulumi.set(__self__, "param_repl_mode", param_repl_mode)
        if param_semisync_repl_timeout is not None:
            pulumi.set(__self__, "param_semisync_repl_timeout", param_semisync_repl_timeout)
        if param_sentinel_compat_enable is not None:
            pulumi.set(__self__, "param_sentinel_compat_enable", param_sentinel_compat_enable)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if read_only_count is not None:
            pulumi.set(__self__, "read_only_count", read_only_count)
        if recover_config_mode is not None:
            pulumi.set(__self__, "recover_config_mode", recover_config_mode)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if secondary_zone_id is not None:
            pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_ip_group_name is not None:
            pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if slave_read_only_count is not None:
            pulumi.set(__self__, "slave_read_only_count", slave_read_only_count)
        if src_db_instance_id is not None:
            pulumi.set(__self__, "src_db_instance_id", src_db_instance_id)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if storage_performance_level is not None:
            pulumi.set(__self__, "storage_performance_level", storage_performance_level)
        if storage_size_gb is not None:
            pulumi.set(__self__, "storage_size_gb", storage_size_gb)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tair_instance_name is not None:
            pulumi.set(__self__, "tair_instance_name", tair_instance_name)
        if vpc_auth_mode is not None:
            pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC).
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vSwitch to which the instance is connected.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Zone ID
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        You can set the BackupId parameter to the backup set ID of the source instance. The system uses the data stored in the backup set to create an instance. You can call the DescribeBackups operation to query backup set IDs. If the source instance is a cluster instance, set the BackupId parameter to the backup set IDs of all shards of the source instance, separated by commas (,).

        If your instance is a cloud-native cluster instance, we recommend that you use DescribeClusterBackupList to query the backup set ID of the cluster instance. Then, set the ClusterBackupId request parameter to the backup set ID to clone the cluster instance. This eliminates the need to specify the backup set ID of each shard.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterBackupId")
    def cluster_backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is supported for specific new cluster instances. You can query the backup set ID by calling the DescribeClusterBackupList operation. If this parameter is supported, you can specify the backup set ID. In this case, you do not need to specify the BackupId parameter. If this parameter is not supported, set the BackupId parameter to the IDs of backup sets in all shards of the source instance, separated by commas (,).
        """
        return pulumi.get(self, "cluster_backup_id")

    @cluster_backup_id.setter
    def cluster_backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_backup_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the endpoint the instance, which must consist of lowercase letters and numbers and start with a lowercase letter.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Default value: 1.0.

        Rules for transferring parameters of different tair product types:

        tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0.

        tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0.

        tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="forceUpgrade")
    def force_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
        """
        return pulumi.get(self, "force_upgrade")

    @force_upgrade.setter
    def force_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="globalInstanceId")
    def global_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a distributed (Global Distributed Cache) instance, which indicates whether to use the newly created instance as a sub-instance of a distributed instance. You can use this method to create a distributed instance.

        1. Enter true if you want the new instance to be the first child instance.

        2. If you want the new instance to be used as the second and third sub-instances, enter the distributed instance ID.

        3. Not as a distributed instance, you do not need to enter any values.
        """
        return pulumi.get(self, "global_instance_id")

    @global_instance_id.setter
    def global_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="intranetBandwidth")
    def intranet_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance intranet bandwidth
        """
        return pulumi.get(self, "intranet_bandwidth")

    @intranet_bandwidth.setter
    def intranet_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "intranet_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The modification method when modifying the IP whitelist. The value includes Cover (default): overwrite the original whitelist; Append: Append the whitelist; Delete: Delete the whitelist.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_mode", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node type. For cloud-native instances, input MASTER_SLAVE (master-replica) or STAND_ALONE (standalone). For classic instances, input double (master-replica) or single (standalone).
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelEnabled")
    def param_no_loose_sentinel_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        sentinel compatibility mode, applicable to non-cluster instances. For more information about parameters, see yes or no in the https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance, valid values: yes, no. The default value is no.
        """
        return pulumi.get(self, "param_no_loose_sentinel_enabled")

    @param_no_loose_sentinel_enabled.setter
    def param_no_loose_sentinel_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_no_loose_sentinel_enabled", value)

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelPasswordFreeAccess")
    def param_no_loose_sentinel_password_free_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow Sentinel commands to be executed without secrets when Sentinel mode is enabled. Value: yes: enabled. After the command is enabled, you can directly run the Sentinel command in the VPC without enabling the password-free feature. no: the default value, disabled. For parameters, see https://help.aliyun.com/zh/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance
        """
        return pulumi.get(self, "param_no_loose_sentinel_password_free_access")

    @param_no_loose_sentinel_password_free_access.setter
    def param_no_loose_sentinel_password_free_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_no_loose_sentinel_password_free_access", value)

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelPasswordFreeCommands")
    def param_no_loose_sentinel_password_free_commands(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        After sentinel mode and the# no_loose_sentinel-password-free-access parameter are enabled, you can use this parameter to add additional secret-free command lists (empty by default). After setting, you can execute the corresponding command on any connection without secret, please operate carefully. Commands are written in lowercase letters, and multiple commands are separated by commas (,). See https://help.aliyun.com/zh/redis/user-guide/parameter-support for details
        """
        return pulumi.get(self, "param_no_loose_sentinel_password_free_commands")

    @param_no_loose_sentinel_password_free_commands.setter
    def param_no_loose_sentinel_password_free_commands(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_no_loose_sentinel_password_free_commands", value)

    @_builtins.property
    @pulumi.getter(name="paramReplMode")
    def param_repl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value is semisync or async. The default value is async.

        The default data synchronization mode is asynchronous replication. To modify the data synchronization mode, refer to https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        """
        return pulumi.get(self, "param_repl_mode")

    @param_repl_mode.setter
    def param_repl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_repl_mode", value)

    @_builtins.property
    @pulumi.getter(name="paramSemisyncReplTimeout")
    def param_semisync_repl_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The degradation threshold time of the semi-synchronous replication mode. This parameter value is required only when semi-synchronous replication is enabled. The unit is milliseconds, and the range is 10ms to 60000ms. The default value is 500ms. Please refer to: https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        """
        return pulumi.get(self, "param_semisync_repl_timeout")

    @param_semisync_repl_timeout.setter
    def param_semisync_repl_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_semisync_repl_timeout", value)

    @_builtins.property
    @pulumi.getter(name="paramSentinelCompatEnable")
    def param_sentinel_compat_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        sentinel compatibility mode, applicable to instances in the cluster architecture proxy connection mode or read/write splitting architecture. For more information about the parameters, see https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance. The value is 0 or 1. The default value is 0.
        """
        return pulumi.get(self, "param_sentinel_compat_enable")

    @param_sentinel_compat_enable.setter
    def param_sentinel_compat_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_sentinel_compat_enable", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default Subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyCount")
    def read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions:

        If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture.

        If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
        """
        return pulumi.get(self, "read_only_count")

    @read_only_count.setter
    def read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="recoverConfigMode")
    def recover_config_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to restore the account, kernel parameters, and whitelist (config) information from the original backup set when creating an instance using a specified backup set. The default value is empty, indicating that the account, kernel parameters, and whitelist information are not restored from the original backup set. This parameter is only applicable to Cloud Native instances, and the account, kernel parameters, and whitelist information must have been saved in the original backup set.
        """
        return pulumi.get(self, "recover_config_mode")

    @recover_config_mode.setter
    def recover_config_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recover_config_mode", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security group id
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP address whitelist. You cannot modify the whitelist that is generated by the system. If you do not specify this parameter, the default whitelist is modified by default.
        """
        return pulumi.get(self, "security_ip_group_name")

    @security_ip_group_name.setter
    def security_ip_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP addresses in the whitelist. Up to 1,000 IP addresses can be specified in a whitelist. Separate multiple IP addresses with a comma (,). Specify an IP address in the 0.0.0.0/0, 10.23.12.24, or 10.23.12.24/24 format. In CIDR block 10.23.12.24/24, /24 specifies the length of the prefix of an IP address. The prefix length ranges from 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="slaveReadOnlyCount")
    def slave_read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance.

        Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
        """
        return pulumi.get(self, "slave_read_only_count")

    @slave_read_only_count.setter
    def slave_read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slave_read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="srcDbInstanceId")
    def src_db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you want to create an instance based on the backup set of an existing instance, set this parameter to the ID of the source instance. preceding three parameters. After you specify the SrcDBInstanceId parameter, use the BackupId, ClusterBackupId (recommended for cloud-native cluster instances), or RestoreTime parameter to specify the backup set or the specific point in time that you want to use to create an instance. The SrcDBInstanceId parameter must be used in combination with one of the preceding three parameters.
        """
        return pulumi.get(self, "src_db_instance_id")

    @src_db_instance_id.setter
    def src_db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modifies SSL encryption configurations. Valid values: 1. Disable (The SSL encryption is disabled) 2. Enable (The SSL encryption is enabled)  3. Update (The SSL certificate is updated)
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="storagePerformanceLevel")
    def storage_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type. Valid values: PL1, PL2, and PL3. This parameter is available only when the value of InstanceType is tair_essd, that is, when an ESSD disk instance is selected.

        If the ESSD instance type is 4C, 8C, or 16C, you can specify the storage type as PL1.

        If the type of ESSD instance you select is 8C, 16C, 32C, or 52C, you can specify the storage type as PL2.

        If the ESSD instance type is 16C, 32C, or 52C, you can specify the storage type as PL3.
        """
        return pulumi.get(self, "storage_performance_level")

    @storage_performance_level.setter
    def storage_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="storageSizeGb")
    def storage_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Different specifications have different value ranges. When the instance_type value is tair_essd and the disk type is ESSD, this attribute takes effect and is required. When a Tair disk is an SSD, see-https://help.aliyun.com/zh/redis/product-overview/capacity-storage-type. The capacity field is defined as different fixed values according to different specifications, and does not need to be specified.
        """
        return pulumi.get(self, "storage_size_gb")

    @storage_size_gb.setter
    def storage_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size_gb", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tairInstanceName")
    def tair_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "tair_instance_name")

    @tair_instance_name.setter
    def tair_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tair_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC authentication mode. Valid values: Open (enables password authentication), Close (disables password authentication and enables [password-free access](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/enable-password-free-access)).
        """
        return pulumi.get(self, "vpc_auth_mode")

    @vpc_auth_mode.setter
    def vpc_auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_auth_mode", value)


@pulumi.input_type
class _TairInstanceState:
    def __init__(__self__, *,
                 architecture_type: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 intranet_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 max_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_access: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_commands: Optional[pulumi.Input[_builtins.str]] = None,
                 param_repl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 param_semisync_repl_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 param_sentinel_compat_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recover_config_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 src_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tair_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tair_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TairInstance resources.
        :param pulumi.Input[_builtins.str] architecture_type: The architecture of the instance.  cluster, standard, rwsplit.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
        :param pulumi.Input[_builtins.str] auto_renew_period: The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
        :param pulumi.Input[_builtins.str] backup_id: You can set the BackupId parameter to the backup set ID of the source instance. The system uses the data stored in the backup set to create an instance. You can call the DescribeBackups operation to query backup set IDs. If the source instance is a cluster instance, set the BackupId parameter to the backup set IDs of all shards of the source instance, separated by commas (,).
               
               If your instance is a cloud-native cluster instance, we recommend that you use DescribeClusterBackupList to query the backup set ID of the cluster instance. Then, set the ClusterBackupId request parameter to the backup set ID to clone the cluster instance. This eliminates the need to specify the backup set ID of each shard.
        :param pulumi.Input[_builtins.str] cluster_backup_id: This parameter is supported for specific new cluster instances. You can query the backup set ID by calling the DescribeClusterBackupList operation. If this parameter is supported, you can specify the backup set ID. In this case, you do not need to specify the BackupId parameter. If this parameter is not supported, set the BackupId parameter to the IDs of backup sets in all shards of the source instance, separated by commas (,).
        :param pulumi.Input[_builtins.str] connection_domain: The internal endpoint of the instance.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix of the endpoint the instance, which must consist of lowercase letters and numbers and start with a lowercase letter.
        :param pulumi.Input[_builtins.str] create_time: The time when the instance was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] effective_time: The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
        :param pulumi.Input[_builtins.str] engine_version: Database version. Default value: 1.0.
               
               Rules for transferring parameters of different tair product types:
               
               tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0.
               
               tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0.
               
               tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of a distributed (Global Distributed Cache) instance, which indicates whether to use the newly created instance as a sub-instance of a distributed instance. You can use this method to create a distributed instance.
               
               1. Enter true if you want the new instance to be the first child instance.
               
               2. If you want the new instance to be used as the second and third sub-instances, enter the distributed instance ID.
               
               3. Not as a distributed instance, you do not need to enter any values.
        :param pulumi.Input[_builtins.str] instance_class: The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
        :param pulumi.Input[_builtins.str] instance_type: The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
        :param pulumi.Input[_builtins.int] intranet_bandwidth: Instance intranet bandwidth
        :param pulumi.Input[_builtins.int] max_connections: The maximum number of connections supported by the instance.
        :param pulumi.Input[_builtins.str] modify_mode: The modification method when modifying the IP whitelist. The value includes Cover (default): overwrite the original whitelist; Append: Append the whitelist; Delete: Delete the whitelist.
        :param pulumi.Input[_builtins.str] network_type: The network type of the instance.  CLASSIC(classic network), VPC.
        :param pulumi.Input[_builtins.str] node_type: The node type. For cloud-native instances, input MASTER_SLAVE (master-replica) or STAND_ALONE (standalone). For classic instances, input double (master-replica) or single (standalone).
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_enabled: sentinel compatibility mode, applicable to non-cluster instances. For more information about parameters, see yes or no in the https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance, valid values: yes, no. The default value is no.
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_access: Whether to allow Sentinel commands to be executed without secrets when Sentinel mode is enabled. Value: yes: enabled. After the command is enabled, you can directly run the Sentinel command in the VPC without enabling the password-free feature. no: the default value, disabled. For parameters, see https://help.aliyun.com/zh/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_commands: After sentinel mode and the# no_loose_sentinel-password-free-access parameter are enabled, you can use this parameter to add additional secret-free command lists (empty by default). After setting, you can execute the corresponding command on any connection without secret, please operate carefully. Commands are written in lowercase letters, and multiple commands are separated by commas (,). See https://help.aliyun.com/zh/redis/user-guide/parameter-support for details
        :param pulumi.Input[_builtins.str] param_repl_mode: The value is semisync or async. The default value is async.
               
               The default data synchronization mode is asynchronous replication. To modify the data synchronization mode, refer to https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_semisync_repl_timeout: The degradation threshold time of the semi-synchronous replication mode. This parameter value is required only when semi-synchronous replication is enabled. The unit is milliseconds, and the range is 10ms to 60000ms. The default value is 500ms. Please refer to: https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_sentinel_compat_enable: sentinel compatibility mode, applicable to instances in the cluster architecture proxy connection mode or read/write splitting architecture. For more information about the parameters, see https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance. The value is 0 or 1. The default value is 0.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default Subscription.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
        :param pulumi.Input[_builtins.int] port: The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
        :param pulumi.Input[_builtins.int] read_only_count: Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions:
               
               If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture.
               
               If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
        :param pulumi.Input[_builtins.str] recover_config_mode: Whether to restore the account, kernel parameters, and whitelist (config) information from the original backup set when creating an instance using a specified backup set. The default value is empty, indicating that the account, kernel parameters, and whitelist information are not restored from the original backup set. This parameter is only applicable to Cloud Native instances, and the account, kernel parameters, and whitelist information must have been saved in the original backup set.
        :param pulumi.Input[_builtins.str] region_id: Region Id
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
        :param pulumi.Input[_builtins.str] security_group_id: Security group id
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the IP address whitelist. You cannot modify the whitelist that is generated by the system. If you do not specify this parameter, the default whitelist is modified by default.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in the whitelist. Up to 1,000 IP addresses can be specified in a whitelist. Separate multiple IP addresses with a comma (,). Specify an IP address in the 0.0.0.0/0, 10.23.12.24, or 10.23.12.24/24 format. In CIDR block 10.23.12.24/24, /24 specifies the length of the prefix of an IP address. The prefix length ranges from 1 to 32.
        :param pulumi.Input[_builtins.int] shard_count: The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
        :param pulumi.Input[_builtins.int] slave_read_only_count: Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance.
               
               Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
        :param pulumi.Input[_builtins.str] src_db_instance_id: If you want to create an instance based on the backup set of an existing instance, set this parameter to the ID of the source instance. preceding three parameters. After you specify the SrcDBInstanceId parameter, use the BackupId, ClusterBackupId (recommended for cloud-native cluster instances), or RestoreTime parameter to specify the backup set or the specific point in time that you want to use to create an instance. The SrcDBInstanceId parameter must be used in combination with one of the preceding three parameters.
        :param pulumi.Input[_builtins.str] ssl_enabled: Modifies SSL encryption configurations. Valid values: 1. Disable (The SSL encryption is disabled) 2. Enable (The SSL encryption is enabled)  3. Update (The SSL certificate is updated)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] storage_performance_level: The storage type. Valid values: PL1, PL2, and PL3. This parameter is available only when the value of InstanceType is tair_essd, that is, when an ESSD disk instance is selected.
               
               If the ESSD instance type is 4C, 8C, or 16C, you can specify the storage type as PL1.
               
               If the type of ESSD instance you select is 8C, 16C, 32C, or 52C, you can specify the storage type as PL2.
               
               If the ESSD instance type is 16C, 32C, or 52C, you can specify the storage type as PL3.
        :param pulumi.Input[_builtins.int] storage_size_gb: Different specifications have different value ranges. When the instance_type value is tair_essd and the disk type is ESSD, this attribute takes effect and is required. When a Tair disk is an SSD, see-https://help.aliyun.com/zh/redis/product-overview/capacity-storage-type. The capacity field is defined as different fixed values according to different specifications, and does not need to be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] tair_instance_id: The ID of the resource.
        :param pulumi.Input[_builtins.str] tair_instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] vpc_auth_mode: The VPC authentication mode. Valid values: Open (enables password authentication), Close (disables password authentication and enables [password-free access](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/enable-password-free-access)).
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC).
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance is connected.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        """
        if architecture_type is not None:
            pulumi.set(__self__, "architecture_type", architecture_type)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if cluster_backup_id is not None:
            pulumi.set(__self__, "cluster_backup_id", cluster_backup_id)
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_upgrade is not None:
            pulumi.set(__self__, "force_upgrade", force_upgrade)
        if global_instance_id is not None:
            pulumi.set(__self__, "global_instance_id", global_instance_id)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if intranet_bandwidth is not None:
            pulumi.set(__self__, "intranet_bandwidth", intranet_bandwidth)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if param_no_loose_sentinel_enabled is not None:
            pulumi.set(__self__, "param_no_loose_sentinel_enabled", param_no_loose_sentinel_enabled)
        if param_no_loose_sentinel_password_free_access is not None:
            pulumi.set(__self__, "param_no_loose_sentinel_password_free_access", param_no_loose_sentinel_password_free_access)
        if param_no_loose_sentinel_password_free_commands is not None:
            pulumi.set(__self__, "param_no_loose_sentinel_password_free_commands", param_no_loose_sentinel_password_free_commands)
        if param_repl_mode is not None:
            pulumi.set(__self__, "param_repl_mode", param_repl_mode)
        if param_semisync_repl_timeout is not None:
            pulumi.set(__self__, "param_semisync_repl_timeout", param_semisync_repl_timeout)
        if param_sentinel_compat_enable is not None:
            pulumi.set(__self__, "param_sentinel_compat_enable", param_sentinel_compat_enable)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if read_only_count is not None:
            pulumi.set(__self__, "read_only_count", read_only_count)
        if recover_config_mode is not None:
            pulumi.set(__self__, "recover_config_mode", recover_config_mode)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if secondary_zone_id is not None:
            pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_ip_group_name is not None:
            pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if slave_read_only_count is not None:
            pulumi.set(__self__, "slave_read_only_count", slave_read_only_count)
        if src_db_instance_id is not None:
            pulumi.set(__self__, "src_db_instance_id", src_db_instance_id)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_performance_level is not None:
            pulumi.set(__self__, "storage_performance_level", storage_performance_level)
        if storage_size_gb is not None:
            pulumi.set(__self__, "storage_size_gb", storage_size_gb)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tair_instance_id is not None:
            pulumi.set(__self__, "tair_instance_id", tair_instance_id)
        if tair_instance_name is not None:
            pulumi.set(__self__, "tair_instance_name", tair_instance_name)
        if vpc_auth_mode is not None:
            pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="architectureType")
    def architecture_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The architecture of the instance.  cluster, standard, rwsplit.
        """
        return pulumi.get(self, "architecture_type")

    @architecture_type.setter
    def architecture_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture_type", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        You can set the BackupId parameter to the backup set ID of the source instance. The system uses the data stored in the backup set to create an instance. You can call the DescribeBackups operation to query backup set IDs. If the source instance is a cluster instance, set the BackupId parameter to the backup set IDs of all shards of the source instance, separated by commas (,).

        If your instance is a cloud-native cluster instance, we recommend that you use DescribeClusterBackupList to query the backup set ID of the cluster instance. Then, set the ClusterBackupId request parameter to the backup set ID to clone the cluster instance. This eliminates the need to specify the backup set ID of each shard.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterBackupId")
    def cluster_backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is supported for specific new cluster instances. You can query the backup set ID by calling the DescribeClusterBackupList operation. If this parameter is supported, you can specify the backup set ID. In this case, you do not need to specify the BackupId parameter. If this parameter is not supported, set the BackupId parameter to the IDs of backup sets in all shards of the source instance, separated by commas (,).
        """
        return pulumi.get(self, "cluster_backup_id")

    @cluster_backup_id.setter
    def cluster_backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_backup_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal endpoint of the instance.
        """
        return pulumi.get(self, "connection_domain")

    @connection_domain.setter
    def connection_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_domain", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the endpoint the instance, which must consist of lowercase letters and numbers and start with a lowercase letter.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the instance was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Default value: 1.0.

        Rules for transferring parameters of different tair product types:

        tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0.

        tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0.

        tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="forceUpgrade")
    def force_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
        """
        return pulumi.get(self, "force_upgrade")

    @force_upgrade.setter
    def force_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="globalInstanceId")
    def global_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a distributed (Global Distributed Cache) instance, which indicates whether to use the newly created instance as a sub-instance of a distributed instance. You can use this method to create a distributed instance.

        1. Enter true if you want the new instance to be the first child instance.

        2. If you want the new instance to be used as the second and third sub-instances, enter the distributed instance ID.

        3. Not as a distributed instance, you do not need to enter any values.
        """
        return pulumi.get(self, "global_instance_id")

    @global_instance_id.setter
    def global_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="intranetBandwidth")
    def intranet_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance intranet bandwidth
        """
        return pulumi.get(self, "intranet_bandwidth")

    @intranet_bandwidth.setter
    def intranet_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "intranet_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections supported by the instance.
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_connections", value)

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The modification method when modifying the IP whitelist. The value includes Cover (default): overwrite the original whitelist; Append: Append the whitelist; Delete: Delete the whitelist.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_mode", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the instance.  CLASSIC(classic network), VPC.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node type. For cloud-native instances, input MASTER_SLAVE (master-replica) or STAND_ALONE (standalone). For classic instances, input double (master-replica) or single (standalone).
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelEnabled")
    def param_no_loose_sentinel_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        sentinel compatibility mode, applicable to non-cluster instances. For more information about parameters, see yes or no in the https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance, valid values: yes, no. The default value is no.
        """
        return pulumi.get(self, "param_no_loose_sentinel_enabled")

    @param_no_loose_sentinel_enabled.setter
    def param_no_loose_sentinel_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_no_loose_sentinel_enabled", value)

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelPasswordFreeAccess")
    def param_no_loose_sentinel_password_free_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow Sentinel commands to be executed without secrets when Sentinel mode is enabled. Value: yes: enabled. After the command is enabled, you can directly run the Sentinel command in the VPC without enabling the password-free feature. no: the default value, disabled. For parameters, see https://help.aliyun.com/zh/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance
        """
        return pulumi.get(self, "param_no_loose_sentinel_password_free_access")

    @param_no_loose_sentinel_password_free_access.setter
    def param_no_loose_sentinel_password_free_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_no_loose_sentinel_password_free_access", value)

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelPasswordFreeCommands")
    def param_no_loose_sentinel_password_free_commands(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        After sentinel mode and the# no_loose_sentinel-password-free-access parameter are enabled, you can use this parameter to add additional secret-free command lists (empty by default). After setting, you can execute the corresponding command on any connection without secret, please operate carefully. Commands are written in lowercase letters, and multiple commands are separated by commas (,). See https://help.aliyun.com/zh/redis/user-guide/parameter-support for details
        """
        return pulumi.get(self, "param_no_loose_sentinel_password_free_commands")

    @param_no_loose_sentinel_password_free_commands.setter
    def param_no_loose_sentinel_password_free_commands(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_no_loose_sentinel_password_free_commands", value)

    @_builtins.property
    @pulumi.getter(name="paramReplMode")
    def param_repl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value is semisync or async. The default value is async.

        The default data synchronization mode is asynchronous replication. To modify the data synchronization mode, refer to https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        """
        return pulumi.get(self, "param_repl_mode")

    @param_repl_mode.setter
    def param_repl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_repl_mode", value)

    @_builtins.property
    @pulumi.getter(name="paramSemisyncReplTimeout")
    def param_semisync_repl_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The degradation threshold time of the semi-synchronous replication mode. This parameter value is required only when semi-synchronous replication is enabled. The unit is milliseconds, and the range is 10ms to 60000ms. The default value is 500ms. Please refer to: https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        """
        return pulumi.get(self, "param_semisync_repl_timeout")

    @param_semisync_repl_timeout.setter
    def param_semisync_repl_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_semisync_repl_timeout", value)

    @_builtins.property
    @pulumi.getter(name="paramSentinelCompatEnable")
    def param_sentinel_compat_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        sentinel compatibility mode, applicable to instances in the cluster architecture proxy connection mode or read/write splitting architecture. For more information about the parameters, see https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance. The value is 0 or 1. The default value is 0.
        """
        return pulumi.get(self, "param_sentinel_compat_enable")

    @param_sentinel_compat_enable.setter
    def param_sentinel_compat_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_sentinel_compat_enable", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default Subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyCount")
    def read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions:

        If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture.

        If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
        """
        return pulumi.get(self, "read_only_count")

    @read_only_count.setter
    def read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="recoverConfigMode")
    def recover_config_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to restore the account, kernel parameters, and whitelist (config) information from the original backup set when creating an instance using a specified backup set. The default value is empty, indicating that the account, kernel parameters, and whitelist information are not restored from the original backup set. This parameter is only applicable to Cloud Native instances, and the account, kernel parameters, and whitelist information must have been saved in the original backup set.
        """
        return pulumi.get(self, "recover_config_mode")

    @recover_config_mode.setter
    def recover_config_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recover_config_mode", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region Id
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security group id
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP address whitelist. You cannot modify the whitelist that is generated by the system. If you do not specify this parameter, the default whitelist is modified by default.
        """
        return pulumi.get(self, "security_ip_group_name")

    @security_ip_group_name.setter
    def security_ip_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP addresses in the whitelist. Up to 1,000 IP addresses can be specified in a whitelist. Separate multiple IP addresses with a comma (,). Specify an IP address in the 0.0.0.0/0, 10.23.12.24, or 10.23.12.24/24 format. In CIDR block 10.23.12.24/24, /24 specifies the length of the prefix of an IP address. The prefix length ranges from 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="slaveReadOnlyCount")
    def slave_read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance.

        Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
        """
        return pulumi.get(self, "slave_read_only_count")

    @slave_read_only_count.setter
    def slave_read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slave_read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="srcDbInstanceId")
    def src_db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you want to create an instance based on the backup set of an existing instance, set this parameter to the ID of the source instance. preceding three parameters. After you specify the SrcDBInstanceId parameter, use the BackupId, ClusterBackupId (recommended for cloud-native cluster instances), or RestoreTime parameter to specify the backup set or the specific point in time that you want to use to create an instance. The SrcDBInstanceId parameter must be used in combination with one of the preceding three parameters.
        """
        return pulumi.get(self, "src_db_instance_id")

    @src_db_instance_id.setter
    def src_db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modifies SSL encryption configurations. Valid values: 1. Disable (The SSL encryption is disabled) 2. Enable (The SSL encryption is enabled)  3. Update (The SSL certificate is updated)
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_enabled", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storagePerformanceLevel")
    def storage_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type. Valid values: PL1, PL2, and PL3. This parameter is available only when the value of InstanceType is tair_essd, that is, when an ESSD disk instance is selected.

        If the ESSD instance type is 4C, 8C, or 16C, you can specify the storage type as PL1.

        If the type of ESSD instance you select is 8C, 16C, 32C, or 52C, you can specify the storage type as PL2.

        If the ESSD instance type is 16C, 32C, or 52C, you can specify the storage type as PL3.
        """
        return pulumi.get(self, "storage_performance_level")

    @storage_performance_level.setter
    def storage_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="storageSizeGb")
    def storage_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Different specifications have different value ranges. When the instance_type value is tair_essd and the disk type is ESSD, this attribute takes effect and is required. When a Tair disk is an SSD, see-https://help.aliyun.com/zh/redis/product-overview/capacity-storage-type. The capacity field is defined as different fixed values according to different specifications, and does not need to be specified.
        """
        return pulumi.get(self, "storage_size_gb")

    @storage_size_gb.setter
    def storage_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size_gb", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tairInstanceId")
    def tair_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "tair_instance_id")

    @tair_instance_id.setter
    def tair_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tair_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="tairInstanceName")
    def tair_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "tair_instance_name")

    @tair_instance_name.setter
    def tair_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tair_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC authentication mode. Valid values: Open (enables password authentication), Close (disables password authentication and enables [password-free access](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/enable-password-free-access)).
        """
        return pulumi.get(self, "vpc_auth_mode")

    @vpc_auth_mode.setter
    def vpc_auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC).
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch to which the instance is connected.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:redis/tairInstance:TairInstance")
class TairInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 intranet_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_access: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_commands: Optional[pulumi.Input[_builtins.str]] = None,
                 param_repl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 param_semisync_repl_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 param_sentinel_compat_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recover_config_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 src_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tair_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Tair (Redis OSS-Compatible) And Memcache (KVStore) Tair Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:redis/tairInstance:TairInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
        :param pulumi.Input[_builtins.str] auto_renew_period: The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
        :param pulumi.Input[_builtins.str] backup_id: You can set the BackupId parameter to the backup set ID of the source instance. The system uses the data stored in the backup set to create an instance. You can call the DescribeBackups operation to query backup set IDs. If the source instance is a cluster instance, set the BackupId parameter to the backup set IDs of all shards of the source instance, separated by commas (,).
               
               If your instance is a cloud-native cluster instance, we recommend that you use DescribeClusterBackupList to query the backup set ID of the cluster instance. Then, set the ClusterBackupId request parameter to the backup set ID to clone the cluster instance. This eliminates the need to specify the backup set ID of each shard.
        :param pulumi.Input[_builtins.str] cluster_backup_id: This parameter is supported for specific new cluster instances. You can query the backup set ID by calling the DescribeClusterBackupList operation. If this parameter is supported, you can specify the backup set ID. In this case, you do not need to specify the BackupId parameter. If this parameter is not supported, set the BackupId parameter to the IDs of backup sets in all shards of the source instance, separated by commas (,).
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix of the endpoint the instance, which must consist of lowercase letters and numbers and start with a lowercase letter.
        :param pulumi.Input[_builtins.str] effective_time: The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
        :param pulumi.Input[_builtins.str] engine_version: Database version. Default value: 1.0.
               
               Rules for transferring parameters of different tair product types:
               
               tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0.
               
               tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0.
               
               tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of a distributed (Global Distributed Cache) instance, which indicates whether to use the newly created instance as a sub-instance of a distributed instance. You can use this method to create a distributed instance.
               
               1. Enter true if you want the new instance to be the first child instance.
               
               2. If you want the new instance to be used as the second and third sub-instances, enter the distributed instance ID.
               
               3. Not as a distributed instance, you do not need to enter any values.
        :param pulumi.Input[_builtins.str] instance_class: The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
        :param pulumi.Input[_builtins.str] instance_type: The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
        :param pulumi.Input[_builtins.int] intranet_bandwidth: Instance intranet bandwidth
        :param pulumi.Input[_builtins.str] modify_mode: The modification method when modifying the IP whitelist. The value includes Cover (default): overwrite the original whitelist; Append: Append the whitelist; Delete: Delete the whitelist.
        :param pulumi.Input[_builtins.str] node_type: The node type. For cloud-native instances, input MASTER_SLAVE (master-replica) or STAND_ALONE (standalone). For classic instances, input double (master-replica) or single (standalone).
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_enabled: sentinel compatibility mode, applicable to non-cluster instances. For more information about parameters, see yes or no in the https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance, valid values: yes, no. The default value is no.
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_access: Whether to allow Sentinel commands to be executed without secrets when Sentinel mode is enabled. Value: yes: enabled. After the command is enabled, you can directly run the Sentinel command in the VPC without enabling the password-free feature. no: the default value, disabled. For parameters, see https://help.aliyun.com/zh/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_commands: After sentinel mode and the# no_loose_sentinel-password-free-access parameter are enabled, you can use this parameter to add additional secret-free command lists (empty by default). After setting, you can execute the corresponding command on any connection without secret, please operate carefully. Commands are written in lowercase letters, and multiple commands are separated by commas (,). See https://help.aliyun.com/zh/redis/user-guide/parameter-support for details
        :param pulumi.Input[_builtins.str] param_repl_mode: The value is semisync or async. The default value is async.
               
               The default data synchronization mode is asynchronous replication. To modify the data synchronization mode, refer to https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_semisync_repl_timeout: The degradation threshold time of the semi-synchronous replication mode. This parameter value is required only when semi-synchronous replication is enabled. The unit is milliseconds, and the range is 10ms to 60000ms. The default value is 500ms. Please refer to: https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_sentinel_compat_enable: sentinel compatibility mode, applicable to instances in the cluster architecture proxy connection mode or read/write splitting architecture. For more information about the parameters, see https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance. The value is 0 or 1. The default value is 0.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default Subscription.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
        :param pulumi.Input[_builtins.int] port: The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
        :param pulumi.Input[_builtins.int] read_only_count: Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions:
               
               If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture.
               
               If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
        :param pulumi.Input[_builtins.str] recover_config_mode: Whether to restore the account, kernel parameters, and whitelist (config) information from the original backup set when creating an instance using a specified backup set. The default value is empty, indicating that the account, kernel parameters, and whitelist information are not restored from the original backup set. This parameter is only applicable to Cloud Native instances, and the account, kernel parameters, and whitelist information must have been saved in the original backup set.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
        :param pulumi.Input[_builtins.str] security_group_id: Security group id
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the IP address whitelist. You cannot modify the whitelist that is generated by the system. If you do not specify this parameter, the default whitelist is modified by default.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in the whitelist. Up to 1,000 IP addresses can be specified in a whitelist. Separate multiple IP addresses with a comma (,). Specify an IP address in the 0.0.0.0/0, 10.23.12.24, or 10.23.12.24/24 format. In CIDR block 10.23.12.24/24, /24 specifies the length of the prefix of an IP address. The prefix length ranges from 1 to 32.
        :param pulumi.Input[_builtins.int] shard_count: The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
        :param pulumi.Input[_builtins.int] slave_read_only_count: Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance.
               
               Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
        :param pulumi.Input[_builtins.str] src_db_instance_id: If you want to create an instance based on the backup set of an existing instance, set this parameter to the ID of the source instance. preceding three parameters. After you specify the SrcDBInstanceId parameter, use the BackupId, ClusterBackupId (recommended for cloud-native cluster instances), or RestoreTime parameter to specify the backup set or the specific point in time that you want to use to create an instance. The SrcDBInstanceId parameter must be used in combination with one of the preceding three parameters.
        :param pulumi.Input[_builtins.str] ssl_enabled: Modifies SSL encryption configurations. Valid values: 1. Disable (The SSL encryption is disabled) 2. Enable (The SSL encryption is enabled)  3. Update (The SSL certificate is updated)
        :param pulumi.Input[_builtins.str] storage_performance_level: The storage type. Valid values: PL1, PL2, and PL3. This parameter is available only when the value of InstanceType is tair_essd, that is, when an ESSD disk instance is selected.
               
               If the ESSD instance type is 4C, 8C, or 16C, you can specify the storage type as PL1.
               
               If the type of ESSD instance you select is 8C, 16C, 32C, or 52C, you can specify the storage type as PL2.
               
               If the ESSD instance type is 16C, 32C, or 52C, you can specify the storage type as PL3.
        :param pulumi.Input[_builtins.int] storage_size_gb: Different specifications have different value ranges. When the instance_type value is tair_essd and the disk type is ESSD, this attribute takes effect and is required. When a Tair disk is an SSD, see-https://help.aliyun.com/zh/redis/product-overview/capacity-storage-type. The capacity field is defined as different fixed values according to different specifications, and does not need to be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] tair_instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] vpc_auth_mode: The VPC authentication mode. Valid values: Open (enables password authentication), Close (disables password authentication and enables [password-free access](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/enable-password-free-access)).
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC).
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance is connected.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TairInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Tair (Redis OSS-Compatible) And Memcache (KVStore) Tair Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:redis/tairInstance:TairInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TairInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TairInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 intranet_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_access: Optional[pulumi.Input[_builtins.str]] = None,
                 param_no_loose_sentinel_password_free_commands: Optional[pulumi.Input[_builtins.str]] = None,
                 param_repl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 param_semisync_repl_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 param_sentinel_compat_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recover_config_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 src_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tair_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TairInstanceArgs.__new__(TairInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["cluster_backup_id"] = cluster_backup_id
            __props__.__dict__["connection_string_prefix"] = connection_string_prefix
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_upgrade"] = force_upgrade
            __props__.__dict__["global_instance_id"] = global_instance_id
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["intranet_bandwidth"] = intranet_bandwidth
            __props__.__dict__["modify_mode"] = modify_mode
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["param_no_loose_sentinel_enabled"] = param_no_loose_sentinel_enabled
            __props__.__dict__["param_no_loose_sentinel_password_free_access"] = param_no_loose_sentinel_password_free_access
            __props__.__dict__["param_no_loose_sentinel_password_free_commands"] = param_no_loose_sentinel_password_free_commands
            __props__.__dict__["param_repl_mode"] = param_repl_mode
            __props__.__dict__["param_semisync_repl_timeout"] = param_semisync_repl_timeout
            __props__.__dict__["param_sentinel_compat_enable"] = param_sentinel_compat_enable
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["port"] = port
            __props__.__dict__["read_only_count"] = read_only_count
            __props__.__dict__["recover_config_mode"] = recover_config_mode
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["secondary_zone_id"] = secondary_zone_id
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_ip_group_name"] = security_ip_group_name
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["slave_read_only_count"] = slave_read_only_count
            __props__.__dict__["src_db_instance_id"] = src_db_instance_id
            __props__.__dict__["ssl_enabled"] = ssl_enabled
            __props__.__dict__["storage_performance_level"] = storage_performance_level
            __props__.__dict__["storage_size_gb"] = storage_size_gb
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tair_instance_name"] = tair_instance_name
            __props__.__dict__["vpc_auth_mode"] = vpc_auth_mode
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["architecture_type"] = None
            __props__.__dict__["connection_domain"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["max_connections"] = None
            __props__.__dict__["network_type"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tair_instance_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TairInstance, __self__).__init__(
            'alicloud:redis/tairInstance:TairInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture_type: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.str]] = None,
            backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_time: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            intranet_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            max_connections: Optional[pulumi.Input[_builtins.int]] = None,
            modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            param_no_loose_sentinel_enabled: Optional[pulumi.Input[_builtins.str]] = None,
            param_no_loose_sentinel_password_free_access: Optional[pulumi.Input[_builtins.str]] = None,
            param_no_loose_sentinel_password_free_commands: Optional[pulumi.Input[_builtins.str]] = None,
            param_repl_mode: Optional[pulumi.Input[_builtins.str]] = None,
            param_semisync_repl_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            param_sentinel_compat_enable: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
            recover_config_mode: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_ips: Optional[pulumi.Input[_builtins.str]] = None,
            shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
            src_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tair_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            tair_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TairInstance':
        """
        Get an existing TairInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] architecture_type: The architecture of the instance.  cluster, standard, rwsplit.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
        :param pulumi.Input[_builtins.str] auto_renew_period: The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
        :param pulumi.Input[_builtins.str] backup_id: You can set the BackupId parameter to the backup set ID of the source instance. The system uses the data stored in the backup set to create an instance. You can call the DescribeBackups operation to query backup set IDs. If the source instance is a cluster instance, set the BackupId parameter to the backup set IDs of all shards of the source instance, separated by commas (,).
               
               If your instance is a cloud-native cluster instance, we recommend that you use DescribeClusterBackupList to query the backup set ID of the cluster instance. Then, set the ClusterBackupId request parameter to the backup set ID to clone the cluster instance. This eliminates the need to specify the backup set ID of each shard.
        :param pulumi.Input[_builtins.str] cluster_backup_id: This parameter is supported for specific new cluster instances. You can query the backup set ID by calling the DescribeClusterBackupList operation. If this parameter is supported, you can specify the backup set ID. In this case, you do not need to specify the BackupId parameter. If this parameter is not supported, set the BackupId parameter to the IDs of backup sets in all shards of the source instance, separated by commas (,).
        :param pulumi.Input[_builtins.str] connection_domain: The internal endpoint of the instance.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The prefix of the endpoint the instance, which must consist of lowercase letters and numbers and start with a lowercase letter.
        :param pulumi.Input[_builtins.str] create_time: The time when the instance was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] effective_time: The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
        :param pulumi.Input[_builtins.str] engine_version: Database version. Default value: 1.0.
               
               Rules for transferring parameters of different tair product types:
               
               tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0.
               
               tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0.
               
               tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of a distributed (Global Distributed Cache) instance, which indicates whether to use the newly created instance as a sub-instance of a distributed instance. You can use this method to create a distributed instance.
               
               1. Enter true if you want the new instance to be the first child instance.
               
               2. If you want the new instance to be used as the second and third sub-instances, enter the distributed instance ID.
               
               3. Not as a distributed instance, you do not need to enter any values.
        :param pulumi.Input[_builtins.str] instance_class: The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
        :param pulumi.Input[_builtins.str] instance_type: The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
        :param pulumi.Input[_builtins.int] intranet_bandwidth: Instance intranet bandwidth
        :param pulumi.Input[_builtins.int] max_connections: The maximum number of connections supported by the instance.
        :param pulumi.Input[_builtins.str] modify_mode: The modification method when modifying the IP whitelist. The value includes Cover (default): overwrite the original whitelist; Append: Append the whitelist; Delete: Delete the whitelist.
        :param pulumi.Input[_builtins.str] network_type: The network type of the instance.  CLASSIC(classic network), VPC.
        :param pulumi.Input[_builtins.str] node_type: The node type. For cloud-native instances, input MASTER_SLAVE (master-replica) or STAND_ALONE (standalone). For classic instances, input double (master-replica) or single (standalone).
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_enabled: sentinel compatibility mode, applicable to non-cluster instances. For more information about parameters, see yes or no in the https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance, valid values: yes, no. The default value is no.
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_access: Whether to allow Sentinel commands to be executed without secrets when Sentinel mode is enabled. Value: yes: enabled. After the command is enabled, you can directly run the Sentinel command in the VPC without enabling the password-free feature. no: the default value, disabled. For parameters, see https://help.aliyun.com/zh/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance
        :param pulumi.Input[_builtins.str] param_no_loose_sentinel_password_free_commands: After sentinel mode and the# no_loose_sentinel-password-free-access parameter are enabled, you can use this parameter to add additional secret-free command lists (empty by default). After setting, you can execute the corresponding command on any connection without secret, please operate carefully. Commands are written in lowercase letters, and multiple commands are separated by commas (,). See https://help.aliyun.com/zh/redis/user-guide/parameter-support for details
        :param pulumi.Input[_builtins.str] param_repl_mode: The value is semisync or async. The default value is async.
               
               The default data synchronization mode is asynchronous replication. To modify the data synchronization mode, refer to https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_semisync_repl_timeout: The degradation threshold time of the semi-synchronous replication mode. This parameter value is required only when semi-synchronous replication is enabled. The unit is milliseconds, and the range is 10ms to 60000ms. The default value is 500ms. Please refer to: https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        :param pulumi.Input[_builtins.str] param_sentinel_compat_enable: sentinel compatibility mode, applicable to instances in the cluster architecture proxy connection mode or read/write splitting architecture. For more information about the parameters, see https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance. The value is 0 or 1. The default value is 0.
        :param pulumi.Input[_builtins.str] password: The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default Subscription.
        :param pulumi.Input[_builtins.int] period: The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
        :param pulumi.Input[_builtins.int] port: The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
        :param pulumi.Input[_builtins.int] read_only_count: Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions:
               
               If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture.
               
               If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
        :param pulumi.Input[_builtins.str] recover_config_mode: Whether to restore the account, kernel parameters, and whitelist (config) information from the original backup set when creating an instance using a specified backup set. The default value is empty, indicating that the account, kernel parameters, and whitelist information are not restored from the original backup set. This parameter is only applicable to Cloud Native instances, and the account, kernel parameters, and whitelist information must have been saved in the original backup set.
        :param pulumi.Input[_builtins.str] region_id: Region Id
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
        :param pulumi.Input[_builtins.str] security_group_id: Security group id
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the IP address whitelist. You cannot modify the whitelist that is generated by the system. If you do not specify this parameter, the default whitelist is modified by default.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in the whitelist. Up to 1,000 IP addresses can be specified in a whitelist. Separate multiple IP addresses with a comma (,). Specify an IP address in the 0.0.0.0/0, 10.23.12.24, or 10.23.12.24/24 format. In CIDR block 10.23.12.24/24, /24 specifies the length of the prefix of an IP address. The prefix length ranges from 1 to 32.
        :param pulumi.Input[_builtins.int] shard_count: The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
        :param pulumi.Input[_builtins.int] slave_read_only_count: Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance.
               
               Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
        :param pulumi.Input[_builtins.str] src_db_instance_id: If you want to create an instance based on the backup set of an existing instance, set this parameter to the ID of the source instance. preceding three parameters. After you specify the SrcDBInstanceId parameter, use the BackupId, ClusterBackupId (recommended for cloud-native cluster instances), or RestoreTime parameter to specify the backup set or the specific point in time that you want to use to create an instance. The SrcDBInstanceId parameter must be used in combination with one of the preceding three parameters.
        :param pulumi.Input[_builtins.str] ssl_enabled: Modifies SSL encryption configurations. Valid values: 1. Disable (The SSL encryption is disabled) 2. Enable (The SSL encryption is enabled)  3. Update (The SSL certificate is updated)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] storage_performance_level: The storage type. Valid values: PL1, PL2, and PL3. This parameter is available only when the value of InstanceType is tair_essd, that is, when an ESSD disk instance is selected.
               
               If the ESSD instance type is 4C, 8C, or 16C, you can specify the storage type as PL1.
               
               If the type of ESSD instance you select is 8C, 16C, 32C, or 52C, you can specify the storage type as PL2.
               
               If the ESSD instance type is 16C, 32C, or 52C, you can specify the storage type as PL3.
        :param pulumi.Input[_builtins.int] storage_size_gb: Different specifications have different value ranges. When the instance_type value is tair_essd and the disk type is ESSD, this attribute takes effect and is required. When a Tair disk is an SSD, see-https://help.aliyun.com/zh/redis/product-overview/capacity-storage-type. The capacity field is defined as different fixed values according to different specifications, and does not need to be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] tair_instance_id: The ID of the resource.
        :param pulumi.Input[_builtins.str] tair_instance_name: The name of the resource.
        :param pulumi.Input[_builtins.str] vpc_auth_mode: The VPC authentication mode. Valid values: Open (enables password authentication), Close (disables password authentication and enables [password-free access](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/enable-password-free-access)).
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC).
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance is connected.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TairInstanceState.__new__(_TairInstanceState)

        __props__.__dict__["architecture_type"] = architecture_type
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["cluster_backup_id"] = cluster_backup_id
        __props__.__dict__["connection_domain"] = connection_domain
        __props__.__dict__["connection_string_prefix"] = connection_string_prefix
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["force_upgrade"] = force_upgrade
        __props__.__dict__["global_instance_id"] = global_instance_id
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["intranet_bandwidth"] = intranet_bandwidth
        __props__.__dict__["max_connections"] = max_connections
        __props__.__dict__["modify_mode"] = modify_mode
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["param_no_loose_sentinel_enabled"] = param_no_loose_sentinel_enabled
        __props__.__dict__["param_no_loose_sentinel_password_free_access"] = param_no_loose_sentinel_password_free_access
        __props__.__dict__["param_no_loose_sentinel_password_free_commands"] = param_no_loose_sentinel_password_free_commands
        __props__.__dict__["param_repl_mode"] = param_repl_mode
        __props__.__dict__["param_semisync_repl_timeout"] = param_semisync_repl_timeout
        __props__.__dict__["param_sentinel_compat_enable"] = param_sentinel_compat_enable
        __props__.__dict__["password"] = password
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["read_only_count"] = read_only_count
        __props__.__dict__["recover_config_mode"] = recover_config_mode
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["secondary_zone_id"] = secondary_zone_id
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_ip_group_name"] = security_ip_group_name
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["slave_read_only_count"] = slave_read_only_count
        __props__.__dict__["src_db_instance_id"] = src_db_instance_id
        __props__.__dict__["ssl_enabled"] = ssl_enabled
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_performance_level"] = storage_performance_level
        __props__.__dict__["storage_size_gb"] = storage_size_gb
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tair_instance_id"] = tair_instance_id
        __props__.__dict__["tair_instance_name"] = tair_instance_name
        __props__.__dict__["vpc_auth_mode"] = vpc_auth_mode
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return TairInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="architectureType")
    def architecture_type(self) -> pulumi.Output[_builtins.str]:
        """
        The architecture of the instance.  cluster, standard, rwsplit.
        """
        return pulumi.get(self, "architecture_type")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        You can set the BackupId parameter to the backup set ID of the source instance. The system uses the data stored in the backup set to create an instance. You can call the DescribeBackups operation to query backup set IDs. If the source instance is a cluster instance, set the BackupId parameter to the backup set IDs of all shards of the source instance, separated by commas (,).

        If your instance is a cloud-native cluster instance, we recommend that you use DescribeClusterBackupList to query the backup set ID of the cluster instance. Then, set the ClusterBackupId request parameter to the backup set ID to clone the cluster instance. This eliminates the need to specify the backup set ID of each shard.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="clusterBackupId")
    def cluster_backup_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter is supported for specific new cluster instances. You can query the backup set ID by calling the DescribeClusterBackupList operation. If this parameter is supported, you can specify the backup set ID. In this case, you do not need to specify the BackupId parameter. If this parameter is not supported, set the BackupId parameter to the IDs of backup sets in all shards of the source instance, separated by commas (,).
        """
        return pulumi.get(self, "cluster_backup_id")

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The internal endpoint of the instance.
        """
        return pulumi.get(self, "connection_domain")

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The prefix of the endpoint the instance, which must consist of lowercase letters and numbers and start with a lowercase letter.
        """
        return pulumi.get(self, "connection_string_prefix")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the instance was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Database version. Default value: 1.0.

        Rules for transferring parameters of different tair product types:

        tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0.

        tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0.

        tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="forceUpgrade")
    def force_upgrade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
        """
        return pulumi.get(self, "force_upgrade")

    @_builtins.property
    @pulumi.getter(name="globalInstanceId")
    def global_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a distributed (Global Distributed Cache) instance, which indicates whether to use the newly created instance as a sub-instance of a distributed instance. You can use this method to create a distributed instance.

        1. Enter true if you want the new instance to be the first child instance.

        2. If you want the new instance to be used as the second and third sub-instances, enter the distributed instance ID.

        3. Not as a distributed instance, you do not need to enter any values.
        """
        return pulumi.get(self, "global_instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="intranetBandwidth")
    def intranet_bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        Instance intranet bandwidth
        """
        return pulumi.get(self, "intranet_bandwidth")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of connections supported by the instance.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The modification method when modifying the IP whitelist. The value includes Cover (default): overwrite the original whitelist; Append: Append the whitelist; Delete: Delete the whitelist.
        """
        return pulumi.get(self, "modify_mode")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the instance.  CLASSIC(classic network), VPC.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        The node type. For cloud-native instances, input MASTER_SLAVE (master-replica) or STAND_ALONE (standalone). For classic instances, input double (master-replica) or single (standalone).
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelEnabled")
    def param_no_loose_sentinel_enabled(self) -> pulumi.Output[_builtins.str]:
        """
        sentinel compatibility mode, applicable to non-cluster instances. For more information about parameters, see yes or no in the https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance, valid values: yes, no. The default value is no.
        """
        return pulumi.get(self, "param_no_loose_sentinel_enabled")

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelPasswordFreeAccess")
    def param_no_loose_sentinel_password_free_access(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to allow Sentinel commands to be executed without secrets when Sentinel mode is enabled. Value: yes: enabled. After the command is enabled, you can directly run the Sentinel command in the VPC without enabling the password-free feature. no: the default value, disabled. For parameters, see https://help.aliyun.com/zh/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance
        """
        return pulumi.get(self, "param_no_loose_sentinel_password_free_access")

    @_builtins.property
    @pulumi.getter(name="paramNoLooseSentinelPasswordFreeCommands")
    def param_no_loose_sentinel_password_free_commands(self) -> pulumi.Output[_builtins.str]:
        """
        After sentinel mode and the# no_loose_sentinel-password-free-access parameter are enabled, you can use this parameter to add additional secret-free command lists (empty by default). After setting, you can execute the corresponding command on any connection without secret, please operate carefully. Commands are written in lowercase letters, and multiple commands are separated by commas (,). See https://help.aliyun.com/zh/redis/user-guide/parameter-support for details
        """
        return pulumi.get(self, "param_no_loose_sentinel_password_free_commands")

    @_builtins.property
    @pulumi.getter(name="paramReplMode")
    def param_repl_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The value is semisync or async. The default value is async.

        The default data synchronization mode is asynchronous replication. To modify the data synchronization mode, refer to https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        """
        return pulumi.get(self, "param_repl_mode")

    @_builtins.property
    @pulumi.getter(name="paramSemisyncReplTimeout")
    def param_semisync_repl_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        The degradation threshold time of the semi-synchronous replication mode. This parameter value is required only when semi-synchronous replication is enabled. The unit is milliseconds, and the range is 10ms to 60000ms. The default value is 500ms. Please refer to: https://www.alibabacloud.com/help/en/redis/user-guide/modify-the-synchronization-mode-of-a-persistent-memory-optimized-instance.
        """
        return pulumi.get(self, "param_semisync_repl_timeout")

    @_builtins.property
    @pulumi.getter(name="paramSentinelCompatEnable")
    def param_sentinel_compat_enable(self) -> pulumi.Output[_builtins.str]:
        """
        sentinel compatibility mode, applicable to instances in the cluster architecture proxy connection mode or read/write splitting architecture. For more information about the parameters, see https://www.alibabacloud.com/help/en/redis/user-guide/use-the-sentinel-compatible-mode-to-connect-to-an-apsaradb-for-redis-instance. The value is 0 or 1. The default value is 0.
        """
        return pulumi.get(self, "param_sentinel_compat_enable")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default Subscription.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="readOnlyCount")
    def read_only_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions:

        If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture.

        If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
        """
        return pulumi.get(self, "read_only_count")

    @_builtins.property
    @pulumi.getter(name="recoverConfigMode")
    def recover_config_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to restore the account, kernel parameters, and whitelist (config) information from the original backup set when creating an instance using a specified backup set. The default value is empty, indicating that the account, kernel parameters, and whitelist information are not restored from the original backup set. This parameter is only applicable to Cloud Native instances, and the account, kernel parameters, and whitelist information must have been saved in the original backup set.
        """
        return pulumi.get(self, "recover_config_mode")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        Region Id
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
        """
        return pulumi.get(self, "secondary_zone_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Security group id
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IP address whitelist. You cannot modify the whitelist that is generated by the system. If you do not specify this parameter, the default whitelist is modified by default.
        """
        return pulumi.get(self, "security_ip_group_name")

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[_builtins.str]:
        """
        The IP addresses in the whitelist. Up to 1,000 IP addresses can be specified in a whitelist. Separate multiple IP addresses with a comma (,). Specify an IP address in the 0.0.0.0/0, 10.23.12.24, or 10.23.12.24/24 format. In CIDR block 10.23.12.24/24, /24 specifies the length of the prefix of an IP address. The prefix length ranges from 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
        """
        return pulumi.get(self, "shard_count")

    @_builtins.property
    @pulumi.getter(name="slaveReadOnlyCount")
    def slave_read_only_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance.

        Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
        """
        return pulumi.get(self, "slave_read_only_count")

    @_builtins.property
    @pulumi.getter(name="srcDbInstanceId")
    def src_db_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If you want to create an instance based on the backup set of an existing instance, set this parameter to the ID of the source instance. preceding three parameters. After you specify the SrcDBInstanceId parameter, use the BackupId, ClusterBackupId (recommended for cloud-native cluster instances), or RestoreTime parameter to specify the backup set or the specific point in time that you want to use to create an instance. The SrcDBInstanceId parameter must be used in combination with one of the preceding three parameters.
        """
        return pulumi.get(self, "src_db_instance_id")

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> pulumi.Output[_builtins.str]:
        """
        Modifies SSL encryption configurations. Valid values: 1. Disable (The SSL encryption is disabled) 2. Enable (The SSL encryption is enabled)  3. Update (The SSL certificate is updated)
        """
        return pulumi.get(self, "ssl_enabled")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storagePerformanceLevel")
    def storage_performance_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The storage type. Valid values: PL1, PL2, and PL3. This parameter is available only when the value of InstanceType is tair_essd, that is, when an ESSD disk instance is selected.

        If the ESSD instance type is 4C, 8C, or 16C, you can specify the storage type as PL1.

        If the type of ESSD instance you select is 8C, 16C, 32C, or 52C, you can specify the storage type as PL2.

        If the ESSD instance type is 16C, 32C, or 52C, you can specify the storage type as PL3.
        """
        return pulumi.get(self, "storage_performance_level")

    @_builtins.property
    @pulumi.getter(name="storageSizeGb")
    def storage_size_gb(self) -> pulumi.Output[_builtins.int]:
        """
        Different specifications have different value ranges. When the instance_type value is tair_essd and the disk type is ESSD, this attribute takes effect and is required. When a Tair disk is an SSD, see-https://help.aliyun.com/zh/redis/product-overview/capacity-storage-type. The capacity field is defined as different fixed values according to different specifications, and does not need to be specified.
        """
        return pulumi.get(self, "storage_size_gb")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tairInstanceId")
    def tair_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "tair_instance_id")

    @_builtins.property
    @pulumi.getter(name="tairInstanceName")
    def tair_instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "tair_instance_name")

    @_builtins.property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC authentication mode. Valid values: Open (enables password authentication), Close (disables password authentication and enables [password-free access](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/enable-password-free-access)).
        """
        return pulumi.get(self, "vpc_auth_mode")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC).
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch to which the instance is connected.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Zone ID
        """
        return pulumi.get(self, "zone_id")

