# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 account_status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] password: The password of the account.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        :param pulumi.Input[_builtins.str] account_status: The status of the account. Valid values: `DISABLE`, `ENABLE`.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if account_status is not None:
            pulumi.set(__self__, "account_status", account_status)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The password of the account.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the account. Valid values: `DISABLE`, `ENABLE`.
        """
        return pulumi.get(self, "account_status")

    @account_status.setter
    def account_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_status", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 account_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.str] account_status: The status of the account. Valid values: `DISABLE`, `ENABLE`.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] password: The password of the account.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        """
        if account_status is not None:
            pulumi.set(__self__, "account_status", account_status)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the account. Valid values: `DISABLE`, `ENABLE`.
        """
        return pulumi.get(self, "account_status")

    @account_status.setter
    def account_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_status", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the account.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("alicloud:rocketmq/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RocketMQ Account resource.

        For information about RocketMQ Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createinstanceaccount).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultg6_zxs2 = alicloud.vpc.Network("defaultg6ZXs2",
            description="111",
            cidr_block="192.168.0.0/16",
            vpc_name="pop-example-vpc")
        defaultv_m_qb_cy = alicloud.vpc.Switch("defaultvMQbCy",
            vpc_id=defaultg6_zxs2.id,
            zone_id="cn-hangzhou-j",
            cidr_block="192.168.0.0/24",
            vswitch_name="pop-example-vswitch")
        default9h_ab83 = alicloud.rocketmq.RocketMQInstance("default9hAb83",
            product_info={
                "msg_process_spec": "rmq.p2.4xlarge",
                "send_receive_ratio": 0.3,
                "message_retention_time": 70,
            },
            service_code="rmq",
            series_code="professional",
            payment_type="PayAsYouGo",
            instance_name=name,
            sub_series_code="cluster_ha",
            remark="example",
            software={
                "maintain_time": "02:00-06:00",
            },
            tags={
                "Created": "TF",
                "For": "example",
            },
            network_info={
                "vpc_info": {
                    "vpc_id": defaultg6_zxs2.id,
                    "vswitches": [{
                        "vswitch_id": defaultv_m_qb_cy.id,
                    }],
                },
                "internet_info": {
                    "internet_spec": "enable",
                    "flow_out_type": "payByBandwidth",
                    "flow_out_bandwidth": 30,
                },
            },
            acl_info={
                "default_vpc_auth_free": False,
                "acl_types": [
                    "default",
                    "apache_acl",
                ],
            })
        default = alicloud.rocketmq.Account("default",
            account_status="ENABLE",
            instance_id=default9h_ab83.id,
            username="tfexample",
            password="1741835136")
        ```

        ## Import

        RocketMQ Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/account:Account example <instance_id>:<username>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_status: The status of the account. Valid values: `DISABLE`, `ENABLE`.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] password: The password of the account.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RocketMQ Account resource.

        For information about RocketMQ Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createinstanceaccount).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultg6_zxs2 = alicloud.vpc.Network("defaultg6ZXs2",
            description="111",
            cidr_block="192.168.0.0/16",
            vpc_name="pop-example-vpc")
        defaultv_m_qb_cy = alicloud.vpc.Switch("defaultvMQbCy",
            vpc_id=defaultg6_zxs2.id,
            zone_id="cn-hangzhou-j",
            cidr_block="192.168.0.0/24",
            vswitch_name="pop-example-vswitch")
        default9h_ab83 = alicloud.rocketmq.RocketMQInstance("default9hAb83",
            product_info={
                "msg_process_spec": "rmq.p2.4xlarge",
                "send_receive_ratio": 0.3,
                "message_retention_time": 70,
            },
            service_code="rmq",
            series_code="professional",
            payment_type="PayAsYouGo",
            instance_name=name,
            sub_series_code="cluster_ha",
            remark="example",
            software={
                "maintain_time": "02:00-06:00",
            },
            tags={
                "Created": "TF",
                "For": "example",
            },
            network_info={
                "vpc_info": {
                    "vpc_id": defaultg6_zxs2.id,
                    "vswitches": [{
                        "vswitch_id": defaultv_m_qb_cy.id,
                    }],
                },
                "internet_info": {
                    "internet_spec": "enable",
                    "flow_out_type": "payByBandwidth",
                    "flow_out_bandwidth": 30,
                },
            },
            acl_info={
                "default_vpc_auth_free": False,
                "acl_types": [
                    "default",
                    "apache_acl",
                ],
            })
        default = alicloud.rocketmq.Account("default",
            account_status="ENABLE",
            instance_id=default9h_ab83.id,
            username="tfexample",
            password="1741835136")
        ```

        ## Import

        RocketMQ Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/account:Account example <instance_id>:<username>
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["account_status"] = account_status
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(Account, __self__).__init__(
            'alicloud:rocketmq/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_status: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_status: The status of the account. Valid values: `DISABLE`, `ENABLE`.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] password: The password of the account.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["account_status"] = account_status
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["password"] = password
        __props__.__dict__["username"] = username
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the account. Valid values: `DISABLE`, `ENABLE`.
        """
        return pulumi.get(self, "account_status")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the account.
        """
        return pulumi.get(self, "username")

