# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ChangeSetParameter',
    'StackGroupAutoDeployment',
    'StackGroupParameter',
    'StackInstanceParameterOverride',
    'StackParameter',
    'TemplateScratchPreferenceParameter',
    'TemplateScratchSourceResource',
    'TemplateScratchSourceResourceGroup',
    'TemplateScratchSourceTag',
    'GetChangeSetsSetResult',
    'GetChangeSetsSetParameterResult',
    'GetRegionsRegionResult',
    'GetStackGroupsGroupResult',
    'GetStackGroupsGroupParameterResult',
    'GetStackInstancesInstanceResult',
    'GetStackInstancesInstanceParameterOverrideResult',
    'GetStacksStackResult',
    'GetStacksStackParameterResult',
    'GetTemplateScratchesScratchResult',
    'GetTemplateScratchesScratchPreferenceParameterResult',
    'GetTemplateScratchesScratchSourceResourceResult',
    'GetTemplateScratchesScratchSourceResourceGroupResult',
    'GetTemplateScratchesScratchSourceTagResult',
    'GetTemplateScratchesScratchStackResult',
    'GetTemplatesTemplateResult',
]

@pulumi.output_type
class ChangeSetParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterKey":
            suggest = "parameter_key"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChangeSetParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChangeSetParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChangeSetParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: The parameter key.
        :param _builtins.str parameter_value: The parameter value.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        The parameter key.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class StackGroupAutoDeployment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainStacksOnAccountRemoval":
            suggest = "retain_stacks_on_account_removal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackGroupAutoDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackGroupAutoDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackGroupAutoDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 retain_stacks_on_account_removal: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Enable or disable automatic deployment. Valid Values:
        :param _builtins.bool retain_stacks_on_account_removal: Whether to retain the stack in the member account when the member account is deleted from the target folder. Valid values:
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retain_stacks_on_account_removal is not None:
            pulumi.set(__self__, "retain_stacks_on_account_removal", retain_stacks_on_account_removal)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable automatic deployment. Valid Values:
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="retainStacksOnAccountRemoval")
    def retain_stacks_on_account_removal(self) -> Optional[_builtins.bool]:
        """
        Whether to retain the stack in the member account when the member account is deleted from the target folder. Valid values:
        """
        return pulumi.get(self, "retain_stacks_on_account_removal")


@pulumi.output_type
class StackGroupParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterKey":
            suggest = "parameter_key"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackGroupParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackGroupParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackGroupParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: The key of parameter N. If you do not specify the key and value of the parameter, ROS uses the default key and value in the template.
        :param _builtins.str parameter_value: The value of parameter N.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        The key of parameter N. If you do not specify the key and value of the parameter, ROS uses the default key and value in the template.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The value of parameter N.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class StackInstanceParameterOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterKey":
            suggest = "parameter_key"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackInstanceParameterOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackInstanceParameterOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackInstanceParameterOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_key: Optional[_builtins.str] = None,
                 parameter_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str parameter_key: The key of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
        :param _builtins.str parameter_value: The value of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
        """
        if parameter_key is not None:
            pulumi.set(__self__, "parameter_key", parameter_key)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> Optional[_builtins.str]:
        """
        The key of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[_builtins.str]:
        """
        The value of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class StackParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterValue":
            suggest = "parameter_value"
        elif key == "parameterKey":
            suggest = "parameter_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_value: _builtins.str,
                 parameter_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str parameter_value: The parameter value.
        :param _builtins.str parameter_key: The parameter key.
        """
        pulumi.set(__self__, "parameter_value", parameter_value)
        if parameter_key is not None:
            pulumi.set(__self__, "parameter_key", parameter_key)

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "parameter_value")

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> Optional[_builtins.str]:
        """
        The parameter key.
        """
        return pulumi.get(self, "parameter_key")


@pulumi.output_type
class TemplateScratchPreferenceParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterKey":
            suggest = "parameter_key"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateScratchPreferenceParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateScratchPreferenceParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateScratchPreferenceParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: Priority parameter key. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
        :param _builtins.str parameter_value: Priority parameter value. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        Priority parameter key. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        Priority parameter value. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class TemplateScratchSourceResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateScratchSourceResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateScratchSourceResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateScratchSourceResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str resource_id: The ID of the Source Resource.
        :param _builtins.str resource_type: The type of the Source resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the Source Resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of the Source resource.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class TemplateScratchSourceResourceGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroupId":
            suggest = "resource_group_id"
        elif key == "resourceTypeFilters":
            suggest = "resource_type_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateScratchSourceResourceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateScratchSourceResourceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateScratchSourceResourceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group_id: _builtins.str,
                 resource_type_filters: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str resource_group_id: The ID of the Source Resource Group.
        """
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_type_filters is not None:
            pulumi.set(__self__, "resource_type_filters", resource_type_filters)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the Source Resource Group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceTypeFilters")
    def resource_type_filters(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "resource_type_filters")


@pulumi.output_type
class TemplateScratchSourceTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTags":
            suggest = "resource_tags"
        elif key == "resourceTypeFilters":
            suggest = "resource_type_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateScratchSourceTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateScratchSourceTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateScratchSourceTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_tags: Mapping[str, _builtins.str],
                 resource_type_filters: Optional[Sequence[_builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] resource_tags: Source label. **NOTE:** A maximum of 10 source labels can be configured.
        """
        pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type_filters is not None:
            pulumi.set(__self__, "resource_type_filters", resource_type_filters)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Mapping[str, _builtins.str]:
        """
        Source label. **NOTE:** A maximum of 10 source labels can be configured.
        """
        return pulumi.get(self, "resource_tags")

    @_builtins.property
    @pulumi.getter(name="resourceTypeFilters")
    def resource_type_filters(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "resource_type_filters")


@pulumi.output_type
class GetChangeSetsSetResult(dict):
    def __init__(__self__, *,
                 change_set_id: _builtins.str,
                 change_set_name: _builtins.str,
                 change_set_type: _builtins.str,
                 description: _builtins.str,
                 disable_rollback: _builtins.bool,
                 execution_status: _builtins.str,
                 id: _builtins.str,
                 parameters: Sequence['outputs.GetChangeSetsSetParameterResult'],
                 stack_id: _builtins.str,
                 stack_name: _builtins.str,
                 status: _builtins.str,
                 template_body: _builtins.str,
                 timeout_in_minutes: _builtins.int):
        """
        :param _builtins.str change_set_id: The ID of the change set.
        :param _builtins.str change_set_name: The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
        :param _builtins.str change_set_type: The type of the change set. Valid values:  CREATE: creates a change set for a new stack. UPDATE: creates a change set for an existing stack. IMPORT: creates a change set for a new stack or an existing stack to import non-ROS-managed resources. If you create a change set for a new stack, ROS creates a stack that has a unique stack ID. The stack is in the REVIEW_IN_PROGRESS state until you execute the change set.  You cannot use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack.
        :param _builtins.str description: The description of the change set. The description can be up to 1,024 bytes in length.
        :param _builtins.bool disable_rollback: Specifies whether to disable rollback on stack creation failure. Default value: false.  Valid values:  true: disables rollback on stack creation failure. false: enables rollback on stack creation failure. Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
        :param _builtins.str execution_status: The execution status of change set N. Maximum value of N: 5. Valid values:  UNAVAILABLE AVAILABLE EXECUTE_IN_PROGRESS EXECUTE_COMPLETE EXECUTE_FAILED OBSOLETE.
        :param _builtins.str id: The ID of the Change Set.
        :param Sequence['GetChangeSetsSetParameterArgs'] parameters: Parameters.
        :param _builtins.str stack_id: The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
        :param _builtins.str stack_name: The name of the stack for which you want to create the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.  Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
        :param _builtins.str status: The status of the change set.
        :param _builtins.str template_body: The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You can specify one of TemplateBody or TemplateURL parameters, but you cannot specify both of them.
        :param _builtins.int timeout_in_minutes: Timeout In Minutes.
        """
        pulumi.set(__self__, "change_set_id", change_set_id)
        pulumi.set(__self__, "change_set_name", change_set_name)
        pulumi.set(__self__, "change_set_type", change_set_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disable_rollback", disable_rollback)
        pulumi.set(__self__, "execution_status", execution_status)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "stack_name", stack_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "template_body", template_body)
        pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @_builtins.property
    @pulumi.getter(name="changeSetId")
    def change_set_id(self) -> _builtins.str:
        """
        The ID of the change set.
        """
        return pulumi.get(self, "change_set_id")

    @_builtins.property
    @pulumi.getter(name="changeSetName")
    def change_set_name(self) -> _builtins.str:
        """
        The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
        """
        return pulumi.get(self, "change_set_name")

    @_builtins.property
    @pulumi.getter(name="changeSetType")
    def change_set_type(self) -> _builtins.str:
        """
        The type of the change set. Valid values:  CREATE: creates a change set for a new stack. UPDATE: creates a change set for an existing stack. IMPORT: creates a change set for a new stack or an existing stack to import non-ROS-managed resources. If you create a change set for a new stack, ROS creates a stack that has a unique stack ID. The stack is in the REVIEW_IN_PROGRESS state until you execute the change set.  You cannot use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack.
        """
        return pulumi.get(self, "change_set_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the change set. The description can be up to 1,024 bytes in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> _builtins.bool:
        """
        Specifies whether to disable rollback on stack creation failure. Default value: false.  Valid values:  true: disables rollback on stack creation failure. false: enables rollback on stack creation failure. Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
        """
        return pulumi.get(self, "disable_rollback")

    @_builtins.property
    @pulumi.getter(name="executionStatus")
    def execution_status(self) -> _builtins.str:
        """
        The execution status of change set N. Maximum value of N: 5. Valid values:  UNAVAILABLE AVAILABLE EXECUTE_IN_PROGRESS EXECUTE_COMPLETE EXECUTE_FAILED OBSOLETE.
        """
        return pulumi.get(self, "execution_status")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Change Set.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetChangeSetsSetParameterResult']:
        """
        Parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        """
        The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> _builtins.str:
        """
        The name of the stack for which you want to create the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.  Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
        """
        return pulumi.get(self, "stack_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the change set.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> _builtins.str:
        """
        The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You can specify one of TemplateBody or TemplateURL parameters, but you cannot specify both of them.
        """
        return pulumi.get(self, "template_body")

    @_builtins.property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> _builtins.int:
        """
        Timeout In Minutes.
        """
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class GetChangeSetsSetParameterResult(dict):
    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: The parameters.
        :param _builtins.str parameter_value: The parameters.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        The parameters.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The parameters.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class GetRegionsRegionResult(dict):
    def __init__(__self__, *,
                 local_name: _builtins.str,
                 region_endpoint: _builtins.str,
                 region_id: _builtins.str):
        """
        :param _builtins.str local_name: The name of the region.
        :param _builtins.str region_endpoint: The endpoint of the region.
        :param _builtins.str region_id: The ID of the region.
        """
        pulumi.set(__self__, "local_name", local_name)
        pulumi.set(__self__, "region_endpoint", region_endpoint)
        pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="localName")
    def local_name(self) -> _builtins.str:
        """
        The name of the region.
        """
        return pulumi.get(self, "local_name")

    @_builtins.property
    @pulumi.getter(name="regionEndpoint")
    def region_endpoint(self) -> _builtins.str:
        """
        The endpoint of the region.
        """
        return pulumi.get(self, "region_endpoint")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of the region.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class GetStackGroupsGroupResult(dict):
    def __init__(__self__, *,
                 administration_role_name: _builtins.str,
                 description: _builtins.str,
                 execution_role_name: _builtins.str,
                 id: _builtins.str,
                 parameters: Sequence['outputs.GetStackGroupsGroupParameterResult'],
                 stack_group_id: _builtins.str,
                 stack_group_name: _builtins.str,
                 status: _builtins.str,
                 template_body: _builtins.str):
        """
        :param _builtins.str administration_role_name: The name of the RAM administrator role assumed by ROS.
        :param _builtins.str description: The description of the stack group.
        :param _builtins.str execution_role_name: The name of the RAM execution role assumed by the administrator role.
        :param _builtins.str id: The ID of the Stack Group.
        :param Sequence['GetStackGroupsGroupParameterArgs'] parameters: The parameters.
        :param _builtins.str stack_group_id: The id of Stack Group.
        :param _builtins.str stack_group_name: The name of the stack group..
        :param _builtins.str status: The status of Stack Group.
        :param _builtins.str template_body: The structure that contains the template body.
        """
        pulumi.set(__self__, "administration_role_name", administration_role_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "execution_role_name", execution_role_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "stack_group_id", stack_group_id)
        pulumi.set(__self__, "stack_group_name", stack_group_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "template_body", template_body)

    @_builtins.property
    @pulumi.getter(name="administrationRoleName")
    def administration_role_name(self) -> _builtins.str:
        """
        The name of the RAM administrator role assumed by ROS.
        """
        return pulumi.get(self, "administration_role_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the stack group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executionRoleName")
    def execution_role_name(self) -> _builtins.str:
        """
        The name of the RAM execution role assumed by the administrator role.
        """
        return pulumi.get(self, "execution_role_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Stack Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetStackGroupsGroupParameterResult']:
        """
        The parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="stackGroupId")
    def stack_group_id(self) -> _builtins.str:
        """
        The id of Stack Group.
        """
        return pulumi.get(self, "stack_group_id")

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> _builtins.str:
        """
        The name of the stack group..
        """
        return pulumi.get(self, "stack_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of Stack Group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> _builtins.str:
        """
        The structure that contains the template body.
        """
        return pulumi.get(self, "template_body")


@pulumi.output_type
class GetStackGroupsGroupParameterResult(dict):
    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: The parameter key.
        :param _builtins.str parameter_value: The parameter value.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        The parameter key.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class GetStackInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 parameter_overrides: Sequence['outputs.GetStackInstancesInstanceParameterOverrideResult'],
                 stack_group_id: _builtins.str,
                 stack_group_name: _builtins.str,
                 stack_id: _builtins.str,
                 stack_instance_account_id: _builtins.str,
                 stack_instance_region_id: _builtins.str,
                 status: _builtins.str,
                 status_reason: _builtins.str):
        """
        :param _builtins.str id: The ID of the Stack Instance. The value formats as `<stack_group_name>:<stack_instance_account_id>:<stack_instance_region_id>`.
        :param Sequence['GetStackInstancesInstanceParameterOverrideArgs'] parameter_overrides: ParameterOverrides.
        :param _builtins.str stack_group_id: The ID of the stack group.
        :param _builtins.str stack_group_name: The name of the stack group.
        :param _builtins.str stack_id: The ID of the stack corresponding to the stack instance.
        :param _builtins.str stack_instance_account_id: The account to which the stack instance belongs.
        :param _builtins.str stack_instance_region_id: The region of the stack instance.
        :param _builtins.str status: The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
               * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
               * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
               * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
               * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
               * The create or update operation is not complete.
        :param _builtins.str status_reason: The reason why the stack is in its current state.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        pulumi.set(__self__, "stack_group_id", stack_group_id)
        pulumi.set(__self__, "stack_group_name", stack_group_name)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "stack_instance_account_id", stack_instance_account_id)
        pulumi.set(__self__, "stack_instance_region_id", stack_instance_region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Stack Instance. The value formats as `<stack_group_name>:<stack_instance_account_id>:<stack_instance_region_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Sequence['outputs.GetStackInstancesInstanceParameterOverrideResult']:
        """
        ParameterOverrides.
        """
        return pulumi.get(self, "parameter_overrides")

    @_builtins.property
    @pulumi.getter(name="stackGroupId")
    def stack_group_id(self) -> _builtins.str:
        """
        The ID of the stack group.
        """
        return pulumi.get(self, "stack_group_id")

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> _builtins.str:
        """
        The name of the stack group.
        """
        return pulumi.get(self, "stack_group_name")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        """
        The ID of the stack corresponding to the stack instance.
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="stackInstanceAccountId")
    def stack_instance_account_id(self) -> _builtins.str:
        """
        The account to which the stack instance belongs.
        """
        return pulumi.get(self, "stack_instance_account_id")

    @_builtins.property
    @pulumi.getter(name="stackInstanceRegionId")
    def stack_instance_region_id(self) -> _builtins.str:
        """
        The region of the stack instance.
        """
        return pulumi.get(self, "stack_instance_region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
        * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
        * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
        * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
        * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
        * The create or update operation is not complete.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        The reason why the stack is in its current state.
        """
        return pulumi.get(self, "status_reason")


@pulumi.output_type
class GetStackInstancesInstanceParameterOverrideResult(dict):
    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: The key of override parameter.
        :param _builtins.str parameter_value: The value of override parameter.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        The key of override parameter.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The value of override parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class GetStacksStackResult(dict):
    def __init__(__self__, *,
                 deletion_protection: _builtins.str,
                 description: _builtins.str,
                 disable_rollback: _builtins.bool,
                 drift_detection_time: _builtins.str,
                 id: _builtins.str,
                 parameters: Sequence['outputs.GetStacksStackParameterResult'],
                 parent_stack_id: _builtins.str,
                 ram_role_name: _builtins.str,
                 root_stack_id: _builtins.str,
                 stack_drift_status: _builtins.str,
                 stack_id: _builtins.str,
                 stack_name: _builtins.str,
                 stack_policy_body: _builtins.str,
                 status: _builtins.str,
                 status_reason: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 template_description: _builtins.str,
                 timeout_in_minutes: _builtins.int):
        """
        :param _builtins.str deletion_protection: Specifies whether to enable deletion protection on the stack.
        :param _builtins.str description: The Description of the Stack.
        :param _builtins.bool disable_rollback: Specifies whether to disable rollback on stack creation failure..
        :param _builtins.str drift_detection_time: Drift DetectionTime.
        :param _builtins.str id: The ID of the Stack.
        :param Sequence['GetStacksStackParameterArgs'] parameters: The parameters.
        :param _builtins.str parent_stack_id: Parent Stack Id.
        :param _builtins.str ram_role_name: The RamRoleName.
        :param _builtins.str root_stack_id: Root Stack Id.
        :param _builtins.str stack_drift_status: Stack DriftStatus.
        :param _builtins.str stack_id: Stack Id.
        :param _builtins.str stack_name: Stack Name.
        :param _builtins.str stack_policy_body: The structure that contains the stack policy body.
        :param _builtins.str status: The status of Stack. Valid Values: `CREATE_COMPLETE`, `CREATE_FAILED`, `CREATE_IN_PROGRESS`, `DELETE_COMPLETE`, `DELETE_FAILED`, `DELETE_IN_PROGRESS`, `ROLLBACK_COMPLETE`, `ROLLBACK_FAILED`, `ROLLBACK_IN_PROGRESS`.
        :param _builtins.str status_reason: Status Reason.
        :param Mapping[str, _builtins.str] tags: Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
        :param _builtins.str template_description: Template Description.
        :param _builtins.int timeout_in_minutes: Specifies whether to use the values that were passed last time for the parameters that you do not specify in the current request.
        """
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disable_rollback", disable_rollback)
        pulumi.set(__self__, "drift_detection_time", drift_detection_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "parent_stack_id", parent_stack_id)
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        pulumi.set(__self__, "root_stack_id", root_stack_id)
        pulumi.set(__self__, "stack_drift_status", stack_drift_status)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "stack_name", stack_name)
        pulumi.set(__self__, "stack_policy_body", stack_policy_body)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "template_description", template_description)
        pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.str:
        """
        Specifies whether to enable deletion protection on the stack.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Description of the Stack.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> _builtins.bool:
        """
        Specifies whether to disable rollback on stack creation failure..
        """
        return pulumi.get(self, "disable_rollback")

    @_builtins.property
    @pulumi.getter(name="driftDetectionTime")
    def drift_detection_time(self) -> _builtins.str:
        """
        Drift DetectionTime.
        """
        return pulumi.get(self, "drift_detection_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Stack.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetStacksStackParameterResult']:
        """
        The parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="parentStackId")
    def parent_stack_id(self) -> _builtins.str:
        """
        Parent Stack Id.
        """
        return pulumi.get(self, "parent_stack_id")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> _builtins.str:
        """
        The RamRoleName.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="rootStackId")
    def root_stack_id(self) -> _builtins.str:
        """
        Root Stack Id.
        """
        return pulumi.get(self, "root_stack_id")

    @_builtins.property
    @pulumi.getter(name="stackDriftStatus")
    def stack_drift_status(self) -> _builtins.str:
        """
        Stack DriftStatus.
        """
        return pulumi.get(self, "stack_drift_status")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        """
        Stack Id.
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> _builtins.str:
        """
        Stack Name.
        """
        return pulumi.get(self, "stack_name")

    @_builtins.property
    @pulumi.getter(name="stackPolicyBody")
    def stack_policy_body(self) -> _builtins.str:
        """
        The structure that contains the stack policy body.
        """
        return pulumi.get(self, "stack_policy_body")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of Stack. Valid Values: `CREATE_COMPLETE`, `CREATE_FAILED`, `CREATE_IN_PROGRESS`, `DELETE_COMPLETE`, `DELETE_FAILED`, `DELETE_IN_PROGRESS`, `ROLLBACK_COMPLETE`, `ROLLBACK_FAILED`, `ROLLBACK_IN_PROGRESS`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Status Reason.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> _builtins.str:
        """
        Template Description.
        """
        return pulumi.get(self, "template_description")

    @_builtins.property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> _builtins.int:
        """
        Specifies whether to use the values that were passed last time for the parameters that you do not specify in the current request.
        """
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class GetStacksStackParameterResult(dict):
    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: The key of parameters.
        :param _builtins.str parameter_value: The value of parameters.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        The key of parameters.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The value of parameters.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class GetTemplateScratchesScratchResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 logical_id_strategy: _builtins.str,
                 preference_parameters: Sequence['outputs.GetTemplateScratchesScratchPreferenceParameterResult'],
                 source_resource_groups: Sequence['outputs.GetTemplateScratchesScratchSourceResourceGroupResult'],
                 source_resources: Sequence['outputs.GetTemplateScratchesScratchSourceResourceResult'],
                 source_tags: Sequence['outputs.GetTemplateScratchesScratchSourceTagResult'],
                 stacks: Sequence['outputs.GetTemplateScratchesScratchStackResult'],
                 status: _builtins.str,
                 template_scratch_id: _builtins.str,
                 template_scratch_type: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str description: The description of the Template Scratch.
        :param _builtins.str id: The ID of the Template Scratch.
        :param _builtins.str logical_id_strategy: The Logical ID generation strategy of the Template Scratch.
        :param Sequence['GetTemplateScratchesScratchPreferenceParameterArgs'] preference_parameters: Priority parameter.
        :param Sequence['GetTemplateScratchesScratchSourceResourceGroupArgs'] source_resource_groups: Source resource grouping.
        :param Sequence['GetTemplateScratchesScratchSourceResourceArgs'] source_resources: Source resource.
        :param Sequence['GetTemplateScratchesScratchSourceTagArgs'] source_tags: The Source label list.
        :param Sequence['GetTemplateScratchesScratchStackArgs'] stacks: A list of resource stacks associated with the resource scene.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str template_scratch_id: The ID of the Template Scratch.
        :param _builtins.str template_scratch_type: The type of the Template Scratch.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logical_id_strategy", logical_id_strategy)
        pulumi.set(__self__, "preference_parameters", preference_parameters)
        pulumi.set(__self__, "source_resource_groups", source_resource_groups)
        pulumi.set(__self__, "source_resources", source_resources)
        pulumi.set(__self__, "source_tags", source_tags)
        pulumi.set(__self__, "stacks", stacks)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "template_scratch_id", template_scratch_id)
        pulumi.set(__self__, "template_scratch_type", template_scratch_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Template Scratch.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Template Scratch.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logicalIdStrategy")
    def logical_id_strategy(self) -> _builtins.str:
        """
        The Logical ID generation strategy of the Template Scratch.
        """
        return pulumi.get(self, "logical_id_strategy")

    @_builtins.property
    @pulumi.getter(name="preferenceParameters")
    def preference_parameters(self) -> Sequence['outputs.GetTemplateScratchesScratchPreferenceParameterResult']:
        """
        Priority parameter.
        """
        return pulumi.get(self, "preference_parameters")

    @_builtins.property
    @pulumi.getter(name="sourceResourceGroups")
    def source_resource_groups(self) -> Sequence['outputs.GetTemplateScratchesScratchSourceResourceGroupResult']:
        """
        Source resource grouping.
        """
        return pulumi.get(self, "source_resource_groups")

    @_builtins.property
    @pulumi.getter(name="sourceResources")
    def source_resources(self) -> Sequence['outputs.GetTemplateScratchesScratchSourceResourceResult']:
        """
        Source resource.
        """
        return pulumi.get(self, "source_resources")

    @_builtins.property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Sequence['outputs.GetTemplateScratchesScratchSourceTagResult']:
        """
        The Source label list.
        """
        return pulumi.get(self, "source_tags")

    @_builtins.property
    @pulumi.getter
    def stacks(self) -> Sequence['outputs.GetTemplateScratchesScratchStackResult']:
        """
        A list of resource stacks associated with the resource scene.
        """
        return pulumi.get(self, "stacks")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="templateScratchId")
    def template_scratch_id(self) -> _builtins.str:
        """
        The ID of the Template Scratch.
        """
        return pulumi.get(self, "template_scratch_id")

    @_builtins.property
    @pulumi.getter(name="templateScratchType")
    def template_scratch_type(self) -> _builtins.str:
        """
        The type of the Template Scratch.
        """
        return pulumi.get(self, "template_scratch_type")


@pulumi.output_type
class GetTemplateScratchesScratchPreferenceParameterResult(dict):
    def __init__(__self__, *,
                 parameter_key: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_key: Priority parameter key.
        :param _builtins.str parameter_value: Priority parameter value.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> _builtins.str:
        """
        Priority parameter key.
        """
        return pulumi.get(self, "parameter_key")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        Priority parameter value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class GetTemplateScratchesScratchSourceResourceResult(dict):
    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str resource_id: The ID of the Source Resource.
        :param _builtins.str resource_type: The type of the Source resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the Source Resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of the Source resource.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetTemplateScratchesScratchSourceResourceGroupResult(dict):
    def __init__(__self__, *,
                 resource_group_id: _builtins.str,
                 resource_type_filters: Sequence[_builtins.str]):
        """
        :param _builtins.str resource_group_id: The ID of the Source Resource Group.
        :param Sequence[_builtins.str] resource_type_filters: Source resource type filter list.
        """
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "resource_type_filters", resource_type_filters)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the Source Resource Group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceTypeFilters")
    def resource_type_filters(self) -> Sequence[_builtins.str]:
        """
        Source resource type filter list.
        """
        return pulumi.get(self, "resource_type_filters")


@pulumi.output_type
class GetTemplateScratchesScratchSourceTagResult(dict):
    def __init__(__self__, *,
                 resource_tags: Mapping[str, _builtins.str],
                 resource_type_filters: Sequence[_builtins.str]):
        """
        :param Mapping[str, _builtins.str] resource_tags: Source label.
        :param Sequence[_builtins.str] resource_type_filters: Source resource type filter list.
        """
        pulumi.set(__self__, "resource_tags", resource_tags)
        pulumi.set(__self__, "resource_type_filters", resource_type_filters)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Mapping[str, _builtins.str]:
        """
        Source label.
        """
        return pulumi.get(self, "resource_tags")

    @_builtins.property
    @pulumi.getter(name="resourceTypeFilters")
    def resource_type_filters(self) -> Sequence[_builtins.str]:
        """
        Source resource type filter list.
        """
        return pulumi.get(self, "resource_type_filters")


@pulumi.output_type
class GetTemplateScratchesScratchStackResult(dict):
    def __init__(__self__, *,
                 stack_id: _builtins.str):
        """
        :param _builtins.str stack_id: The ID of the Resource stack.
        """
        pulumi.set(__self__, "stack_id", stack_id)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        """
        The ID of the Resource stack.
        """
        return pulumi.get(self, "stack_id")


@pulumi.output_type
class GetTemplatesTemplateResult(dict):
    def __init__(__self__, *,
                 change_set_id: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 share_type: _builtins.str,
                 stack_group_name: _builtins.str,
                 stack_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 template_body: _builtins.str,
                 template_id: _builtins.str,
                 template_name: _builtins.str,
                 template_version: _builtins.str):
        """
        :param _builtins.str change_set_id: The ID of the change set.
        :param _builtins.str description: The description of the template. The description can be up to 256 characters in length.
        :param _builtins.str id: The ID of the Template.
        :param _builtins.str share_type: Share Type.
        :param _builtins.str stack_group_name: The name of the stack group. The name must be unique in a region.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
        :param _builtins.str stack_id: The ID of the stack.
        :param Mapping[str, _builtins.str] tags: Tags.
        :param _builtins.str template_body: The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You must specify one of the TemplateBody and TemplateURL parameters, but you cannot specify both of them.
        :param _builtins.str template_id: The ID of the template.
        :param _builtins.str template_name: The name of the template.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
        :param _builtins.str template_version: Template Version.
        """
        pulumi.set(__self__, "change_set_id", change_set_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "stack_group_name", stack_group_name)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "template_body", template_body)
        pulumi.set(__self__, "template_id", template_id)
        pulumi.set(__self__, "template_name", template_name)
        pulumi.set(__self__, "template_version", template_version)

    @_builtins.property
    @pulumi.getter(name="changeSetId")
    def change_set_id(self) -> _builtins.str:
        """
        The ID of the change set.
        """
        return pulumi.get(self, "change_set_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the template. The description can be up to 256 characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Template.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        Share Type.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> _builtins.str:
        """
        The name of the stack group. The name must be unique in a region.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
        """
        return pulumi.get(self, "stack_group_name")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        """
        The ID of the stack.
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> _builtins.str:
        """
        The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You must specify one of the TemplateBody and TemplateURL parameters, but you cannot specify both of them.
        """
        return pulumi.get(self, "template_body")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> _builtins.str:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        The name of the template.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> _builtins.str:
        """
        Template Version.
        """
        return pulumi.get(self, "template_version")


