# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppGroupArgs', 'AppGroup']

@pulumi.input_type
class AppGroupArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 namespace_name: pulumi.Input[_builtins.str],
                 app_type: Optional[pulumi.Input[_builtins.int]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_jobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 max_jobs: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_config_json: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_contacts_json: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_busy_workers: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AppGroup resource.
        :param pulumi.Input[_builtins.str] app_name: Application Name
        :param pulumi.Input[_builtins.str] group_id: Application ID
        :param pulumi.Input[_builtins.str] namespace: The namespace ID, which is obtained on the namespace page of the console.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name.
        :param pulumi.Input[_builtins.int] app_type: Application type.
               - 1, general application.
               - 2, k8s application.
        :param pulumi.Input[_builtins.str] app_version: Application Version, 1: Basic Edition, 2: Professional Edition
        :param pulumi.Input[_builtins.bool] delete_jobs: Whether to delete the task in the application Group. The values are as follows:
        :param pulumi.Input[_builtins.str] description: Application Description
        :param pulumi.Input[_builtins.bool] enable_log: Whether to enable the log.
               - true: On
               - false: Close
        :param pulumi.Input[_builtins.int] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.int] max_jobs: Application Grouping Configurable Maximum Number of Tasks
        :param pulumi.Input[_builtins.str] monitor_config_json: Alarm configuration JSON field. For more information about this field, see **Request Parameters * *.
        :param pulumi.Input[_builtins.str] monitor_contacts_json: Alarm contact JSON format.
        :param pulumi.Input[_builtins.str] namespace_source: Not supported for the time being, no need to fill in.
        :param pulumi.Input[_builtins.bool] schedule_busy_workers: Whether to schedule a busy machine.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "namespace_name", namespace_name)
        if app_type is not None:
            pulumi.set(__self__, "app_type", app_type)
        if app_version is not None:
            pulumi.set(__self__, "app_version", app_version)
        if delete_jobs is not None:
            pulumi.set(__self__, "delete_jobs", delete_jobs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_log is not None:
            pulumi.set(__self__, "enable_log", enable_log)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_jobs is not None:
            pulumi.set(__self__, "max_jobs", max_jobs)
        if monitor_config_json is not None:
            pulumi.set(__self__, "monitor_config_json", monitor_config_json)
        if monitor_contacts_json is not None:
            pulumi.set(__self__, "monitor_contacts_json", monitor_contacts_json)
        if namespace_source is not None:
            pulumi.set(__self__, "namespace_source", namespace_source)
        if schedule_busy_workers is not None:
            pulumi.set(__self__, "schedule_busy_workers", schedule_busy_workers)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[_builtins.str]:
        """
        Application Name
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Application ID
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace ID, which is obtained on the namespace page of the console.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace name.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Application type.
        - 1, general application.
        - 2, k8s application.
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "app_type", value)

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Version, 1: Basic Edition, 2: Professional Edition
        """
        return pulumi.get(self, "app_version")

    @app_version.setter
    def app_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_version", value)

    @_builtins.property
    @pulumi.getter(name="deleteJobs")
    def delete_jobs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the task in the application Group. The values are as follows:
        """
        return pulumi.get(self, "delete_jobs")

    @delete_jobs.setter
    def delete_jobs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_jobs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableLog")
    def enable_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the log.
        - true: On
        - false: Close
        """
        return pulumi.get(self, "enable_log")

    @enable_log.setter
    def enable_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_log", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="maxJobs")
    def max_jobs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Application Grouping Configurable Maximum Number of Tasks
        """
        return pulumi.get(self, "max_jobs")

    @max_jobs.setter
    def max_jobs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_jobs", value)

    @_builtins.property
    @pulumi.getter(name="monitorConfigJson")
    def monitor_config_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alarm configuration JSON field. For more information about this field, see **Request Parameters * *.
        """
        return pulumi.get(self, "monitor_config_json")

    @monitor_config_json.setter
    def monitor_config_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_config_json", value)

    @_builtins.property
    @pulumi.getter(name="monitorContactsJson")
    def monitor_contacts_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alarm contact JSON format.
        """
        return pulumi.get(self, "monitor_contacts_json")

    @monitor_contacts_json.setter
    def monitor_contacts_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_contacts_json", value)

    @_builtins.property
    @pulumi.getter(name="namespaceSource")
    def namespace_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Not supported for the time being, no need to fill in.
        """
        return pulumi.get(self, "namespace_source")

    @namespace_source.setter
    def namespace_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_source", value)

    @_builtins.property
    @pulumi.getter(name="scheduleBusyWorkers")
    def schedule_busy_workers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to schedule a busy machine.
        """
        return pulumi.get(self, "schedule_busy_workers")

    @schedule_busy_workers.setter
    def schedule_busy_workers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "schedule_busy_workers", value)


@pulumi.input_type
class _AppGroupState:
    def __init__(__self__, *,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_type: Optional[pulumi.Input[_builtins.int]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_jobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 max_jobs: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_config_json: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_contacts_json: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_busy_workers: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AppGroup resources.
        :param pulumi.Input[_builtins.str] app_name: Application Name
        :param pulumi.Input[_builtins.int] app_type: Application type.
               - 1, general application.
               - 2, k8s application.
        :param pulumi.Input[_builtins.str] app_version: Application Version, 1: Basic Edition, 2: Professional Edition
        :param pulumi.Input[_builtins.bool] delete_jobs: Whether to delete the task in the application Group. The values are as follows:
        :param pulumi.Input[_builtins.str] description: Application Description
        :param pulumi.Input[_builtins.bool] enable_log: Whether to enable the log.
               - true: On
               - false: Close
        :param pulumi.Input[_builtins.str] group_id: Application ID
        :param pulumi.Input[_builtins.int] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.int] max_jobs: Application Grouping Configurable Maximum Number of Tasks
        :param pulumi.Input[_builtins.str] monitor_config_json: Alarm configuration JSON field. For more information about this field, see **Request Parameters * *.
        :param pulumi.Input[_builtins.str] monitor_contacts_json: Alarm contact JSON format.
        :param pulumi.Input[_builtins.str] namespace: The namespace ID, which is obtained on the namespace page of the console.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name.
        :param pulumi.Input[_builtins.str] namespace_source: Not supported for the time being, no need to fill in.
        :param pulumi.Input[_builtins.bool] schedule_busy_workers: Whether to schedule a busy machine.
        """
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_type is not None:
            pulumi.set(__self__, "app_type", app_type)
        if app_version is not None:
            pulumi.set(__self__, "app_version", app_version)
        if delete_jobs is not None:
            pulumi.set(__self__, "delete_jobs", delete_jobs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_log is not None:
            pulumi.set(__self__, "enable_log", enable_log)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_jobs is not None:
            pulumi.set(__self__, "max_jobs", max_jobs)
        if monitor_config_json is not None:
            pulumi.set(__self__, "monitor_config_json", monitor_config_json)
        if monitor_contacts_json is not None:
            pulumi.set(__self__, "monitor_contacts_json", monitor_contacts_json)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if namespace_source is not None:
            pulumi.set(__self__, "namespace_source", namespace_source)
        if schedule_busy_workers is not None:
            pulumi.set(__self__, "schedule_busy_workers", schedule_busy_workers)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Name
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Application type.
        - 1, general application.
        - 2, k8s application.
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "app_type", value)

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Version, 1: Basic Edition, 2: Professional Edition
        """
        return pulumi.get(self, "app_version")

    @app_version.setter
    def app_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_version", value)

    @_builtins.property
    @pulumi.getter(name="deleteJobs")
    def delete_jobs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the task in the application Group. The values are as follows:
        """
        return pulumi.get(self, "delete_jobs")

    @delete_jobs.setter
    def delete_jobs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_jobs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableLog")
    def enable_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the log.
        - true: On
        - false: Close
        """
        return pulumi.get(self, "enable_log")

    @enable_log.setter
    def enable_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_log", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application ID
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="maxJobs")
    def max_jobs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Application Grouping Configurable Maximum Number of Tasks
        """
        return pulumi.get(self, "max_jobs")

    @max_jobs.setter
    def max_jobs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_jobs", value)

    @_builtins.property
    @pulumi.getter(name="monitorConfigJson")
    def monitor_config_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alarm configuration JSON field. For more information about this field, see **Request Parameters * *.
        """
        return pulumi.get(self, "monitor_config_json")

    @monitor_config_json.setter
    def monitor_config_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_config_json", value)

    @_builtins.property
    @pulumi.getter(name="monitorContactsJson")
    def monitor_contacts_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alarm contact JSON format.
        """
        return pulumi.get(self, "monitor_contacts_json")

    @monitor_contacts_json.setter
    def monitor_contacts_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_contacts_json", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace ID, which is obtained on the namespace page of the console.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="namespaceSource")
    def namespace_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Not supported for the time being, no need to fill in.
        """
        return pulumi.get(self, "namespace_source")

    @namespace_source.setter
    def namespace_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_source", value)

    @_builtins.property
    @pulumi.getter(name="scheduleBusyWorkers")
    def schedule_busy_workers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to schedule a busy machine.
        """
        return pulumi.get(self, "schedule_busy_workers")

    @schedule_busy_workers.setter
    def schedule_busy_workers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "schedule_busy_workers", value)


@pulumi.type_token("alicloud:schedulerx/appGroup:AppGroup")
class AppGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_type: Optional[pulumi.Input[_builtins.int]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_jobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 max_jobs: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_config_json: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_contacts_json: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_busy_workers: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Schedulerx App Group resource.

        For information about Schedulerx App Group and how to use it, see [What is App Group](https://www.alibabacloud.com/help/en/schedulerx/schedulerx-serverless/developer-reference/api-schedulerx2-2019-04-30-createappgroup).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        create_name_space = alicloud.schedulerx.Namespace("CreateNameSpace",
            namespace_name=name,
            description=name)
        default = alicloud.schedulerx.AppGroup("default",
            max_jobs=100,
            monitor_contacts_json=json.dumps([
                {
                    "userName": "name1",
                    "userPhone": "89756******",
                },
                {
                    "userName": "name2",
                    "ding": "http://www.example.com",
                },
            ]),
            delete_jobs=False,
            app_type=1,
            namespace_source="schedulerx",
            group_id="example-appgroup-pop-autoexample",
            namespace_name="default",
            description=name,
            monitor_config_json=json.dumps({
                "sendChannel": "sms,ding",
            }),
            app_version="1",
            app_name="example-appgroup-pop-autoexample",
            namespace=create_name_space.namespace_uid,
            enable_log=False,
            schedule_busy_workers=False)
        ```

        ## Import

        Schedulerx App Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:schedulerx/appGroup:AppGroup example <namespace>:<group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_name: Application Name
        :param pulumi.Input[_builtins.int] app_type: Application type.
               - 1, general application.
               - 2, k8s application.
        :param pulumi.Input[_builtins.str] app_version: Application Version, 1: Basic Edition, 2: Professional Edition
        :param pulumi.Input[_builtins.bool] delete_jobs: Whether to delete the task in the application Group. The values are as follows:
        :param pulumi.Input[_builtins.str] description: Application Description
        :param pulumi.Input[_builtins.bool] enable_log: Whether to enable the log.
               - true: On
               - false: Close
        :param pulumi.Input[_builtins.str] group_id: Application ID
        :param pulumi.Input[_builtins.int] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.int] max_jobs: Application Grouping Configurable Maximum Number of Tasks
        :param pulumi.Input[_builtins.str] monitor_config_json: Alarm configuration JSON field. For more information about this field, see **Request Parameters * *.
        :param pulumi.Input[_builtins.str] monitor_contacts_json: Alarm contact JSON format.
        :param pulumi.Input[_builtins.str] namespace: The namespace ID, which is obtained on the namespace page of the console.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name.
        :param pulumi.Input[_builtins.str] namespace_source: Not supported for the time being, no need to fill in.
        :param pulumi.Input[_builtins.bool] schedule_busy_workers: Whether to schedule a busy machine.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Schedulerx App Group resource.

        For information about Schedulerx App Group and how to use it, see [What is App Group](https://www.alibabacloud.com/help/en/schedulerx/schedulerx-serverless/developer-reference/api-schedulerx2-2019-04-30-createappgroup).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        create_name_space = alicloud.schedulerx.Namespace("CreateNameSpace",
            namespace_name=name,
            description=name)
        default = alicloud.schedulerx.AppGroup("default",
            max_jobs=100,
            monitor_contacts_json=json.dumps([
                {
                    "userName": "name1",
                    "userPhone": "89756******",
                },
                {
                    "userName": "name2",
                    "ding": "http://www.example.com",
                },
            ]),
            delete_jobs=False,
            app_type=1,
            namespace_source="schedulerx",
            group_id="example-appgroup-pop-autoexample",
            namespace_name="default",
            description=name,
            monitor_config_json=json.dumps({
                "sendChannel": "sms,ding",
            }),
            app_version="1",
            app_name="example-appgroup-pop-autoexample",
            namespace=create_name_space.namespace_uid,
            enable_log=False,
            schedule_busy_workers=False)
        ```

        ## Import

        Schedulerx App Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:schedulerx/appGroup:AppGroup example <namespace>:<group_id>
        ```

        :param str resource_name: The name of the resource.
        :param AppGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_type: Optional[pulumi.Input[_builtins.int]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_jobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 max_jobs: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_config_json: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_contacts_json: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_busy_workers: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppGroupArgs.__new__(AppGroupArgs)

            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["app_type"] = app_type
            __props__.__dict__["app_version"] = app_version
            __props__.__dict__["delete_jobs"] = delete_jobs
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_log"] = enable_log
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["max_jobs"] = max_jobs
            __props__.__dict__["monitor_config_json"] = monitor_config_json
            __props__.__dict__["monitor_contacts_json"] = monitor_contacts_json
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            __props__.__dict__["namespace_source"] = namespace_source
            __props__.__dict__["schedule_busy_workers"] = schedule_busy_workers
        super(AppGroup, __self__).__init__(
            'alicloud:schedulerx/appGroup:AppGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_type: Optional[pulumi.Input[_builtins.int]] = None,
            app_version: Optional[pulumi.Input[_builtins.str]] = None,
            delete_jobs: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_log: Optional[pulumi.Input[_builtins.bool]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
            max_jobs: Optional[pulumi.Input[_builtins.int]] = None,
            monitor_config_json: Optional[pulumi.Input[_builtins.str]] = None,
            monitor_contacts_json: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_source: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_busy_workers: Optional[pulumi.Input[_builtins.bool]] = None) -> 'AppGroup':
        """
        Get an existing AppGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_name: Application Name
        :param pulumi.Input[_builtins.int] app_type: Application type.
               - 1, general application.
               - 2, k8s application.
        :param pulumi.Input[_builtins.str] app_version: Application Version, 1: Basic Edition, 2: Professional Edition
        :param pulumi.Input[_builtins.bool] delete_jobs: Whether to delete the task in the application Group. The values are as follows:
        :param pulumi.Input[_builtins.str] description: Application Description
        :param pulumi.Input[_builtins.bool] enable_log: Whether to enable the log.
               - true: On
               - false: Close
        :param pulumi.Input[_builtins.str] group_id: Application ID
        :param pulumi.Input[_builtins.int] max_concurrency: The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        :param pulumi.Input[_builtins.int] max_jobs: Application Grouping Configurable Maximum Number of Tasks
        :param pulumi.Input[_builtins.str] monitor_config_json: Alarm configuration JSON field. For more information about this field, see **Request Parameters * *.
        :param pulumi.Input[_builtins.str] monitor_contacts_json: Alarm contact JSON format.
        :param pulumi.Input[_builtins.str] namespace: The namespace ID, which is obtained on the namespace page of the console.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace name.
        :param pulumi.Input[_builtins.str] namespace_source: Not supported for the time being, no need to fill in.
        :param pulumi.Input[_builtins.bool] schedule_busy_workers: Whether to schedule a busy machine.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppGroupState.__new__(_AppGroupState)

        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["app_type"] = app_type
        __props__.__dict__["app_version"] = app_version
        __props__.__dict__["delete_jobs"] = delete_jobs
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_log"] = enable_log
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["max_jobs"] = max_jobs
        __props__.__dict__["monitor_config_json"] = monitor_config_json
        __props__.__dict__["monitor_contacts_json"] = monitor_contacts_json
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["namespace_source"] = namespace_source
        __props__.__dict__["schedule_busy_workers"] = schedule_busy_workers
        return AppGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[_builtins.str]:
        """
        Application Name
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appType")
    def app_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Application type.
        - 1, general application.
        - 2, k8s application.
        """
        return pulumi.get(self, "app_type")

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application Version, 1: Basic Edition, 2: Professional Edition
        """
        return pulumi.get(self, "app_version")

    @_builtins.property
    @pulumi.getter(name="deleteJobs")
    def delete_jobs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to delete the task in the application Group. The values are as follows:
        """
        return pulumi.get(self, "delete_jobs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableLog")
    def enable_log(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the log.
        - true: On
        - false: Close
        """
        return pulumi.get(self, "enable_log")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Application ID
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of instances running at the same time. The default value is 1, that is, the last trigger is not completed, and the next trigger will not be performed even at the running time.
        """
        return pulumi.get(self, "max_concurrency")

    @_builtins.property
    @pulumi.getter(name="maxJobs")
    def max_jobs(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Application Grouping Configurable Maximum Number of Tasks
        """
        return pulumi.get(self, "max_jobs")

    @_builtins.property
    @pulumi.getter(name="monitorConfigJson")
    def monitor_config_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alarm configuration JSON field. For more information about this field, see **Request Parameters * *.
        """
        return pulumi.get(self, "monitor_config_json")

    @_builtins.property
    @pulumi.getter(name="monitorContactsJson")
    def monitor_contacts_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alarm contact JSON format.
        """
        return pulumi.get(self, "monitor_contacts_json")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace ID, which is obtained on the namespace page of the console.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace name.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="namespaceSource")
    def namespace_source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Not supported for the time being, no need to fill in.
        """
        return pulumi.get(self, "namespace_source")

    @_builtins.property
    @pulumi.getter(name="scheduleBusyWorkers")
    def schedule_busy_workers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to schedule a busy machine.
        """
        return pulumi.get(self, "schedule_busy_workers")

