# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.int],
                 content: pulumi.Input[_builtins.str],
                 rule_name: pulumi.Input[_builtins.str],
                 content_category: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_level_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[_builtins.int]] = None,
                 stat_express: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 warn_level: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[_builtins.int] category: The content type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] content: The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
        :param pulumi.Input[_builtins.str] rule_name: The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
        :param pulumi.Input[_builtins.str] content_category: The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
        :param pulumi.Input[_builtins.str] description: The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Default value: `zh`. Valid values:
        :param pulumi.Input[_builtins.str] product_code: The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
        :param pulumi.Input[_builtins.str] product_id: The ID of the service to which the data asset belongs. Valid values:
        :param pulumi.Input[_builtins.str] risk_level_id: The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.int] rule_type: The type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] stat_express: The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
        :param pulumi.Input[_builtins.int] status: Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] target: The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
        :param pulumi.Input[_builtins.int] warn_level: The risk level of the alert that is triggered. Valid values:
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "rule_name", rule_name)
        if content_category is not None:
            pulumi.set(__self__, "content_category", content_category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if product_code is not None:
            pulumi.set(__self__, "product_code", product_code)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if risk_level_id is not None:
            pulumi.set(__self__, "risk_level_id", risk_level_id)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if stat_express is not None:
            pulumi.set(__self__, "stat_express", stat_express)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if warn_level is not None:
            pulumi.set(__self__, "warn_level", warn_level)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.int]:
        """
        The content type of the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="contentCategory")
    def content_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
        """
        return pulumi.get(self, "content_category")

    @content_category.setter
    def content_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_category", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the content within the request and response. Default value: `zh`. Valid values:
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_code", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the service to which the data asset belongs. Valid values:
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="riskLevelId")
    def risk_level_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "risk_level_id")

    @risk_level_id.setter
    def risk_level_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "risk_level_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_type", value)

    @_builtins.property
    @pulumi.getter(name="statExpress")
    def stat_express(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
        """
        return pulumi.get(self, "stat_express")

    @stat_express.setter
    def stat_express(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stat_express", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="warnLevel")
    def warn_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The risk level of the alert that is triggered. Valid values:
        """
        return pulumi.get(self, "warn_level")

    @warn_level.setter
    def warn_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "warn_level", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.int]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_category: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_level_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[_builtins.int]] = None,
                 stat_express: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 warn_level: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[_builtins.int] category: The content type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] content: The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
        :param pulumi.Input[_builtins.str] content_category: The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
        :param pulumi.Input[_builtins.int] custom_type: The type of the sensitive data detection rule. **NOTE:** From version 1.222.0, `custom_type` cannot be specified when create Rule.
        :param pulumi.Input[_builtins.str] description: The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Default value: `zh`. Valid values:
        :param pulumi.Input[_builtins.str] product_code: The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
        :param pulumi.Input[_builtins.str] product_id: The ID of the service to which the data asset belongs. Valid values:
        :param pulumi.Input[_builtins.str] risk_level_id: The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] rule_name: The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
        :param pulumi.Input[_builtins.int] rule_type: The type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] stat_express: The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
        :param pulumi.Input[_builtins.int] status: Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] target: The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
        :param pulumi.Input[_builtins.int] warn_level: The risk level of the alert that is triggered. Valid values:
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_category is not None:
            pulumi.set(__self__, "content_category", content_category)
        if custom_type is not None:
            pulumi.set(__self__, "custom_type", custom_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if product_code is not None:
            pulumi.set(__self__, "product_code", product_code)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if risk_level_id is not None:
            pulumi.set(__self__, "risk_level_id", risk_level_id)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if stat_express is not None:
            pulumi.set(__self__, "stat_express", stat_express)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if warn_level is not None:
            pulumi.set(__self__, "warn_level", warn_level)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The content type of the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentCategory")
    def content_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
        """
        return pulumi.get(self, "content_category")

    @content_category.setter
    def content_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_category", value)

    @_builtins.property
    @pulumi.getter(name="customType")
    def custom_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of the sensitive data detection rule. **NOTE:** From version 1.222.0, `custom_type` cannot be specified when create Rule.
        """
        return pulumi.get(self, "custom_type")

    @custom_type.setter
    def custom_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "custom_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the content within the request and response. Default value: `zh`. Valid values:
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_code", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the service to which the data asset belongs. Valid values:
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="riskLevelId")
    def risk_level_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "risk_level_id")

    @risk_level_id.setter
    def risk_level_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "risk_level_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_type", value)

    @_builtins.property
    @pulumi.getter(name="statExpress")
    def stat_express(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
        """
        return pulumi.get(self, "stat_express")

    @stat_express.setter
    def stat_express(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stat_express", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="warnLevel")
    def warn_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The risk level of the alert that is triggered. Valid values:
        """
        return pulumi.get(self, "warn_level")

    @warn_level.setter
    def warn_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "warn_level", value)


@pulumi.type_token("alicloud:sddp/rule:Rule")
class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.int]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_category: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_level_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[_builtins.int]] = None,
                 stat_express: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 warn_level: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Data Security Center Rule resource.

        For information about Data Security Center Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/data-security-center/latest/api-sddp-2019-01-03-createrule).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example-name"
        default = alicloud.sddp.Rule("default",
            rule_name=name,
            category=2,
            content=\"\"\"  [
            {
              \\"rule\\": [
                {
                  \\"operator\\": \\"contains\\",
                  \\"target\\": \\"content\\",
                  \\"value\\": \\"tf-testACCContent\\"
                }
              ],
              \\"ruleRelation\\": \\"AND\\"
            }
          ]
        \"\"\",
            risk_level_id="4",
            product_code="OSS")
        ```

        ## Import

        Data Security Center Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sddp/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] category: The content type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] content: The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
        :param pulumi.Input[_builtins.str] content_category: The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
        :param pulumi.Input[_builtins.str] description: The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Default value: `zh`. Valid values:
        :param pulumi.Input[_builtins.str] product_code: The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
        :param pulumi.Input[_builtins.str] product_id: The ID of the service to which the data asset belongs. Valid values:
        :param pulumi.Input[_builtins.str] risk_level_id: The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] rule_name: The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
        :param pulumi.Input[_builtins.int] rule_type: The type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] stat_express: The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
        :param pulumi.Input[_builtins.int] status: Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] target: The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
        :param pulumi.Input[_builtins.int] warn_level: The risk level of the alert that is triggered. Valid values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Security Center Rule resource.

        For information about Data Security Center Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/data-security-center/latest/api-sddp-2019-01-03-createrule).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example-name"
        default = alicloud.sddp.Rule("default",
            rule_name=name,
            category=2,
            content=\"\"\"  [
            {
              \\"rule\\": [
                {
                  \\"operator\\": \\"contains\\",
                  \\"target\\": \\"content\\",
                  \\"value\\": \\"tf-testACCContent\\"
                }
              ],
              \\"ruleRelation\\": \\"AND\\"
            }
          ]
        \"\"\",
            risk_level_id="4",
            product_code="OSS")
        ```

        ## Import

        Data Security Center Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sddp/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.int]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_category: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_level_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[_builtins.int]] = None,
                 stat_express: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 warn_level: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["content_category"] = content_category
            __props__.__dict__["description"] = description
            __props__.__dict__["lang"] = lang
            __props__.__dict__["product_code"] = product_code
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["risk_level_id"] = risk_level_id
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["rule_type"] = rule_type
            __props__.__dict__["stat_express"] = stat_express
            __props__.__dict__["status"] = status
            __props__.__dict__["target"] = target
            __props__.__dict__["warn_level"] = warn_level
            __props__.__dict__["custom_type"] = None
        super(Rule, __self__).__init__(
            'alicloud:sddp/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.int]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            content_category: Optional[pulumi.Input[_builtins.str]] = None,
            custom_type: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            product_code: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            risk_level_id: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_type: Optional[pulumi.Input[_builtins.int]] = None,
            stat_express: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            target: Optional[pulumi.Input[_builtins.str]] = None,
            warn_level: Optional[pulumi.Input[_builtins.int]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] category: The content type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] content: The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
        :param pulumi.Input[_builtins.str] content_category: The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
        :param pulumi.Input[_builtins.int] custom_type: The type of the sensitive data detection rule. **NOTE:** From version 1.222.0, `custom_type` cannot be specified when create Rule.
        :param pulumi.Input[_builtins.str] description: The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Default value: `zh`. Valid values:
        :param pulumi.Input[_builtins.str] product_code: The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
        :param pulumi.Input[_builtins.str] product_id: The ID of the service to which the data asset belongs. Valid values:
        :param pulumi.Input[_builtins.str] risk_level_id: The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] rule_name: The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
        :param pulumi.Input[_builtins.int] rule_type: The type of the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] stat_express: The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
        :param pulumi.Input[_builtins.int] status: Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
        :param pulumi.Input[_builtins.str] target: The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
        :param pulumi.Input[_builtins.int] warn_level: The risk level of the alert that is triggered. Valid values:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["category"] = category
        __props__.__dict__["content"] = content
        __props__.__dict__["content_category"] = content_category
        __props__.__dict__["custom_type"] = custom_type
        __props__.__dict__["description"] = description
        __props__.__dict__["lang"] = lang
        __props__.__dict__["product_code"] = product_code
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["risk_level_id"] = risk_level_id
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["rule_type"] = rule_type
        __props__.__dict__["stat_express"] = stat_express
        __props__.__dict__["status"] = status
        __props__.__dict__["target"] = target
        __props__.__dict__["warn_level"] = warn_level
        return Rule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.int]:
        """
        The content type of the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the sensitive data detection rule. **NOTE:** From version 1.222.0, `content` can be modified.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentCategory")
    def content_category(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the content in the sensitive data detection rule. **NOTE:** From version 1.222.0, `content_category` cannot be modified.
        """
        return pulumi.get(self, "content_category")

    @_builtins.property
    @pulumi.getter(name="customType")
    def custom_type(self) -> pulumi.Output[_builtins.int]:
        """
        The type of the sensitive data detection rule. **NOTE:** From version 1.222.0, `custom_type` cannot be specified when create Rule.
        """
        return pulumi.get(self, "custom_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the rule. **NOTE:** From version 1.222.0, `description` cannot be modified.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the content within the request and response. Default value: `zh`. Valid values:
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the service to which data in the column of the table belongs. Valid values: `OSS`, `RDS`, `ODPS`(MaxCompute).
        """
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the service to which the data asset belongs. Valid values:
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="riskLevelId")
    def risk_level_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The sensitivity level of the sensitive data that hits the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "risk_level_id")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the sensitive data detection rule. **NOTE:** From version 1.222.0, `rule_name` can be modified.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The type of the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "rule_type")

    @_builtins.property
    @pulumi.getter(name="statExpress")
    def stat_express(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The statistical expression. **NOTE:** From version 1.222.0, `stat_express` cannot be modified.
        """
        return pulumi.get(self, "stat_express")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        Sensitive Specifies whether to enable the sensitive data detection rule. Valid values:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The code of the service to which the sensitive data detection rule is applied. **NOTE:** From version 1.222.0, `target` cannot be modified.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="warnLevel")
    def warn_level(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The risk level of the alert that is triggered. Valid values:
        """
        return pulumi.get(self, "warn_level")

