# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProvisionedProductArgs', 'ProvisionedProduct']

@pulumi.input_type
class ProvisionedProductArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[_builtins.str],
                 product_version_id: pulumi.Input[_builtins.str],
                 provisioned_product_name: pulumi.Input[_builtins.str],
                 stack_region_id: pulumi.Input[_builtins.str],
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]]] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ProvisionedProduct resource.
        :param pulumi.Input[_builtins.str] product_id: Product ID.
        :param pulumi.Input[_builtins.str] product_version_id: Product version ID.
        :param pulumi.Input[_builtins.str] provisioned_product_name: The name of the instance.The length is 1~128 characters.
        :param pulumi.Input[_builtins.str] stack_region_id: The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
        :param pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]] parameters: Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
        :param pulumi.Input[_builtins.str] portfolio_id: Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
        :param pulumi.Input[_builtins.str] provisioned_product_id: The ID of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "product_version_id", product_version_id)
        pulumi.set(__self__, "provisioned_product_name", provisioned_product_name)
        pulumi.set(__self__, "stack_region_id", stack_region_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if portfolio_id is not None:
            pulumi.set(__self__, "portfolio_id", portfolio_id)
        if provisioned_product_id is not None:
            pulumi.set(__self__, "provisioned_product_id", provisioned_product_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[_builtins.str]:
        """
        Product ID.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="productVersionId")
    def product_version_id(self) -> pulumi.Input[_builtins.str]:
        """
        Product version ID.
        """
        return pulumi.get(self, "product_version_id")

    @product_version_id.setter
    def product_version_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_version_id", value)

    @_builtins.property
    @pulumi.getter(name="provisionedProductName")
    def provisioned_product_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the instance.The length is 1~128 characters.
        """
        return pulumi.get(self, "provisioned_product_name")

    @provisioned_product_name.setter
    def provisioned_product_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provisioned_product_name", value)

    @_builtins.property
    @pulumi.getter(name="stackRegionId")
    def stack_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
        """
        return pulumi.get(self, "stack_region_id")

    @stack_region_id.setter
    def stack_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_region_id", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]]]:
        """
        Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
        """
        return pulumi.get(self, "portfolio_id")

    @portfolio_id.setter
    def portfolio_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portfolio_id", value)

    @_builtins.property
    @pulumi.getter(name="provisionedProductId")
    def provisioned_product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "provisioned_product_id")

    @provisioned_product_id.setter
    def provisioned_product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioned_product_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProvisionedProductState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_provisioning_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_successful_provisioning_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductOutputArgs']]]] = None,
                 owner_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]]] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ProvisionedProduct resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the product instance
        :param pulumi.Input[_builtins.str] last_provisioning_task_id: The ID of the last instance operation task
        :param pulumi.Input[_builtins.str] last_successful_provisioning_task_id: The ID of the last successful instance operation task
        :param pulumi.Input[_builtins.str] last_task_id: The ID of the last task
        :param pulumi.Input[Sequence[pulumi.Input['ProvisionedProductOutputArgs']]] outputs: The output value of the template.
        :param pulumi.Input[_builtins.str] owner_principal_id: The RAM entity ID of the owner
        :param pulumi.Input[_builtins.str] owner_principal_type: The RAM entity type of the owner
        :param pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]] parameters: Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
        :param pulumi.Input[_builtins.str] portfolio_id: Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
        :param pulumi.Input[_builtins.str] product_id: Product ID.
        :param pulumi.Input[_builtins.str] product_name: The name of the product
        :param pulumi.Input[_builtins.str] product_version_id: Product version ID.
        :param pulumi.Input[_builtins.str] product_version_name: The name of the product version
        :param pulumi.Input[_builtins.str] provisioned_product_arn: The ARN of the product instance
        :param pulumi.Input[_builtins.str] provisioned_product_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] provisioned_product_name: The name of the instance.The length is 1~128 characters.
        :param pulumi.Input[_builtins.str] provisioned_product_type: Instance type.The value is RosStack, which indicates the stack of Alibaba Cloud resource orchestration service (ROS).
        :param pulumi.Input[_builtins.str] stack_id: The ID of the ROS stack
        :param pulumi.Input[_builtins.str] stack_region_id: The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
        :param pulumi.Input[_builtins.str] status: Instance status
        :param pulumi.Input[_builtins.str] status_message: The status message of the product instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if last_provisioning_task_id is not None:
            pulumi.set(__self__, "last_provisioning_task_id", last_provisioning_task_id)
        if last_successful_provisioning_task_id is not None:
            pulumi.set(__self__, "last_successful_provisioning_task_id", last_successful_provisioning_task_id)
        if last_task_id is not None:
            pulumi.set(__self__, "last_task_id", last_task_id)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if owner_principal_id is not None:
            pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        if owner_principal_type is not None:
            pulumi.set(__self__, "owner_principal_type", owner_principal_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if portfolio_id is not None:
            pulumi.set(__self__, "portfolio_id", portfolio_id)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if product_version_id is not None:
            pulumi.set(__self__, "product_version_id", product_version_id)
        if product_version_name is not None:
            pulumi.set(__self__, "product_version_name", product_version_name)
        if provisioned_product_arn is not None:
            pulumi.set(__self__, "provisioned_product_arn", provisioned_product_arn)
        if provisioned_product_id is not None:
            pulumi.set(__self__, "provisioned_product_id", provisioned_product_id)
        if provisioned_product_name is not None:
            pulumi.set(__self__, "provisioned_product_name", provisioned_product_name)
        if provisioned_product_type is not None:
            pulumi.set(__self__, "provisioned_product_type", provisioned_product_type)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if stack_region_id is not None:
            pulumi.set(__self__, "stack_region_id", stack_region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the product instance
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="lastProvisioningTaskId")
    def last_provisioning_task_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the last instance operation task
        """
        return pulumi.get(self, "last_provisioning_task_id")

    @last_provisioning_task_id.setter
    def last_provisioning_task_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_provisioning_task_id", value)

    @_builtins.property
    @pulumi.getter(name="lastSuccessfulProvisioningTaskId")
    def last_successful_provisioning_task_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the last successful instance operation task
        """
        return pulumi.get(self, "last_successful_provisioning_task_id")

    @last_successful_provisioning_task_id.setter
    def last_successful_provisioning_task_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_successful_provisioning_task_id", value)

    @_builtins.property
    @pulumi.getter(name="lastTaskId")
    def last_task_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the last task
        """
        return pulumi.get(self, "last_task_id")

    @last_task_id.setter
    def last_task_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_task_id", value)

    @_builtins.property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductOutputArgs']]]]:
        """
        The output value of the template.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM entity ID of the owner
        """
        return pulumi.get(self, "owner_principal_id")

    @owner_principal_id.setter
    def owner_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalType")
    def owner_principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM entity type of the owner
        """
        return pulumi.get(self, "owner_principal_type")

    @owner_principal_type.setter
    def owner_principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_principal_type", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]]]:
        """
        Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
        """
        return pulumi.get(self, "portfolio_id")

    @portfolio_id.setter
    def portfolio_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portfolio_id", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product ID.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the product
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_name", value)

    @_builtins.property
    @pulumi.getter(name="productVersionId")
    def product_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product version ID.
        """
        return pulumi.get(self, "product_version_id")

    @product_version_id.setter
    def product_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_version_id", value)

    @_builtins.property
    @pulumi.getter(name="productVersionName")
    def product_version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the product version
        """
        return pulumi.get(self, "product_version_name")

    @product_version_name.setter
    def product_version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_version_name", value)

    @_builtins.property
    @pulumi.getter(name="provisionedProductArn")
    def provisioned_product_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the product instance
        """
        return pulumi.get(self, "provisioned_product_arn")

    @provisioned_product_arn.setter
    def provisioned_product_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioned_product_arn", value)

    @_builtins.property
    @pulumi.getter(name="provisionedProductId")
    def provisioned_product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "provisioned_product_id")

    @provisioned_product_id.setter
    def provisioned_product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioned_product_id", value)

    @_builtins.property
    @pulumi.getter(name="provisionedProductName")
    def provisioned_product_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance.The length is 1~128 characters.
        """
        return pulumi.get(self, "provisioned_product_name")

    @provisioned_product_name.setter
    def provisioned_product_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioned_product_name", value)

    @_builtins.property
    @pulumi.getter(name="provisionedProductType")
    def provisioned_product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type.The value is RosStack, which indicates the stack of Alibaba Cloud resource orchestration service (ROS).
        """
        return pulumi.get(self, "provisioned_product_type")

    @provisioned_product_type.setter
    def provisioned_product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioned_product_type", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ROS stack
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_id", value)

    @_builtins.property
    @pulumi.getter(name="stackRegionId")
    def stack_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
        """
        return pulumi.get(self, "stack_region_id")

    @stack_region_id.setter
    def stack_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status message of the product instance
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_message", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:servicecatalog/provisionedProduct:ProvisionedProduct")
class ProvisionedProduct(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProvisionedProductParameterArgs', 'ProvisionedProductParameterArgsDict']]]]] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Service Catalog Provisioned Product resource.

        For information about Service Catalog Provisioned Product and how to use it, see [What is Provisioned Product](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-launchproduct).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-testAccServiceCatalogProvisionedProduct"
        default = alicloud.servicecatalog.ProvisionedProduct("default",
            provisioned_product_name=name,
            stack_region_id="cn-hangzhou",
            product_version_id="pv-bp1d7dxy2pcc1g",
            product_id="prod-bp1u3dkc282cwd",
            portfolio_id="port-bp119dvn27jccw",
            tags={
                "v1": "tf-test",
            },
            parameters=[{
                "parameter_key": "role_name",
                "parameter_value": name,
            }])
        ```

        ## Import

        Service Catalog Provisioned Product can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/provisionedProduct:ProvisionedProduct example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProvisionedProductParameterArgs', 'ProvisionedProductParameterArgsDict']]]] parameters: Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
        :param pulumi.Input[_builtins.str] portfolio_id: Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
        :param pulumi.Input[_builtins.str] product_id: Product ID.
        :param pulumi.Input[_builtins.str] product_version_id: Product version ID.
        :param pulumi.Input[_builtins.str] provisioned_product_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] provisioned_product_name: The name of the instance.The length is 1~128 characters.
        :param pulumi.Input[_builtins.str] stack_region_id: The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProvisionedProductArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Service Catalog Provisioned Product resource.

        For information about Service Catalog Provisioned Product and how to use it, see [What is Provisioned Product](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-launchproduct).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-testAccServiceCatalogProvisionedProduct"
        default = alicloud.servicecatalog.ProvisionedProduct("default",
            provisioned_product_name=name,
            stack_region_id="cn-hangzhou",
            product_version_id="pv-bp1d7dxy2pcc1g",
            product_id="prod-bp1u3dkc282cwd",
            portfolio_id="port-bp119dvn27jccw",
            tags={
                "v1": "tf-test",
            },
            parameters=[{
                "parameter_key": "role_name",
                "parameter_value": name,
            }])
        ```

        ## Import

        Service Catalog Provisioned Product can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/provisionedProduct:ProvisionedProduct example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ProvisionedProductArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProvisionedProductArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProvisionedProductParameterArgs', 'ProvisionedProductParameterArgsDict']]]]] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_product_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProvisionedProductArgs.__new__(ProvisionedProductArgs)

            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["portfolio_id"] = portfolio_id
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            if product_version_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_version_id'")
            __props__.__dict__["product_version_id"] = product_version_id
            __props__.__dict__["provisioned_product_id"] = provisioned_product_id
            if provisioned_product_name is None and not opts.urn:
                raise TypeError("Missing required property 'provisioned_product_name'")
            __props__.__dict__["provisioned_product_name"] = provisioned_product_name
            if stack_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_region_id'")
            __props__.__dict__["stack_region_id"] = stack_region_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_provisioning_task_id"] = None
            __props__.__dict__["last_successful_provisioning_task_id"] = None
            __props__.__dict__["last_task_id"] = None
            __props__.__dict__["outputs"] = None
            __props__.__dict__["owner_principal_id"] = None
            __props__.__dict__["owner_principal_type"] = None
            __props__.__dict__["product_name"] = None
            __props__.__dict__["product_version_name"] = None
            __props__.__dict__["provisioned_product_arn"] = None
            __props__.__dict__["provisioned_product_type"] = None
            __props__.__dict__["stack_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
        super(ProvisionedProduct, __self__).__init__(
            'alicloud:servicecatalog/provisionedProduct:ProvisionedProduct',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            last_provisioning_task_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_successful_provisioning_task_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_task_id: Optional[pulumi.Input[_builtins.str]] = None,
            outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProvisionedProductOutputArgs', 'ProvisionedProductOutputArgsDict']]]]] = None,
            owner_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            owner_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProvisionedProductParameterArgs', 'ProvisionedProductParameterArgsDict']]]]] = None,
            portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            product_name: Optional[pulumi.Input[_builtins.str]] = None,
            product_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            product_version_name: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_product_arn: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_product_id: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_product_name: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_product_type: Optional[pulumi.Input[_builtins.str]] = None,
            stack_id: Optional[pulumi.Input[_builtins.str]] = None,
            stack_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_message: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ProvisionedProduct':
        """
        Get an existing ProvisionedProduct resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the product instance
        :param pulumi.Input[_builtins.str] last_provisioning_task_id: The ID of the last instance operation task
        :param pulumi.Input[_builtins.str] last_successful_provisioning_task_id: The ID of the last successful instance operation task
        :param pulumi.Input[_builtins.str] last_task_id: The ID of the last task
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProvisionedProductOutputArgs', 'ProvisionedProductOutputArgsDict']]]] outputs: The output value of the template.
        :param pulumi.Input[_builtins.str] owner_principal_id: The RAM entity ID of the owner
        :param pulumi.Input[_builtins.str] owner_principal_type: The RAM entity type of the owner
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProvisionedProductParameterArgs', 'ProvisionedProductParameterArgsDict']]]] parameters: Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
        :param pulumi.Input[_builtins.str] portfolio_id: Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
        :param pulumi.Input[_builtins.str] product_id: Product ID.
        :param pulumi.Input[_builtins.str] product_name: The name of the product
        :param pulumi.Input[_builtins.str] product_version_id: Product version ID.
        :param pulumi.Input[_builtins.str] product_version_name: The name of the product version
        :param pulumi.Input[_builtins.str] provisioned_product_arn: The ARN of the product instance
        :param pulumi.Input[_builtins.str] provisioned_product_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] provisioned_product_name: The name of the instance.The length is 1~128 characters.
        :param pulumi.Input[_builtins.str] provisioned_product_type: Instance type.The value is RosStack, which indicates the stack of Alibaba Cloud resource orchestration service (ROS).
        :param pulumi.Input[_builtins.str] stack_id: The ID of the ROS stack
        :param pulumi.Input[_builtins.str] stack_region_id: The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
        :param pulumi.Input[_builtins.str] status: Instance status
        :param pulumi.Input[_builtins.str] status_message: The status message of the product instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProvisionedProductState.__new__(_ProvisionedProductState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["last_provisioning_task_id"] = last_provisioning_task_id
        __props__.__dict__["last_successful_provisioning_task_id"] = last_successful_provisioning_task_id
        __props__.__dict__["last_task_id"] = last_task_id
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["owner_principal_id"] = owner_principal_id
        __props__.__dict__["owner_principal_type"] = owner_principal_type
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["portfolio_id"] = portfolio_id
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["product_name"] = product_name
        __props__.__dict__["product_version_id"] = product_version_id
        __props__.__dict__["product_version_name"] = product_version_name
        __props__.__dict__["provisioned_product_arn"] = provisioned_product_arn
        __props__.__dict__["provisioned_product_id"] = provisioned_product_id
        __props__.__dict__["provisioned_product_name"] = provisioned_product_name
        __props__.__dict__["provisioned_product_type"] = provisioned_product_type
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["stack_region_id"] = stack_region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["status_message"] = status_message
        __props__.__dict__["tags"] = tags
        return ProvisionedProduct(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the product instance
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="lastProvisioningTaskId")
    def last_provisioning_task_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the last instance operation task
        """
        return pulumi.get(self, "last_provisioning_task_id")

    @_builtins.property
    @pulumi.getter(name="lastSuccessfulProvisioningTaskId")
    def last_successful_provisioning_task_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the last successful instance operation task
        """
        return pulumi.get(self, "last_successful_provisioning_task_id")

    @_builtins.property
    @pulumi.getter(name="lastTaskId")
    def last_task_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the last task
        """
        return pulumi.get(self, "last_task_id")

    @_builtins.property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Sequence['outputs.ProvisionedProductOutput']]:
        """
        The output value of the template.
        """
        return pulumi.get(self, "outputs")

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The RAM entity ID of the owner
        """
        return pulumi.get(self, "owner_principal_id")

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalType")
    def owner_principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The RAM entity type of the owner
        """
        return pulumi.get(self, "owner_principal_type")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ProvisionedProductParameter']]]:
        """
        Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
        """
        return pulumi.get(self, "portfolio_id")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[_builtins.str]:
        """
        Product ID.
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the product
        """
        return pulumi.get(self, "product_name")

    @_builtins.property
    @pulumi.getter(name="productVersionId")
    def product_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        Product version ID.
        """
        return pulumi.get(self, "product_version_id")

    @_builtins.property
    @pulumi.getter(name="productVersionName")
    def product_version_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the product version
        """
        return pulumi.get(self, "product_version_name")

    @_builtins.property
    @pulumi.getter(name="provisionedProductArn")
    def provisioned_product_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the product instance
        """
        return pulumi.get(self, "provisioned_product_arn")

    @_builtins.property
    @pulumi.getter(name="provisionedProductId")
    def provisioned_product_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "provisioned_product_id")

    @_builtins.property
    @pulumi.getter(name="provisionedProductName")
    def provisioned_product_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance.The length is 1~128 characters.
        """
        return pulumi.get(self, "provisioned_product_name")

    @_builtins.property
    @pulumi.getter(name="provisionedProductType")
    def provisioned_product_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type.The value is RosStack, which indicates the stack of Alibaba Cloud resource orchestration service (ROS).
        """
        return pulumi.get(self, "provisioned_product_type")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ROS stack
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="stackRegionId")
    def stack_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
        """
        return pulumi.get(self, "stack_region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[_builtins.str]:
        """
        The status message of the product instance
        """
        return pulumi.get(self, "status_message")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

