# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApplicationLoadBalancersResult',
    'AwaitableGetApplicationLoadBalancersResult',
    'get_application_load_balancers',
    'get_application_load_balancers_output',
]

@pulumi.output_type
class GetApplicationLoadBalancersResult:
    """
    A collection of values returned by getApplicationLoadBalancers.
    """
    def __init__(__self__, address=None, address_ip_version=None, address_type=None, balancers=None, enable_details=None, id=None, ids=None, internet_charge_type=None, load_balancer_name=None, master_zone_id=None, name_regex=None, names=None, network_type=None, output_file=None, page_number=None, page_size=None, payment_type=None, resource_group_id=None, server_id=None, server_intranet_address=None, slave_zone_id=None, slbs=None, status=None, tags=None, total_count=None, vpc_id=None, vswitch_id=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if address_ip_version and not isinstance(address_ip_version, str):
            raise TypeError("Expected argument 'address_ip_version' to be a str")
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        if address_type and not isinstance(address_type, str):
            raise TypeError("Expected argument 'address_type' to be a str")
        pulumi.set(__self__, "address_type", address_type)
        if balancers and not isinstance(balancers, list):
            raise TypeError("Expected argument 'balancers' to be a list")
        pulumi.set(__self__, "balancers", balancers)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if internet_charge_type and not isinstance(internet_charge_type, str):
            raise TypeError("Expected argument 'internet_charge_type' to be a str")
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if load_balancer_name and not isinstance(load_balancer_name, str):
            raise TypeError("Expected argument 'load_balancer_name' to be a str")
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if master_zone_id and not isinstance(master_zone_id, str):
            raise TypeError("Expected argument 'master_zone_id' to be a str")
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if payment_type and not isinstance(payment_type, str):
            raise TypeError("Expected argument 'payment_type' to be a str")
        pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if server_intranet_address and not isinstance(server_intranet_address, str):
            raise TypeError("Expected argument 'server_intranet_address' to be a str")
        pulumi.set(__self__, "server_intranet_address", server_intranet_address)
        if slave_zone_id and not isinstance(slave_zone_id, str):
            raise TypeError("Expected argument 'slave_zone_id' to be a str")
        pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        if slbs and not isinstance(slbs, list):
            raise TypeError("Expected argument 'slbs' to be a list")
        pulumi.set(__self__, "slbs", slbs)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id and not isinstance(vswitch_id, str):
            raise TypeError("Expected argument 'vswitch_id' to be a str")
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The IP address that the SLB instance uses to provide services.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[_builtins.str]:
        """
        The address ip version.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[_builtins.str]:
        """
        The address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def balancers(self) -> Sequence['outputs.GetApplicationLoadBalancersBalancerResult']:
        """
        A list of SLBs. Each element contains the following attributes:
        """
        return pulumi.get(self, "balancers")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of slb IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[_builtins.str]:
        """
        The billing method of the Internet-facing SLB instance.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[_builtins.str]:
        """
        The name of the SLB.
        """
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> Optional[_builtins.str]:
        """
        Master availability zone of the SLBs.
        """
        return pulumi.get(self, "master_zone_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of slb names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        Network type of the SLB. Possible values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Elastic Compute Service (ECS) instance that is specified as a backend server of the CLB instance.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="serverIntranetAddress")
    def server_intranet_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "server_intranet_address")

    @_builtins.property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> Optional[_builtins.str]:
        """
        Slave availability zone of the SLBs.
        """
        return pulumi.get(self, "slave_zone_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'slbs' has deprecated from v1.123.1 and replace by 'balancers'.""")
    def slbs(self) -> Sequence['outputs.GetApplicationLoadBalancersSlbResult']:
        return pulumi.get(self, "slbs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tags of the SLB.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        return pulumi.get(self, "total_count")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        ID of the VPC the SLB belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        ID of the vSwitch the SLB belongs to.
        """
        return pulumi.get(self, "vswitch_id")


class AwaitableGetApplicationLoadBalancersResult(GetApplicationLoadBalancersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationLoadBalancersResult(
            address=self.address,
            address_ip_version=self.address_ip_version,
            address_type=self.address_type,
            balancers=self.balancers,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            internet_charge_type=self.internet_charge_type,
            load_balancer_name=self.load_balancer_name,
            master_zone_id=self.master_zone_id,
            name_regex=self.name_regex,
            names=self.names,
            network_type=self.network_type,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            payment_type=self.payment_type,
            resource_group_id=self.resource_group_id,
            server_id=self.server_id,
            server_intranet_address=self.server_intranet_address,
            slave_zone_id=self.slave_zone_id,
            slbs=self.slbs,
            status=self.status,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id,
            vswitch_id=self.vswitch_id)


def get_application_load_balancers(address: Optional[_builtins.str] = None,
                                   address_ip_version: Optional[_builtins.str] = None,
                                   address_type: Optional[_builtins.str] = None,
                                   enable_details: Optional[_builtins.bool] = None,
                                   ids: Optional[Sequence[_builtins.str]] = None,
                                   internet_charge_type: Optional[_builtins.str] = None,
                                   load_balancer_name: Optional[_builtins.str] = None,
                                   master_zone_id: Optional[_builtins.str] = None,
                                   name_regex: Optional[_builtins.str] = None,
                                   network_type: Optional[_builtins.str] = None,
                                   output_file: Optional[_builtins.str] = None,
                                   page_number: Optional[_builtins.int] = None,
                                   page_size: Optional[_builtins.int] = None,
                                   payment_type: Optional[_builtins.str] = None,
                                   resource_group_id: Optional[_builtins.str] = None,
                                   server_id: Optional[_builtins.str] = None,
                                   server_intranet_address: Optional[_builtins.str] = None,
                                   slave_zone_id: Optional[_builtins.str] = None,
                                   status: Optional[_builtins.str] = None,
                                   tags: Optional[Mapping[str, _builtins.str]] = None,
                                   vpc_id: Optional[_builtins.str] = None,
                                   vswitch_id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationLoadBalancersResult:
    """
    This data source provides the server load balancers of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.123.1+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.slb.get_application_load_balancers(name_regex="sample_slb",
        tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
    pulumi.export("firstSlbId", example.balancers[0].id)
    ```


    :param _builtins.str address: Service address of the SLBs.
    :param _builtins.str address_ip_version: The address ip version. Valid values `ipv4` and `ipv6`.
    :param _builtins.str address_type: The address type of the SLB. Valid values `internet` and `intranet`.
    :param Sequence[_builtins.str] ids: A list of SLBs IDs.
    :param _builtins.str internet_charge_type: The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
    :param _builtins.str load_balancer_name: The name of the SLB.
    :param _builtins.str master_zone_id: The master zone id of the SLB.
    :param _builtins.str name_regex: A regex string to filter results by SLB name.
    :param _builtins.str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
    :param _builtins.str resource_group_id: The Id of resource group which SLB belongs.
    :param _builtins.str server_id: The server ID.
    :param _builtins.str server_intranet_address: The server intranet address.
    :param _builtins.str slave_zone_id: The slave zone id of the SLB.
    :param _builtins.str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
    :param Mapping[str, _builtins.str] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
    :param _builtins.str vpc_id: ID of the VPC linked to the SLBs.
    :param _builtins.str vswitch_id: ID of the vSwitch linked to the SLBs.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['addressIpVersion'] = address_ip_version
    __args__['addressType'] = address_type
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['internetChargeType'] = internet_charge_type
    __args__['loadBalancerName'] = load_balancer_name
    __args__['masterZoneId'] = master_zone_id
    __args__['nameRegex'] = name_regex
    __args__['networkType'] = network_type
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['paymentType'] = payment_type
    __args__['resourceGroupId'] = resource_group_id
    __args__['serverId'] = server_id
    __args__['serverIntranetAddress'] = server_intranet_address
    __args__['slaveZoneId'] = slave_zone_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:slb/getApplicationLoadBalancers:getApplicationLoadBalancers', __args__, opts=opts, typ=GetApplicationLoadBalancersResult).value

    return AwaitableGetApplicationLoadBalancersResult(
        address=pulumi.get(__ret__, 'address'),
        address_ip_version=pulumi.get(__ret__, 'address_ip_version'),
        address_type=pulumi.get(__ret__, 'address_type'),
        balancers=pulumi.get(__ret__, 'balancers'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        internet_charge_type=pulumi.get(__ret__, 'internet_charge_type'),
        load_balancer_name=pulumi.get(__ret__, 'load_balancer_name'),
        master_zone_id=pulumi.get(__ret__, 'master_zone_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        network_type=pulumi.get(__ret__, 'network_type'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        payment_type=pulumi.get(__ret__, 'payment_type'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        server_id=pulumi.get(__ret__, 'server_id'),
        server_intranet_address=pulumi.get(__ret__, 'server_intranet_address'),
        slave_zone_id=pulumi.get(__ret__, 'slave_zone_id'),
        slbs=pulumi.get(__ret__, 'slbs'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vswitch_id=pulumi.get(__ret__, 'vswitch_id'))
def get_application_load_balancers_output(address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          address_ip_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          address_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                          ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          internet_charge_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          load_balancer_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          master_zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          network_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                          page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                          payment_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          server_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          server_intranet_address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          slave_zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                          vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          vswitch_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationLoadBalancersResult]:
    """
    This data source provides the server load balancers of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.123.1+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.slb.get_application_load_balancers(name_regex="sample_slb",
        tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
    pulumi.export("firstSlbId", example.balancers[0].id)
    ```


    :param _builtins.str address: Service address of the SLBs.
    :param _builtins.str address_ip_version: The address ip version. Valid values `ipv4` and `ipv6`.
    :param _builtins.str address_type: The address type of the SLB. Valid values `internet` and `intranet`.
    :param Sequence[_builtins.str] ids: A list of SLBs IDs.
    :param _builtins.str internet_charge_type: The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
    :param _builtins.str load_balancer_name: The name of the SLB.
    :param _builtins.str master_zone_id: The master zone id of the SLB.
    :param _builtins.str name_regex: A regex string to filter results by SLB name.
    :param _builtins.str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
    :param _builtins.str resource_group_id: The Id of resource group which SLB belongs.
    :param _builtins.str server_id: The server ID.
    :param _builtins.str server_intranet_address: The server intranet address.
    :param _builtins.str slave_zone_id: The slave zone id of the SLB.
    :param _builtins.str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
    :param Mapping[str, _builtins.str] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
    :param _builtins.str vpc_id: ID of the VPC linked to the SLBs.
    :param _builtins.str vswitch_id: ID of the vSwitch linked to the SLBs.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['addressIpVersion'] = address_ip_version
    __args__['addressType'] = address_type
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['internetChargeType'] = internet_charge_type
    __args__['loadBalancerName'] = load_balancer_name
    __args__['masterZoneId'] = master_zone_id
    __args__['nameRegex'] = name_regex
    __args__['networkType'] = network_type
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['paymentType'] = payment_type
    __args__['resourceGroupId'] = resource_group_id
    __args__['serverId'] = server_id
    __args__['serverIntranetAddress'] = server_intranet_address
    __args__['slaveZoneId'] = slave_zone_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:slb/getApplicationLoadBalancers:getApplicationLoadBalancers', __args__, opts=opts, typ=GetApplicationLoadBalancersResult)
    return __ret__.apply(lambda __response__: GetApplicationLoadBalancersResult(
        address=pulumi.get(__response__, 'address'),
        address_ip_version=pulumi.get(__response__, 'address_ip_version'),
        address_type=pulumi.get(__response__, 'address_type'),
        balancers=pulumi.get(__response__, 'balancers'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        internet_charge_type=pulumi.get(__response__, 'internet_charge_type'),
        load_balancer_name=pulumi.get(__response__, 'load_balancer_name'),
        master_zone_id=pulumi.get(__response__, 'master_zone_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        network_type=pulumi.get(__response__, 'network_type'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        payment_type=pulumi.get(__response__, 'payment_type'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        server_id=pulumi.get(__response__, 'server_id'),
        server_intranet_address=pulumi.get(__response__, 'server_intranet_address'),
        slave_zone_id=pulumi.get(__response__, 'slave_zone_id'),
        slbs=pulumi.get(__response__, 'slbs'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        total_count=pulumi.get(__response__, 'total_count'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vswitch_id=pulumi.get(__response__, 'vswitch_id')))
