# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRulesResult',
    'AwaitableGetRulesResult',
    'get_rules',
    'get_rules_output',
]

@pulumi.output_type
class GetRulesResult:
    """
    A collection of values returned by getRules.
    """
    def __init__(__self__, frontend_port=None, id=None, ids=None, load_balancer_id=None, name_regex=None, names=None, output_file=None, slb_rules=None):
        if frontend_port and not isinstance(frontend_port, int):
            raise TypeError("Expected argument 'frontend_port' to be a int")
        pulumi.set(__self__, "frontend_port", frontend_port)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if slb_rules and not isinstance(slb_rules, list):
            raise TypeError("Expected argument 'slb_rules' to be a list")
        pulumi.set(__self__, "slb_rules", slb_rules)

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> _builtins.int:
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of SLB listener rules IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of SLB listener rules names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="slbRules")
    def slb_rules(self) -> Sequence['outputs.GetRulesSlbRuleResult']:
        """
        A list of SLB listener rules. Each element contains the following attributes:
        """
        return pulumi.get(self, "slb_rules")


class AwaitableGetRulesResult(GetRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulesResult(
            frontend_port=self.frontend_port,
            id=self.id,
            ids=self.ids,
            load_balancer_id=self.load_balancer_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            slb_rules=self.slb_rules)


def get_rules(frontend_port: Optional[_builtins.int] = None,
              ids: Optional[Sequence[_builtins.str]] = None,
              load_balancer_id: Optional[_builtins.str] = None,
              name_regex: Optional[_builtins.str] = None,
              output_file: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulesResult:
    """
    This data source provides the rules associated with a server load balancer listener.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "slbrulebasicconfig"
    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        name=name,
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/16",
        zone_id=default.zones[0].id,
        vswitch_name=name)
    default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
        load_balancer_name=name,
        vswitch_id=default_switch.id)
    default_listener = alicloud.slb.Listener("default",
        load_balancer_id=default_application_load_balancer.id,
        backend_port=22,
        frontend_port=22,
        protocol="http",
        bandwidth=5,
        health_check_connect_port=20)
    default_server_group = alicloud.slb.ServerGroup("default", load_balancer_id=default_application_load_balancer.id)
    default_rule = alicloud.slb.Rule("default",
        load_balancer_id=default_application_load_balancer.id,
        frontend_port=default_listener.frontend_port,
        name=name,
        domain="*.aliyun.com",
        url="/image",
        server_group_id=default_server_group.id)
    sample_ds = default_application_load_balancer.id.apply(lambda id: alicloud.slb.get_rules_output(load_balancer_id=id,
        frontend_port=22))
    pulumi.export("firstSlbRuleId", sample_ds.slb_rules[0].id)
    ```


    :param _builtins.int frontend_port: SLB listener port.
    :param Sequence[_builtins.str] ids: A list of rules IDs to filter results.
    :param _builtins.str load_balancer_id: ID of the SLB with listener rules.
    :param _builtins.str name_regex: A regex string to filter results by rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['frontendPort'] = frontend_port
    __args__['ids'] = ids
    __args__['loadBalancerId'] = load_balancer_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:slb/getRules:getRules', __args__, opts=opts, typ=GetRulesResult).value

    return AwaitableGetRulesResult(
        frontend_port=pulumi.get(__ret__, 'frontend_port'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        slb_rules=pulumi.get(__ret__, 'slb_rules'))
def get_rules_output(frontend_port: Optional[pulumi.Input[_builtins.int]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                     name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRulesResult]:
    """
    This data source provides the rules associated with a server load balancer listener.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "slbrulebasicconfig"
    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        name=name,
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/16",
        zone_id=default.zones[0].id,
        vswitch_name=name)
    default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
        load_balancer_name=name,
        vswitch_id=default_switch.id)
    default_listener = alicloud.slb.Listener("default",
        load_balancer_id=default_application_load_balancer.id,
        backend_port=22,
        frontend_port=22,
        protocol="http",
        bandwidth=5,
        health_check_connect_port=20)
    default_server_group = alicloud.slb.ServerGroup("default", load_balancer_id=default_application_load_balancer.id)
    default_rule = alicloud.slb.Rule("default",
        load_balancer_id=default_application_load_balancer.id,
        frontend_port=default_listener.frontend_port,
        name=name,
        domain="*.aliyun.com",
        url="/image",
        server_group_id=default_server_group.id)
    sample_ds = default_application_load_balancer.id.apply(lambda id: alicloud.slb.get_rules_output(load_balancer_id=id,
        frontend_port=22))
    pulumi.export("firstSlbRuleId", sample_ds.slb_rules[0].id)
    ```


    :param _builtins.int frontend_port: SLB listener port.
    :param Sequence[_builtins.str] ids: A list of rules IDs to filter results.
    :param _builtins.str load_balancer_id: ID of the SLB with listener rules.
    :param _builtins.str name_regex: A regex string to filter results by rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['frontendPort'] = frontend_port
    __args__['ids'] = ids
    __args__['loadBalancerId'] = load_balancer_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:slb/getRules:getRules', __args__, opts=opts, typ=GetRulesResult)
    return __ret__.apply(lambda __response__: GetRulesResult(
        frontend_port=pulumi.get(__response__, 'frontend_port'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        slb_rules=pulumi.get(__response__, 'slb_rules')))
