# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CollectionPolicyArgs', 'CollectionPolicy']

@pulumi.input_type
class CollectionPolicyArgs:
    def __init__(__self__, *,
                 data_code: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 policy_config: pulumi.Input['CollectionPolicyPolicyConfigArgs'],
                 policy_name: pulumi.Input[_builtins.str],
                 product_code: pulumi.Input[_builtins.str],
                 centralize_config: Optional[pulumi.Input['CollectionPolicyCentralizeConfigArgs']] = None,
                 centralize_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_config: Optional[pulumi.Input['CollectionPolicyDataConfigArgs']] = None,
                 resource_directory: Optional[pulumi.Input['CollectionPolicyResourceDirectoryArgs']] = None):
        """
        The set of arguments for constructing a CollectionPolicy resource.
        :param pulumi.Input[_builtins.str] data_code: Log type encoding.
        :param pulumi.Input[_builtins.bool] enabled: Whether to open.
        :param pulumi.Input['CollectionPolicyPolicyConfigArgs'] policy_config: Collection rule configuration. See `policy_config` below.
        :param pulumi.Input[_builtins.str] policy_name: The name of the rule, with a minimum of 3 characters and a maximum of 63 characters, must start with a letter.
        :param pulumi.Input[_builtins.str] product_code: Product code.
        :param pulumi.Input['CollectionPolicyCentralizeConfigArgs'] centralize_config: Centralized transfer configuration. See `centralize_config` below.
        :param pulumi.Input[_builtins.bool] centralize_enabled: Whether to enable centralized Conversion. The default value is false.
        :param pulumi.Input['CollectionPolicyDataConfigArgs'] data_config: The configuration is supported only when the log type is global. For example, if the productCode is sls, global logs will be collected to the corresponding region during the first configuration. See `data_config` below.
        :param pulumi.Input['CollectionPolicyResourceDirectoryArgs'] resource_directory: For Resource Directory configuration, the account must have opened the resource directory and be an administrator or a delegated administrator. See `resource_directory` below.
        """
        pulumi.set(__self__, "data_code", data_code)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "policy_config", policy_config)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "product_code", product_code)
        if centralize_config is not None:
            pulumi.set(__self__, "centralize_config", centralize_config)
        if centralize_enabled is not None:
            pulumi.set(__self__, "centralize_enabled", centralize_enabled)
        if data_config is not None:
            pulumi.set(__self__, "data_config", data_config)
        if resource_directory is not None:
            pulumi.set(__self__, "resource_directory", resource_directory)

    @_builtins.property
    @pulumi.getter(name="dataCode")
    def data_code(self) -> pulumi.Input[_builtins.str]:
        """
        Log type encoding.
        """
        return pulumi.get(self, "data_code")

    @data_code.setter
    def data_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_code", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to open.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="policyConfig")
    def policy_config(self) -> pulumi.Input['CollectionPolicyPolicyConfigArgs']:
        """
        Collection rule configuration. See `policy_config` below.
        """
        return pulumi.get(self, "policy_config")

    @policy_config.setter
    def policy_config(self, value: pulumi.Input['CollectionPolicyPolicyConfigArgs']):
        pulumi.set(self, "policy_config", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the rule, with a minimum of 3 characters and a maximum of 63 characters, must start with a letter.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> pulumi.Input[_builtins.str]:
        """
        Product code.
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_code", value)

    @_builtins.property
    @pulumi.getter(name="centralizeConfig")
    def centralize_config(self) -> Optional[pulumi.Input['CollectionPolicyCentralizeConfigArgs']]:
        """
        Centralized transfer configuration. See `centralize_config` below.
        """
        return pulumi.get(self, "centralize_config")

    @centralize_config.setter
    def centralize_config(self, value: Optional[pulumi.Input['CollectionPolicyCentralizeConfigArgs']]):
        pulumi.set(self, "centralize_config", value)

    @_builtins.property
    @pulumi.getter(name="centralizeEnabled")
    def centralize_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable centralized Conversion. The default value is false.
        """
        return pulumi.get(self, "centralize_enabled")

    @centralize_enabled.setter
    def centralize_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "centralize_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataConfig")
    def data_config(self) -> Optional[pulumi.Input['CollectionPolicyDataConfigArgs']]:
        """
        The configuration is supported only when the log type is global. For example, if the productCode is sls, global logs will be collected to the corresponding region during the first configuration. See `data_config` below.
        """
        return pulumi.get(self, "data_config")

    @data_config.setter
    def data_config(self, value: Optional[pulumi.Input['CollectionPolicyDataConfigArgs']]):
        pulumi.set(self, "data_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceDirectory")
    def resource_directory(self) -> Optional[pulumi.Input['CollectionPolicyResourceDirectoryArgs']]:
        """
        For Resource Directory configuration, the account must have opened the resource directory and be an administrator or a delegated administrator. See `resource_directory` below.
        """
        return pulumi.get(self, "resource_directory")

    @resource_directory.setter
    def resource_directory(self, value: Optional[pulumi.Input['CollectionPolicyResourceDirectoryArgs']]):
        pulumi.set(self, "resource_directory", value)


@pulumi.input_type
class _CollectionPolicyState:
    def __init__(__self__, *,
                 centralize_config: Optional[pulumi.Input['CollectionPolicyCentralizeConfigArgs']] = None,
                 centralize_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_code: Optional[pulumi.Input[_builtins.str]] = None,
                 data_config: Optional[pulumi.Input['CollectionPolicyDataConfigArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_config: Optional[pulumi.Input['CollectionPolicyPolicyConfigArgs']] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_directory: Optional[pulumi.Input['CollectionPolicyResourceDirectoryArgs']] = None):
        """
        Input properties used for looking up and filtering CollectionPolicy resources.
        :param pulumi.Input['CollectionPolicyCentralizeConfigArgs'] centralize_config: Centralized transfer configuration. See `centralize_config` below.
        :param pulumi.Input[_builtins.bool] centralize_enabled: Whether to enable centralized Conversion. The default value is false.
        :param pulumi.Input[_builtins.str] data_code: Log type encoding.
        :param pulumi.Input['CollectionPolicyDataConfigArgs'] data_config: The configuration is supported only when the log type is global. For example, if the productCode is sls, global logs will be collected to the corresponding region during the first configuration. See `data_config` below.
        :param pulumi.Input[_builtins.bool] enabled: Whether to open.
        :param pulumi.Input['CollectionPolicyPolicyConfigArgs'] policy_config: Collection rule configuration. See `policy_config` below.
        :param pulumi.Input[_builtins.str] policy_name: The name of the rule, with a minimum of 3 characters and a maximum of 63 characters, must start with a letter.
        :param pulumi.Input[_builtins.str] product_code: Product code.
        :param pulumi.Input['CollectionPolicyResourceDirectoryArgs'] resource_directory: For Resource Directory configuration, the account must have opened the resource directory and be an administrator or a delegated administrator. See `resource_directory` below.
        """
        if centralize_config is not None:
            pulumi.set(__self__, "centralize_config", centralize_config)
        if centralize_enabled is not None:
            pulumi.set(__self__, "centralize_enabled", centralize_enabled)
        if data_code is not None:
            pulumi.set(__self__, "data_code", data_code)
        if data_config is not None:
            pulumi.set(__self__, "data_config", data_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if policy_config is not None:
            pulumi.set(__self__, "policy_config", policy_config)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if product_code is not None:
            pulumi.set(__self__, "product_code", product_code)
        if resource_directory is not None:
            pulumi.set(__self__, "resource_directory", resource_directory)

    @_builtins.property
    @pulumi.getter(name="centralizeConfig")
    def centralize_config(self) -> Optional[pulumi.Input['CollectionPolicyCentralizeConfigArgs']]:
        """
        Centralized transfer configuration. See `centralize_config` below.
        """
        return pulumi.get(self, "centralize_config")

    @centralize_config.setter
    def centralize_config(self, value: Optional[pulumi.Input['CollectionPolicyCentralizeConfigArgs']]):
        pulumi.set(self, "centralize_config", value)

    @_builtins.property
    @pulumi.getter(name="centralizeEnabled")
    def centralize_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable centralized Conversion. The default value is false.
        """
        return pulumi.get(self, "centralize_enabled")

    @centralize_enabled.setter
    def centralize_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "centralize_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataCode")
    def data_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log type encoding.
        """
        return pulumi.get(self, "data_code")

    @data_code.setter
    def data_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_code", value)

    @_builtins.property
    @pulumi.getter(name="dataConfig")
    def data_config(self) -> Optional[pulumi.Input['CollectionPolicyDataConfigArgs']]:
        """
        The configuration is supported only when the log type is global. For example, if the productCode is sls, global logs will be collected to the corresponding region during the first configuration. See `data_config` below.
        """
        return pulumi.get(self, "data_config")

    @data_config.setter
    def data_config(self, value: Optional[pulumi.Input['CollectionPolicyDataConfigArgs']]):
        pulumi.set(self, "data_config", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to open.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="policyConfig")
    def policy_config(self) -> Optional[pulumi.Input['CollectionPolicyPolicyConfigArgs']]:
        """
        Collection rule configuration. See `policy_config` below.
        """
        return pulumi.get(self, "policy_config")

    @policy_config.setter
    def policy_config(self, value: Optional[pulumi.Input['CollectionPolicyPolicyConfigArgs']]):
        pulumi.set(self, "policy_config", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule, with a minimum of 3 characters and a maximum of 63 characters, must start with a letter.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product code.
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_code", value)

    @_builtins.property
    @pulumi.getter(name="resourceDirectory")
    def resource_directory(self) -> Optional[pulumi.Input['CollectionPolicyResourceDirectoryArgs']]:
        """
        For Resource Directory configuration, the account must have opened the resource directory and be an administrator or a delegated administrator. See `resource_directory` below.
        """
        return pulumi.get(self, "resource_directory")

    @resource_directory.setter
    def resource_directory(self, value: Optional[pulumi.Input['CollectionPolicyResourceDirectoryArgs']]):
        pulumi.set(self, "resource_directory", value)


@pulumi.type_token("alicloud:sls/collectionPolicy:CollectionPolicy")
class CollectionPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 centralize_config: Optional[pulumi.Input[Union['CollectionPolicyCentralizeConfigArgs', 'CollectionPolicyCentralizeConfigArgsDict']]] = None,
                 centralize_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_code: Optional[pulumi.Input[_builtins.str]] = None,
                 data_config: Optional[pulumi.Input[Union['CollectionPolicyDataConfigArgs', 'CollectionPolicyDataConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_config: Optional[pulumi.Input[Union['CollectionPolicyPolicyConfigArgs', 'CollectionPolicyPolicyConfigArgsDict']]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_directory: Optional[pulumi.Input[Union['CollectionPolicyResourceDirectoryArgs', 'CollectionPolicyResourceDirectoryArgsDict']]] = None,
                 __props__=None):
        """
        Provides a SLS Collection Policy resource.

        Orchestration policies for cloud product log collection.

        For information about SLS Collection Policy and how to use it, see [What is Collection Policy](https://www.alibabacloud.com/help/zh/sls/developer-reference/api-sls-2020-12-30-upsertcollectionpolicy).

        > **NOTE:** Available since v1.232.0.

        ## Example Usage

        Enable real-time log query for all of OSS buckets.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        project_create01 = alicloud.log.Project("project_create_01",
            description=name,
            project_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore_create01 = alicloud.log.Store("logstore_create_01",
            retention_period=30,
            shard_count=2,
            project_name=project_create01.project_name,
            logstore_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        update01 = alicloud.log.Project("update_01",
            description=name,
            project_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore002 = alicloud.log.Store("logstore002",
            retention_period=30,
            shard_count=2,
            project_name=update01.project_name,
            logstore_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        default_collection_policy = alicloud.sls.CollectionPolicy("default",
            policy_config={
                "resource_mode": "all",
                "regions": ["cn-hangzhou"],
            },
            data_code="metering_log",
            centralize_enabled=True,
            product_code="oss",
            policy_name="xc-example-oss-01",
            enabled=True,
            data_config={
                "data_region": "cn-hangzhou",
            },
            centralize_config={
                "dest_ttl": 3,
                "dest_region": "cn-shanghai",
                "dest_project": project_create01.project_name,
                "dest_logstore": logstore_create01.logstore_name,
            },
            resource_directory={
                "account_group_type": "custom",
                "members": ["1936728897040477"],
            })
        ```

        Enable real-time log query for one or more specific OSS buckets

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example-on-single-bucket"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        project_create01 = alicloud.log.Project("project_create_01",
            description=name,
            project_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore_create01 = alicloud.log.Store("logstore_create_01",
            retention_period=30,
            shard_count=2,
            project_name=project_create01.project_name,
            logstore_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        update01 = alicloud.log.Project("update_01",
            description=name,
            project_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore002 = alicloud.log.Store("logstore002",
            retention_period=30,
            shard_count=2,
            project_name=update01.project_name,
            logstore_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        bucket = alicloud.oss.Bucket("bucket", bucket=std.format(input="%s1%s",
            args=[
                name,
                default["result"],
            ]).result)
        default_collection_policy = alicloud.sls.CollectionPolicy("default",
            policy_config={
                "resource_mode": "instanceMode",
                "instance_ids": [bucket.id],
            },
            data_code="access_log",
            centralize_enabled=False,
            product_code="oss",
            policy_name="xc-example-oss-01",
            enabled=True)
        ```

        ## Import

        SLS Collection Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/collectionPolicy:CollectionPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CollectionPolicyCentralizeConfigArgs', 'CollectionPolicyCentralizeConfigArgsDict']] centralize_config: Centralized transfer configuration. See `centralize_config` below.
        :param pulumi.Input[_builtins.bool] centralize_enabled: Whether to enable centralized Conversion. The default value is false.
        :param pulumi.Input[_builtins.str] data_code: Log type encoding.
        :param pulumi.Input[Union['CollectionPolicyDataConfigArgs', 'CollectionPolicyDataConfigArgsDict']] data_config: The configuration is supported only when the log type is global. For example, if the productCode is sls, global logs will be collected to the corresponding region during the first configuration. See `data_config` below.
        :param pulumi.Input[_builtins.bool] enabled: Whether to open.
        :param pulumi.Input[Union['CollectionPolicyPolicyConfigArgs', 'CollectionPolicyPolicyConfigArgsDict']] policy_config: Collection rule configuration. See `policy_config` below.
        :param pulumi.Input[_builtins.str] policy_name: The name of the rule, with a minimum of 3 characters and a maximum of 63 characters, must start with a letter.
        :param pulumi.Input[_builtins.str] product_code: Product code.
        :param pulumi.Input[Union['CollectionPolicyResourceDirectoryArgs', 'CollectionPolicyResourceDirectoryArgsDict']] resource_directory: For Resource Directory configuration, the account must have opened the resource directory and be an administrator or a delegated administrator. See `resource_directory` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CollectionPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SLS Collection Policy resource.

        Orchestration policies for cloud product log collection.

        For information about SLS Collection Policy and how to use it, see [What is Collection Policy](https://www.alibabacloud.com/help/zh/sls/developer-reference/api-sls-2020-12-30-upsertcollectionpolicy).

        > **NOTE:** Available since v1.232.0.

        ## Example Usage

        Enable real-time log query for all of OSS buckets.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        project_create01 = alicloud.log.Project("project_create_01",
            description=name,
            project_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore_create01 = alicloud.log.Store("logstore_create_01",
            retention_period=30,
            shard_count=2,
            project_name=project_create01.project_name,
            logstore_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        update01 = alicloud.log.Project("update_01",
            description=name,
            project_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore002 = alicloud.log.Store("logstore002",
            retention_period=30,
            shard_count=2,
            project_name=update01.project_name,
            logstore_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        default_collection_policy = alicloud.sls.CollectionPolicy("default",
            policy_config={
                "resource_mode": "all",
                "regions": ["cn-hangzhou"],
            },
            data_code="metering_log",
            centralize_enabled=True,
            product_code="oss",
            policy_name="xc-example-oss-01",
            enabled=True,
            data_config={
                "data_region": "cn-hangzhou",
            },
            centralize_config={
                "dest_ttl": 3,
                "dest_region": "cn-shanghai",
                "dest_project": project_create01.project_name,
                "dest_logstore": logstore_create01.logstore_name,
            },
            resource_directory={
                "account_group_type": "custom",
                "members": ["1936728897040477"],
            })
        ```

        Enable real-time log query for one or more specific OSS buckets

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example-on-single-bucket"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        project_create01 = alicloud.log.Project("project_create_01",
            description=name,
            project_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore_create01 = alicloud.log.Store("logstore_create_01",
            retention_period=30,
            shard_count=2,
            project_name=project_create01.project_name,
            logstore_name=std.format(input="%s1%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        update01 = alicloud.log.Project("update_01",
            description=name,
            project_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        logstore002 = alicloud.log.Store("logstore002",
            retention_period=30,
            shard_count=2,
            project_name=update01.project_name,
            logstore_name=std.format(input="%s2%s",
                args=[
                    name,
                    default["result"],
                ]).result)
        bucket = alicloud.oss.Bucket("bucket", bucket=std.format(input="%s1%s",
            args=[
                name,
                default["result"],
            ]).result)
        default_collection_policy = alicloud.sls.CollectionPolicy("default",
            policy_config={
                "resource_mode": "instanceMode",
                "instance_ids": [bucket.id],
            },
            data_code="access_log",
            centralize_enabled=False,
            product_code="oss",
            policy_name="xc-example-oss-01",
            enabled=True)
        ```

        ## Import

        SLS Collection Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/collectionPolicy:CollectionPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CollectionPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CollectionPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 centralize_config: Optional[pulumi.Input[Union['CollectionPolicyCentralizeConfigArgs', 'CollectionPolicyCentralizeConfigArgsDict']]] = None,
                 centralize_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_code: Optional[pulumi.Input[_builtins.str]] = None,
                 data_config: Optional[pulumi.Input[Union['CollectionPolicyDataConfigArgs', 'CollectionPolicyDataConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_config: Optional[pulumi.Input[Union['CollectionPolicyPolicyConfigArgs', 'CollectionPolicyPolicyConfigArgsDict']]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_code: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_directory: Optional[pulumi.Input[Union['CollectionPolicyResourceDirectoryArgs', 'CollectionPolicyResourceDirectoryArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CollectionPolicyArgs.__new__(CollectionPolicyArgs)

            __props__.__dict__["centralize_config"] = centralize_config
            __props__.__dict__["centralize_enabled"] = centralize_enabled
            if data_code is None and not opts.urn:
                raise TypeError("Missing required property 'data_code'")
            __props__.__dict__["data_code"] = data_code
            __props__.__dict__["data_config"] = data_config
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if policy_config is None and not opts.urn:
                raise TypeError("Missing required property 'policy_config'")
            __props__.__dict__["policy_config"] = policy_config
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
            if product_code is None and not opts.urn:
                raise TypeError("Missing required property 'product_code'")
            __props__.__dict__["product_code"] = product_code
            __props__.__dict__["resource_directory"] = resource_directory
        super(CollectionPolicy, __self__).__init__(
            'alicloud:sls/collectionPolicy:CollectionPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            centralize_config: Optional[pulumi.Input[Union['CollectionPolicyCentralizeConfigArgs', 'CollectionPolicyCentralizeConfigArgsDict']]] = None,
            centralize_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            data_code: Optional[pulumi.Input[_builtins.str]] = None,
            data_config: Optional[pulumi.Input[Union['CollectionPolicyDataConfigArgs', 'CollectionPolicyDataConfigArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            policy_config: Optional[pulumi.Input[Union['CollectionPolicyPolicyConfigArgs', 'CollectionPolicyPolicyConfigArgsDict']]] = None,
            policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            product_code: Optional[pulumi.Input[_builtins.str]] = None,
            resource_directory: Optional[pulumi.Input[Union['CollectionPolicyResourceDirectoryArgs', 'CollectionPolicyResourceDirectoryArgsDict']]] = None) -> 'CollectionPolicy':
        """
        Get an existing CollectionPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CollectionPolicyCentralizeConfigArgs', 'CollectionPolicyCentralizeConfigArgsDict']] centralize_config: Centralized transfer configuration. See `centralize_config` below.
        :param pulumi.Input[_builtins.bool] centralize_enabled: Whether to enable centralized Conversion. The default value is false.
        :param pulumi.Input[_builtins.str] data_code: Log type encoding.
        :param pulumi.Input[Union['CollectionPolicyDataConfigArgs', 'CollectionPolicyDataConfigArgsDict']] data_config: The configuration is supported only when the log type is global. For example, if the productCode is sls, global logs will be collected to the corresponding region during the first configuration. See `data_config` below.
        :param pulumi.Input[_builtins.bool] enabled: Whether to open.
        :param pulumi.Input[Union['CollectionPolicyPolicyConfigArgs', 'CollectionPolicyPolicyConfigArgsDict']] policy_config: Collection rule configuration. See `policy_config` below.
        :param pulumi.Input[_builtins.str] policy_name: The name of the rule, with a minimum of 3 characters and a maximum of 63 characters, must start with a letter.
        :param pulumi.Input[_builtins.str] product_code: Product code.
        :param pulumi.Input[Union['CollectionPolicyResourceDirectoryArgs', 'CollectionPolicyResourceDirectoryArgsDict']] resource_directory: For Resource Directory configuration, the account must have opened the resource directory and be an administrator or a delegated administrator. See `resource_directory` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CollectionPolicyState.__new__(_CollectionPolicyState)

        __props__.__dict__["centralize_config"] = centralize_config
        __props__.__dict__["centralize_enabled"] = centralize_enabled
        __props__.__dict__["data_code"] = data_code
        __props__.__dict__["data_config"] = data_config
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["policy_config"] = policy_config
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["product_code"] = product_code
        __props__.__dict__["resource_directory"] = resource_directory
        return CollectionPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="centralizeConfig")
    def centralize_config(self) -> pulumi.Output['outputs.CollectionPolicyCentralizeConfig']:
        """
        Centralized transfer configuration. See `centralize_config` below.
        """
        return pulumi.get(self, "centralize_config")

    @_builtins.property
    @pulumi.getter(name="centralizeEnabled")
    def centralize_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable centralized Conversion. The default value is false.
        """
        return pulumi.get(self, "centralize_enabled")

    @_builtins.property
    @pulumi.getter(name="dataCode")
    def data_code(self) -> pulumi.Output[_builtins.str]:
        """
        Log type encoding.
        """
        return pulumi.get(self, "data_code")

    @_builtins.property
    @pulumi.getter(name="dataConfig")
    def data_config(self) -> pulumi.Output['outputs.CollectionPolicyDataConfig']:
        """
        The configuration is supported only when the log type is global. For example, if the productCode is sls, global logs will be collected to the corresponding region during the first configuration. See `data_config` below.
        """
        return pulumi.get(self, "data_config")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to open.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="policyConfig")
    def policy_config(self) -> pulumi.Output['outputs.CollectionPolicyPolicyConfig']:
        """
        Collection rule configuration. See `policy_config` below.
        """
        return pulumi.get(self, "policy_config")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule, with a minimum of 3 characters and a maximum of 63 characters, must start with a letter.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> pulumi.Output[_builtins.str]:
        """
        Product code.
        """
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="resourceDirectory")
    def resource_directory(self) -> pulumi.Output['outputs.CollectionPolicyResourceDirectory']:
        """
        For Resource Directory configuration, the account must have opened the resource directory and be an administrator or a delegated administrator. See `resource_directory` below.
        """
        return pulumi.get(self, "resource_directory")

