# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEtlsResult',
    'AwaitableGetEtlsResult',
    'get_etls',
    'get_etls_output',
]

@pulumi.output_type
class GetEtlsResult:
    """
    A collection of values returned by getEtls.
    """
    def __init__(__self__, etls=None, id=None, ids=None, logstore=None, offset=None, output_file=None, project=None, size=None):
        if etls and not isinstance(etls, list):
            raise TypeError("Expected argument 'etls' to be a list")
        pulumi.set(__self__, "etls", etls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if logstore and not isinstance(logstore, str):
            raise TypeError("Expected argument 'logstore' to be a str")
        pulumi.set(__self__, "logstore", logstore)
        if offset and not isinstance(offset, int):
            raise TypeError("Expected argument 'offset' to be a int")
        pulumi.set(__self__, "offset", offset)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def etls(self) -> Sequence['outputs.GetEtlsEtlResult']:
        """
        A list of Etl Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "etls")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Etl IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> _builtins.str:
        """
        Destination Logstore Name.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        Target Project name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "size")


class AwaitableGetEtlsResult(GetEtlsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEtlsResult(
            etls=self.etls,
            id=self.id,
            ids=self.ids,
            logstore=self.logstore,
            offset=self.offset,
            output_file=self.output_file,
            project=self.project,
            size=self.size)


def get_etls(ids: Optional[Sequence[_builtins.str]] = None,
             logstore: Optional[_builtins.str] = None,
             offset: Optional[_builtins.int] = None,
             output_file: Optional[_builtins.str] = None,
             project: Optional[_builtins.str] = None,
             size: Optional[_builtins.int] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEtlsResult:
    """
    This data source provides Sls Etl available to the user.[What is Etl](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateETL)

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    defaulthh_a_po6 = alicloud.log.Project("defaulthhAPo6",
        description="terraform-etl-example-813",
        project_name="terraform-etl-example-330")
    defaultz_wk_lkp = alicloud.log.Store("defaultzWKLkp",
        hot_ttl=8,
        retention_period=30,
        shard_count=2,
        project_name=defaulthh_a_po6.id,
        logstore_name="example")
    default_etl = alicloud.sls.Etl("default",
        project=defaulthh_a_po6.id,
        description="etl-1740472705-185721",
        configuration={
            "script": "* | extend a=1",
            "lang": "SPL",
            "role_arn": name,
            "sinks": [{
                "name": "11111",
                "endpoint": "cn-hangzhou-intranet.log.aliyuncs.com",
                "project": "gy-hangzhou-huolang-1",
                "logstore": "gy-rm2",
                "datasets": ["__UNNAMED__"],
                "role_arn": name,
            }],
            "logstore": defaultz_wk_lkp.logstore_name,
            "from_time": 1706771697,
            "to_time": 1738394097,
        },
        job_name="etl-1740472705-185721",
        display_name="etl-1740472705-185721")
    default = alicloud.sls.get_etls_output(logstore=defaultz_wk_lkp.name,
        project=defaulthh_a_po6.id)
    pulumi.export("alicloudSlsEtlExampleId", default.etls[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Etl IDs. The value is formulated as `<project>:<job_name>`.
    :param _builtins.str logstore: Source Logstore Name.
    :param _builtins.int offset: Query start row. The default value is 0.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project: Project Name
    :param _builtins.int size: Specify the number of data processing tasks returned by the query
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logstore'] = logstore
    __args__['offset'] = offset
    __args__['outputFile'] = output_file
    __args__['project'] = project
    __args__['size'] = size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:sls/getEtls:getEtls', __args__, opts=opts, typ=GetEtlsResult).value

    return AwaitableGetEtlsResult(
        etls=pulumi.get(__ret__, 'etls'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        logstore=pulumi.get(__ret__, 'logstore'),
        offset=pulumi.get(__ret__, 'offset'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project=pulumi.get(__ret__, 'project'),
        size=pulumi.get(__ret__, 'size'))
def get_etls_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    logstore: Optional[pulumi.Input[_builtins.str]] = None,
                    offset: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    project: Optional[pulumi.Input[_builtins.str]] = None,
                    size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEtlsResult]:
    """
    This data source provides Sls Etl available to the user.[What is Etl](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateETL)

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    defaulthh_a_po6 = alicloud.log.Project("defaulthhAPo6",
        description="terraform-etl-example-813",
        project_name="terraform-etl-example-330")
    defaultz_wk_lkp = alicloud.log.Store("defaultzWKLkp",
        hot_ttl=8,
        retention_period=30,
        shard_count=2,
        project_name=defaulthh_a_po6.id,
        logstore_name="example")
    default_etl = alicloud.sls.Etl("default",
        project=defaulthh_a_po6.id,
        description="etl-1740472705-185721",
        configuration={
            "script": "* | extend a=1",
            "lang": "SPL",
            "role_arn": name,
            "sinks": [{
                "name": "11111",
                "endpoint": "cn-hangzhou-intranet.log.aliyuncs.com",
                "project": "gy-hangzhou-huolang-1",
                "logstore": "gy-rm2",
                "datasets": ["__UNNAMED__"],
                "role_arn": name,
            }],
            "logstore": defaultz_wk_lkp.logstore_name,
            "from_time": 1706771697,
            "to_time": 1738394097,
        },
        job_name="etl-1740472705-185721",
        display_name="etl-1740472705-185721")
    default = alicloud.sls.get_etls_output(logstore=defaultz_wk_lkp.name,
        project=defaulthh_a_po6.id)
    pulumi.export("alicloudSlsEtlExampleId", default.etls[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Etl IDs. The value is formulated as `<project>:<job_name>`.
    :param _builtins.str logstore: Source Logstore Name.
    :param _builtins.int offset: Query start row. The default value is 0.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project: Project Name
    :param _builtins.int size: Specify the number of data processing tasks returned by the query
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logstore'] = logstore
    __args__['offset'] = offset
    __args__['outputFile'] = output_file
    __args__['project'] = project
    __args__['size'] = size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:sls/getEtls:getEtls', __args__, opts=opts, typ=GetEtlsResult)
    return __ret__.apply(lambda __response__: GetEtlsResult(
        etls=pulumi.get(__response__, 'etls'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        logstore=pulumi.get(__response__, 'logstore'),
        offset=pulumi.get(__response__, 'offset'),
        output_file=pulumi.get(__response__, 'output_file'),
        project=pulumi.get(__response__, 'project'),
        size=pulumi.get(__response__, 'size')))
